/*
    libfame - Fast Assembly MPEG Encoder Library
    Copyright (C) 2000-2001 Vivien Chappelier

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cpuflags.h"

unsigned long cpuflags(void)
{
  unsigned int flags = 0;

#if defined(i386) && defined(__GNUC__)
  asm volatile ("push %%eax\n"
		"push %%ebx\n"
		"push %%ecx\n"
		"pushfl\n"
		"popl %%ecx\n"
		"movl %%ecx, %%edx\n"
		"xorl $0x200000,%%edx\n" /* test cpuid flag */
		"pushl %%edx\n"
		"popfl\n"
		"pushfl\n"
		"popl %%edx\n"
		"xorl %%ecx, %%edx\n"
		"je 1f\n"                /* no cpuid instruction */
		"pushl %%ecx\n"
		"popfl\n"
		"movl $1,%%eax\n"
		"cpuid\n"
		"1:\n"
		"pop %%ecx\n"
		"pop %%ebx\n"
		"pop %%eax\n"
		: "=d" (flags));
#endif

  return(flags);
}
