/***************************************************************************
                          stuff.h  -  description
                             -------------------
    begin                : Mon Aug 19 2002
    copyright            : (C) 2002 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef STUFF_H
#define STUFF_H

#include <qstring.h>
#include <qstringlist.h>
#include <arts/iomanager.h>
#include <arts/dispatcher.h>

const int POLL_DELAY_MS = 250; // how much time between device polls
const int MAX_HISTORY = 240; // number of device states to be saved

extern "C" {
  #include <iwlib.h>
}

struct deviceinfo
  {
    int has_freq;
    float freq;
    int mode;
    int has_mode;
    int has_key;
    QString key;
    int key_size;
    int key_flags;
    QString essid;
    sockaddr ap_addr;
    QString ip_addr;
    iwparam bitrate;
    QString used_interface;
    int skfd;
    iw_quality qual;
    iwrange range;
    int has_range;
  };

struct deviceinfo_new {
    bool has_frequency;
    float frequency;
    bool has_mode;
    int mode;
    bool has_key;
    QString key;
    int key_size;
    int key_flags;
    QString essid;
    sockaddr access_point_address;
    QString ip_address;
    iwparam bitrate;
    QString interface_name;
    int socket;
    iw_quality quality;
    bool has_range;
    iwrange range;
};

struct statistical_data
{
  int sigLevel[240];
  int sigLevelMin, sigLevelMax;
  int noiseLevel[240];
  int noiseLevelMin, noiseLevelMax;
  int qual[240];
  bool valid[240];
  int current;
};

void sinus_wave (double frequency);

class MyTimeNotify:public
  Arts::TimeNotify
{
public:
  Arts::Dispatcher * test;
  MyTimeNotify (Arts::Dispatcher * siff)
  {
    test = siff;
  };
  void notifyTime ();
};

QString whois (char *MAC_ADR, QStringList APList);
int operator == (const deviceinfo & eins, const deviceinfo & zwei);

#endif /*  STUFF_H */
