/***************************************************************************
                            KRestrictedLine.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KRESTRICTEDLINE_H
#define KRESTRICTEDLINE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KLineEdit.h>

/**
 
 The KRestrictedLine widget is a variant of @ref QLineEdit which
 accepts only a restricted set of characters as input. 
 All other characters will be discarded and the signal @ref  #--invalidChar 
 will be emitted for each of them.

 Valid characters can be passed as a QString to the constructor
 or set afterwards via @ref  #--setValidChars.
 The default key bindings of @ref QLineEdit are still in effect.

 @author Michael Wiedmann <mw@miwie.in-berlin.de>

 @version 0.0.1
 
 @short A line editor for restricted character sets.

*/
@interface KRestrictedLine : KLineEdit 

/** 
 Constructor: This contructor takes three - optional - arguments.
  The first two parameters are simply passed on to @ref QLineEdit.

*/
- initWithWidget: (QWidget *)parent name: (NSString *)name valid: (NSString *)valid;
- init;

/** 
 Destructs the restricted line editor.
   
*/
- (void) dealloc;

/** 
 All characters in the string valid are treated as 
 acceptable characters.
   
*/
- setValidChars: (NSString *)valid;

/** 

*/
- (NSString *) validChars;
@end

/** Override these methods in subclasses of KRestrictedLine to customise event handling behaviour */
@protocol KRestrictedLineEventHandling

/** 

   
*/
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) e;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;

/** 
 Re-implemented for internal reasons.  API not affected.

 See @ref -[QLineEdit mousePressEvent].
    
*/
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;

/** 
 Re-implemented for internal reasons.  API not affected.

 See @ref -[QWidget mouseDoubleClickEvent].
    
*/
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) e;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;

/** 
 Re-implemented to handle URI drops.

 See @ref -[QLineEdit dropEvent].
    
*/
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
