/***************************************************************************
                            DCOPObject.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef DCOPOBJECT_H
#define DCOPOBJECT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Provides an interface for receiving DCOP messages.

 This class provides an interface for receiving DCOP messages.  To use it,
 simply multiply-inherit from DCOPObject and from some other class, and
 then implement the @ref -[DCOPObject process] method.  Because this method is
 pure virtual, you @p must implement the method.

 @author Preston Brown <pbrown@kde.org>, Matthias Ettrich <ettrich@kde.org>
 
 @short 
 Provides an interface for receiving DCOP messages.
*/

@class DCOPObject;
@class QByteArray;
@class QObject;

@protocol DCOPObjectInterface


- (NSString *) objId;

/** 
 Renames a dcop object, if no other with the same name exists
 Use with care, all dcop signals are disconnected

 The new name is @p objId

*/
- (BOOL) setObjId: (NSString *)objId;

/** 
 Dispatches a message.

 Usually you want to use an IDL
 compiler to automatically generate an implementation for
 this function.

 If this function returns @p false, then @ref -processDynamic
 is called.

 Note to implementators: remember to call the baseclasses
 implementation.

*/
- (BOOL) process: (NSString *)fun data: (QByteArray*)data replyType: (NSString *)replyType replyData: (QByteArray*)replyData;

/** 
 This function is of interest when you used an IDL compiler
 to generate the implementation for @ref -process but
 you still want to dispatch some functions dynamically.
 Dynamically means that methods may appear and vanish
 during runtime.

*/
- (BOOL) processDynamic: (NSString *)fun data: (QByteArray*)data replyType: (NSString *)replyType replyData: (QByteArray*)replyData;

/** 
 This function is of interest when you used an IDL compiler
 to generate the implementation for @ref -functions but
 you still want to list some functions dynamically.
 Dynamically means that the methods may appear and vanish
 during runtime.

*/
- (NSArray *) functionsDynamic;

/** 
 This function is of interest when you used an IDL compiler
 to generate the implementation for @ref -interfaces but
 you still want to list some interfaces dynamically.
 Dynamically means that they may appear and vanish
 during runtime.

*/
- (NSArray *) interfacesDynamic;

/** 
 Returns the names of the interfaces, specific ones last. The
 functions gets reimplemented by the IDL compiler. If you don't
 use the IDL compiler, consider implementing this function
 manually if you want your object to be easily explorable.

*/
- (NSArray *) interfaces;

/** 
 Returns the list of functions understood by the object. It gets
 reimplemented by the IDL compiler. If you don't use the IDL
 compiler, consider implementing this function manually if you
 want your object to be easily scriptable.

 Rationale: -functions allows an interpreter to do client-side
 type-casting properly.

 Note to implementators: remember to call the baseclasses
 implementation.

*/
- (NSArray *) functions;

/** 
 Emit @p signal as DCOP signal from this object with @p data as
 arguments
   
*/
- emitDCOPSignal: (NSString *)signal data: (QByteArray*)data;

/** 
 Connects to a DCOP signal.

*/
- (BOOL) connectDCOPSignal: (NSString *)sender senderObj: (NSString *)senderObj signal: (NSString *)signal slot: (NSString *)slot Volatile: (BOOL)Volatile;

/** 
 Disconnects a DCOP signal.

 A special case is when both sender & signal are empty. In this
 case all connections related to this object in the current client
 are disconnected. (Both connections from as well as to this object!)

*/
- (BOOL) disconnectDCOPSignal: (NSString *)sender senderObj: (NSString *)senderObj signal: (NSString *)signal slot: (NSString *)slot;

/** 

 @ref DCOPObjectProxy
   
*/
+ (BOOL) hasObject: (NSString *)objId;

/** 

 This function does not query the @ref DCOPObjectProxy.
   
*/
+ (DCOPObject*) find: (NSString *)objId;

/** 
 Creates an object id for the QObject @p obj. This is done
 using the @ref -[QObject name] function.
   
*/
+ (NSString *) objectName: (QObject *)obj;
@end

@interface DCOPObject : NSObject <QtSupport,DCOPObjectInterface>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
/**
 Creates a DCOPObject and calculates the object id
 using its physical memory address.

*/
- init;

/**
 Creates a DCOPObject and calculates the object id
 using @ref -[QObject name].

*/
- initWithObject: (QObject *)obj;

/**
 Creates a DCOPObject with object Id @p objId.

*/
- initWithText: (NSString *)objId;

/**
 Destroys the DCOPObject and removes it from the map
 of known objects.

*/
- (void) dealloc;

@end

#endif
