//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QRect;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QObject;
import org.kde.qt.QCloseEvent;
import org.kde.qt.QPixmap;
import java.util.Calendar;
import org.kde.qt.QFocusEvent;
import org.kde.qt.QEvent;
import org.kde.qt.QWidget;
import org.kde.qt.QResizeEvent;
import org.kde.qt.QWidget;

/**

 Base class for all MDI view widgets. KMdi stores additional information in this class
 to handle the attach/detach mechanism and such things.
 All such windows 'lives' attached to a KMdiChildFrm widget
 managed by KMdiChildArea, or detached (managed by the window manager.)
 So remember that the KMdiChildView.parent pointer may change, and may be null, too.
 There are 2 possibilities for you to put your widgets under MDI control:
 Either you inherit all the views from KMdiChildView:
   <pre>
   public class MyMdiWidget implements KMdiChildView
   { .... }
   ...
   MyMdiWidget w;
   mainframe.addWindow(w, flags);
   </pre>
 or you wrap them by a KMdiChildView somehow like this:
 <pre>
 void DocViewMan.addKMdiFrame(QWidget pNewView, boolean bShow, QPixmap icon)
 {
   // cover it by a KMdi childview and add that MDI system
   KMdiChildView pMDICover = new KMdiChildView( pNewView.caption());
   pMDICover.setIcon(icon);
   m_MDICoverList.append( pMDICover);
   QBoxLayout pLayout = new QHBoxLayout( pMDICover, 0, -1, "layout");
   pNewView.reparent( pMDICover, QPoint(0,0));
   pLayout.addWidget( pNewView);
   pMDICover.setName( pNewView.name());
   // captions
   String shortName = pNewView.caption();
   int length = shortName.length();
   shortName = shortName.right(length - (shortName.findRev('/') +1));
   pMDICover.setTabCaption( shortName);
   pMDICover.setCaption(pNewView.caption());
   // fake a viewActivated to update the currentEditView/currentBrowserView pointers _before_ adding to MDI control
   slot_viewActivated( pMDICover);
   // take it under MDI mainframe control (note: this triggers also a setFocus())
   int flags;
   if (bShow) {
     flags = KMdi.StandardAdd;
   }
   else {
     flags = KMdi.Hide;
   }
   // set the accelerators for Toplevel MDI mode (each toplevel window needs its own accels
   connect( m_pParent, SIGNAL("childViewIsDetachedNow(QWidget)"), this, SLOT("initKeyAccel(QWidget)") );
   m_pParent.addWindow( pMDICover, flags);
   // correct the default settings of KMdi ('cause we haven't a tab order for subwidget focuses)
   pMDICover.setFirstFocusableChildWidget(null);
   pMDICover.setLastFocusableChildWidget(null);
 }
 </pre>
   See {@link KMdiChildViewSignals} for signals emitted by KMdiChildView
		@short Base class for all your special view windows.

*/
public class KMdiChildView extends QWidget  {
	protected KMdiChildView(Class dummy){super((Class) null);}
	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Constructor
		   		@short    Constructor
	*/
	public KMdiChildView(String caption, QWidget parentWidget, String name, int f) {
		super((Class) null);
		newKMdiChildView(caption,parentWidget,name,f);
	}
	private native void newKMdiChildView(String caption, QWidget parentWidget, String name, int f);
	public KMdiChildView(String caption, QWidget parentWidget, String name) {
		super((Class) null);
		newKMdiChildView(caption,parentWidget,name);
	}
	private native void newKMdiChildView(String caption, QWidget parentWidget, String name);
	public KMdiChildView(String caption, QWidget parentWidget) {
		super((Class) null);
		newKMdiChildView(caption,parentWidget);
	}
	private native void newKMdiChildView(String caption, QWidget parentWidget);
	public KMdiChildView(String caption) {
		super((Class) null);
		newKMdiChildView(caption);
	}
	private native void newKMdiChildView(String caption);
	/**	
		 Constructor 2 (sets "Unnamed" as default caption)
		   		@short    Constructor 2 (sets "Unnamed" as default caption)
	*/
	public KMdiChildView(QWidget parentWidget, String name, int f) {
		super((Class) null);
		newKMdiChildView(parentWidget,name,f);
	}
	private native void newKMdiChildView(QWidget parentWidget, String name, int f);
	public KMdiChildView(QWidget parentWidget, String name) {
		super((Class) null);
		newKMdiChildView(parentWidget,name);
	}
	private native void newKMdiChildView(QWidget parentWidget, String name);
	public KMdiChildView(QWidget parentWidget) {
		super((Class) null);
		newKMdiChildView(parentWidget);
	}
	private native void newKMdiChildView(QWidget parentWidget);
	public KMdiChildView() {
		super((Class) null);
		newKMdiChildView();
	}
	private native void newKMdiChildView();
	/**	
		 This method does the same as focusInEvent(). That's why it is a replacement for the setFocus() call. It makes
		 sense if you for instance want to focus (I mean raise and activate) this view although the real focus is
		 in another toplevel widget. focusInEvent() will never get called in that case and your setFocus() call for this
		 widget would fail without any effect.
		 Use this method with caution, it always raises the view and pushes the taskbar button. Also when the focus is
		 still on another MDI view in the same toplevel window where this is located!
		   		@short    This method does the same as focusInEvent().
	*/
	public native void activate();
	/**	
		 Memorizes the first focusable child widget of this widget
		   		@short    Memorizes the first focusable child widget of this widget
	*/
	public native void setFirstFocusableChildWidget(QWidget arg1);
	/**	
		 Memorizes the last focusable child widget of this widget
		   		@short    Memorizes the last focusable child widget of this widget
	*/
	public native void setLastFocusableChildWidget(QWidget arg1);
	/**	
		 Returns the current focused child widget of this widget
		   		@short    Returns the current focused child widget of this widget
	*/
	public native QWidget focusedChildWidget();
	/**	
		 Returns true if the MDI view is a child window within the MDI mainframe widget
		 or false if the MDI view is in toplevel mode
		   		@short    Returns true if the MDI view is a child window within the MDI mainframe widget  or false if the MDI view is in toplevel mode
	*/
	public native boolean isAttached();
	/**	
		 Returns the caption of the child window (different from the caption on the button in the taskbar)
		   		@short    Returns the caption of the child window (different from the caption on the button in the taskbar)
	*/
	public native String caption();
	/**	
		 Returns the caption of the button on the taskbar
		   		@short    Returns the caption of the button on the taskbar
	*/
	public native String tabCaption();
	/**	
		 Sets the window caption string...
		 Calls updateButton on the taskbar button if it has been set.
		   		@short    Sets the window caption string.
	*/
	public native void setCaption(String szCaption);
	/**	
		 Sets the caption of the button referring to this window
		   		@short    Sets the caption of the button referring to this window
	*/
	public native void setTabCaption(String caption);
	/**	
		 Sets the caption of both, window and button on the taskbar (they are going to be the same)
		   		@short    Sets the caption of both, window and button on the taskbar (they are going to be the same)
	*/
	public native void setMDICaption(String caption);
	/**	
		 Returns the KMdiChildFrm parent widget (or 0 if the window is not attached)
		   		@short    Returns the KMdiChildFrm parent widget (or 0 if the window is not attached)
	*/
	public native KMdiChildFrm mdiParent();
	/**	
		 Tells if the window is minimized when attached to the Mdi manager,
		 or if it is VISIBLE when 'floating'.
		   		@short    Tells if the window is minimized when attached to the Mdi manager,  or if it is VISIBLE when 'floating'.
	*/
	public native boolean isMinimized();
	/**	
		 Tells if the window is minimized when attached to the Mdi manager,
		 otherwise returns false.
		   		@short    Tells if the window is minimized when attached to the Mdi manager,  otherwise returns false.
	*/
	public native boolean isMaximized();
	/**	
		 Returns the geometry of this MDI child window as QWidget.geometry() does.
		    		@short    Returns the geometry of this MDI child window as QWidget.geometry() does.
	*/
	public native QRect internalGeometry();
	/**	
		 Sets the geometry of the client area of this MDI child window. The
		 top left position of the argument is the position of the top left point
		 of the client area in its parent coordinates and the arguments width
		 and height is the width and height of the client area. Please note: This
		 differs from the behavior of QWidget.setGeometry()!
		   		@short    Sets the geometry of the client area of this MDI child window.
	*/
	public native void setInternalGeometry(QRect newGeomety);
	/**	
		 Returns the frame geometry of this window or of the parent if there is any...
		   		@short    Returns the frame geometry of this window or of the parent if there is any.
	*/
	public native QRect externalGeometry();
	/**	
		 Sets the geometry of the frame of this MDI child window. The top left
		 position of the argument is the position of the top left point of the
		 frame in its parent coordinates and the arguments width and height is
		 the width and height of the widget frame. Please note: This differs
		 from the behavior of QWidget.setGeometry()!
		   		@short    Sets the geometry of the frame of this MDI child window.
	*/
	public native void setExternalGeometry(QRect newGeomety);
	/**	
		 You should override this function in the derived class.
		   		@short    You should override this function in the derived class.
	*/
	public native QPixmap myIconPtr();
	/**	
		 Minimizes this window when it is attached to the Mdi manager.
		 Otherwise has no effect
		   		@short    Minimizes this window when it is attached to the Mdi manager.
	*/
	public native void minimize(boolean bAnimate);
	/**	
		 Maximizes this window when it is attached to the Mdi manager.
		 Otherwise has no effect
		   		@short    Maximizes this window when it is attached to the Mdi manager.
	*/
	public native void maximize(boolean bAnimate);
	/**	
		 Returns the geometry that will be restored by calling restore().
		   		@short    Returns the geometry that will be restored by calling restore().
	*/
	public native QRect restoreGeometry();
	/**	
		 Sets the geometry that will be restored by calling restore().
		   		@short    Sets the geometry that will be restored by calling restore().
	*/
	public native void setRestoreGeometry(QRect newRestGeo);
	/**	
		 Switches interposing in event loop of all current child widgets off.
		   		@short    Switches interposing in event loop of all current child widgets off.
	*/
	public native void removeEventFilterForAllChildren();
	/**	
		 Internally used for setting an ID for the 'Window' menu entry
		   		@short    Internally used for setting an ID for the 'Window' menu entry
	*/
	public native void setWindowMenuID(int id);
	/**	
		 Sets the minimum size of the widget to w by h pixels.
		 It extends it base clase method in a way that the minimum size of
		 its childframe (if there is one) will be set, additionally.
		   		@short    Sets the minimum size of the widget to w by h pixels.
	*/
	public native void setMinimumSize(int minw, int minh);
	/**	
		 Sets the maximum size of the widget to w by h pixels.
		 It extends it base clase method in a way that the maximum size of
		 its childframe (if there is one) will be set, additionally.
		   		@short    Sets the maximum size of the widget to w by h pixels.
	*/
	public native void setMaximumSize(int maxw, int maxh);
	/**	
		 Returns if this is added as MDI tool-view
		   		@short    Returns if this is added as MDI tool-view
	*/
	public native boolean isToolView();
	/**	
		 Remember the current time
		   		@short    Remember the current time
	*/
	public native void updateTimeStamp();
	/**	
		 Recall a previously remembered time, i.e. the value of m_time
		   		@short    Recall a previously remembered time, i.
	*/
	public native Calendar getTimeStamp();
	/**	
		 Attaches this window to the Mdi manager.
		 It calls the KMdiMainFrm attachWindow function , so if you have a pointer
		 to this KMdiMainFrm you'll be faster calling that function.
		 Useful as slot.
		   		@short    Attaches this window to the Mdi manager.
	*/
	public native void attach();
	/**	
		 Detaches this window from the Mdi manager.
		 It calls the KMdiMainFrm detachWindow function , so if you have a pointer
		 to this KMdiMainFrm you'll be faster calling that function.
		 Useful as slot.
		   		@short    Detaches this window from the Mdi manager.
	*/
	public native void detach();
	/**	
		 Mimimizes the MDI view. If attached, the covering childframe widget is minimized (only a mini widget
		 showing the caption bar and the system buttons will remain visible). If detached, it will use the
		 minimize of the underlying system ( QWidget.showMinimized ).
		   		@short    Mimimizes the MDI view.
	*/
	public native void minimize();
	/**	
		 Maximizes the MDI view. If attached, this widget will fill the whole MDI view area widget. The system buttons
		 move to the main menubar (if set by KMdiMainFrm.setMenuForSDIModeSysButtons ).
		 If detached, it will use the minimize of the underlying system ( QWidget.showMaximized ).
		   		@short    Maximizes the MDI view.
	*/
	public native void maximize();
	/**	
		 Restores this window to its normal size. Also known as 'normalize'.
		   		@short    Restores this window to its normal size.
	*/
	public native void restore();
	/**	
		 Internally called, if KMdiMainFrm.attach is called.
		 Actually, only the caption of the covering childframe is set.
		   		@short    Internally called, if KMdiMainFrm.attach is called.
	*/
	public native void youAreAttached(KMdiChildFrm lpC);
	/**	
		 Internally called, if KMdiMainFrm.detach is called.
		 Some things for going toplevel will be done here.
		   		@short    Internally called, if KMdiMainFrm.detach is called.
	*/
	public native void youAreDetached();
	/**	
		 Called if someone click on the "Window" menu item for this child frame window
		   		@short    Called if someone click on the "Window" menu item for this child frame window
	*/
	public native void slot_clickedInWindowMenu();
	/**	
		 Called if someone click on the "Dock/Undock..." menu item for this child frame window
		   		@short    Called if someone click on the "Dock/Undock.
	*/
	public native void slot_clickedInDockMenu();
	/**	
		 Calls QWidget.show but also for it's parent widget if attached
		   		@short    Calls QWidget.show but also for it's parent widget if attached
	*/
	public native void show();
	/**	
		 Calls QWidget.hide() or it's parent widget hide() if attached
		   		@short    Calls QWidget.hide() or it's parent widget hide() if attached
	*/
	public native void hide();
	/**	
		 Calls QWidget.raise() or it's parent widget raise() if attached
		   		@short    Calls QWidget.raise() or it's parent widget raise() if attached
	*/
	public native void raise();
	/**	
		 Overridden from its base class method. Emits a signal KMdiChildView.isMinimizedNow , additionally.
		 Note that this method is not used by an external windows manager call on system minimizing.
		   		@short    Overridden from its base class method.
	*/
	public native void showMinimized();
	/**	
		 Overridden from its base class method. Emits a signal KMdiChildView.isMaximizedNow , additionally.
		 Note that this method is not used by an external windows manager call on system maximizing.
		   		@short    Overridden from its base class method.
	*/
	public native void showMaximized();
	/**	
		 Overridden from its base class method. Emits a signal KMdiChildView.isRestoredNow , additionally.
		 Note that this method is not used by an external windows manager call on system normalizing.
		   		@short    Overridden from its base class method.
	*/
	public native void showNormal();
	/**	
		 Ignores the event and calls KMdiMainFrm.childWindowCloseRequest instead. This is because the
		 mainframe has control over the views. Therefore the MDI view has to request the mainframe for a close.
		    		@short    Ignores the event and calls KMdiMainFrm.childWindowCloseRequest instead.
	*/
	protected native void closeEvent(QCloseEvent e);
	/**	
		 It only catches QEvent.KeyPress events there. If a Qt.Key_Tab is pressed, the internal MDI focus
		 handling is called. That means if the last focusable child widget of this is called, it will jump to the
		 first focusable child widget of this.
		 See KMdiChildView.setFirstFocusableChildWidget and KMdiChildView.lastFirstFocusableChildWidget
		   		@short    It only catches QEvent.KeyPress events there.
	*/
	public native boolean eventFilter(QObject arg1, QEvent e);
	/**	
		 If attached, the childframe will be activated and the MDI taskbar button will be pressed. Additionally, the
		 memorized old focused child widget of this is focused again.
		 Sends the focusInEventOccurs signal before changing the focus and the
		 gotFocus signal after changing the focus.
		   		@short    If attached, the childframe will be activated and the MDI taskbar button will be pressed.
	*/
	protected native void focusInEvent(QFocusEvent e);
	/**	
		 Send the lostFocus signal
		   		@short    Send the lostFocus signal
	*/
	protected native void focusOutEvent(QFocusEvent e);
	/**	
		 Internally used for the minimize/maximize/restore mechanism when in attach mode.
		   		@short    Internally used for the minimize/maximize/restore mechanism when in attach mode.
	*/
	protected native void resizeEvent(QResizeEvent e);
	protected native void trackIconAndCaptionChanges(QWidget view);
	protected native void slot_childDestroyed();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
