/***************************************************************************
                            kde_KSocket.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSOCKET
#define KDE_KSOCKET

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 You can connect this socket to any Internet address.

 The socket gives you three signals: When ready for reading,
 ready for writing or if the connection is broken.
 Using @ref socket() you get a file descriptor
 which you can use with the usual UNIX function like @ref write() or
  @ref read().
 If you have already such a socket identifier you can construct a KSocket
 on this identifier.

 If @ref socket() delivers a value of -1 or less, the connection
 was not successful.

 @author Torben Weis <weis@uni-frankfurt.de>

 @version $Id: kde_KSocket.h,v 1.6 2002/12/30 14:37:06 geiseri Exp $

 @short A TCP/IP client socket.
 
*/

/** *
 Constructs a KSocket with the provided file descriptor.

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KSocket * kde_new_KSocket(int _sock);

/** *
 Creates a socket and connects to a host.

*/
kde_KSocket * kde_new_KSocket1(char* _host, unsigned short _port, int timeOut);

/** *
 Connects to a UNIX domain socket.

*/
kde_KSocket * kde_new_KSocket2(char* _path);

/** *
 Destructor. Closes the socket if it is still open.
     
*/
void kde_del_KSocket( kde_KSocket* p );

/** *
 Returns a file descriptor for this socket.

*/
int kde_KSocket_socket(kde_KSocket* instPointer);

/** *
 Enables the socket for reading.

 If you enable read mode, the socket will emit the signal
 @ref readEvent() whenever there is something to read out of this
 socket.

*/
void kde_KSocket_enableRead(kde_KSocket* instPointer,int enable);

/** *
 Enables the socket for writing.

 If you enable write mode, the socket will emit the signal
 @ref writeEvent() whenever the socket is ready for writing.

 Warning: If you forget to call enableWrite(false) when you are
 not ready to send data, you will get lots of writeEvent() signals,
 in the order of thousands a second !

*/
void kde_KSocket_enableWrite(kde_KSocket* instPointer,int enable);

/** *
 Return address.
 This function is dumb. Don't ever use it
 if you need the peer address of this socket, use @ref KExtendedSocket::peerAddress(int)
 instead

     
*/
unsigned long kde_KSocket_ipv4_addr(kde_KSocket* instPointer);

/** *
 Connected to the writeNotifier.

 Called when
  the socket is ready for writing.

*/
void kde_KSocket_slotWrite(kde_KSocket* instPointer,int x);

/** *
 Connected to the readNotifier.

 Called when
  the socket is ready for reading.

*/
void kde_KSocket_slotRead(kde_KSocket* instPointer,int x);

/** *
  A small wrapper around @ref gethostbyname() and such.
  Don't use this in new programs. Use @ref KExtendedSocket::lookup

      
*/
int kde_KSocket_initSockaddr( void* server_name, char* hostname, unsigned short port, int domain);
int kde_KSocket_connect(kde_KSocket* instPointer,qt_QString * _host, unsigned short _port, int timeout);
int kde_KSocket_connect1(kde_KSocket* instPointer,char* _path);

#ifdef __cplusplus
}
#endif
#endif
