/***************************************************************************
                            kde_KGlobal.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KGLOBAL
#define KDE_KGLOBAL

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Access to the KDE global objects.
 KGlobal provides you with pointers of many central 
 objects that exist only once in the process. It is also
 responsible for managing instances of @ref KStaticDeleterBase.

 @author Sirtaj Singh Kang (taj@kde.org)

 @version $Id: kde_KGlobal.h,v 1.5 2002/12/30 14:37:06 geiseri Exp $
 
 @short *
 Access to the KDE global objects.
*/

/** *
 Returns the global instance.  There is always at least
 one instance of a component in one application (in most
 cases the application itself).

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KInstance* kde_KGlobal_instance( );

/** *
  Returns the application standard dirs object.

*/
kde_KStandardDirs* kde_KGlobal_dirs( );

/** *
  Returns the general config object.

*/
kde_KConfig* kde_KGlobal_config( );

/** *
  Returns an iconloader object.

*/
kde_KIconLoader* kde_KGlobal_iconLoader( );

/** *
 Returns the global locale object.

*/
kde_KLocale* kde_KGlobal_locale( );

/** *
 The global charset manager.

*/
kde_KCharsets* kde_KGlobal_charsets( );

/** *
 Creates a static QString.

 To be used inside functions(!) like:
 <pre>
 static const QString &myString = KGlobal::staticQString("myText");
 </pre>

 !!! Do _NOT_ use: !!!
 <pre>
 static QString myString = KGlobal::staticQString("myText");
 </pre>
 This creates a static object (instead of a static reference)
 and as you know static objects are EVIL.

*/
qt_QString * kde_KGlobal_staticQString( char* str);

/** *
 Creates a static QString.

 To be used inside functions(!) like:
 <pre>
 static const QString &myString = KGlobal::staticQString(i18n("My Text"));
 </pre>

 !!! Do _NOT_ use: !!!
 <pre>
 static QString myString = KGlobal::staticQString(i18n("myText"));
 </pre>
 This creates a static object (instead of a static reference)
 and as you know static objects are EVIL.

*/
qt_QString * kde_KGlobal_staticQString1( qt_QString * str);

/** *
 Registers a static deleter.

*/
void kde_KGlobal_registerStaticDeleter( kde_KStaticDeleterBase* d);

/** *
 Unregisters a static deleter.

*/
void kde_KGlobal_unregisterStaticDeleter( kde_KStaticDeleterBase* d);

/** *
 Calls KStaticDeleterBase::destructObject() on all
 registered static deleters and unregisters them all.

*/
void kde_KGlobal_deleteStaticDeleters( );

/** *
 The instance currently active (useful in a multi-instance
 application, such as a KParts application).
 Don't use this - it's mainly for KAboutDialog and KBugReport.

     
*/
void kde_KGlobal_setActiveInstance( kde_KInstance* d);
kde_KInstance* kde_KGlobal_activeInstance( );

#ifdef __cplusplus
}
#endif
#endif
