/***************************************************************************
                           videosettings.h 
                             -------------------
    begin                : Mit Mai 7 2003
    revision             : $Revision: 1.4 $
    last modified        : $Date: 2004/05/08 11:13:36 $ by $Author: juergenk $
    copyright            : (C) 2003-2004 by J. Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VIDEOSETTINGS_H
#define VIDEOSETTINGS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kdialogbase.h>

#include <qslider.h>



class VideoSettings : public KDialogBase
{

   Q_OBJECT
   
public: 
  VideoSettings(int hue, int sat, int contrast, int bright, int avOffset,
                int spuOffset, QWidget *parent=0, const char *name=0);
 ~VideoSettings();

signals:
  void signalNewHue(int);
  void signalNewSaturation(int);
  void signalNewContrast(int);
  void signalNewBrightness(int);

  void signalNewAVOffset(int);
  void signalNewSpuOffset(int);

private slots:

  void slotSetDefaultValues();


private:
  QSlider* hueSlider;
  QSlider* satSlider;
  QSlider* contrastSlider;
  QSlider* brightSlider;
  QSlider* avOffsetSlider;
  QSlider* spuOffsetSlider;
                
};

#endif
