/***************************************************************************
                           videosettings.cpp
                             -------------------
    begin                : Mit Mai 7 2003
    revision             : $Revision: 1.8 $
    last modified        : $Date: 2004/05/08 11:13:55 $ by $Author: juergenk $
    copyright            : (C) 2003-2004 by J. Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <kaccel.h>

#include <qlayout.h>
#include <qlabel.h>
#include <qnamespace.h>

#include "videosettings.h"
#include "videosettings.moc"


VideoSettings::VideoSettings(int hue, int sat, int contrast, int bright,
        int avOffset, int spuOffset, QWidget *parent, const char *name)
         : KDialogBase(KDialogBase::Plain, i18n("Kaffeine Video Settings"), KDialogBase::Default | KDialogBase::Close, KDialogBase::Close, parent, name, false)
{
  
  QWidget* page = plainPage();  
  
  QGridLayout* grid = new QGridLayout(page, 6, 2);
  grid->setSpacing(5);
  
  QLabel* hueText = new QLabel(i18n("Hue"), page);
  hueText->setAlignment(AlignRight);
  hueSlider = new QSlider(Qt::Horizontal, page);
  hueSlider->setRange(0, 65535);
  hueSlider->setSteps(10, 1000);
  hueSlider->setValue(hue);
  connect(hueSlider, SIGNAL(valueChanged(int)), this, SIGNAL(signalNewHue(int)));
  grid->addWidget(hueText, 0, 0);
  grid->addWidget(hueSlider, 0, 1);

  QLabel* satText = new QLabel(i18n("Saturation"), page);
  satText->setAlignment(AlignRight);
  satSlider = new QSlider(Qt::Horizontal, page);
  satSlider->setRange(0, 65535);
  satSlider->setSteps(10, 1000);
  satSlider->setValue(sat);
  connect(satSlider, SIGNAL(valueChanged(int)), this, SIGNAL(signalNewSaturation(int)));
  grid->addWidget(satText, 1, 0);
  grid->addWidget(satSlider, 1, 1);

  QLabel* contrastText = new QLabel(i18n("Contrast"), page);
  contrastText->setAlignment(AlignRight);
  contrastSlider = new QSlider(Qt::Horizontal, page);
  contrastSlider->setRange(0, 65535);
  contrastSlider->setSteps(10, 1000);
  contrastSlider->setValue(contrast);
  connect(contrastSlider, SIGNAL(valueChanged(int)), this, SIGNAL(signalNewContrast(int)));
  grid->addWidget(contrastText, 2, 0);
  grid->addWidget(contrastSlider, 2, 1);

  QLabel* brightText = new QLabel(i18n("Brightness"), page);
  brightText->setAlignment(AlignRight);
  brightSlider = new QSlider(Qt::Horizontal, page);
  brightSlider->setRange(0, 65535);
  brightSlider->setSteps(10, 1000);
  brightSlider->setValue(bright);
  connect(brightSlider, SIGNAL(valueChanged(int)), this, SIGNAL(signalNewBrightness(int)));
  grid->addWidget(brightText, 3, 0);
  grid->addWidget(brightSlider, 3, 1);

  QLabel* avOffsetText = new QLabel(i18n("AV Offset"), page);
  avOffsetText->setAlignment(AlignRight);
  avOffsetSlider = new QSlider(Qt::Horizontal, page);
  avOffsetSlider->setRange(-90000, 90000); // +/- 1 sec
  avOffsetSlider->setSteps(100, 10000);
  avOffsetSlider->setValue(avOffset);
  connect(avOffsetSlider, SIGNAL(valueChanged(int)), this, SIGNAL(signalNewAVOffset(int)));
  grid->addWidget(avOffsetText, 4, 0);
  grid->addWidget(avOffsetSlider, 4, 1);

  QLabel* spuOffsetText = new QLabel(i18n("Subtitle Offset"), page);
  spuOffsetText->setAlignment(AlignRight);
  spuOffsetSlider = new QSlider(Qt::Horizontal, page);
  spuOffsetSlider->setRange(-90000, 90000);  // +/- 1 sec
  spuOffsetSlider->setSteps(100, 10000);
  spuOffsetSlider->setValue(spuOffset);
  connect(spuOffsetSlider, SIGNAL(valueChanged(int)), this, SIGNAL(signalNewSpuOffset(int)));
  grid->addWidget(spuOffsetText, 5, 0);
  grid->addWidget(spuOffsetSlider, 5, 1);


 /*** key accelerators ***/
  KAccel* accel = new KAccel( this );
  accel->insert( i18n("Hide video settings window"), Qt::Key_V, this, SLOT(hide()) );


  connect(this, SIGNAL(defaultClicked()), this, SLOT(slotSetDefaultValues()));
}



VideoSettings::~VideoSettings()
{
  
}


void VideoSettings::slotSetDefaultValues()
{
  hueSlider->setValue(0);
  satSlider->setValue(32768);
  contrastSlider->setValue(32768);
  brightSlider->setValue(32768);
  avOffsetSlider->setValue(0);
  spuOffsetSlider->setValue(0);
}  



