/***************************************************************************
                           urllistview.cpp
                             -------------------
    begin                : Mon Apr 28 2003
    revision             : $Revision: 1.13 $
    last modified        : $Date: 2004/05/10 09:12:42 $ by $Author: juergenk $
    copyright            : (C) 2003-2004 by J. Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 
#include <kglobal.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kdebug.h>
#include <kurl.h>
#include <kurldrag.h>
#include <kglobalsettings.h>
#include <kfiledialog.h>

#include <qfontmetrics.h>

#include "urllistview.h"
#include "playlist.h"
#include "urllistview.moc"


UrlListView::UrlListView(QWidget *parent, const char *name ) : KListView(parent,name), listCleared(true), itemOfContextMenu( NULL )
{
  contextMenu = new KPopupMenu(this);
  contextMenu->insertItem(KGlobal::iconLoader()->loadIconSet("player_play", KIcon::Small), i18n("Play"), this, SLOT(slotPlayItem()));
  contextMenu->insertItem(KGlobal::iconLoader()->loadIconSet("edit", KIcon::Small), i18n("&Edit title"), this, SLOT(slotEditTitle()));
  contextMenu->insertItem(KGlobal::iconLoader()->loadIconSet("editcut", KIcon::Small), i18n("C&ut"), this, SIGNAL(signalCut()));
  contextMenu->insertItem(KGlobal::iconLoader()->loadIconSet("editcopy", KIcon::Small), i18n("&Copy"), this, SIGNAL(signalCopy()));
  contextMenu->insertItem(KGlobal::iconLoader()->loadIconSet("editpaste", KIcon::Small), i18n("&Paste"), this, SIGNAL(signalPaste()));
  contextMenu->insertSeparator();
  contextMenu->insertItem(KGlobal::iconLoader()->loadIconSet("indent", KIcon::Small), i18n("Add Sub&title"), this, SLOT(slotAddSubtitle()),QKeySequence(),100 );  
  contextMenu->insertSeparator();
  contextMenu->insertItem(KGlobal::iconLoader()->loadIconSet("info", KIcon::Small), i18n("&Info"), this, SLOT(slotShowInfo()));

/* width of the "length"-column */
  QFontMetrics met( KGlobalSettings::generalFont() );
  int w1 = met.width(i18n("Length"));
  int w2 =  met.width("5:55:55");

  column2Width = w1 > w2 ? w1 : w2;
  column2Width += 12;
   
  connect(this, SIGNAL(contextMenuRequested(QListViewItem*, const QPoint&, int)),
          this, SLOT(slotShowContextMenu(QListViewItem*, const QPoint&, int)));
  connect(this, SIGNAL(currentChanged(QListViewItem*)),
          this, SLOT(slotCurrentChanged(QListViewItem*)));
  connect(this, SIGNAL(clicked( QListViewItem*, const QPoint&, int )),
          this, SLOT(slotClicked( QListViewItem*, const QPoint&, int )));
}


UrlListView::~UrlListView()
{
}


bool UrlListView::acceptDrag(QDropEvent* event) const
{
 return QUriDrag::canDecode(event) || QTextDrag::canDecode(event) || KListView::acceptDrag(event);
}


QDragObject* UrlListView::dragObject()
{
 // get selected items 
  QPtrList<QListViewItem> selected;
  KURL::List kurlList;
  
  selected = selectedItems();
  for (uint i = 0; i<selected.count(); i++)
  {
    kurlList.append( selected.at(i)->text(4) );
  }  

  return KURLDrag::newDrag( kurlList, viewport() );
}


void UrlListView::resizeEvent(QResizeEvent* rev)
{

  setColumnWidth(0, 18);
  setColumnWidth(2, column2Width);  /* width of "lenght" column */
  setColumnWidth(3, 18);
  setColumnWidth(4, 18);
  setColumnWidth(1, contentsRect().width()-column2Width-70);

  KListView::resizeEvent(rev);
}


void UrlListView::clear()
{
  listCleared = true;
 // kdDebug(555) << "Playlist cleared\n";

  itemOfContextMenu = NULL;
  KListView::clear();
}


void UrlListView::SetCleared(bool cl)
{
  listCleared = cl;
}


bool UrlListView::GetCleared() const   /* was playlist cleared ? */
{
  return listCleared;
}



/********** context menu **********/  

void UrlListView::slotShowContextMenu(QListViewItem* item, const QPoint& pos, int)
{
  if (!item) return;  /* dont allow context menu on empty space */
  
  itemOfContextMenu = dynamic_cast<PlaylistItem *>(item);

  if (!itemOfContextMenu) return;

  if((dynamic_cast<PlaylistItem *>(itemOfContextMenu)->mime().contains("video")))
      enableSubEntry();
   else
      disableSubEntry();
  
  contextMenu->popup(pos);
}


void UrlListView::slotPlayItem()
{
  emit signalPlayItem(itemOfContextMenu);
}
  

void UrlListView::slotEditTitle()
{
  itemOfContextMenu->setRenameEnabled(1, true);
  itemOfContextMenu->startRename(1);
  itemOfContextMenu->setRenameEnabled(1, false);
}


//Pretty print item info
void UrlListView::slotShowInfo()
{
  QString num;
  num = num.setNum(childCount());
  QString info = "<qt><table width=\"90%\">"; 
  info = info + "<tr><td colspan=\"2\"><center><b>" + itemOfContextMenu->title() + "</b></center></td></tr>";
  if(itemOfContextMenu->url().contains("#subtitle:"))
    info = info + "<tr><td><b>" + i18n("URL")+ ":</b></td><td>" + 
           itemOfContextMenu->url().section("#subtitle:",0,0) + "</td></tr>";
  else
    info = info + "<tr><td><b>" + i18n("URL")+ ":</b></td><td>" + itemOfContextMenu->url() + "</td></tr>";
  info = info + "<tr><td><b>" + i18n("Length") + ":</b></td><td>" + itemOfContextMenu->length() + "</td></tr>";
  info = info + "<tr><td><b>" + i18n("Stream") + ":</b></td><td>" + itemOfContextMenu->info() + "</td></tr>";
  if(!itemOfContextMenu->subtitles().isEmpty())
  { 
     info = info + "<tr><td><b>" + i18n("Subtitles") + ":</b></td><td>";
     QString subinuse = QString::null;
     if(itemOfContextMenu->url().contains("#subtitle:"))
         subinuse = itemOfContextMenu->url().section("#subtitle:",-1,-1);
     for(unsigned int i = 0; i < itemOfContextMenu->subtitles().size(); i++ )
     {
       info = info + ""+itemOfContextMenu->subtitles()[i];
       if(subinuse == itemOfContextMenu->subtitles()[i])
          info = info + "<small> ("+i18n("in use")+")</small>";
       info = info + "<br>";
     }
     info = info + "</ul></td></tr></table></qt>";
  }
   
  KMessageBox::information(this, info);
}  


void UrlListView::slotClicked( QListViewItem* item, const QPoint&, int col )
{
  if ( (item) && (col == 3) )
  {
    itemOfContextMenu = dynamic_cast<PlaylistItem *>(item);
    if (!itemOfContextMenu) return;
    slotShowInfo();
  }  
}  

  
void UrlListView::slotAddSubtitle()
{
   QString openURL = QString::null;
   if(itemOfContextMenu->url().contains("#subtitle:"))
      openURL = itemOfContextMenu->url().section("#subtitle:",0,0);
   else
      openURL = itemOfContextMenu->url();
      
   QString subtitleURL = KFileDialog::getOpenURL(openURL,
                         i18n("*.smi *.srt *.sub *.txt *.ssa *.asc|Subtitle Files\n*.*|All Files"),
                         0, i18n("Select a subtitle file")).path();
   if(!(subtitleURL == "") && !(itemOfContextMenu->subtitles().contains(subtitleURL))){
     itemOfContextMenu->addSubtitle(subtitleURL);
     itemOfContextMenu->setUrl(openURL+"#subtitle:"+subtitleURL);
   }
}

void UrlListView::slotCurrentChanged(QListViewItem * item)
{
   if(item == 0) //All items deleted
      itemOfContextMenu = NULL;
   else
      itemOfContextMenu = dynamic_cast<PlaylistItem *>(item);
}

void UrlListView::enableSubEntry()
{
  contextMenu->setItemEnabled( 100, true );
}

void UrlListView::disableSubEntry()
{
  contextMenu->setItemEnabled( 100, false );
}


