/***************************************************************************
                          splashwidget.cpp - alpha masked OSD
                             -------------------
    begin                : Mit Apr 30 2003
    revision             : $Revision: 1.5 $
    last modified        : $Date: 2004/01/11 13:09:46 $ by $Author: juergenk $
    copyright            : (C) 2003-2004 by J. Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kglobal.h>
#include <kiconloader.h>

#include <qfontmetrics.h>
#include <qpainter.h>
#include <qpixmap.h>

#include "splashwidget.h"
#include "splashwidget.moc"


SplashWidget::SplashWidget(QWidget *parent, const char *name ) :
   QWidget(parent, name, WStyle_Customize | WStyle_NoBorder | WStyle_StaysOnTop | WX11BypassWM)
{
  posx = 0; posy = 0; displayTime = 0; useMe = false; animate = false;
  playIcon = KGlobal::iconLoader()->loadIcon("player_play", KIcon::Panel, KIcon::SizeMedium);

  connect(&waitTimer, SIGNAL(timeout()), this, SLOT(slotWait()));
  connect(&fadeInTimer, SIGNAL(timeout()), this, SLOT(slotFadeIn()));
  connect(&fadeOutTimer, SIGNAL(timeout()), this, SLOT(slotFadeOut()));
}


SplashWidget::~SplashWidget(){ }


void SplashWidget::GetConfig(bool& use, bool& anim, int& speed,
                             QFont& f, QColor& col, int& time, int& x, int& y) const
{
  use =  useMe;
  anim = animate;
  speed = animSpeed;
  f = font;
  col = color;
  time = displayTime;
  x = posx;
  y = posy;                 
}


void SplashWidget::slotSetConfig(bool use, bool anim, int speed,
                                 QFont* f, QColor* col, int time, int x, int y)
{
  useMe = use;
  animate = anim;
  animSpeed = speed;
  font = *f;
  color = *col;
  displayTime = time;
  posx = x;
  posy = y;
}


void SplashWidget::slotOsdShow(const QString& text)
{

  if (!useMe) return;
  if (isVisible())
  {
     hide();
     waitTimer.stop();
     fadeInTimer.stop();
     fadeOutTimer.stop();
  }   

  QFontMetrics met(font);
  height = met.ascent() + met.descent();
  height = (height > playIcon.height()) ? height : playIcon.height();
  height += 4;
  width = met.width(text) + playIcon.width() + 10;

  setGeometry(posx, posy, width, height);
  int playIconY = (height - playIcon.height())/2;

  QPixmap back(width, height);
  back.fill(color);
  QPainter backp(&back);
  backp.drawPixmap(1, playIconY , playIcon);

  mask = QBitmap(width, height, true); /* fill bitmap with 1 - invisible */

  QPainter p(&mask);
  
  p.setBackgroundMode(QPainter::TransparentMode);
  p.setPen(Qt::color1);
  p.drawPixmap(1, playIconY, *playIcon.mask());
  p.setFont(font);
  int y = ((height - met.ascent())/2) + met.ascent();
  p.drawText(playIcon.width() + 5, y , text);

  setPaletteBackgroundPixmap(back);

  if (!animate)
  {
    setMask(mask);
    waitTimer.start(displayTime * 1000, true);
  }
  else
  {  
    animPos = playIcon.width() + 5;
    setMask(QBitmap(width, height , true)); /* invisible */
    fadeInTimer.start(50);
  }

  show();  
}


void SplashWidget::slotWait()
{
  if (!animate)
  {
    hide();
  }
  else
  {
    animPos = width;
    fadeOutTimer.start(50);
  }
}      


void SplashWidget::slotFadeIn()
{
  QBitmap mask2(mask);
  QPainter p(&mask2);
  
  p.setBackgroundMode(QPainter::TransparentMode);
  p.setPen(Qt::color0);

/*** set transparent rectangle ***/ 
  p.fillRect(animPos,  0, width-animPos, height, QBrush(QColor("color0")));

  setMask(mask2);

  animPos += animSpeed;
  if (animPos > width )
  {
    fadeInTimer.stop();
    setMask(mask);
    waitTimer.start(displayTime * 1000, true);
  }  
}


void SplashWidget::slotFadeOut()
{
  QBitmap mask2(mask);
  QPainter p(&mask2);

  p.setBackgroundMode(QPainter::TransparentMode);
  p.setPen(Qt::color0);

/*** set transparent rectangle ***/  
  p.fillRect(animPos,  0, width-animPos, height, QBrush(QColor("color0")));

  setMask(mask2);
  
  animPos -= animSpeed;
  if (animPos < playIcon.width() )
  {
    fadeOutTimer.stop();
    hide();
  }
}



