/***************************************************************************
                           kaffeineapp.cpp
                             -------------------
    begin                : Die Mai 13 2003
    revision             : $Revision: 1.15 $
    last modified        : $Date: 2004/04/27 08:39:33 $ by $Author: juergenk $
    copyright            : (C) 2003-2004 by J.  Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/resource.h>

#include <kcmdlineargs.h>
#include <kdebug.h>
#include <kwin.h>

#include "kaffeineapp.h"


KaffeineApp::KaffeineApp() : KUniqueApplication(), kaffeine(0)
{
}


KaffeineApp::~KaffeineApp()
{
  delete kaffeine;
}


int KaffeineApp::newInstance()
{
  /* parse command line options */

  KCmdLineArgs* args = KCmdLineArgs::parsedArgs();

  if (kaffeine)  /* still running */
  {
  
    KURL::List files;

    QString remote = args->getOption("rc");

    if (args->count() > 0) /* get urls */
    {
      for (int i=0; i<args->count(); i++)
      {
        files.append(args->url(i));
      }
    }

    if (files.count() > 0)  /* send urls to running instance */
    {
      kdDebug(555) << "Send URLs to running instance...\n";
      kaffeine->CmdLineArgs(files, args->getOption("device"), false, false, false, args->isSet("enqueue") );
      if (!args->isSet("enqueue"))
      {
        kaffeine->show(); 
        KWin::setActiveWindow( kaffeine->winId() );
      }  
      return 0;
    }
    if (remote != "do_nothing") /* send remote command */
    {
      kaffeine->ExecuteRemoteCommand(remote);
      return 0;
    }    

    kdDebug(555) << "Kaffeine is still running...\n";
    kaffeine->show();
    KWin::setActiveWindow( kaffeine->winId() );
    return 0;
 }  

 /* start kaffeine */
 
  kaffeine = new KMP(0, "main window", args);

  if (isRestored())    /* if restored by session manager */
    kaffeine->showMinimized();
   else 
    kaffeine->show();
 
  return 0;
}



