/***************************************************************************
                           kaffeine.h - main widget
                             -------------------
    begin                : Don Apr 17 11:30:44 CEST 2003
    revision             : $Revision: 1.33 $
    last modified        : $Date: 2004/04/20 10:03:15 $ by $Author: juergenk $
    copyright            : (C) 2003-2004 by J.Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMP_H
#define KMP_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <kstdaction.h>
#include <klocale.h>
#include <kaction.h>
#include <kpopupmenu.h>
#include <kmenubar.h>
#include <kaboutapplication.h>
#include <khelpmenu.h>
#include <kbookmarkmanager.h>
#include <kbookmarkmenu.h>
#include <dcopobject.h>
#include <kcmdlineargs.h>
#include <kaccel.h>

#include <qwidget.h>
#include <qlayout.h>
#include <qsignalmapper.h>
#include <qtimer.h>

#include <math.h>

#include "splashwidget.h"
#include "controlpanel.h"
#include "inforow.h"
#include "playlist.h"
#include "configwidget.h"
#include "xineconfig.h"
#include "videosettings.h"
#include "equalizer.h"
#include "videowindow.h"
#include "systemtray.h"
#include "fullscreenpanel.h"
#include "filterdialog.h"


/*
 * Define this if you use kaffeine under windowmaker.
 * Makes sure the fullscreen window is above the panel, but produces a
 * ugly flickery if you switch to fullscreen
 */
//#define WINDOWMAKER


/** KMP is the base class of the project */
class KMP : public QWidget, virtual public KBookmarkOwner, public DCOPObject
{
  Q_OBJECT
  K_DCOP
  public:
    /** construtor */
    KMP(QWidget* parent=0, const char *name=0, KCmdLineArgs* args = NULL);
    /** destructor */
    ~KMP();
   
   /* parse command line options */
    void CmdLineArgs(const KURL::List& files, const QString device, bool playAtStartup, bool startFullscreen, bool minimalMode, bool enqueueFiles);
  /* execute a command string like play, pause, next, etc; */  
    void ExecuteRemoteCommand(const QString&);  
    void LoadPlaylist();
    /*Play a playlist item*/
    void playItem(PlaylistItem *);
     
    VideoWindow* videoWin;

   /* reimplement BookmarkOwner methods */
    virtual void openBookmarkURL(const QString&);
    virtual QString currentTitle() const;
    virtual QString currentURL() const;

  /*** DCOP Interface ***/  
  k_dcop:
    void playURL(QString url) { slotPlayRecent(KURL(url)); }
    void appendURL(QString url) { playList->Add( url, playList->GetLast() ); }
    void play() { ExecuteRemoteCommand("play"); }
    bool isPlaying() { return cPanel->GetPlaying(); }
    void pause() { ExecuteRemoteCommand("pause"); }
    void togglePlayPause() { cPanel->slotPlayPause(); }
    void next() { ExecuteRemoteCommand("next"); }
    void previous() { ExecuteRemoteCommand("prev"); }
    void stop() { ExecuteRemoteCommand("stop"); }
    QString getTitle() { if (cTitle.isNull()) return QString("Kaffeine");
                         return cTitle;
                       }  
    void playlist() { slotShowPlayList(); }
    void quit() { slotQuit(); }
    void random() { playRandomPlay->setChecked(!playRandomPlay->isChecked());
                    slotRandomPlay();
                  }
    void fullscreen() { viewFullscreen->setChecked(!viewFullscreen->isChecked());
                        slotToggleFullscreen(); }
    void zoomIn() { videoWin->slotZoomIn(); }
    void zoomOut() { videoWin->slotZoomOut(); }
                       
  public slots:
    virtual void polish();   /* reimplementation */
    
  private slots:
    void slotQuit();
    void slotOpenFile();
    void slotOpenUrl();
    void slotSaveStreamAs();
    void slotPlay();
    void slotEndOfPlayback(); /* xine send signal end of playback */
    void slotPlayNext();
    void slotPlayPrev();
    void slotPlayRecent(const KURL&); /* choosen file from recent menu */
    void slotPlayFiles(const KURL::List&);
    void slotStop();
    void slotGetNewTitle(const QString&);
    void slotToggleFullscreenChecked();
    void slotToggleFullscreen();
    void slotEscape();
    void slotToggleMinimalMode();
    void slotEnableAutoresize();
    void slotPlayAutoplayPlugin(const QString&); /* e.g. dvd:// */
    void slotShowPlayList(); /* toggel visibility of playlist window */
    void slotShowSetup();
    void slotShowFilterConfig();
    void slotHasChapters(bool);  /* set if stream has chapters or not */
    void slotEndlessMode();
    void slotRandomPlay();
    void slotToggleBroadcastMaster();
    void slotBroadcastSlave();
    void slotGenConfig(bool loadPl, bool embed);
    void slotConfigXine();
    void slotVideoSettings();
    void slotConfigureShortcuts();
    void slotEqualizer();
    void slotScreenshot();
    void slotToggleTv();  /* not implemeted yet*/
    void slotAddAutoplayUrls(const QString& plugin, QListViewItem* after);
    void slotSetVisual(int);
    void slotNewXineMessage();
    void slotSetSubtitleChannel(int); /*Set subtitle from channel or file*/
    void slotClearRecent();
    void slotShowDeinterlaceDialog();
   
   /* for context menu */
    void slotShowContextMenu(const QPoint&);
    void slotContextMenuVolume(int);
    void slotContextMenuAudioChannel(int);
    void slotContextMenuSubtitleChannel(int);
    void slotNewChannels(const QStringList& audio, const QStringList& subtitles, int currentAudio, int currentSub);
    
   /* for fullscreen panel */
    void slotShowFullscreenPanel(const QPoint&);
    
  protected:

    virtual void closeEvent(QCloseEvent*);
    virtual void moveEvent(QMoveEvent*);
    virtual void dropEvent(QDropEvent*);
    virtual void dragEnterEvent(QDragEnterEvent*);
    virtual void wheelEvent( QWheelEvent* e )
    {
      float offset = log10( QABS(e->delta()) ) / 0.002;
      int newVal = 0;
      if (e->delta()>0)
        newVal = cPanel->posSlider->value() + int(offset);
       else
        newVal = cPanel->posSlider->value() - int(offset);

      cPanel->posSlider->SetValue( newVal, true );
      e->accept();
    }
   virtual void showEvent ( QShowEvent * );
   virtual void hideEvent ( QHideEvent * );   
    
  private:

    KCmdLineArgs* cmdLineArgs;

    PlayList* playList;
    ControlPanel* cPanel;
    TextRow* tRow;
    SplashWidget* osDisplay;
    ConfigWidget* configWin;
    VideoSettings* videoSettings;
    Equalizer* equalizer;
    SystemTray* systemTray;
    FullscreenPanel* fsPanel;
    FilterDialog* filterDialog;

    QString currentAutoPlayMrl;
    
    enum SubtitleMode{
         fileSubtitles = 1,
         xineSubtitles = 2
    }stMode;
    
    QString currentVisualPlugin;
  
    QString cUrl;
    QString cTitle;

    int broadcastPort;
    QString broadcastMasterAddress;
    QString fileFilter;
  
    void InitActions();
    void InitMenu();
    void InitContextMenu();
    void InitConnections();
    void ReadConfig();
    void SaveConfig();
    void InitSystemTray();
    void InitFullscreenPanel();
   
    bool hasChapters;
    bool loadPlaylistAtStartup;
    bool embedSystemTray;

    uint currentDeinterlaceQuality;
    
    KConfig* config;

    KMenuBar* menuBar;
    KPopupMenu* fileMenu;
    KPopupMenu* playMenu;
    KPopupMenu* visualMenu;
    KPopupMenu* broadcastMenu;
    KPopupMenu* dvdMenu;
    KPopupMenu* viewMenu;
    KPopupMenu* aspectMenu;
    KPopupMenu* configMenu;
    KPopupMenu* helpMenu;

 /* context menu */
    KPopupMenu* contextMenu;
    KPopupMenu* controlMenu;
    KPopupMenu* audioChannelMenu;
    KPopupMenu* subtitleChannelMenu;
    
 /* bookmark system */   
    KPopupMenu* bookmarkMenu;
    KBookmarkMenu* bmenu;
    KBookmarkManager* bookmarkManager;

    KActionCollection* actionCollection;
    
    KAction* fileOpen;
    KAction* fileOpenUrl;
    KRecentFilesAction* fileOpenRecent;
    KAction* fileSaveScreenshot;
   // KAction* fileEject;
    KAction* fileQuit;
    
    KToggleAction* playEndlessPlay;
    KToggleAction* playRandomPlay;

    KToggleAction* broadcastMaster;
    KAction* broadcastSlave;
    
    KAction* viewPlaylist;
    KToggleAction* viewFullscreen;
    KToggleAction* viewMinimalMode;
    KAction* aspectRatioAuto;
    KAction* aspectRatio4_3;
    KAction* aspectRatio16_9;
    KAction* aspectRatioSquare;
    KToggleAction* viewAutoresize;
  
    KToggleAction* viewDeinterlace;
    KAction* viewZoomIn;
    KAction* viewZoomOut;
    KAction* viewZoomOff;
    KToggleAction* viewToggleTv;
    KAction* configVideoControl;
    KAction* configEqualizer;
    KAction* configDeinterlace;
    KAction* configPostFilter;
    KAction* configXine;
    KAction* configKMP;
    KAction* configShortcuts;

    KAction* dvdMenuToggle;
    KAction* dvdMenuTitle;
    KAction* dvdMenuRoot;
    KAction* dvdMenuSub;
    KAction* dvdMenuAudio;
    KAction* dvdMenuAngle;
    KAction* dvdMenuPart;
    
  /* actions for context menu */
  
    KAction* controlSaveStreamAs;
    KAction* controlPlayPause;
    KAction* controlNext;
    KAction* controlPrevious;
    KAction* controlStop;
};


#endif
