/***************************************************************************
                           inforow.cpp
                             -------------------
    begin                : Die Apr 15 2003
    revision             : $Revision: 1.8 $
    last modified        : $Date: 2004/03/23 19:39:02 $ by $Author: juergenk $
    copyright            : (C) 2003-2004 by J.Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpainter.h>
#include <qpixmap.h>
#include <qnamespace.h>

#include <kdebug.h>

#include "inforow.h"
#include "inforow.moc"


TextRow::TextRow(QWidget *parent, const char *name ) : QWidget(parent,name)
{
  setPaletteBackgroundColor(QColor(0,0,0));
 
  posx = 3; posx2 = width(); posXold = 0;

  connect(&timer, SIGNAL(timeout()), this, SLOT(slotTimerEvent()));
  
  timer.start(250);

  drawSecond = false;
}


TextRow::~TextRow()
{
  timer.stop();
}


void TextRow::paintEvent(QPaintEvent*)
{
  //kdDebug(555) << "Repaint info text" << endl;

  QPixmap bufMap( width(), height() );
  bufMap.fill( QColor(0,0,0) );
  QPainter p( &bufMap );

  p.setPen(color);
  p.setFont(font);
  
  p.drawText(posx,posy, text);
  if (drawSecond)
    p.drawText(posx2, posy, text);

  p.flush();
    
  bitBlt( this, 0, 0, &bufMap, 0, 0, width(), height(), Qt::CopyROP );
}


void TextRow::slotTimerEvent()
{
  met = new QFontMetrics(font);
  if ((met->width(text)+3) < width())  /*** begin ***/
  {
    posx = 3;
    posx2 = width();
    drawSecond = false;
  }
  else
  {
    posx -= 5;
    if (posx < (-30))   /** show second line **/
    {
      posx2 = posx + met->width(text) + 30;
      drawSecond = true;
    }  
    else
    {
      posx2 = width();
      drawSecond = false;
    }  

    if (posx2 < 25)  /*** restart ***/
    {
      posx = posx2;
      posx2 = width();
      drawSecond = false;
    }
  }
  delete(met);
  if (posx != posXold)
  {
    repaint();  /*** calls paintEvent ***/
    posXold = posx;
  }  
}


void TextRow::slotChangeText(const QString& newText)
{
  text = newText;
  posx = 3;
  posXold = 0; /* force repaint */
  slotTimerEvent();  //refresh
}  


void TextRow::GetConfig(QFont& f,QColor& c) const
{
  f = font;
  c = color;
}


void TextRow::slotSetConfig(QFont* f, QColor* c)
{
  font = *f;
  color = *c;

  met = new QFontMetrics(font);
  setFixedHeight(met->ascent()+met->descent()+4);
  posy = height()-met->descent()-2;
  delete met;
  posXold = 0; /* force repaint */
}


