/***************************************************************************
                           fullscreenpanel.h  
                             -------------------
    begin                : Die Dez 2 2003
    revision             : $Revision: 1.3 $
    last modified        : $Date: 2004/01/11 12:29:05 $ by $Author: juergenk $
    copyright            : (C) 2003-2004 by Juergen  Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FULLSCREENPANEL_H
#define FULLSCREENPANEL_H

#include <ktoolbar.h>

#include <qwidget.h>
#include <qvbox.h>
#include <qtimer.h>
#include <qlabel.h>
#include <qpopupmenu.h>

/**
  *@author Juergen  Kofler
  */

class FullscreenPanel : public QVBox
{
   Q_OBJECT
public: 
  FullscreenPanel(QWidget *parent=0, const char *name=0);
  ~FullscreenPanel();

  void ShowAt(const QPoint& pos);
  void SetContextMenus( QPopupMenu* audio, QPopupMenu* subtitle);
  void SetWidgetToActivate( QWidget* w ) { widgetToActivate = w; }
   
signals:
  void signalPlayPause();
  void signalStop();
  void signalPrevious();
  void signalNext();
  void signalForward();
  void signalRewind();
  void signalVolUp();
  void signalVolDown();
  void signalDVDMenu();
  
    
public slots:
   void slotSetTitle(const QString& t) { title->setText( QString("<b>") + t + "</b>" ); adjustSize(); }
   void slotSetStreamInfo(const QString& i) { streamInfo->setText( i ); }
   void slotSetLength(const QString& l) { length = l; }
   void slotSetPosition(int, const QString& pos) { lengthInfo->setText( pos + " / " + length ); }

protected:
  virtual void leaveEvent(QEvent*);
  virtual void enterEvent(QEvent*);
         
private:
  QLabel* title;
  QLabel* streamInfo;
  QLabel* lengthInfo;
  QTimer hideTimer;
  QString length;
  KToolBar* toolbar;
  QWidget* widgetToActivate;  
};

#endif
