/***************************************************************************
                           equalizer.h  
                             -------------------
    begin                : Son Okt 19 2003
    revision             : $Revision: 1.4 $
    last modified        : $Date: 2004/01/30 22:52:33 $ by $Author: juergenk $
    copyright            : (C) 2003-2004 by Juergen  Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EQUALIZER_H
#define EQUALIZER_H

#include <kdialogbase.h>
#include <kconfig.h>

#include <qwidget.h>
#include <qslider.h>
#include <qgroupbox.h>
#include <qcheckbox.h>

/**equalizer widget
  *@author Juergen  Kofler
  */

class Equalizer : public KDialogBase  {
   Q_OBJECT
public: 
  Equalizer(QWidget *parent=0, const char *name=0);
  ~Equalizer();

  void ReadValues(KConfig* config);
  void SaveValues(KConfig* config);

signals:
  void signalNewEq30(int);
  void signalNewEq60(int);
  void signalNewEq125(int);
  void signalNewEq250(int);
  void signalNewEq500(int);
  void signalNewEq1k(int);
  void signalNewEq2k(int);
  void signalNewEq4k(int);
  void signalNewEq8k(int);
  void signalNewEq16k(int);
  
private slots:
  void slotSetDefaultValues();
  void slotSetEnabled( bool );

private:
  QCheckBox* on;
  QGroupBox* equalGroup;
  QSlider* eq30Slider;
  QSlider* eq60Slider;
  QSlider* eq125Slider;
  QSlider* eq250Slider;
  QSlider* eq500Slider;
  QSlider* eq1kSlider;
  QSlider* eq2kSlider;
  QSlider* eq4kSlider;
  QSlider* eq8kSlider;
  QSlider* eq16kSlider;
};

#endif
