/***************************************************************************
                          deinterlacequality.h  -
                          in this dialog the user can select the quality of deinterlacing
                             -------------------
    begin                : Mon Apr 19 2004
    revision             : $Revision: 1.1 $
    last modified        : $Date: 2004/04/20 09:55:23 $ by $Author: juergenk $    
    copyright            : (C) 2004 by Juergen  Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DEINTERLACEQUALITY_H
#define DEINTERLACEQUALITY_H

#include <qwidget.h>
#include <qcheckbox.h>
#include <qslider.h>
#include <qstring.h>
#include <qstringlist.h>

#include <klocale.h>
#include <kdialogbase.h>
#include <kpushbutton.h>

/**
  *@author Juergen  Kofler
  */
  

class DeinterlaceQuality : public KDialogBase  {
   Q_OBJECT
public: 
  DeinterlaceQuality(QWidget *parent=0, const char *name=0);
  ~DeinterlaceQuality();  

  void SetQuality( uint );
  uint GetQuality() const;
  
signals:
  void signalConfigureDeinterlacer();
  void signalSetDeinterlaceConfig( const QString& );

private slots:
  void slotLevelChanged( int );
  void slotCustomBoxToggled( bool );

private:
  QStringList configStrings;
  QSlider* qualitySlider;
  QCheckBox* customBox;
  KPushButton* customConfigButton;
};

#endif
