(defvar irchat-pj-install-list
  '("irchat-commands.el"
    "irchat-copyright.el"
    "irchat-dcc.el"
    "irchat-filter.el"
    "irchat-globals.el"
    "irchat-handle.el"
    "irchat-inlines.el"
    "irchat-vars.el"
    ("irchat-pj-specific-nemacs.el"  . (boundp 'NEMACS))
    ("irchat-pj-specific-mule2.el"   . (and (featurep 'mule)
					    (> 20 emacs-major-version)
					    (not (featurep 'xemacs))))
    ("irchat-pj-specific-emacs20.el" . (and (featurep 'mule)
					    (<= 20 emacs-major-version)
					    (not (featurep 'xemacs))))
    ("irchat-pj-specific-xmas.el"    . (and (featurep 'xemacs)
					    (featurep 'mule)))
    ("irchat-pj-specific-others.el"  . (and (not (boundp 'NEMACS))
					    (not (featurep 'mule))))
    "irchat-pj-coding-system.el"
    "irchat-pj-jisx0201.el"
    "irchat-pj-modeline.el"
    "irchat-pj-version-string.el"
    "irchat-pj-sound.el"
    "irchat-pj-action.el"
    "irchat.el"))

(or (fboundp 'make-directory-internal)
    (defsubst make-directory-internal (dir)
      (call-process "mkdir" nil nil nil dir)))

(defun make-directory-one (dir)
  (or (and (file-exists-p dir)
	   (not (file-directory-p dir))
	   (error "Cannot make site-lisp directory: file \"%s\" exists." dir))
      (file-exists-p dir)
      (make-directory-internal dir)))

(defun get-bindir ()
  (message
   (expand-file-name
    (concat data-directory
            (cond ((featurep 'xemacs)
                   "../../../")
                  ((or (featurep 'meadow) (eq 'windows-nt system-type))
                   "../")
                  (t
                   "../../../../"))
            "bin/"))))

(defun get-site-lisp ()
  (message
   (expand-file-name
    (concat data-directory
            (cond ((featurep 'xemacs)
                   "../../xemacs/")
                  ((or (featurep 'meadow) (eq 'windows-nt system-type))
                   "../")
                  (t
                   "../../"))
            "site-lisp/"))))

(defun get-package-base ()
  (if (boundp 'early-packages)
      (let ((dirs (append (if early-package-load-path
                              early-packages)
                          (if late-package-load-path
                              late-packages)
                          (if last-package-load-path
                              last-packages)))
            dir)
        (while (not (file-exists-p
                     (setq dir (car dirs))))
          (setq dirs (cdr dirs)))
        (message dir))))

;;################

(defun get-filename (file)
  (or (and (stringp file)
	   (file-exists-p file)
	   file)
      (and (consp file)
	   (eval (cdr file))
	   (stringp (car file))
	   (car file))))

(defun compile-lisp (list)
  (mapcar
   '(lambda (cell)
      (let (file compiled)
	(and (setq file (get-filename cell))
	     (setq compiled (concat file "c"))
	     (file-newer-than-file-p file compiled)
	     (byte-compile-file file))))
   list))

(defun install-lisp (src dst)
  (message "Install *.el files...")
  (mapcar
   '(lambda (list)
      (let ((file (get-filename list)))
        (and (stringp file)
             (message "%s -> %s" file dst)
             (copy-file file (concat dst (file-name-nondirectory file)) t t))))
   irchat-pj-install-list)
  (message "done.")
  (message "Install *.elc files...")
  (mapcar
   '(lambda (file)
      (cond ((string-match ".*\\.elc$" file)
             (message "%s -> %s" file dst)
             (copy-file file (concat dst (file-name-nondirectory file)) t t)
             (delete-file file))))
   (directory-files src))
  (message "done."))

(defsubst install-current-lisp (dir)
  (install-lisp (expand-file-name "./") dir))

;;################

(defun compile-pj ()
  (setq load-path (cons (expand-file-name ".") load-path))
  (load "irchat-setpath")
  (load "shutup")
  (compile-lisp irchat-pj-install-list))

(defun install-pj ()
  (compile-pj)
  (let* ((dir (or (car command-line-args-left) "default"))
         (path (cond ((string= "default" dir)
                      (concat (get-site-lisp) "irchat-pj/"))
                     ((string= "site-lisp" dir)
                      (get-site-lisp))
                     ((string-match "/$" dir)
                      dir)
                     (t
                      (concat dir "/")))))
    (make-directory-one (substring path 0 (1- (length path))))
    (install-current-lisp path)))

(defun install-dcc ()
  (let* ((dir (or (car command-line-args-left) "default"))
         (path (cond ((string= "default" dir)
                      (get-bindir))
                     ((string-match "/$" dir)
                      dir)
                     (t
                      (concat dir "/")))))
    (make-directory-one path)
    (if (eq system-type 'windows-nt)
	(copy-file (concat (expand-file-name "./dcc") "/dcc.exe") (concat path "dcc.exe") t t)
      (copy-file (concat (expand-file-name "./dcc") "/dcc") (concat path "dcc") t t))))

(defun install-package ()
  (compile-pj)
  (let* ((dir (or (car command-line-args-left) "default"))
         (path (cond ((string= "default" dir)
                      (get-package-base))
                     ((string-match "/$" dir)
                      dir)
                     (t
                      (concat dir "/"))))
         (lispbase (concat path     "lisp/"))
         (lispdir  (concat lispbase "irchat-pj/"))
         (etcbase  (concat path     "etc/"))
         (etcdir   (concat etcbase  "irchat-pj/"))
         (infodir  (concat path     "pkginfo/"))
         (dcc      (concat (expand-file-name "./dcc") "/dcc")))
    (make-directory-one path)
    (make-directory-one lispbase)
    (make-directory-one lispdir)
    (make-directory-one etcbase)
    (make-directory-one etcdir)
    (make-directory-one infodir)
    (copy-file "contrib/MANIFEST.irchat-pj" (concat infodir "MANIFEST.irchat-pj") t t)
    (if (and (file-exists-p dcc) (not (file-directory-p dcc)))
        (progn
          (copy-file dcc (concat etcdir "dcc") t t)
          (delete-file dcc)))
    (mapcar
     '(lambda (file)
        (if (not (string-match "^\\." file))
            (copy-file (concat "doc/" file) (concat etcdir file) t t)))
     (directory-files (expand-file-name "./doc/")))
    (install-current-lisp lispdir)))
