/*
 *  URL Encoding routines - Rick Franchuk <rickf@transpect.net>
 *
 *  Anything that's not an isalnum() or a space is converted to %xx format
 *  Spaces are converted to '%20's.
 *
 *  Requires: char * buffer in dest of 3x the size of the source string
 *  Returns : pointer to dest buffer (helpful for char * function chaining)
 */

#include <sys/types.h>
#include <ctype.h>

#include "encode.h"

const char urlencstring[16] = "0123456789abcdef";

char *urlencode(char *dest, char *source)
{
	unsigned char *p, *q;
	int digit;

	for(p=source,q=dest ; *p ; p++,q++) {
		if(isalnum((int)*p)) {
			*q = *p;
		} else if(*p==' ') {
			*q++ = '%';
			*q++ = '2';
			*q = '0';
		} else {
			*q++ = '%';
			digit = *p >> 4;
			*q++ = urlencstring[digit];
			digit = *p & 0xf;
			*q = urlencstring[digit];
		}
	}

	*q=0;

	return(dest);
}

/*
 *
 * urlnencode() - length limited urlencode
 *
 */

char *urlnencode(char *dest, char *source, size_t length)
{
	unsigned char *p, *q;
	int digit;
	size_t n;

	for(p=source,q=dest,n=0 ; *p && n<length ; p++,q++,n++) {
		if(isalnum((int)*p)) {
			*q = *p;
		} else if(*p==' ') {
			if(n>length-3) {
				q++;
				break;
			}
			*q++ = '%';
			*q++ = '2';
			*q = '0';
		} else {
			if(n>length-3) {
				q++; 
				break; 
			}

			*q++ = '%';
			digit = *p >> 4;
			*q++ = urlencstring[digit];
			digit = *p & 0xf;
			*q = urlencstring[digit];
			n+=2;
		}
	}

	*q=0;

	return(dest);
}
