/*
 * basic.h
 * * - Function definitions for basic.c
 * *
 * * Copyright (c) 1999 Jack Moffitt, Barath Raghavan, and Alexander Havng
 * *
 * * This program is free software; you can redistribute it and/or
 * * modify it under the terms of the GNU General Public License
 * * as published by the Free Software Foundation; either version 2
 * * of the License, or (at your option) any later version.
 * * 
 * * This program is distributed in the hope that it will be useful,
 * * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * * GNU General Public License for more details.
 * * 
 * * You should have received a copy of the GNU General Public License
 * * along with this program; if not, write to the Free Software
 * * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * *
 */

void init_authentication_scheme();
void parse_authentication_scheme();
void destroy_authentication_scheme();
int authenticate_user_request(connection_t * con, request_t * req);
int need_authentication(request_t * req);
void rehash_authentication_scheme();
int need_authentication_on_mount(char *mount);

typedef avl_tree usertree_t;
typedef avl_tree grouptree_t;
typedef avl_tree mounttree_t;

typedef struct userSt {
	char *name;
	char *pass;
} ice_user_t;

typedef struct groupSt {
	char *name;
	usertree_t *usertree;
} group_t;

typedef struct mountSt {
	char *name;
	grouptree_t *grouptree;
} mount_t;
