# hanterm-xf RPM spec file

%define name	hanterm-xf
%define ver	2.0.0
%define rel	1

# To share hangul_keyboard file with ami
%define prefix	/usr

# XXX: need to check 'devel' package
%define withXaw95 %(if [ -n "`rpm -qa | grep Xaw95`" ]; then echo 1; else echo 0; fi)
%if %{withXaw95}
%define withneXtaw 0
%define withXaw3d 0
%else
%define withneXtaw %(if [ -n "`rpm -qa | grep neXtaw`" ]; then echo 1; else echo 0; fi)
%endif
%if %{withXaw95} || %{withneXtaw}
%define withXaw3d 0
%else
%define withXaw3d %(if [ -n "`rpm -qa | grep Xaw3d`" ]; then echo 1; else echo 0; fi)
%endif

Summary		: Hangul Terminal for X
Summary(ko)     : X 쿡   ִ ѱ ͹̳
Name		: %{name}
Version		: %{ver}
Release		: %{rel}
License	        : MIT
Group		: Desktops
Source0		: http://www.kr.freebsd.org/~hwang/hanterm/%{name}-%{ver}.tar.gz
Requires	: XFree86-libs
%if %{withXaw95} == 1
Requires	: Xaw95
#XXX: BuildPrereq	: Xaw3d-devel
%endif
%if %{withneXtaw} == 1
Requires	: neXtaw
#XXX: BuildPrereq	: Xaw3d-devel
%endif
%if %{withXaw3d} == 1
Requires	: Xaw3d
BuildPrereq	: Xaw3d-devel
%endif
Obsoletes	: hanterm, hanterm-xf86

BuildRoot	: %{_tmppath}/%{name}-root

%description
Hangul terminal for X. it is based on the xterm in XFree86.

%description -l ko
XFree86  ִ xterm   ѱ ͹̳ Դϴ.

%prep
%setup -q
 
%build
xawopt=
%if %{withXaw95} == 1
xawopt="--with-Xaw95"
%endif
%if %{withneXtaw} == 1
xawopt="--with-neXtaw"
%endif
%if %{withXaw3d} == 1
xawopt="--with-Xaw3d"
%endif
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{prefix} ${xawopt} \
    --enable-boxchar --enable-ansi-color
# --enable-256-color --enable-tcap-query
make

%install
mkdir -p $RPM_BUILD_ROOT%{prefix}/bin
install -c -s -m 4711 hanterm  $RPM_BUILD_ROOT%{prefix}/bin

mkdir -p $RPM_BUILD_ROOT%{prefix}/man/man1
./minstall.sh "install -m 644" hanterm.man $RPM_BUILD_ROOT%{prefix}/man/man1/hanterm.1

mkdir -p $RPM_BUILD_ROOT/usr/X11R6/{lib/X11/app-defaults,lib/X11/ko/app-defaults}
install -m444 Hanterm.ad \
	$RPM_BUILD_ROOT/usr/X11R6/lib/X11/ko/app-defaults/Hanterm
install -m444 Hanterm-col.ad \
	$RPM_BUILD_ROOT/usr/X11R6/lib/X11/ko/app-defaults/Hanterm-color

mkdir -p $RPM_BUILD_ROOT%{prefix}/share/hangul_keyboard
install -m444 keyboard/*.kbd $RPM_BUILD_ROOT%{prefix}/share/hangul_keyboard
install -m444 keyboard/*.map $RPM_BUILD_ROOT%{prefix}/share/hangul_keyboard

# strip binaries
strip `file $RPM_BUILD_ROOT%{prefix}/bin/* | awk -F':' '/executable/ { print $1 }'`

%clean
rm -rf $RPM_BUILD_ROOT

%files
%doc docs/*
%attr(0555,-,-) %{prefix}/bin/hanterm
%{prefix}/man/man1/hanterm.*
%config /usr/X11R6/lib/X11/ko/app-defaults/Hanterm
%config /usr/X11R6/lib/X11/ko/app-defaults/Hanterm-color
%config(missingok) %{prefix}/share/hangul_keyboard

%changelog
* Fri Jun  1 2001 Nam SungHyun <namsh@kldp.org>
- modified version of mizi hanterm-xf.spec
