/*
    This software may only be used by you under license from AT&T Corp.
    ("AT&T").  A copy of AT&T's Source Code Agreement is available at
    AT&T's Internet website having the URL:
    <http://www.research.att.com/sw/tools/graphviz/license/source.html>
    If you received this software without first entering into a license
    with AT&T, you have an infringing copy of this software and cannot use
    it without violating AT&T's intellectual property rights.
*/
#pragma prototyped

#include "render.h"
#include "utils.h"

#ifdef DMALLOC
#include "dmalloc.h"
#endif

static double timesFontWidth[] = {
  0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, /*  */
  0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, /*  */
  0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, /*  */
  0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, /*  */
  0.3333, 0.1562, 0.3750, 0.6250, 0.5312, 1.0208, 0.9479, 0.1354, /*  !"#$%&' */
  0.3542, 0.3542, 0.4688, 0.6979, 0.1979, 0.3438, 0.1458, 0.3750, /* ()*+,-./ */
  0.5729, 0.3438, 0.5833, 0.5104, 0.6042, 0.5208, 0.5625, 0.5625, /* 01234567 */
  0.5104, 0.5521, 0.1458, 0.1979, 0.7083, 0.7083, 0.7083, 0.4792, /* 89:;<=>? */
  1.1354, 0.9375, 0.8125, 0.7917, 0.8958, 0.7604, 0.6667, 0.9062, /* @ABCDEFG */
  0.9167, 0.3750, 0.4896, 0.9583, 0.7604, 1.1354, 0.9792, 0.8750, /* HIJKLMNO */
  0.6771, 0.8750, 0.8854, 0.5833, 0.7396, 0.9375, 0.9479, 1.2292, /* PQRSTUVW */
  0.9271, 0.9271, 0.7604, 0.2917, 0.3750, 0.2917, 0.5729, 0.7083, /* XYZ[\]^_ */
  0.2188, 0.5521, 0.6354, 0.5000, 0.6250, 0.5104, 0.5312, 0.6042, /* `abcdefg */
  0.6562, 0.2917, 0.3750, 0.6667, 0.3021, 1.0208, 0.6667, 0.5833, /* hijklmno */
  0.6354, 0.6250, 0.4479, 0.4167, 0.3542, 0.6667, 0.6458, 0.9375, /* pqrstuvw */
  0.6354, 0.6562, 0.5417, 0.3646, 0.0625, 0.3646, 0.6979, 0.0000, /* xyz{|}~ */
  0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, /*  */
  0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, /*  */
  0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, /*  */
  0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, /*  */
  0.0000, 0.1562, 0.5000, 0.5938, 0.6354, 0.6667, 0.0625, 0.4688, /*  */
  0.3750, 0.9271, 0.3750, 0.5833, 0.7083, 0.3438, 0.9271, 0.7083, /*  */
  0.4062, 0.6979, 0.3542, 0.3125, 0.2188, 0.6250, 0.6354, 0.1354, /*  */
  0.1979, 0.2188, 0.3854, 0.5833, 0.8958, 0.8854, 0.9583, 0.4896, /*  */
  0.9375, 0.9375, 0.9375, 0.9479, 0.9375, 0.9375, 1.1771, 0.7917, /*  */
  0.7604, 0.7604, 0.7604, 0.7604, 0.3750, 0.3750, 0.3750, 0.3958, /*  */
  0.8958, 0.9688, 0.8750, 0.8750, 0.8750, 0.8750, 0.8750, 0.5312, /*  */
  0.8750, 0.9375, 0.9375, 0.9375, 0.9375, 0.9271, 0.6771, 0.6042, /*  */
  0.5521, 0.5521, 0.5521, 0.5521, 0.5417, 0.5521, 0.8021, 0.5000, /*  */
  0.5104, 0.5104, 0.5104, 0.5000, 0.3125, 0.3125, 0.3750, 0.3750, /*  */
  0.5833, 0.6667, 0.5833, 0.5833, 0.5833, 0.5833, 0.5833, 0.7083, /*  */
  0.6146, 0.6667, 0.6667, 0.6667, 0.6667, 0.6562, 0.6354, 0.6562, /*  */
};
static double courFontWidth[] = {
  0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, /*  */
  0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, /*  */
  0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, /*  */
  0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, /*  */
  0.8021, 0.1667, 0.4479, 0.5417, 0.5104, 0.5625, 0.5104, 0.1771, /*  !"#$%&' */
  0.2188, 0.2188, 0.5000, 0.6146, 0.2708, 0.5625, 0.2083, 0.5104, /* ()*+,-./ */
  0.5104, 0.5000, 0.5312, 0.5417, 0.5104, 0.5417, 0.5104, 0.5104, /* 01234567 */
  0.5000, 0.5104, 0.2083, 0.3021, 0.6354, 0.6771, 0.6354, 0.4792, /* 89:;<=>? */
  0.5000, 0.7917, 0.6667, 0.6458, 0.6458, 0.6458, 0.6354, 0.6771, /* @ABCDEFG */
  0.6667, 0.5000, 0.6771, 0.7083, 0.6458, 0.7812, 0.7292, 0.6771, /* HIJKLMNO */
  0.6146, 0.6771, 0.7396, 0.5625, 0.6250, 0.6979, 0.7812, 0.7604, /* PQRSTUVW */
  0.6979, 0.6667, 0.5312, 0.2292, 0.5104, 0.2292, 0.5104, 0.8021, /* XYZ[\]^_ */
  0.2292, 0.6354, 0.6979, 0.6146, 0.6979, 0.6146, 0.5833, 0.6667, /* `abcdefg */
  0.6875, 0.5625, 0.4271, 0.6354, 0.5625, 0.7812, 0.6562, 0.6146, /* hijklmno */
  0.6979, 0.6979, 0.6146, 0.5312, 0.6146, 0.6667, 0.7292, 0.7292, /* pqrstuvw */
  0.6875, 0.6875, 0.5104, 0.2708, 0.0625, 0.2708, 0.5625, 0.0000, /* xyz{|}~ */
  0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, /*  */
  0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, /*  */
  0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, /*  */
  0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, /*  */
  0.0000, 0.1771, 0.4792, 0.6250, 0.5417, 0.6771, 0.0625, 0.6250, /*  */
  0.3958, 0.8021, 0.4375, 0.6562, 0.6979, 0.5625, 0.8021, 0.8542, /*  */
  0.3646, 0.6250, 0.3438, 0.3229, 0.2292, 0.6667, 0.5833, 0.1354, /*  */
  0.2188, 0.3125, 0.4271, 0.6562, 0.7917, 0.8021, 0.7917, 0.4792, /*  */
  0.7812, 0.7917, 0.7812, 0.7917, 0.7708, 0.7812, 0.7812, 0.6458, /*  */
  0.6458, 0.6458, 0.6458, 0.6458, 0.5000, 0.5104, 0.5000, 0.5000, /*  */
  0.6979, 0.7188, 0.6771, 0.6771, 0.6771, 0.6771, 0.6771, 0.4479, /*  */
  0.6875, 0.6875, 0.6979, 0.6771, 0.7083, 0.6667, 0.6146, 0.6146, /*  */
  0.6354, 0.6354, 0.6354, 0.6458, 0.6354, 0.6354, 0.7708, 0.6146, /*  */
  0.6146, 0.6146, 0.6146, 0.6250, 0.5625, 0.5729, 0.5625, 0.5625, /*  */
  0.6146, 0.6667, 0.6146, 0.6146, 0.6146, 0.6146, 0.6146, 0.6146, /*  */
  0.6562, 0.6667, 0.6667, 0.6667, 0.6771, 0.6771, 0.6979, 0.6667, /*  */
};
static double arialFontWidth[] = {
  0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, /*  */
  0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, /*  */
  0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, /*  */
  0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, /*  */
  0.3750, 0.1458, 0.3542, 0.7188, 0.6250, 1.0312, 0.7917, 0.1354, /*  !"#$%&' */
  0.3125, 0.3229, 0.4271, 0.6458, 0.1458, 0.3646, 0.1354, 0.3750, /* ()*+,-./ */
  0.6250, 0.3542, 0.6354, 0.6250, 0.6667, 0.6354, 0.6354, 0.6146, /* 01234567 */
  0.6250, 0.6354, 0.1354, 0.1458, 0.6354, 0.6354, 0.6354, 0.6250, /* 89:;<=>? */
  1.2292, 0.8958, 0.7292, 0.8438, 0.7812, 0.7083, 0.6458, 0.8854, /* @ABCDEFG */
  0.7500, 0.1250, 0.5208, 0.7917, 0.5938, 0.9167, 0.7604, 0.9062, /* HIJKLMNO */
  0.7188, 0.9271, 0.8438, 0.7604, 0.7604, 0.7500, 0.8750, 1.2292, /* PQRSTUVW */
  0.8750, 0.8750, 0.7500, 0.2604, 0.3750, 0.2604, 0.5521, 0.7917, /* XYZ[\]^_ */
  0.2500, 0.6354, 0.6042, 0.6042, 0.6042, 0.6354, 0.4062, 0.6146, /* `abcdefg */
  0.5729, 0.1250, 0.2812, 0.5729, 0.1250, 0.9479, 0.5729, 0.6562, /* hijklmno */
  0.6042, 0.6042, 0.3750, 0.5833, 0.3333, 0.5729, 0.6354, 0.9479, /* pqrstuvw */
  0.6458, 0.6354, 0.6146, 0.3854, 0.1042, 0.3854, 0.6667, 0.0000, /* xyz{|}~ */
  0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, /*  */
  0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, /*  */
  0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, /*  */
  0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, /*  */
  0.0000, 0.1354, 0.6042, 0.6875, 0.6354, 0.7396, 0.1042, 0.6354, /*  */
  0.3646, 0.9896, 0.4375, 0.5625, 0.6458, 0.3646, 0.9896, 0.7917, /*  */
  0.3646, 0.6458, 0.4167, 0.4062, 0.2396, 0.5729, 0.7292, 0.1354, /*  */
  0.2917, 0.2500, 0.4375, 0.5625, 1.0208, 1.0312, 1.0833, 0.6146, /*  */
  0.8958, 0.8958, 0.8958, 0.8958, 0.8958, 0.8958, 1.2604, 0.8438, /*  */
  0.7083, 0.7083, 0.7083, 0.7188, 0.2500, 0.2396, 0.4271, 0.3646, /*  */
  0.8854, 0.7604, 0.9062, 0.9062, 0.9062, 0.9062, 0.9062, 0.5729, /*  */
  0.9375, 0.7500, 0.7500, 0.7500, 0.7500, 0.8750, 0.7188, 0.6771, /*  */
  0.6354, 0.6354, 0.6354, 0.6354, 0.6354, 0.6354, 1.0938, 0.6042, /*  */
  0.6354, 0.6354, 0.6354, 0.6354, 0.2396, 0.2500, 0.4167, 0.3646, /*  */
  0.6458, 0.5729, 0.6562, 0.6562, 0.6562, 0.6458, 0.6562, 0.6354, /*  */
  0.6562, 0.5729, 0.5729, 0.5729, 0.5521, 0.6354, 0.6042, 0.6354, /*  */
};

point estimate_textsize(char *str, char *fontname, double fontsz)
{
	point           rv;
	double		width=0.0, *Fontwidth;
	char		c,*p;

        if (strncasecmp(fontname,"cour",4) == 0) {
		Fontwidth = courFontWidth;
	}
	else if (strncasecmp(fontname,"arial",5) == 0) {
		Fontwidth = arialFontWidth;
	}
	else {
		Fontwidth = timesFontWidth;
	}
	p = str;
	while ((c = *p++)) {	
		width += Fontwidth[(unsigned char)c];
	}
	rv.x = fontsz*width;
	rv.y = fontsz;
	return rv;
}
