/*
              Copyright (C) 1993 - 2001   Masahito Yamaga

Permission to use, copy, and distribute this package and its documentation
for any purpose is granted, provided that this permission notice is included
in supporting documentation.

Permission to modify this package is also granted, but please send an e-mail
to Yamaga (ma@yama-ga.com) in case of distributing the modified code.

This package provides NO WARRANTY. You can use this at your own risks.

Copyrights on this package belong to Masahito Yamaga, but GNUPLOT's to Mr.
Thomas Williams and Mr. Colin Kelley (See "Copyright" in the original GNUPLOT
source package).

Distribution of GNUPLOT that has been applied this patch to (especially
binaries) has to be very carefully done. See "Copyright" in the original
GNUPLOT source package.

                                   2001/01/11 Masahito Yamaga(ma@yama-ga.com)
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <string.h>
#ifndef NO_STDLIB_H
#include <stdlib.h>
#endif
#include "gp+lib.h"

#ifdef __STDC__
int sindex(const char *s1,const char *s2)
#else
int sindex(s1,s2)
char *s1,*s2;
#endif
{
	int i, j;

	i = 0;
	while(s1[i] != '\0') {
		j=0;
		while(s2[j] == s1[i+j]) {
			if (s2[++j] == '\0') return(i+1);
		}
		++i;
	}
	return(0);
}

#ifdef __STDC__
char *substr(const char *str,int start,int last)
#else
char *substr(str,start,last)
char *str;
int start,last;
#endif
{
	static char *s;
	int	i = start - 1,
		j = 0;

	if (start > last || i < 0 ) return "";

	s = (char *)malloc(strlen(str) + 1);
	memset(s, 0, strlen(str) + 1);

	while(i < last && str[i] != '\0') {
		s[j++] = str[i++];
	}
	s[j] = '\0';

	return(s);
}

#ifdef __STDC__
void reverse(char *s)
#else
reverse(s)
char *s;
#endif
{
	int c, i, j;

	for(i = 0, j = strlen(s) - 1; i < j; i++, j--){
		c = s[i];
		s[i] = s[j];
		s[j] = c;
	}
}

#ifdef __STDC__
char *itostr(int n)
#else
char *itostr(n)
int n;
#endif
{
	int i, sign;
	static char s[128];

	if ((sign = n) < 0) n = -n;

	i = 0;
	do {
		s[i++] = n % 10 + '0';
	} while((n /= 10) > 0);

	if (sign < 0) s[i++] = '-';
	s[i] = '\0';

	reverse(s);
	return(s);
}
