/*
              Copyright (C) 1993 - 2001   Masahito Yamaga

Permission to use, copy, and distribute this package and its documentation
for any purpose is granted, provided that this permission notice is included
in supporting documentation.

Permission to modify this package is also granted, but please send an e-mail
to Yamaga (ma@yama-ga.com) in case of distributing the modified code.

This package provides NO WARRANTY. You can use this at your own risks.

Copyrights on this package belong to Masahito Yamaga, but GNUPLOT's to Mr.
Thomas Williams and Mr. Colin Kelley (See "Copyright" in the original GNUPLOT
source package).

Distribution of GNUPLOT that has been applied this patch to (especially
binaries) has to be very carefully done. See "Copyright" in the original
GNUPLOT source package.

                                   2001/01/11 Masahito Yamaga(ma@yama-ga.com)
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <string.h>
#ifndef NO_STDLIB_H
#include <stdlib.h>
#endif
#include "gp+lib.h"

extern FILE *gpoutfile;
int fontscale;

#ifdef __STDC__
void setcolor(int x,int y)
#else
setcolor(x,y)
int x,y;
#endif
{
	if (x!=y){
		switch(x){
		case GREEN:
			fprintf(gpoutfile,"Green\n");
			break;
		case BLUE:
			fprintf(gpoutfile,"Blue\n");
			break;
		case RED:
			fprintf(gpoutfile,"Red\n");
			break;
		case PURPLE:
			fprintf(gpoutfile,"Purple\n");
			break;
		case SKYBLUE:
			fprintf(gpoutfile,"Skyblue\n");
			break;
		case YELLOW:
			fprintf(gpoutfile,"Yellow\n");
			break;
		case GRAY:
			fprintf(gpoutfile,"Gray\n");
			break;
		default:
			fprintf(gpoutfile,"Black\n");
			break;
		}
	}
}

#ifdef __STDC__
char *setfontname(int x,int bold,int iso)
#else
char *setfontname(x,bold,iso)
int x,bold,iso;
#endif
{
	static char s[128];

	switch(x){
	case ITALIC:
		if (bold) strcpy(s, "bit");
		else strcpy(s, "it");
		if (iso) strcat(s," ISO");
		break;
	case COURIER:
		if (bold) strcpy(s, "btt");
		else strcpy(s, "tt");
		if (iso) strcat(s," ISO");
		break;
	case HELVETICA:
		if (bold) strcpy(s, "bsf");
		else strcpy(s, "sf");
		if (iso) strcat(s," ISO");
		break;
	case SYMBOL:
		return("sm");
		break;
	case NSYMBOL:
		return("nsm");
		break;
	case JAPANESE:
		if (bold) strcpy(s, "gothic");
		else strcpy(s, "mincho");
		break;
	case ROMAN:
		if (bold) strcpy(s, "brm");
		else strcpy(s, "rm");
		if (iso) strcat(s," ISO");
		break;
	default:
		strcpy(s, "df");
		if (iso) strcat(s," ISO");
		break;
	}
	return(s);
}

#ifdef __STDC__
extern char *itostr(int);
#else
extern char *itostr();
#endif

#ifdef __STDC__
char *setfontsize(int x)
#else
char *setfontsize(x)
int x;
#endif
{
	switch(x){
	case NORMALSIZE:
		return "ns";
		break;
	case TINY:
		return "ns 2 div";
		break;
	case SCRIPTSCRIPTSIZE:
		return "ns 2 div";
		break;
	case SCRIPTSIZE:
		return "ss";
		/* return "ns 0.7 mul"; */
		break;
	case FOOTNOTESIZE:
		return "ns 0.8 mul";
		break;
	case SMALL:
		return "ns 0.9 mul";
		break;
	case LARGE:
		return "ns 1.2 mul";
		break;
	case LARGE2:
		return "ns 1.4 mul";
		break;
	case LARGE3:
		return "ns 1.7 mul";
		break;
	case HUGE:
		return "ns 2 mul";
		break;
	case HUGE2:
		return "ns 2.5 mul";
		break;
	default:
		return itostr(x*fontscale);
		break;
	}
}

#ifdef __STDC__
char *setfontopt(int x)
#else
char *setfontopt(x)
int x;
#endif
{
	switch(x){
	case OBLIQUE:
		return("o ");
		break;
	case VERTICAL:
		return("v ");
		break;
	default:
		return("");
		break;
	}
}

#ifdef __STDC__
char *setpos(int x,int y)
#else
char *setpos(x,y)
int x,y;
#endif
{
	switch(x){
	case SUPERSC:
		return "u";
		break;
	case SUBSC:
		return "d";
		break;
	case SUPERSUPERSC:
		if (y) return "uu";
		else return "u";
		break;
	case SUBSUBSC:
		if (y) return "dd";
		else   return "d";
		break;
	case SUPERSUBSC:
		if (y) return "ud";
		else   return "u";
		break;
	case SUBSUPERSC:
		if (y) return "du";
		else   return "d";
		break;
	default:
		return "n";
		break;
	}
}

#ifdef __STDC__
extern int psplus_split(unsigned char *,struct style *);
extern unsigned char *get_size(unsigned char *,const char *,int *);
#else
extern int psplus_split();
extern unsigned char *get_size();
#endif

#ifdef __STDC__
void startendline(int x,int y,int line,int size,int fopt,int pos,int k)
#else
startendline(x,y,line,size,fopt,pos,k)
int x,y,line,size,fopt,pos,k;
#endif
{
	if (x > y) {

		if (line==2) {
			fprintf(gpoutfile,"(\\326) sm %s %s%s",
			     setfontsize(size),setfontopt(fopt),setpos(pos,k));
			if (k) fprintf(gpoutfile,"\n");
			else   fprintf(gpoutfile,"ln\n");
		} else if (k){
			fprintf(gpoutfile,"() sm %s %s%s\n",
			     setfontsize(size),setfontopt(fopt),setpos(pos,k));
		}

		if (k) fprintf(gpoutfile,"%d startline\n",line);

	} else if (x < y && k) fprintf(gpoutfile,"%d endline\n",line);
}

#ifdef __STDC__
void put_text(unsigned char *str,int showstyle)
#else
put_text(str,showstyle)
unsigned char *str;
int showstyle;
#endif
{
	int i,j,k,n,angle=0;
	struct style tmp[MAXWORD];

	str=get_size(str,"\\rotate=",&angle);

	fprintf(gpoutfile,"gsave\n");
	if (angle)
	      fprintf(gpoutfile,"currentpoint translate %d rotate 0 0 M\n",angle);
	fprintf(gpoutfile,"init\n");

	n=psplus_split(str,tmp);

	for(k=0;k<2;k++) {

	if (k){
		switch(showstyle){
		case 'R':
			fprintf(gpoutfile,"Right\n");
			break;
		case 'C':
			fprintf(gpoutfile,"Center\n");
			break;
		default:
			fprintf(gpoutfile,"Left\n");
			break;
		}
	}

	if(tmp[0].Frac==BUNSI){
		fprintf(gpoutfile,"fracstart");
		if (k) fprintf(gpoutfile,"\n");
		else   fprintf(gpoutfile,"ln\n");
	}

	startendline(tmp[0].Overline,FALSE,0,
				tmp[0].Size,tmp[0].Fopt,tmp[0].Pos,k);
	startendline(tmp[0].Underline,FALSE,1,
				tmp[0].Size,tmp[0].Fopt,tmp[0].Pos,k);
	startendline(tmp[0].Sqrtline,FALSE,2,
				tmp[0].Size,tmp[0].Fopt,tmp[0].Pos,k);
	if (k) setcolor(tmp[0].Color,BLACK);

	for(i=0;i<=n;i++){
		if (i){
			if(tmp[i].Frac==BUNSI && tmp[i-1].Frac==FALSE){
				fprintf(gpoutfile,"fracstart");
				if (k) fprintf(gpoutfile,"\n");
				else   fprintf(gpoutfile,"ln\n");
			}
			if(tmp[i].Frac==BUNBO && tmp[i-1].Frac==BUNSI){
				fprintf(gpoutfile,"fracmid");
				if (k) fprintf(gpoutfile,"\n");
				else   fprintf(gpoutfile,"ln\n");
			}
			if(tmp[i].Frac==FALSE && tmp[i-1].Frac==BUNBO){
				fprintf(gpoutfile,"fracend");
				if (k) fprintf(gpoutfile,"\n");
				else   fprintf(gpoutfile,"ln\n");
			}

			startendline(tmp[i].Overline,tmp[i-1].Overline,0,
					tmp[i].Size,tmp[i].Fopt,tmp[i].Pos,k);
			startendline(tmp[i].Underline,tmp[i-1].Underline,1,
					tmp[i].Size,tmp[i].Fopt,tmp[i].Pos,k);
			startendline(tmp[i].Sqrtline,tmp[i-1].Sqrtline,2,
					tmp[i].Size,tmp[i].Fopt,tmp[i].Pos,k);
			if (k) setcolor(tmp[i].Color,tmp[i-1].Color);
		}

		if (!strcmp((const char *)tmp[i].Body,"@NULL@")){
			tmp[i].Body[0]='\0';
			tmp[i].Font=SYMBOL;
		}

		if (tmp[i].Body[0] & 0x80){
			fprintf(gpoutfile,"(");
			for(j=0;j<(int)strlen((const char *)tmp[i].Body);j++){
				fprintf(gpoutfile,"\\%o",(tmp[i].Body[j])&0x7f);
			}
			fprintf(gpoutfile,") ");
			fprintf(gpoutfile,"%s ",
			      setfontname(JAPANESE,tmp[i].Bfont,FALSE));
		} else {
			fprintf(gpoutfile,"(%s) ",tmp[i].Body);
			fprintf(gpoutfile,"%s ",
			      setfontname(tmp[i].Font,tmp[i].Bfont,tmp[i].Iso));
		}

		fprintf(gpoutfile,"%s ",setfontsize(tmp[i].Size));

		if(tmp[i].Fopt) fprintf(gpoutfile,"%s",setfontopt(tmp[i].Fopt));

		fprintf(gpoutfile,"%s",setpos(tmp[i].Pos,k));
		if (k) {
			if (tmp[i].Body[0] & 0x80 && !tmp[i].Pos)
						fprintf(gpoutfile,"2");
			fprintf(gpoutfile,"\n");
		} else   fprintf(gpoutfile,"ln\n");

		if (tmp[i].Opt && k) {
			switch(tmp[i].Opt){
			case HAT:
				fprintf(gpoutfile,
					"(\\303) rm %s (%s) head\n",
					setfontsize(tmp[i].Size),tmp[i].Body);
				break;
			case CHECK:
				fprintf(gpoutfile,
					"(\\317) rm %s (%s) head\n",
					setfontsize(tmp[i].Size),tmp[i].Body);
				break;
			case TILDE:
				fprintf(gpoutfile,
					"(\\176) rm %s (%s) head\n",
					setfontsize(tmp[i].Size),tmp[i].Body);
				break;
			case ACUTE:
				fprintf(gpoutfile,
					"(\\302) rm %s (%s) head\n",
					setfontsize(tmp[i].Size),tmp[i].Body);
				break;
			case DOT:
				fprintf(gpoutfile,
					"(.) sm %s (%s) head\n",
					setfontsize(tmp[i].Size),tmp[i].Body);
				break;
			case DDOT:
				fprintf(gpoutfile,
					"(\\310) rm %s (%s) head\n",
					setfontsize(tmp[i].Size),tmp[i].Body);
				break;
			case GRAVE:
				fprintf(gpoutfile,
					"(\\301) rm %s (%s) head\n",
					setfontsize(tmp[i].Size),tmp[i].Body);
				break;
			case BREVE:
				fprintf(gpoutfile,
					"(\\306) rm %s (%s) head\n",
					setfontsize(tmp[i].Size),tmp[i].Body);
				break;
			case BAR:
				fprintf(gpoutfile,
					"(\\261) rm %s (%s) head\n",
					setfontsize(tmp[i].Size),tmp[i].Body);
				break;
			case VEC:
				fprintf(gpoutfile,
					"(\\256) sm %s Vs (%s) head\n",
					setfontsize(tmp[i].Size),tmp[i].Body);
				break;
			default:
				break;
			}
		}
	}

		if(tmp[n].Frac){
			fprintf(gpoutfile,"fracend");
			if (k) fprintf(gpoutfile,"\n");
			else   fprintf(gpoutfile,"ln\n");
		}

		startendline(FALSE,tmp[n].Overline,0,
					tmp[n].Size,tmp[n].Fopt,tmp[n].Pos,k);
		startendline(FALSE,tmp[n].Underline,1,
					tmp[n].Size,tmp[n].Fopt,tmp[n].Pos,k);
		startendline(FALSE,tmp[n].Sqrtline,2,
					tmp[n].Size,tmp[n].Fopt,tmp[n].Pos,k);
		if (k) setcolor(BLACK,tmp[n].Color);
	}

	fprintf(gpoutfile,"grestore\n");
}

#ifdef __STDC__
void psplus_put_text(char *str,int scale,int showstyle)
#else
psplus_put_text(str,scale,showstyle)
char *str;
int scale,showstyle;
#endif
{
	unsigned char *tmpstr;
	tmpstr=(unsigned char *)malloc(2*MAXLEN);

	fontscale=scale;

	while(*str==' ') ++str;
	strcpy((char *)tmpstr,str);

	put_text(tmpstr,showstyle);
	free(tmpstr);
}
