// Copyright (C) 2001 Nils Bokermann <Nils.Bokermann@mediaWays.net>
//
// PURPOSE OF THIS FILE: Implement ldap_abandon functions
//
// - Automatic Version Information via RCS:
//   $Id: abandon.cxx,v 1.1 2001/12/17 16:36:17 nilsb Exp $
//   $Source: /cvsroot/openh323gk/openh323gk/ldap/src/abandon.cxx,v $
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "ldapapi.h"
#include <ldap-int.h>

#ifndef lint
// mark object with version info
static const char vcid[] = "@(#) $Id: abandon.cxx,v 1.1 2001/12/17 16:36:17 nilsb Exp $";
static const char vcHid[] = __LDAP_OPENH323_H;
#endif

int ldap_abandon_ext (LDAP *ld, int msgid, LDAPControl **serverctrls,
		      LDAPControl **clientctrls) {
  LDAP_LDAPMessage msg;
  
  msg.m_messageID=++(ld->msg_id);
  msg.m_protocolOp=LDAP_LDAPMessage_protocolOp(LDAP_LDAPMessage_protocolOp::e_abandonRequest);
  if(!msg.m_protocolOp.CreateObject()){
    ld->ld_errno=LDAP_NO_MEMORY;
    return LDAP_NO_MEMORY;
  }

  LDAP_AbandonRequest &ab=msg.m_protocolOp;
  ab=msgid;

  PBER_Stream encoding_stream;
  msg.Encode(encoding_stream);
  if(encoding_stream.Write(*(ld->socket))) {
    return LDAP_SUCCESS;
  }
  ld->ld_errno=LDAP_UNAVAILABLE;
  return ld->ld_errno;
}

int ldap_abandon (LDAP *ld, int msgid) {
  return ldap_abandon_ext(ld, msgid, NULL, NULL);
}


//
// End of abandon.cxx
//
