//////////////////////////////////////////////////////////////////
//
// ODBC Connection for GNU Gatekeeper
//
// Copyright (c) Farooq S. Khan 
//
// This work is published under the GNU Public License (GPL)
// see file COPYING for details.
// We also explicitely grant the right to link this code
// with the OpenH323 library.
//
// initial author: Farooq S. Khan (fskhan@ezvoip.net)
// initial version: 10/03/2003
//
//////////////////////////////////////////////////////////////////

#ifndef ODBCCON_H
#define ODBCCON_H "@(#) $Id: odbcsupp.h,v 1.1.2.1 2003/11/10 14:06:34 zvision Exp $"

#define HAS_ODBC

#ifndef _PTLIB_H
#include <ptlib.h>
#endif


#ifdef WIN32
#include <windows.h>
#endif 

/* STANDARD C HEADERS */
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

/* ODBC HEADERS */
#include <sql.h>
#include <sqlext.h>

#ifdef NEVER
#ifndef NULL
#define NULL 0
#endif

#ifndef ushort
#define ushort unsigned short
#endif

#ifndef bool
#define bool unsigned char
#endif

#ifndef true
#define true 1
#endif

#ifndef false
#define false 0
#endif
#endif 

// None of our SQL fields are longer than 255. 
#define MAX_NAME_LEN 128
#define MAX_COLUMNS 32
#define MAX_COL_DATA_LEN 64

// Settings for H.235 based module will be stored inside [RadAuth] config section
#define ODBCAuthConfigSectionName "ODBCPasswordAuth"
// Settings for alias based module will be stored inside [RadAliasAuth] config section
#define ODBCAliasAuthConfigSectionName "ODBCAliasAuth"


typedef struct st_OneCol {
	char aCol[MAX_COL_DATA_LEN];
} ONECOL;

typedef struct st_OneRow {
	char aRow[MAX_COLUMNS*MAX_COL_DATA_LEN];
} ONEROW;


typedef struct st_ODBCCon {
    SQLHENV  *  henv;
    SQLHDBC  *  hdbc; 
    SQLHSTMT *  hstmt;
} ODBCCon;

struct st_ODBC_res;
typedef st_ODBC_res ODBC_RES;
void ODBCTest(const PString & SQLstmt);


class ODBCsupp {
public:

	ODBCsupp(PConfig *, const char *);
	virtual ~ODBCsupp();

    bool ODBCsupp::ExecThisQuery(SQLCHAR * theSQL);
	bool ColFetch(const PString &,PString &);
	bool RowFetch(const PString &,ONEROW * aRow);
    bool FetchNxN(SQLCHAR * SQLStmt,  ONECOL *  InVars, int InVarsCount,  ONECOL *  OutVars, int OutVarsCount);


protected:

	bool Init();
	void Cleanup();

    
	PMutex m_mutex;
	ODBCCon   * odbc_connection;
	PString m_clause;

	PConfig *m_config;
	const char *m_section;
};

#endif // ODBCCON_H
/* ifdef  HAS_ODBC */

