/* -*- C++ -*-
#S#
#
# This Program is part of EbDic (EP-WING Dictionary Reader)
# Copyright (C) 1995-1997 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. (File "COPYING")
#
#    Note!: General Public Licence is copyrighted by the Free Software 
#           Foundation,  but this code is copyrighted by me.
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
#E#
*/

#ifndef __def_h__
#define __def_h__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

const int cCacheBlocks=256;  

const unsigned int cMaxHit=200;
const int cDispMaxX=80;
const int cDispMaxY=24;
const int cVramMaxX=80;

const int cDicMaxBlock=999999; // do not edit
const unsigned int cHistSize=20;
const unsigned int cMaxGaiji=100;

const int cMaxKeywordLen=256;  // do not edit 
const int cBlockSize=2048;  // do not edit 

const int cMaxButton=2048;
const int cTmpLength=1024;

const bool cAutoInlineImage=true;


typedef unsigned long dword;
typedef unsigned short word;
typedef unsigned char byte;

extern dword GetDWord(byte *buf);
extern word GetWord(byte *buf);
extern dword GetRDWord(byte *buf);
extern word GetRWord(byte *buf);
extern bool PutDWord(dword d,byte *buf);
extern bool PutWord(word d,byte *buf);
extern bool PutRDWord(dword d,byte *buf);
extern bool PutRWord(word d,byte *buf);
extern int GetBCD(byte *buf,int nDigits=2);

#include "debug.h"

#if !defined(HAVE_GETTEXT) && defined(ENABLE_NLS)
#undef ENABLE_NLS
#endif

#ifdef ENABLE_NLS
#include <libintl.h>

inline const char* _(const char* str) { return gettext(str); };
#ifdef gettext_noop
#define N_(str) gettext_noop (str)
#else
#define N_(str) (str)
#endif

#else
inline const char* _(const char* str) { return str; };
#define N_(str) (str)
#endif
#endif

#ifndef INC_STRING
#define INC_STRING
#include <string>
#ifdef NEED_BASTRING_CC
#include <std/bastring.cc>
#endif
#endif
typedef std::string EUC_STRING;
typedef std::string JIS_STRING;
typedef std::string NATIVE_STRING;
typedef std::string UTF8_STRING;
typedef std::string UNKNOWN_STRING;
