// -*- C++ -*-

/*
#
# This Program is part of Dictionary Reader
# Copyright (C) 1999 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. 
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
*/

#ifndef __CATALOG_H__
#define __CATALOG_H__

#include "def.h"

#if defined(HAVE_VECTOR) && defined(HAVE_STRING)

#ifndef INC_VECTOR
#include <vector>
#define INC_VECTOR
#endif

#ifndef INC_STRING
#define INC_STRING
#include <string>
#ifdef NEED_BASTRING_CC
#include <std/bastring.cc>
#endif
#endif

#else // !defined(HAVE_VECTOR) || !defined(HAVE_STRING)
#error You need STL headers in INCLUDES path.
#endif

class DICT {
protected:
  int bookNumber;
  int version;
  bool iseb;
  NATIVE_STRING dicName;
  NATIVE_STRING baseDir;
  NATIVE_STRING dicPath;
  NATIVE_STRING streamPath;
  NATIVE_STRING graphicsPath;
  NATIVE_STRING soundPath;
  NATIVE_STRING moviePath;
  NATIVE_STRING gaijiPath[2][4];
  int charOffset,gaijiOffset,charExtend;
  bool autoImageDisplay;
  int startBlock;
  bool GetDictViaNDTP(NATIVE_STRING baseDirName);

public:
  DICT() { };
  DICT(const DICT& dict);
  int Type() const { return 0xff & (version >> 8); };
  int Version() const { return version & 0xff; };
  bool isEB() const { return iseb; };
  const std::string DicName() const { return dicName; };
  const char* BaseDir() const;
  const char* DicPath() const;
  const char* StreamPath() const;
  const char* GraphicsPath() const;
  const char* SoundPath() const;
  const char* MoviePath() const;
  const char* GaijiPath(int isHankaku,int size) const;
  bool AutoImageDisplay() const { return autoImageDisplay; };
  int StartBlock() const { return startBlock; };
  int CharOffset() const { return charOffset; };
  int GaijiOffset() const { return gaijiOffset; };
  int CharExtend() const { return charExtend; };

  void DebugOut(int debugLevel=Debug::CATALOG_DECODE) const;

  friend class CATALOG;
  friend class BOOK;
};

struct BOOK {
  std::string title;
  NATIVE_STRING path;      // for save preference 
  int charOffset;   // for save preference 
  int gaijiOffset;  // for save preference 
  int charExtend;   // for save preference 
  bool autoImage;   // for save preference 
  bool disable;   // for save preference
  NATIVE_STRING disableSubbook;   // for save preference
  std::vector<DICT> dict;
};

struct CATALOG {
  int version;
  std::vector<BOOK> books;
  CATALOG();
  ~CATALOG();
  DICT* Dic(int n);
  int nDic();
  bool Append(std::string path,std::string title,
	      int charOffset,int gaijiOffset,int charExtend,
	      bool autoImage,bool disable, std::string disableSubbook=std::string(""));
  bool Clear();
};

#endif

