// -*- C++ -*-
/*
#
# This Program is part of Dictionary Reader
# Copyright (C) 1999 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. 
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
*/

#include "gui.h"
#include "global.h"

GtkWidget* indexSearchMenu;
GtkWidget* indexEntryBox[8];
GtkWidget* indexCountBox[8];
INDEXITEMLIST_T wordList[8];
gint indexEntryNum[8];
GtkWidget* menuTreeHead[8];
int indexSearchID;

static gboolean DestroyIndexSearchMenu(GtkWidget *widget)
{
  gtk_main_quit ();
  gtk_widget_destroy(indexSearchMenu);
  return false;
}


static gboolean GoIndexSearch(GtkWidget* w){
  DestroyIndexSearchMenu(w);

  for(int i=0;i<8;i++){
    for(INDEXITEMLIST_T::iterator ii=wordList[i].begin();
	ii!=wordList[i].end();++ii){
      (*ii).keywordTag=(*ii).adrs;
      (*ii).keyword=(*ii).dkeyword;
    }
  }

  INDEXITEMLIST_T w0=wordList[0],w1;
  for(int i=1;i<8;i++){
    w1=And(w0,wordList[i]);
    w0=w1;
  }
  // MakeIndexList(w0,false);
  currentDict->sel->items.clear();
  copy(w0.begin(),w0.end(),back_inserter(currentDict->sel->items));
  currentDict->sel->nReverse=0;
  currentDict->sel->nForward=currentDict->sel->items.size();
  MakeIndexList(currentDict->sel,false);
  return false;
}

void indexEntryEdit_callback(GtkWidget *widget, int *entryNum){
  char buf[1024];
  int ent=*entryNum;
  EUC_STRING entry_text = 
    _CE(gtk_entry_get_text(GTK_ENTRY(indexEntryBox[ent])));
  wordList[ent]=currentDict->FindWord(entry_text,indexSearchID);
  sprintf(buf,"%6d",wordList[ent].size());
  gtk_label_set(GTK_LABEL(indexCountBox[ent]),buf);
}

void CreateIndexSearchMenu(GtkWidget* parent,int indexNumber){
  indexSearchMenu=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_modal(GTK_WINDOW(indexSearchMenu),true);
  gtk_window_set_transient_for (GTK_WINDOW(indexSearchMenu),
				GTK_WINDOW (parent));
  gtk_signal_connect (GTK_OBJECT(indexSearchMenu), "destroy",
		      GTK_SIGNAL_FUNC(DestroyIndexSearchMenu),NULL);
  GtkWidget* vbox=gtk_vbox_new(false,0);

  for(int i=0;i<8;i++){
    wordList[i].clear();
  }

  if (currentDict->IndexExist(indexNumber)){
    GtkWidget* lbl=gtk_label_new(currentDict->IndexName(indexNumber));
    indexSearchID=indexNumber;
    gtk_widget_show(lbl);
    gtk_box_pack_start(GTK_BOX(vbox),lbl,false,false,1);
  }
  for(int i=0;i<8;i++){
    indexEntryNum[i]=i;
    GtkWidget* hbox=gtk_hbox_new(false,0);
    GtkWidget* labelBox=gtk_label_new(i==0?"    ":_("And "));
    indexEntryBox[i]=gtk_entry_new_with_max_length(40);
    indexCountBox[i]=gtk_label_new("     0");
    gtk_signal_connect(GTK_OBJECT(indexEntryBox[i]), "changed",
		       GTK_SIGNAL_FUNC(indexEntryEdit_callback),
		       indexEntryNum+i);
    gtk_widget_show(labelBox);
    gtk_widget_show(indexEntryBox[i]);
    gtk_widget_show(indexCountBox[i]);
    gtk_box_pack_start(GTK_BOX(hbox),labelBox,false,false,1);
    gtk_box_pack_start(GTK_BOX(hbox),indexEntryBox[i],false,false,1);
    gtk_box_pack_start(GTK_BOX(hbox),indexCountBox[i],false,false,1);
    gtk_widget_show(hbox);
    gtk_box_pack_start(GTK_BOX(vbox),hbox,false,false,1);
  }
  GtkWidget* hbox=gtk_hbox_new(false,0);
  GtkWidget* goButton=gtk_button_new_with_label(_(" Search "));
  GtkWidget* closeButton=gtk_button_new_with_label(_(" Close "));
  gtk_widget_show(goButton);
  gtk_widget_show(closeButton);
  gtk_box_pack_start(GTK_BOX(hbox),goButton,false,false,1);
  gtk_box_pack_start(GTK_BOX(hbox),closeButton,false,false,1);
  gtk_box_pack_start(GTK_BOX(vbox),hbox,false,false,1);
  gtk_widget_show(hbox);
  gtk_widget_show(vbox);
  gtk_container_add(GTK_CONTAINER(indexSearchMenu),vbox);
  gtk_widget_show (indexSearchMenu);
  gtk_signal_connect (GTK_OBJECT(closeButton), "clicked",
		      GTK_SIGNAL_FUNC(DestroyIndexSearchMenu),indexSearchMenu);
  gtk_signal_connect (GTK_OBJECT(goButton), "clicked",
		      GTK_SIGNAL_FUNC(GoIndexSearch),indexSearchMenu);
  gtk_main ();
}
 


static gboolean DestroyMessageBox(GtkWidget *widget)
{
  gtk_main_quit ();
  return false;
}

void CreateMessageBox(GtkWidget* parent,GtkWidget* child1,GtkWidget* child2){
  if (parent==NULL) return;
  GtkWidget* messageBox=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_modal(GTK_WINDOW(messageBox),true);
  gtk_window_set_transient_for (GTK_WINDOW(messageBox),
				GTK_WINDOW (parent));
  GtkWidget* vbox=gtk_vbox_new(false,0);
  gtk_widget_show(child1);
  gtk_box_pack_start(GTK_BOX(vbox),child1,false,false,1);
  if (child2!=NULL) {
    gtk_widget_show(child2);
    gtk_box_pack_start(GTK_BOX(vbox),child2,false,false,1);
  }
  GtkWidget* ok=gtk_button_new_with_label(_("Ok"));
  gtk_widget_show(ok);
  gtk_box_pack_start(GTK_BOX(vbox),ok,false,false,1);
  gtk_widget_show(vbox);
  gtk_container_add(GTK_CONTAINER(messageBox),vbox);
  gtk_widget_show (messageBox);
  gtk_signal_connect (GTK_OBJECT(messageBox), "destroy",
		      GTK_SIGNAL_FUNC(DestroyMessageBox),NULL);
  gtk_signal_connect_object (GTK_OBJECT(ok),"clicked", 
			     GTK_SIGNAL_FUNC(gtk_widget_destroy),
			     GTK_OBJECT(messageBox));
  gtk_main ();
}

bool yesno=false; 
static gboolean DestroyYesNoBox(GtkWidget *widget)
{
  gtk_main_quit();
  return false;
}

static gboolean DestroyYesNoBoxYes(GtkWidget *widget)
{
  yesno=true;
  gtk_widget_destroy(widget);
  return true;
}

static gboolean DestroyYesNoBoxNo(GtkWidget *widget)
{
  yesno=false;
  gtk_widget_destroy(widget);
  return true;
}

void CreateYesNoBox(GtkWidget* parent,const char* lb1,const char* lb2,
		    const char* yesStr,const char* noStr,bool defaultVal){
  yesno=defaultVal;
  //  GtkWidget* messageBox=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  GtkWidget* messageBox=gtk_dialog_new();
  gtk_window_set_modal(GTK_WINDOW(messageBox),true);
  /*
  gtk_window_set_transient_for (GTK_WINDOW(messageBox),
				GTK_WINDOW (parent));
  */
  //  GtkWidget* vbox=gtk_vbox_new(false,0);
  GtkWidget* vbox=GTK_DIALOG(messageBox)->vbox;
  GtkWidget* child1=gtk_label_new(lb1);
  gtk_widget_show(child1);
  gtk_box_pack_start(GTK_BOX(vbox),child1,false,false,1);
  if (lb2!=NULL) {
    GtkWidget* child2=gtk_label_new(lb2);
    gtk_widget_show(child2);
    gtk_box_pack_start(GTK_BOX(vbox),child2,false,false,1);
  }

  GtkWidget* yes=gtk_button_new_with_label(yesStr);
  gtk_widget_show(yes);
  GTK_WIDGET_SET_FLAGS(yes,GTK_CAN_DEFAULT);

  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(messageBox)->action_area),
		     yes,false,false,1);
  GtkWidget* no=gtk_button_new_with_label(noStr);
  gtk_widget_show(no);
  GTK_WIDGET_SET_FLAGS(no,GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(messageBox)->action_area),
		     no,false,false,1);
  //  gtk_widget_show(vbox);
  //  gtk_container_add(GTK_CONTAINER(messageBox),vbox);
  gtk_widget_show (messageBox);
  gtk_signal_connect (GTK_OBJECT(messageBox), "destroy",
		      GTK_SIGNAL_FUNC(DestroyYesNoBox),NULL);
  gtk_signal_connect_object (GTK_OBJECT(yes),"clicked", 
			     GTK_SIGNAL_FUNC(DestroyYesNoBoxYes),
			     GTK_OBJECT(messageBox));
  gtk_signal_connect_object (GTK_OBJECT(no),"clicked", 
			     GTK_SIGNAL_FUNC(DestroyYesNoBoxNo),
			     GTK_OBJECT(messageBox));
  gtk_widget_grab_default(yes);
  gtk_main ();
}
 
static gboolean DestroyModelessMessageBox(GtkWidget *widget)
{
  gtk_widget_destroy(widget);
  return true;
}

void CreateModelessMessageBox(GtkWidget* parent,GtkWidget* child1,
			      GtkWidget* child2){
  GtkWidget* messageBox=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_transient_for (GTK_WINDOW(messageBox),
				GTK_WINDOW (parent));
  GtkWidget* vbox=gtk_vbox_new(false,0);
  gtk_widget_show(child1);
  gtk_box_pack_start(GTK_BOX(vbox),child1,false,false,1);
  if (child2!=NULL) {
    gtk_widget_show(child2);
    gtk_box_pack_start(GTK_BOX(vbox),child2,false,false,1);
  }
  GtkWidget* ok=gtk_button_new_with_label(_("Ok"));
  gtk_widget_show(ok);
  gtk_box_pack_start(GTK_BOX(vbox),ok,false,false,1);
  gtk_widget_show(vbox);
  gtk_container_add(GTK_CONTAINER(messageBox),vbox);
  gtk_widget_show (messageBox);
  gtk_signal_connect (GTK_OBJECT(messageBox), "destroy",
		      GTK_SIGNAL_FUNC(DestroyModelessMessageBox),NULL);
  gtk_signal_connect_object (GTK_OBJECT(ok),"clicked", 
			     GTK_SIGNAL_FUNC(gtk_widget_destroy),
			     GTK_OBJECT(messageBox));
}
 
struct MENU_ITEM {
  int id;
  JIS_STRING text;
  DICSTRING dicstring;
  GtkWidget* widget;
  MENU_ITEM(int i,JIS_STRING& s,DICSTRING& s2,GtkWidget* w){
    id=i;
    text=s;
    dicstring=s2;
    widget=w;
  };
};

std::vector<MENU_ITEM*> menuItemList;

static void InitializeMenuTree(){
  for(int i=menuItemList.size()-1;i>=0;--i){
    delete menuItemList[i];
  }
  menuItemList.clear();
}

static void MenuTreeSelect(GtkWidget* w,gpointer p){
  MENU_ITEM* item=reinterpret_cast<MENU_ITEM*>(p);
  gtk_option_menu_set_history(GTK_OPTION_MENU(menuTreeHead[item->id]),0);
  gtk_entry_set_text(GTK_ENTRY(indexEntryBox[item->id]),
		     _EC(_JE(item->text)).c_str());
}

static GtkWidget* MakeMenuTree(int id=-1,BlockIO* pf=NULL,TAG t=TAG(0,0),
			NATIVE_STRING title=NATIVE_STRING("")){
  int menuCount=0;
  if (id==-1) {
    InitializeMenuTree();
    return NULL;
  }

  GtkWidget* menu=gtk_menu_new();
  GtkWidget* orgMenu=menu;
  if (title!=NATIVE_STRING("")){
    gtk_menu_append(GTK_MENU(menu),
		    gtk_menu_item_new_with_label(title.c_str()));
  }

  TAG orgPoint=pf->Tell();
  if (t!=TAG(0,0)){  pf->Seek(t); };
  JIS_STRING menuItemString=JIS_STRING("");
  DICSTRING menuItemDicString=DICSTRING();
  for(int ch=pf->GetWord();ch!=0x1f03;ch=pf->GetWord()){
    switch(ch){
    case 0:
      break;
    case 0x1f43:
      break;
    case 0x1f63:
      {
	GtkWidget* w=gtk_menu_item_new();
	GtkWidget* pix=MakePixmapFromDicText(menuItemDicString,false);
	gtk_container_add(GTK_CONTAINER(w),pix);
	MENU_ITEM* m=new MENU_ITEM(id,menuItemString,menuItemDicString,pix);
	menuItemList.push_back(m);
	TAG tt=pf->GetBCDTag();
	if (tt!=TAG(0,0)){
	  gtk_menu_item_set_submenu(GTK_MENU_ITEM(w),MakeMenuTree(id,pf,tt));
	} else {
	  gtk_signal_connect(GTK_OBJECT(w),"activate",
			     GTK_SIGNAL_FUNC(MenuTreeSelect),
			     static_cast<gpointer>(m));
	}
	gtk_widget_show_all(w);
	gtk_menu_append(GTK_MENU(menu),w);
	menuCount++;
	if (menuCount>15){
	  w=gtk_menu_item_new_with_label(_("<< More >>"));
	  gtk_widget_show(w);
	  gtk_menu_append(GTK_MENU(menu),w);
	  menu=gtk_menu_new();
	  gtk_menu_item_set_submenu(GTK_MENU_ITEM(w),menu);
	  menuCount=0;
	}
      }
      menuItemString=JIS_STRING("");
      menuItemDicString=DICSTRING();
      break;
    default:
      if ((ch & 0xff00)==0x1f00) break;
      menuItemString+=static_cast<char>(255 & (ch>>8));
      menuItemString+=static_cast<char>(255 & ch);
      menuItemDicString+=DICCHAR(ch,ATTR(),TAG(0,0));
    }
  }
  

  pf->Seek(orgPoint);
  gtk_widget_show_all(orgMenu);
  return orgMenu;
}

static void combinedEntryEdit_callback(GtkWidget *widget, int *entryNum){
  char buf[1024];
  int ent1=65535 & ((*entryNum)>>16);
  int ent2=65535 & (*entryNum);
  EUC_STRING entry_text = 
    _CE(gtk_entry_get_text(GTK_ENTRY(indexEntryBox[ent2])));
  wordList[ent2]=currentDict->FindWord(entry_text,ent1,ent2);
  sprintf(buf,"%6d",wordList[ent2].size());
  gtk_label_set(GTK_LABEL(indexCountBox[ent2]),buf);
}

void CreateCombinedSearchMenu(GtkWidget* parent,int indexNumber){
  indexSearchMenu=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_modal(GTK_WINDOW(indexSearchMenu),true);
  gtk_window_set_transient_for (GTK_WINDOW(indexSearchMenu),
				GTK_WINDOW (parent));
  gtk_signal_connect (GTK_OBJECT(indexSearchMenu), "destroy",
		      GTK_SIGNAL_FUNC(DestroyIndexSearchMenu),NULL);
  GtkWidget* vbox=gtk_vbox_new(false,0);

  for(int i=0;i<8;i++){
    wordList[i].clear();
  }
  //===================
  //  indexNumber&=0xf;
  indexNumber=(indexNumber & 0xff00)>>8;
  if (indexNumber > currentDict->nmIndex()) return;

  Debug::DebugOut(Debug::TEMP,"Combined Index Number = %02x\n",indexNumber);

  MINDEX_HEAD* midx=currentDict->MIndex(indexNumber);
  GtkWidget* lbl=gtk_label_new(currentDict->MIndexName(indexNumber));
  gtk_widget_show(lbl);
  gtk_box_pack_start(GTK_BOX(vbox),lbl,false,false,1);
  int maxlen=strlen(reinterpret_cast<const char*>
		    (midx->SubIndex(0)->typeName));
  for(int i=1;i<midx->nSubIndex();i++){
    int len=strlen(reinterpret_cast<const char*>(midx->SubIndex(i)->typeName));
    if (maxlen<len) maxlen=len;
  }

  MakeMenuTree(-1); // Initialize Menu
    
  for(int i=0;i<midx->nSubIndex();i++){
    char buf[32];
    SUBINDEX* sb=midx->SubIndex(i);
    indexEntryNum[i]=i+(indexNumber<<16);
    GtkWidget* hbox=gtk_hbox_new(false,0);
    EUC_STRING labelName=_JE(reinterpret_cast<const char*>(sb->typeName));
    sprintf(buf,"%-30s ",labelName.c_str());
    buf[maxlen+1]=0;
    GtkWidget* labelBox=gtk_label_new(_EC(buf).c_str());
    indexEntryBox[i]=gtk_entry_new_with_max_length(40);
    indexCountBox[i]=gtk_label_new("     0");
    gtk_signal_connect(GTK_OBJECT(indexEntryBox[i]), "changed",
		       GTK_SIGNAL_FUNC(combinedEntryEdit_callback),
		       indexEntryNum+i);

    gtk_widget_show(labelBox);
    gtk_widget_show(indexEntryBox[i]);
    gtk_widget_show(indexCountBox[i]);
    gtk_box_pack_start(GTK_BOX(hbox),labelBox,false,false,1);
    gtk_box_pack_start(GTK_BOX(hbox),indexEntryBox[i],false,false,1);
    gtk_box_pack_start(GTK_BOX(hbox),indexCountBox[i],false,false,1);

    if (sb->subSubIndex.find(0x01)!=sb->subSubIndex.end()){
      GtkWidget* menu=gtk_menu_new();
      GtkWidget* w=gtk_menu_item_new_with_label("");
      gtk_widget_show(w);
      gtk_menu_append(GTK_MENU(menu),w);
      INDEX_HEAD * sbsbidx=sb->SubSubIndex(0x01);
      BlockIO* pf=currentDict->BlockFile();

      menu=MakeMenuTree(i,pf,TAG(sbsbidx->start,0),_("=== Select ==="));

      gtk_widget_show(menu);
      GtkWidget* menuButton=gtk_option_menu_new();
      menuTreeHead[i]=menuButton;
      gtk_option_menu_set_menu(GTK_OPTION_MENU(menuButton),menu);
      gtk_widget_show(menuButton);
      gtk_box_pack_start(GTK_BOX(hbox),menuButton,false,false,1);
    }

    gtk_widget_show(hbox);
    gtk_box_pack_start(GTK_BOX(vbox),hbox,false,false,1);
  }
  GtkWidget* hbox=gtk_hbox_new(false,0);
  GtkWidget* goButton=gtk_button_new_with_label(_(" Search "));
  GtkWidget* closeButton=gtk_button_new_with_label(_(" Close "));
  gtk_widget_show(goButton);
  gtk_widget_show(closeButton);
  gtk_box_pack_start(GTK_BOX(hbox),goButton,false,false,1);
  gtk_box_pack_start(GTK_BOX(hbox),closeButton,false,false,1);
  gtk_box_pack_start(GTK_BOX(vbox),hbox,false,false,1);
  gtk_widget_show(hbox);
  gtk_widget_show(vbox);
  gtk_container_add(GTK_CONTAINER(indexSearchMenu),vbox);
  gtk_widget_show (indexSearchMenu);
  gtk_signal_connect (GTK_OBJECT(closeButton), "clicked",
		      GTK_SIGNAL_FUNC(DestroyIndexSearchMenu),indexSearchMenu);
  gtk_signal_connect (GTK_OBJECT(goButton), "clicked",
		      GTK_SIGNAL_FUNC(GoIndexSearch),indexSearchMenu);
  gtk_main ();
}


static GtkWidget* fileDialog=NULL;
static gboolean fselOk=FALSE;
// static string retCode;

static gboolean DestroyFileDialog(GtkWidget* w,int ok){
  if (fileDialog!=NULL) {
    gtk_main_quit();
  }
  return false;
}

void fsel_ok(GtkWidget *w, GtkFileSelection *fs){
  fselOk=TRUE;
  gtk_main_quit();
}

void fsel_cancel (GtkWidget *w, GtkFileSelection *fs){
  fselOk=FALSE;
  gtk_main_quit();
}

NATIVE_STRING FileDialog(NATIVE_STRING fileName,NATIVE_STRING defaultFileName){
  if (fileDialog!=NULL) gtk_widget_destroy(fileDialog);

  GtkWidget* fileDialog=gtk_file_selection_new("Select catalog file");
  gtk_window_set_modal(GTK_WINDOW(fileDialog),true);
  gtk_window_set_transient_for(GTK_WINDOW(fileDialog),
			       GTK_WINDOW(mainWindow));

  gtk_file_selection_complete(GTK_FILE_SELECTION(fileDialog),
			      defaultFileName.c_str());
  gtk_signal_connect(GTK_OBJECT(fileDialog), "destroy",
		     GTK_SIGNAL_FUNC(DestroyFileDialog),NULL);
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION (fileDialog)->ok_button),
		     "clicked", (GtkSignalFunc) fsel_ok, fileDialog);
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(fileDialog)->cancel_button),
		      "clicked", (GtkSignalFunc) fsel_cancel, fileDialog);
  gtk_widget_show_all(fileDialog);
  gtk_main();
  NATIVE_STRING fname=NATIVE_STRING(gtk_file_selection_get_filename(
		      GTK_FILE_SELECTION(fileDialog)));
  gtk_widget_destroy(fileDialog);
  fileDialog=NULL;
  if (fselOk) return fname;
  return NATIVE_STRING("");
}

