/*
#
# This Program is part of Dictionary Reader
# Copyright (C) 1999 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. 
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
*/

#include <cstdio>
#include <cstring>

// EBXA
inline int GetHalf(int high_p, unsigned char *ubuf) {
  int val = (high_p == 0) ? *ubuf: (*ubuf)>>4;
  return (val & 7) - (val & 8);
}

static void XADecode(FILE* ofp,char* sbuf,int& prev1,int& prev2){
  const int delta1[4]={0,0xf0,0x1cc,0x188};
  const int delta2[4]={0,0,-0xd0,-0xdc};
  int val;
  unsigned char* ubuf=reinterpret_cast<unsigned char*>(sbuf) + 4;
  unsigned char* ubuf2=reinterpret_cast<unsigned char*>(sbuf) + 16;
  for(int i=0;i<8;i++){
    int r=12-(ubuf[i]&15);
    int f=(ubuf[i]>>4)&15;
    for(int j=0;j<28;j++){
      val=(GetHalf((i&1),ubuf2+i/2+j*4)<<r)+
	((prev1*delta1[f]+prev2*delta2[f])>>8);
      if (val<-0x8000) val=-0x8000;
      if (val>0x7fff) val=0x7fff;
      putc(val & 255,ofp);
      putc(((0xff00 & val) >> 8)&255,ofp);
      prev2=prev1;
      prev1=val;
    }
  }
}

bool Ebxa2wav(FILE* soundfp,FILE* wavfp,int startLBA,int endLBA){
  char buf0[128];
  int size=8*28*2*18*(((endLBA-startLBA)>>4)+1);
  // Write WAV Header
  fprintf(wavfp,"RIFF");

  int l=size+0x24;         // Data + Header Length
  putc(l & 255,wavfp);
  putc((l>>8) & 255,wavfp);
  putc((l>>16) & 255,wavfp);
  putc((l>>24) & 255,wavfp);
  
  fprintf(wavfp,"WAVEfmt ");
  putc(0x10,wavfp); putc(0x0,wavfp); putc(0x0,wavfp); putc(0x0,wavfp);
  putc(0x1,wavfp); putc(0x0,wavfp); putc(0x1,wavfp); putc(0x0,wavfp);
  putc(0xd4,wavfp); putc(0x49,wavfp);  // Sample Rate 18900
  putc(0x0,wavfp); putc(0x0,wavfp); 
  putc(0xa8,wavfp); putc(0x93,wavfp);  // Sample Rate 18900*2
  putc(0x0,wavfp); putc(0x0,wavfp); 
  putc(0x2,wavfp); putc(0x0,wavfp); putc(0x10,wavfp); putc(0x0,wavfp);
  fprintf(wavfp,"data");
  putc(size & 255,wavfp);
  putc((size>>8) & 255,wavfp);
  putc((size>>16) & 255,wavfp);
  putc((size>>24) & 255,wavfp);

  int y=0,z=0;
  
  bool isWinFile=false;
  fseek(soundfp,0,SEEK_SET);
  if (fread(buf0,1,128,soundfp)==0) return false;
  if (memcmp(buf0,"RIFF",4)==0 && 
      memcmp(buf0+8,"CDXAfmt ",8)==0) isWinFile=true;
  for(;startLBA<=endLBA;startLBA+=16){
    if (isWinFile){
      fseek(soundfp,startLBA*0x930+0x18,SEEK_SET);
    } else {
      fseek(soundfp,startLBA*0x900,SEEK_SET);
    }
    for(int i=0;i<18;i++){
      fread(buf0,1,128,soundfp);
      XADecode(wavfp,buf0,y,z);
    }
  }

  return true;
}

#ifdef STANDALONE

#include <cstdlib>
char* arg0;
int Usage(void){
  fprintf(stderr,_("%s <EBXA sound file> <output file> ")
	  _("<start sector> <end sector>\n"),arg0);
  exit(1);
}

int main(int argc,char** argv){
  arg0=argv[0];
  if (argc!=5) Usage();
  FILE* ifp=fopen(argv[1],"r");
  FILE* ofp=stdout;
  if (argv[2][0]!='-' || argv[2][1]!=0) {
    ofp=fopen(argv[2],"w");
    if (ofp==NULL) {
      fprintf(stderr,_("Can't open output file.\n"));
      Usage();
    }
  }
  int start=atoi(argv[3]);
  int end=atoi(argv[4]);
  
  Ebxa2wav(ifp,ofp,start,end);
  
}

#endif
