/* misc.h - 2000/06/28 */
/*
 *  EasyTAG - Tag editor for MP3 and Ogg Vorbis files
 *  Copyright (C) 2000-2003  Jerome Couderc <j.couderc@ifrance.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __MISC_H__
#define __MISC_H__


#include <gtk/gtk.h>

/***************
 * Declaration *
 ***************/

GtkWidget *WritePlaylistWindow;
GtkWidget *playlist_use_mask_name;
GtkWidget *PlayListNameEntry;
GtkWidget *playlist_use_dir_name;
GtkWidget *playlist_full_path;
GtkWidget *playlist_relative_path;
GtkWidget *playlist_create_in_parent_dir;
GtkWidget *playlist_use_dos_separator;
GtkWidget *playlist_content_none;
GtkWidget *playlist_content_filename;
GtkWidget *playlist_content_mask;
GtkWidget *PlayListContentMaskEntry;

GtkWidget *LoadFilenameWindow;
GtkWidget *LoadFileRunScanner;


/*
 * Types for using Audio Player
 */
typedef enum
{
    PLAY_DIRECTORY = 0, // Load files of the directory
    PLAY_SELECTION = 1,  // Load only selected file
    PLAY_UNKNOWN
} AP_Play_Type;



/**************
 * Prototypes *
 **************/

/*
 * Create Pixmaps, buttons,...
 */
GtkWidget *Create_Button_With_Pixmap         (guint button_type);
GtkWidget *Create_Pixmap_Icon                (gchar **pixmap_name);
GtkWidget *Create_Pixmap_Icon_With_Event_Box (gchar **pixmap_name);
GtkWidget *Create_Button_With_Icon_And_Label (gchar **pixmap_name, gchar *label);


/*
 * Combobox history
 */
void   Add_To_Combo_Box_History (GtkObject *combobox);
GList *Add_String_To_Glist      (GList *list, gchar *string);


/*
 * Other
 */
void Entry_Changed_Disable_Object(GtkObject *widget_to_disable, GtkEditable *source_widget);
void Insert_Only_Digit (GtkEditable *editable,const gchar *text,gint length,gint *position,gpointer data);
void Parse_Genre (GtkEntry *entry, GdkEvent *event, GtkCombo *combo);
void Parse_Date (void);
void Load_Genres_List_To_UI (void);
void Load_Track_List_To_UI  (void);
void Init_Character_Translation_Table (void);
void Focus_Select_Text_In_Editable (GtkWidget *widget);

// Mouse cursor
void Init_Mouse_Cursor    (void);
void Destroy_Mouse_Cursor (void);
void Set_Busy_Cursor      (void);
void Set_Unbusy_Cursor    (void);

// Tooltips
GtkTooltips *gtk_tooltips_new_1 (void);
void Set_Tips_Color (GtkTooltips *tips);

// Run Audio Player
void Run_Audio_Player_Using_File_List (AP_Play_Type type);
void Run_Audio_Player_Using_Directory (void);
void Run_Audio_Player_Using_Selection (void);

gchar *Convert_Size     (gfloat size);
gchar *Convert_Size_1   (gfloat size);
gchar *Convert_Duration (gulong duration);

gulong Get_File_Size (gchar *filename);

void Strip_String (gchar *string);

gchar *gtk_entry_get_text_1 (GtkWidget *widget);
void   gtk_entry_set_text_1 (GtkWidget *widget, gchar *text);

// Playlist window
void Open_Write_Playlist_Window (void);
// Search file window
void Open_Search_File_Window (void);
// Load filenames window
void Open_Load_Filename_Window (void);


#endif /* __MISC_H__ */
