/* bar.c - 2000/05/05 */
/*
 *  EasyTAG - Tag editor for MP3 and Ogg Vorbis files
 *  Copyright (C) 2000-2003  Jerome Couderc <j.couderc@ifrance.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <gtk/gtk.h>

#include "bar.h"
#include "easytag.h"
#include "about.h"
#include "prefs.h"
#include "setting.h"
#include "browser.h"
#include "scan.h"
#include "cddb.h"
#include "misc.h"
#include "i18n.h"


/***************
 * Declaration *
 ***************/
GtkWidget   *StatusBar = NULL;
static guint StatusbarTimerId = 0;


/**************
 * Prototypes *
 **************/
void Init_Menu_Bar (void);
void Menu_Item_Action (GtkWidget *widget, guint action);

void     Statusbar_Start_Timer  (void);
gboolean Statusbar_Stop_Timer   (void);
void     Statusbar_Remove_Timer (void);


/*************
 * Functions *
 *************/

/*
 * Menu bar
 */
void Menu_Item_Action (GtkWidget *widget ATTRIBUTE_UNUSED, guint action)
{
    switch (action)
    {
        case AM_SORT_ASCENDING_FILENAME:       ET_Sort_File_List_And_Update_UI(SORTING_BY_ASCENDING_FILENAME);       break;
        case AM_SORT_DESCENDING_FILENAME:      ET_Sort_File_List_And_Update_UI(SORTING_BY_DESCENDING_FILENAME);      break;
        case AM_SORT_ASCENDING_CREATION_DATE:  ET_Sort_File_List_And_Update_UI(SORTING_BY_ASCENDING_CREATION_DATE);  break;
        case AM_SORT_DESCENDING_CREATION_DATE: ET_Sort_File_List_And_Update_UI(SORTING_BY_DESCENDING_CREATION_DATE); break;
        case AM_SORT_ASCENDING_TRACK_NUMBER:   ET_Sort_File_List_And_Update_UI(SORTING_BY_ASCENDING_TRACK_NUMBER);   break;
        case AM_SORT_DESCENDING_TRACK_NUMBER:  ET_Sort_File_List_And_Update_UI(SORTING_BY_DESCENDING_TRACK_NUMBER);  break;
        case AM_SORT_ASCENDING_TITLE:          ET_Sort_File_List_And_Update_UI(SORTING_BY_ASCENDING_TITLE);          break;
        case AM_SORT_DESCENDING_TITLE:         ET_Sort_File_List_And_Update_UI(SORTING_BY_DESCENDING_TITLE);         break;
        case AM_SORT_ASCENDING_ARTIST:         ET_Sort_File_List_And_Update_UI(SORTING_BY_ASCENDING_ARTIST);         break;
        case AM_SORT_DESCENDING_ARTIST:        ET_Sort_File_List_And_Update_UI(SORTING_BY_DESCENDING_ARTIST);        break;
        case AM_SORT_ASCENDING_ALBUM:          ET_Sort_File_List_And_Update_UI(SORTING_BY_ASCENDING_ALBUM);          break;
        case AM_SORT_DESCENDING_ALBUM:         ET_Sort_File_List_And_Update_UI(SORTING_BY_DESCENDING_ALBUM);         break;
        case AM_SORT_ASCENDING_YEAR:           ET_Sort_File_List_And_Update_UI(SORTING_BY_ASCENDING_YEAR);           break;
        case AM_SORT_DESCENDING_YEAR:          ET_Sort_File_List_And_Update_UI(SORTING_BY_DESCENDING_YEAR);          break;
        case AM_SORT_ASCENDING_GENRE:          ET_Sort_File_List_And_Update_UI(SORTING_BY_ASCENDING_GENRE);          break;
        case AM_SORT_DESCENDING_GENRE:         ET_Sort_File_List_And_Update_UI(SORTING_BY_DESCENDING_GENRE);         break;
        case AM_SORT_ASCENDING_COMMENT:        ET_Sort_File_List_And_Update_UI(SORTING_BY_ASCENDING_COMMENT);        break;
        case AM_SORT_DESCENDING_COMMENT:       ET_Sort_File_List_And_Update_UI(SORTING_BY_DESCENDING_COMMENT);       break;
        case AM_SORT_ASCENDING_FILE_TYPE:      ET_Sort_File_List_And_Update_UI(SORTING_BY_ASCENDING_FILE_TYPE);      break;
        case AM_SORT_DESCENDING_FILE_TYPE:     ET_Sort_File_List_And_Update_UI(SORTING_BY_DESCENDING_FILE_TYPE);     break;
        case AM_SORT_ASCENDING_FILE_SIZE:      ET_Sort_File_List_And_Update_UI(SORTING_BY_ASCENDING_FILE_SIZE);      break;
        case AM_SORT_DESCENDING_FILE_SIZE:     ET_Sort_File_List_And_Update_UI(SORTING_BY_DESCENDING_FILE_SIZE);     break;
        case AM_SORT_ASCENDING_FILE_DURATION:  ET_Sort_File_List_And_Update_UI(SORTING_BY_ASCENDING_FILE_DURATION);  break;
        case AM_SORT_DESCENDING_FILE_DURATION: ET_Sort_File_List_And_Update_UI(SORTING_BY_DESCENDING_FILE_DURATION); break;
        case AM_SORT_ASCENDING_FILE_BITRATE:   ET_Sort_File_List_And_Update_UI(SORTING_BY_ASCENDING_FILE_BITRATE);   break;
        case AM_SORT_DESCENDING_FILE_BITRATE:  ET_Sort_File_List_And_Update_UI(SORTING_BY_DESCENDING_FILE_BITRATE);  break;
        case AM_SORT_ASCENDING_FILE_SAMPLERATE: ET_Sort_File_List_And_Update_UI(SORTING_BY_ASCENDING_FILE_SAMPLERATE); break;
        case AM_SORT_DESCENDING_FILE_SAMPLERATE:ET_Sort_File_List_And_Update_UI(SORTING_BY_DESCENDING_FILE_SAMPLERATE);break;
        case AM_SELECT_ALL_FILES:       Action_Select_All_Files();              break;
        case AM_UNSELECT_ALL_FILES:     Action_Unselect_All_Files();            break;
        case AM_INVERT_SELECTION:       Action_Invert_Files_Selection();        break;
        case AM_DELETE_FILE:            Action_Delete_Selected_Files();         break;
        case AM_FIRST:                  Action_Select_First_File();             break;
        case AM_PREV:                   Action_Select_Prev_File();              break;
        case AM_NEXT:                   Action_Select_Next_File();              break;
        case AM_LAST:                   Action_Select_Last_File();              break;
        case AM_SCAN:                   Action_Scan_Selected_Files();           break;
        case AM_REMOVE:                 Action_Remove_Selected_Tags();          break;
        case AM_UNDO:                   Action_Undo_Selected_Files();           break;
        case AM_REDO:                   Action_Redo_Selected_File();            break;
        case AM_SAVE:                   Action_Save_Selected_Files();           break;
        case AM_UNDO_HISTORY:           Action_Undo_From_History_List();        break;
        case AM_REDO_HISTORY:           Action_Redo_From_History_List();        break;
        case AM_LOAD_HOME_DIR:          Browser_Load_Home_Directory();          break;
        case AM_LOAD_DEFAULT_DIR:       Browser_Load_Default_Directory();       break;
        case AM_SET_PATH_AS_DEFAULT:    Set_Current_Path_As_Default();          break;
        case AM_RENAME_DIR:             Browser_Open_Rename_Directory_Window(); break;
        case AM_COLLAPSE_TREE:          Browser_Tree_Collapse();                break;
        case AM_INITIALIZE_TREE:        Browser_Tree_Rebuild(NULL);             break;
        case AM_RELOAD_DIRECTORY:       Browser_Reload_Directory();             break;
        case AM_BROWSE_DIRECTORY_WITH:  Browser_Open_Run_Program_Tree_Window(); break;
        case AM_BROWSE_FILE_WITH:       Browser_Open_Run_Program_List_Window(); break;
        case AM_OPEN_OPTIONS_WINDOW:    Open_OptionsWindow();                   break;
        case AM_SAVE_CONFIG:            Save_Config_Now();                      break;
        case AM_SCANNER_FILL_TAG:
            if (!Scanner_Option_Menu_Get_Active_Menu_Item(SCANNER_FILL_TAG))
                Open_ScannerWindow(SCANNER_FILL_TAG);
            else
                if (ScannerWindow)
                    Scan_Select_Mode_And_Run_Scanner(ETFileDisplayed);
            break;
        case AM_SCANNER_RENAME_FILE:
            if (!Scanner_Option_Menu_Get_Active_Menu_Item(SCANNER_RENAME_FILE))
                Open_ScannerWindow(SCANNER_RENAME_FILE);
            else
                if (ScannerWindow)
                    Scan_Select_Mode_And_Run_Scanner(ETFileDisplayed);
            break;
        case AM_SCANNER_PROCESS_FIELDS:
            if (!Scanner_Option_Menu_Get_Active_Menu_Item(SCANNER_PROCESS_FIELDS))
                Open_ScannerWindow(SCANNER_PROCESS_FIELDS);
            else
                if (ScannerWindow)
                    Scan_Select_Mode_And_Run_Scanner(ETFileDisplayed);
            break;
        case AM_SEARCH_FILE:            Open_Search_File_Window();          break;
        case AM_CDDB_SEARCH:            Open_Cddb_Window();                 break;
        case AM_FILENAME_FROM_TXT:      Open_Load_Filename_Window();        break;
        case AM_WRITE_PLAYLIST:         Open_Write_Playlist_Window();       break;
        case AM_RUN_AUDIO_PLAYER:       Run_Audio_Player_Using_Selection(); break;
        case AM_OPEN_ABOUT_WINDOW:      Show_About_Window();                break;
        case AM_QUIT:                   Quit_MainWindow();                  break;
        default: g_warning("No menu action defined for this item!");        break;
    }
}


GtkWidget *Create_Menu_Bar (void)
{
    // This can be defined out of the function, but '_(' must be replaced by 'N_('
    GtkItemFactoryEntry MenuItems[] = 
    {
      {_("/_File"),                          NULL,             NULL,                 0,        "<Branch>"},
      {_("/File/tearoff"),                   NULL,             NULL,                 0,        "<Tearoff>"},
      {_("/File/Sort List"),                 NULL,             NULL,                 0,        "<Branch>"},
      {_("/File/Sort List/tearoff"),         NULL,             NULL,                 0,        "<Tearoff>"},
      {_("/File/Sort List/Ascending by filename"),         NULL,     Menu_Item_Action, AM_SORT_ASCENDING_FILENAME,      "<Item>"},
      {_("/File/Sort List/Descending by filename"),        NULL,     Menu_Item_Action, AM_SORT_DESCENDING_FILENAME,     "<Item>"},
      {_("/File/Sort List/sep"),                           NULL,     NULL,             0,                               "<Separator>"},
      {_("/File/Sort List/Ascending by creation date"),    NULL,     Menu_Item_Action, AM_SORT_ASCENDING_CREATION_DATE, "<Item>"},
      {_("/File/Sort List/Descending by creation date"),   NULL,     Menu_Item_Action, AM_SORT_DESCENDING_CREATION_DATE,"<Item>"},
      {_("/File/Sort List/sep"),                           NULL,     NULL,             0,                               "<Separator>"},
      {_("/File/Sort List/Ascending by track number"),     NULL,     Menu_Item_Action, AM_SORT_ASCENDING_TRACK_NUMBER,  "<Item>"},
      {_("/File/Sort List/Descending by track number"),    NULL,     Menu_Item_Action, AM_SORT_DESCENDING_TRACK_NUMBER, "<Item>"},
      {_("/File/Sort List/sep"),                           NULL,     NULL,             0,                               "<Separator>"},
      {_("/File/Sort List/Ascending by title"),            NULL,     Menu_Item_Action, AM_SORT_ASCENDING_TITLE,         "<Item>"},
      {_("/File/Sort List/Descending by title"),           NULL,     Menu_Item_Action, AM_SORT_DESCENDING_TITLE,        "<Item>"},
      {_("/File/Sort List/sep"),                           NULL,     NULL,             0,                               "<Separator>"},
      {_("/File/Sort List/Ascending by artist"),           NULL,     Menu_Item_Action, AM_SORT_ASCENDING_ARTIST,        "<Item>"},
      {_("/File/Sort List/Descending by artist"),          NULL,     Menu_Item_Action, AM_SORT_DESCENDING_ARTIST,       "<Item>"},
      {_("/File/Sort List/sep"),                           NULL,     NULL,             0,                               "<Separator>"},
      {_("/File/Sort List/Ascending by album"),            NULL,     Menu_Item_Action, AM_SORT_ASCENDING_ALBUM,         "<Item>"},
      {_("/File/Sort List/Descending by album"),           NULL,     Menu_Item_Action, AM_SORT_DESCENDING_ALBUM,        "<Item>"},
      {_("/File/Sort List/sep"),                           NULL,     NULL,             0,                               "<Separator>"},
      {_("/File/Sort List/Ascending by year"),             NULL,     Menu_Item_Action, AM_SORT_ASCENDING_YEAR,          "<Item>"},
      {_("/File/Sort List/Descending by year"),            NULL,     Menu_Item_Action, AM_SORT_DESCENDING_YEAR,         "<Item>"},
      {_("/File/Sort List/sep"),                           NULL,     NULL,             0,                               "<Separator>"},
      {_("/File/Sort List/Ascending by genre"),            NULL,     Menu_Item_Action, AM_SORT_ASCENDING_GENRE,         "<Item>"},
      {_("/File/Sort List/Descending by genre"),           NULL,     Menu_Item_Action, AM_SORT_DESCENDING_GENRE,        "<Item>"},
      {_("/File/Sort List/sep"),                           NULL,     NULL,             0,                               "<Separator>"},
      {_("/File/Sort List/Ascending by comment"),          NULL,     Menu_Item_Action, AM_SORT_ASCENDING_COMMENT,       "<Item>"},
      {_("/File/Sort List/Descending by comment"),         NULL,     Menu_Item_Action, AM_SORT_DESCENDING_COMMENT,      "<Item>"},
      {_("/File/Sort List/sep"),                           NULL,     NULL,             0,                               "<Separator>"},
      {_("/File/Sort List/Ascending by file type"),        NULL,     Menu_Item_Action, AM_SORT_ASCENDING_FILE_TYPE,     "<Item>"},
      {_("/File/Sort List/Descending by file type"),       NULL,     Menu_Item_Action, AM_SORT_DESCENDING_FILE_TYPE,    "<Item>"},
      {_("/File/Sort List/sep"),                           NULL,     NULL,             0,                               "<Separator>"},
      {_("/File/Sort List/Ascending by file size"),        NULL,     Menu_Item_Action, AM_SORT_ASCENDING_FILE_SIZE,     "<Item>"},
      {_("/File/Sort List/Descending by file size"),       NULL,     Menu_Item_Action, AM_SORT_DESCENDING_FILE_SIZE,    "<Item>"},
      {_("/File/Sort List/sep"),                           NULL,     NULL,             0,                               "<Separator>"},
      {_("/File/Sort List/Ascending by duration"),         NULL,     Menu_Item_Action, AM_SORT_ASCENDING_FILE_DURATION, "<Item>"},
      {_("/File/Sort List/Descending by duration"),        NULL,     Menu_Item_Action, AM_SORT_DESCENDING_FILE_DURATION,"<Item>"},
      {_("/File/Sort List/sep"),                           NULL,     NULL,             0,                               "<Separator>"},
      {_("/File/Sort List/Ascending by bitrate"),          NULL,     Menu_Item_Action, AM_SORT_ASCENDING_FILE_BITRATE,  "<Item>"},
      {_("/File/Sort List/Descending by bitrate"),         NULL,     Menu_Item_Action, AM_SORT_DESCENDING_FILE_BITRATE, "<Item>"},
      {_("/File/Sort List/sep"),                           NULL,     NULL,             0,                               "<Separator>"},
      {_("/File/Sort List/Ascending by samplerate"),       NULL,     Menu_Item_Action, AM_SORT_ASCENDING_FILE_SAMPLERATE, "<Item>"},
      {_("/File/Sort List/Descending by samplerate"),      NULL,     Menu_Item_Action, AM_SORT_DESCENDING_FILE_SAMPLERATE,"<Item>"},
      {_("/File/Open File(s) with ..."),                   NULL,     Menu_Item_Action,     AM_BROWSE_FILE_WITH,  "<Item>"},
      {_("/File/sep"),                                     NULL,     NULL,                 0,                    "<Separator>"},
      {_("/File/Select All Files"),         "<control>A",             Menu_Item_Action,     AM_SELECT_ALL_FILES,  "<Item>"},
      {_("/File/Unselect All Files"),       "<control><shift>A",      Menu_Item_Action,     AM_UNSELECT_ALL_FILES,"<Item>"},
      {_("/File/Invert Files Selection"),   "<control>I",             Menu_Item_Action,     AM_INVERT_SELECTION,  "<Item>"},
      {_("/File/sep"),                      NULL,             NULL,                 0,                    "<Separator>"},
      {_("/File/Delete File(s)"),           NULL,             Menu_Item_Action,     AM_DELETE_FILE,       "<Item>"},
      {_("/File/sep"),                      NULL,             NULL,                 0,                    "<Separator>"},
      {_("/File/_First File"),              "<control>F",     Menu_Item_Action,     AM_FIRST,             "<Item>"},
      {_("/File/_Previous File"),           "<control>P",     Menu_Item_Action,     AM_PREV,              "<Item>"},
      {_("/File/_Next File"),               "<control>N",     Menu_Item_Action,     AM_NEXT,              "<Item>"},
      {_("/File/_Last File"),               "<control>L",     Menu_Item_Action,     AM_LAST,              "<Item>"},
      {_("/File/sep"),                      NULL,             NULL,                 0,                    "<Separator>"},
      {_("/File/S_can File(s)"),            "<control>C",     Menu_Item_Action,     AM_SCAN,              "<Item>"},
      {_("/File/_Remove Tag(s)"),           "<control>R",     Menu_Item_Action,     AM_REMOVE,            "<Item>"},
      {_("/File/_Undo Last File(s) Changes"),"<control>U",    Menu_Item_Action,     AM_UNDO,              "<Item>"},
      {_("/File/R_edo Last File(s) Changes"),"<control>E",    Menu_Item_Action,     AM_REDO,              "<Item>"},
      {_("/File/_Save File(s)"),            "<control>S",     Menu_Item_Action,     AM_SAVE,              "<Item>"},
      {_("/File/sep"),                      NULL,             NULL,                 0,                    "<Separator>"},
      {_("/File/Undo Last Changes"),        "<control><alt>U",Menu_Item_Action,     AM_UNDO_HISTORY,      "<Item>"},
      {_("/File/Redo Last Changes"),        "<control><alt>E",Menu_Item_Action,     AM_REDO_HISTORY,      "<Item>"},
      {_("/File/sep"),                      NULL,             NULL,                 0,                    "<Separator>"},
      {_("/File/_Quit"),                    "<control>Q",     Menu_Item_Action,     AM_QUIT,              "<Item>"},

      {_("/_Browser"),                            NULL,               NULL,            0,                       "<Branch>"},
      {_("/Browser/tearoff"),                     NULL,               NULL,            0,                       "<Tearoff>"},
      {_("/Browser/Go to _Home Directory"),       "<control>H",       Menu_Item_Action,AM_LOAD_HOME_DIR,        "<Item>"},
      {_("/Browser/Go to _Default Directory"),    "<control>D",       Menu_Item_Action,AM_LOAD_DEFAULT_DIR,     "<Item>"},
      {_("/Browser/Set _Current Path as Default"),NULL,               Menu_Item_Action,AM_SET_PATH_AS_DEFAULT,  "<Item>"},
      {_("/Browser/sep"),                         NULL,               NULL,            0,                       "<Separator>"},
      {_("/Browser/Rename Directory ..."),        "<control><shift>D",Menu_Item_Action,AM_RENAME_DIR,           "<Item>"},
      {_("/Browser/Reload Directory"),            NULL,               Menu_Item_Action,AM_RELOAD_DIRECTORY,     "<Item>"},
      {_("/Browser/Browse Directory with ..."),   NULL,               Menu_Item_Action,AM_BROWSE_DIRECTORY_WITH,"<Item>"},
      {_("/Browser/sep"),                         NULL,               NULL,            0,                       "<Separator>"},
      {_("/Browser/Browse _Sub-directories"),     "<control><shift>S",NULL,            AM_RECURSE,              "<CheckItem>"},
      {_("/Browser/sep"),                         NULL,               NULL,            0,                       "<Separator>"},
      {_("/Browser/_Collapse Tree"),              "<control><shift>C",Menu_Item_Action,AM_COLLAPSE_TREE,        "<Item>"},
      {_("/Browser/_Refresh Tree"),               "<control><shift>R",Menu_Item_Action,AM_INITIALIZE_TREE,      "<Item>"},
   
      {_("/S_canner"),                         NULL,        NULL,             0,                        "<Branch>"},
      {_("/Scanner/tearoff"),                  NULL,        NULL,             0,                        "<Tearoff>"},
      {_("/Scanner/_Fill Tag(s) ..."),         NULL,        Menu_Item_Action, AM_SCANNER_FILL_TAG,      "<Item>"},
      {_("/Scanner/_Rename File(s) ..."),      NULL,        Menu_Item_Action, AM_SCANNER_RENAME_FILE,   "<Item>"},
      {_("/Scanner/_Process Fields ..."),      NULL,        Menu_Item_Action, AM_SCANNER_PROCESS_FIELDS,"<Item>"},

      {_("/_Misc"),                            NULL,        NULL,             0,                        "<Branch>"},
      {_("/Misc/tearoff"),                     NULL,        NULL,             0,                        "<Tearoff>"},
      {_("/Misc/S_earch File(s) ..."),         "<alt>E",    Menu_Item_Action, AM_SEARCH_FILE,           "<Item>"},
      {_("/Misc/_CDDB Search ..."),            NULL,        Menu_Item_Action, AM_CDDB_SEARCH,           "<Item>"},
      {_("/Misc/sep"),                         NULL,        NULL,             0,                        "<Separator>"},
      {_("/Misc/Load Filenames from TXT ..."), "<alt>T",    Menu_Item_Action, AM_FILENAME_FROM_TXT,     "<Item>"},
      {_("/Misc/Write Playlist ..."),          "<alt>W",    Menu_Item_Action, AM_WRITE_PLAYLIST,        "<Item>"},
      {_("/Misc/Run Audio Player"),            "<alt>X",    Menu_Item_Action, AM_RUN_AUDIO_PLAYER,      "<Item>"},
    
      {_("/_Settings"),                        NULL,        NULL,             0,                        "<Branch>"},
      {_("/Settings/tearoff"),                 NULL,        NULL,             0,                        "<Tearoff>"},
      {_("/Settings/_Preferences ..."),        "<alt>P",    Menu_Item_Action, AM_OPEN_OPTIONS_WINDOW,   "<Item>"},
      {_("/Settings/sep"),                     NULL,        NULL,             0,                        "<Separator>"},
      {_("/Settings/Save _Configuration Now"), "<alt>C",    Menu_Item_Action, AM_SAVE_CONFIG,           "<Item>"},
    
      {_("/_Help"),                            NULL,        NULL,             0,                        "<LastBranch>"},
      {_("/Help/tearoff"),                     NULL,        NULL,             0,                        "<Tearoff>"},
      {_("/Help/_About .."),                   "<alt>A",    Menu_Item_Action, AM_OPEN_ABOUT_WINDOW,     "<Item>"}
    };

    GtkWidget *HandleBar;
    GtkAccelGroup *accel_group;


    /* Calculate number of items into the menu */
    gint NbrMenuItems = sizeof(MenuItems) / sizeof(MenuItems[0]); 
    
    /* Accelerator group */
    accel_group = gtk_accel_group_new();

    /* Factory creation */
    ItemFactory = gtk_item_factory_new(GTK_TYPE_MENU_BAR,"<Main>",accel_group);

    /* Menu item creation */
    gtk_item_factory_create_items(ItemFactory,NbrMenuItems,MenuItems,NULL);
    gtk_accel_group_attach (accel_group,GTK_OBJECT(MainWindow));

    /* Get menu bar from factory */
    MenuBar = gtk_item_factory_get_widget (ItemFactory,"<Main>");

    /* Menu is into a handlebar */
    HandleBar = gtk_handle_box_new();
    gtk_container_add(GTK_CONTAINER(HandleBar),MenuBar);

    Init_Menu_Bar();

    gtk_widget_show_all(HandleBar);
    return HandleBar;
}


/*
 * Initialize some items of the main menu
 */
void Init_Menu_Bar (void)
{
    CheckMenuItemBrowseSubdirMainMenu = gtk_item_factory_get_widget_by_action(ItemFactory,AM_RECURSE);
    if (CheckMenuItemBrowseSubdirMainMenu)
    {
        gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(CheckMenuItemBrowseSubdirMainMenu),BROWSE_SUBDIR);
        gtk_signal_connect(GTK_OBJECT(CheckMenuItemBrowseSubdirMainMenu),"toggled",
            (GtkSignalFunc)Check_Menu_Item_Toggled_Browse_Subdir,NULL);
    }

    /* If entry not implemented */
    //{GtkWidget *widget = gtk_item_factory_get_widget_by_action(ItemFactory,FILENAME_FROM_TXT);
    //if (widget) gtk_widget_set_sensitive(widget,FALSE);}

}

/*
 * Callback to update state of check button to browse subdir into menu
 */
void Check_Menu_Item_Toggled_Browse_Subdir (GtkWidget *checkmenuitem)
{
    BROWSE_SUBDIR = GTK_CHECK_MENU_ITEM(checkmenuitem)->active;
    Check_Menu_Item_Update_Browse_Subdir();
}
void Check_Menu_Item_Update_Browse_Subdir (void)
{
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(CheckMenuItemBrowseSubdirMainMenu),BROWSE_SUBDIR);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(CheckMenuItemBrowseSubdirPopupMenu),BROWSE_SUBDIR);
}









/*
 * Status bar functions
 */
GtkWidget *Create_Status_Bar (void)
{
    StatusBar = gtk_statusbar_new();
    /* Specify a size to avoid statubar resizing if the message is too long */
    gtk_widget_set_usize(StatusBar,200,-1);
    /* Create serie */
    StatusBarContext = gtk_statusbar_get_context_id(GTK_STATUSBAR(StatusBar),"Messages");

    Statusbar_Message(_("Ready to start..."),TRUE);

    gtk_widget_show(StatusBar);
    return StatusBar;
}

gboolean Statusbar_Stop_Timer (void)
{
    gtk_statusbar_pop(GTK_STATUSBAR(StatusBar),StatusBarContext);
    return FALSE;    /* Stop the timer */
}

void Statusbar_Start_Timer (void)
{
    Statusbar_Remove_Timer();
    StatusbarTimerId = gtk_timeout_add(4000,(GtkFunction)Statusbar_Stop_Timer,NULL);
}

void Statusbar_Remove_Timer (void)
{
    if (StatusbarTimerId)
    {
        gtk_timeout_remove(StatusbarTimerId);
        StatusbarTimerId = 0;
    }
}

/*
 * Send a message to the status bar
 *  - with_timer: if TRUE, the message will be displayed during 4s
 *                if FALSE, the message will be displayed up to the next posted message
 */
void Statusbar_Message (gchar *message, gint with_timer)
{
    if (!StatusBar) return;

    /* Remove a running timer */
    Statusbar_Remove_Timer();
    
    /* Pop last message */
    gtk_statusbar_pop(GTK_STATUSBAR(StatusBar),StatusBarContext);

    /* Push the given message */
    gtk_statusbar_push(GTK_STATUSBAR(StatusBar),StatusBarContext,message);
    while (gtk_events_pending())
        gtk_main_iteration();

    if (with_timer)
        Statusbar_Start_Timer();
}







/*
 * Progress bar
 */
GtkWidget *Create_Progress_Bar (void)
{
    ProgressBar = gtk_progress_bar_new();

    gtk_widget_show(ProgressBar);
    return ProgressBar;
}







/*
 * Tools bar
 */
#include "../pixmaps/first.xpm"
#include "../pixmaps/previous.xpm"
#include "../pixmaps/next.xpm"
#include "../pixmaps/last.xpm"
#include "../pixmaps/scan.xpm"
#include "../pixmaps/delete.xpm"
#include "../pixmaps/undo.xpm"
#include "../pixmaps/redo.xpm"
#include "../pixmaps/save.xpm"
#include "../pixmaps/select_all.xpm"
#include "../pixmaps/invert_selection.xpm"
#include "../pixmaps/stop.xpm"
#include "../pixmaps/exit.xpm"
GtkWidget *Create_Tool_Bar (void)
{
    GtkWidget *HandleBar;
    GtkWidget *Icon;

    ToolBar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL,GTK_TOOLBAR_ICONS);
    gtk_container_set_border_width(GTK_CONTAINER(ToolBar),2);
    gtk_toolbar_set_space_size(GTK_TOOLBAR(ToolBar),15);
    gtk_toolbar_set_space_style(GTK_TOOLBAR(ToolBar),GTK_TOOLBAR_SPACE_LINE);
    gtk_toolbar_set_button_relief(GTK_TOOLBAR(ToolBar),GTK_RELIEF_NONE);

    Set_Tips_Color(GTK_TOOLBAR(ToolBar)->tooltips);

    /* Toolbar is into a handlebar */
    HandleBar = gtk_handle_box_new();
    gtk_container_add(GTK_CONTAINER(HandleBar),ToolBar);

    /*
     * Buttons: First, Prev, Next, Last.
     */
    Icon = Create_Pixmap_Icon(first_xpm);
    TBFirstButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Select first file"),NULL,
                                            Icon,GTK_SIGNAL_FUNC(Action_Select_First_File),NULL);
    Icon = Create_Pixmap_Icon(previous_xpm);
    TBPrevButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Select previous file"),NULL,
                                           Icon,GTK_SIGNAL_FUNC(Action_Select_Prev_File),NULL);
    Icon = Create_Pixmap_Icon(next_xpm);
    TBNextButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Select next file"),NULL,
                                           Icon,GTK_SIGNAL_FUNC(Action_Select_Next_File),NULL);
    Icon = Create_Pixmap_Icon(last_xpm);
    TBLastButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Select last file"),NULL,
                                           Icon,GTK_SIGNAL_FUNC(Action_Select_Last_File),NULL);

    /* Separator */    
    gtk_toolbar_append_space(GTK_TOOLBAR(ToolBar));

    /*
     * Buttons for actions for selected files.
     */
    Icon = Create_Pixmap_Icon(scan_xpm);
    TBScanButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Scan selected files"),
                                           NULL,Icon,GTK_SIGNAL_FUNC(Action_Scan_Selected_Files),NULL);
    Icon = Create_Pixmap_Icon(delete_xpm);
    TBRemoveButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Remove tag of selected files"),
                                             NULL,Icon,GTK_SIGNAL_FUNC(Action_Remove_Selected_Tags),NULL);
    Icon = Create_Pixmap_Icon(undo_xpm);
    TBUndoButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Undo last changes of selected files"),
                                           NULL,Icon,GTK_SIGNAL_FUNC(Action_Undo_Selected_Files),NULL);
    //gtk_signal_connect(GTK_OBJECT(TBUndoButton),"enter",GTK_SIGNAL_FUNC(Undo_Display_Last_Info),NULL);

    Icon = Create_Pixmap_Icon(redo_xpm);
    TBRedoButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Redo last changes of selected files"),
                                           NULL,Icon,GTK_SIGNAL_FUNC(Action_Redo_Selected_File),NULL);
    //gtk_signal_connect(GTK_OBJECT(TBUndoButton),"enter",GTK_SIGNAL_FUNC(Undo_Display_Last_Info),NULL);

    Icon = Create_Pixmap_Icon(save_xpm);
    TBSaveButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Save selected files"),
                                            NULL,Icon,GTK_SIGNAL_FUNC(Action_Save_Selected_Files),NULL);

    /* Separator */    
    gtk_toolbar_append_space(GTK_TOOLBAR(ToolBar));

    Icon = Create_Pixmap_Icon(select_all_xpm);
    TBSelectAllButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Select all files"),NULL,
                                               Icon,GTK_SIGNAL_FUNC(Action_Select_All_Files),NULL);

    Icon = Create_Pixmap_Icon(invert_selection_xpm);
    TBInvertSelectionButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Invert files selection"),NULL,
                                               Icon,GTK_SIGNAL_FUNC(Action_Invert_Files_Selection),NULL);

    /* Separator */    
    gtk_toolbar_append_space(GTK_TOOLBAR(ToolBar));

    /*
     * Button to stop (for example: stop the subdirectories search).
     */
    Icon = Create_Pixmap_Icon(stop_xpm);
    TBStopButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Stop the current action"),NULL,
                                           Icon,GTK_SIGNAL_FUNC(Action_Main_Stop_Button_Pressed),NULL);

    /* Separator */    
    gtk_toolbar_append_space(GTK_TOOLBAR(ToolBar));

    /*
     * Button to quit.
     */
    Icon = Create_Pixmap_Icon(exit_xpm);
    TBQuitButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Exit EasyTAG!"),NULL,
                                           Icon,GTK_SIGNAL_FUNC(Quit_MainWindow),NULL);

    gtk_widget_show_all(HandleBar);
    return HandleBar;
}
