/*
 * شۥϥѸ켭ŵ桼ƥƥ - csrd
 *
 *	Written by Junn Ohta (ohta@src.ricoh.co.jp), Public Domain.
 */

char	*progname = "csrd";
char	*version  = "1.0";
char	*date     = "1999/07/19";

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifdef UNIX
#include <unistd.h>
#endif
#ifdef MSDOS
#include <io.h>
#endif

typedef	unsigned char	uchr;
typedef	unsigned int	unt;

#ifndef O_BINARY
#define	O_BINARY	0
#endif

#define	OK		0
#define	ERR		(-1)

#define	TRUE		1
#define	FALSE		0

#define	SJIS1(c)	((c)>=0x81 && (c)<=0x9f || (c)>=0xe0 && (c)<=0xef)

#ifdef DEBUG
int	debug = FALSE;		/* ǥХåե饰		*/
int	debug2 = FALSE;		/* ǥХåե饰		*/
#endif

/* -------------------- 桼ƥƥؿ -------------------- */ 

#define	POOLSIZ		1024	/* ʸסγñ	*/

uchr	*pool = NULL;		/* ʸס			*/
uchr	*pfree = NULL;		/* ʸסζΰƬ	*/

int	hexval();
uchr	*escchar();
uchr	*skipeq();
uchr	*skipsp();
uchr	*strpool();
void	bsltosl();
int	nspaces();
void	lower();

/*
 * hexval - 216ʿ֤ͤ
 */
int
hexval(p)
uchr	*p;
{
    int		i, n;

    n = 0;
    for (i = 0; i < 2; i++) {
	n <<= 4;
	if (*p >= '0' && *p <= '9')
	    n += *p - '0';
	else if (*p >= 'a' && *p <= 'f')
	    n += *p - 'a' + 10;
	else if (*p >= 'A' && *p <= 'F')
	    n += *p - 'A' + 10;
	else
	    n = 0;
	p++;
    }
    return n;
}

/*
 * escchar - '\'ǥפ줿ʸĴ١ΰ֤֤
 */
uchr *
escchar(str, cp)
uchr	*str;
int	*cp;
{
    uchr	*p;

    p = str;
    if (*p++ != '\\')
	return str;
    if (*p >= '0' && *p <= '7') {
	sscanf(p, "%3o", cp);
	return p + 3;
    }
    switch (*p) {
    case 'x':
	*cp = hexval(p + 1);
	p += 3;
	break;
    case 'n':
	*cp = '\n';
	p++;
	break;
    case 't':
	*cp = '\t';
	p++;
	break;
    default:
	*cp = *p++;
	break;
    }
    return p;
}

/*
 * skipeq - '='ޤǤɤФΰ֤֤
 */
uchr *
skipeq(str)
uchr	*str;
{
    while (*str && *str != '=')
	str++;
    if (*str == '=')
	str++;
    return str;
}

/*
 * skipsp - ɤФΰ֤֤
 */
uchr *
skipsp(str)
uchr	*str;
{
    while (*str == ' ' || *str == '\t')
	str++;
    return str;
}

/*
 * strpool - ʸס˳ǼƤΥɥ쥹֤
 *	     (θʤstrdup)
 */
uchr *
strpool(str)
uchr	*str;
{
    int		len;
    uchr	*p;

    if (str == NULL)
	return NULL;
    len = strlen(str) + 1;
    if (pool == NULL || pfree + len > pool + POOLSIZ) {
	pool = (uchr *)malloc(POOLSIZ); /* poolͤ˺ */
	if (pool == NULL)
	    return NULL;
	pfree = pool;
    }
    p = pfree;
    pfree += len;
    return strcpy(p, str);
}

/*
 * bsltosl - ʸΥХåå(\)򥹥å(/)Ѵ
 */
void
bsltosl(str)
uchr	*str;
{
    if (str == NULL)
	return;
    while (*str) {
	if (*str == '\\')
	    *str = '/';
	if (SJIS1(*str))
	    str++;
	str++;
    }
}

/*
 * nspaces - ʸƬˤ륹ڡ̤
 */
int
nspaces(str)
uchr	*str;
{
    int		n;

    if (str == NULL)
	return 0;
    n = 0;
    while (*str && isspace(*str)) {
	switch (*str++) {
	case ' ':
	    n++;
	    break;
	case '\t':
	    n = (n | 0x07) + 1;
	    break;
	case '\n':
	case '\r':
	    n = 0;
	    break;
	case '\b':
	    if (n > 0)
		n--;
	    break;
	}
    }
    return n;
}

/*
 * lower - ʸʸ
 */
void
lower(str)
uchr	*str;
{
    if (str == NULL)
	return;
    while (*str) {
	if (isascii(*str) && isupper(*str))
	    *str = tolower(*str);
	str++;
    }
}

/* -------------------- Хåե -------------------- */

#define	BBUFSIZ		4096

typedef	struct _bfile {
    int		fd;
    long	size;
    long	pos;
    uchr	*p, *ep;
    uchr	buf[BBUFSIZ];
} BFILE;

BFILE	*bopen();
long	btell();
int	bseek();
int	bread();
int	bgetc();
int	bgetcbw();
int	bclose();

/*
 * bopen - ХåեϤǥե򥪡ץ󤹤
 *	   bseek()ǰ֤Ť򤹤ޤɤ߹ߤϤǤʤ
 */
BFILE *
bopen(file)
char	*file;
{
    int		fd;
    BFILE	*bp;
    struct stat	st;

    if ((fd = open(file, O_RDONLY|O_BINARY)) < 0)
	return NULL;
    if (fstat(fd, &st) < 0) {
	close(fd);
	return NULL;
    }
    bp = (BFILE *)malloc(sizeof(BFILE));
    if (bp == NULL) {
	close(fd);
	return NULL;
    }
    bp->fd = fd;
    bp->size = st.st_size;
    bp->pos = 0L;
    bp->p = bp->ep = NULL;
    return bp;
}

/*
 * btell - ХåեϤtell()ɤ
 */
long
btell(bp)
BFILE	*bp;
{
    if (bp->p == NULL)
	return (long)ERR;
    return bp->pos + (bp->p - bp->buf);
}

/*
 * bseek - ХåեϤlseek()ɤ
 */
int
bseek(bp, pos)
BFILE	*bp;
long	pos;
{
    int		n;

    if (bp->p
	&& pos >= bp->pos
	&& pos < bp->pos + (bp->ep - bp->buf)) {
	bp->p = bp->buf + (pos - bp->pos);
	return OK;
    }
    if (pos >= bp->size
	|| lseek(bp->fd, pos, SEEK_SET) < 0
	|| (n = read(bp->fd, bp->buf, BBUFSIZ)) <= 0) {
	bp->pos = 0L;
	bp->p = bp->ep = NULL;
	return ERR;
    }
    bp->pos = pos;
    bp->p = bp->buf;
    bp->ep = bp->buf + n;
    return OK;
}

/*
 * bread - ХåեϤread()ɤ
 */
int
bread(bp, buf, len)
BFILE	*bp;
uchr	*buf;
int	len;
{
    int		n;
    uchr	*p;

    if (bp->p == NULL)
	return ERR;
    p = buf;
    while (len > 0) {
	n = bp->ep - bp->p;
	if (n >= len) {
	    memcpy(p, bp->p, (size_t)len);
	    p += len;
	    bp->p += len;
	    len = 0;
	} else if (n > 0) {
	    memcpy(p, bp->p, (size_t)n);
		p += n;
		bp->p += n;
	    len -= n;
	} else {
	    n = read(bp->fd, bp->buf, BBUFSIZ);
	    if (n <= 0) {
		bp->pos = 0L;
		bp->p = bp->ep = NULL;
		break;
	    }
	    bp->pos += bp->ep - bp->buf;
	    bp->p = bp->buf;
	    bp->ep = bp->buf + n;
	}
    }
    return p - buf;
}

/*
 * bgetc - ХåեϤgetc()ɤ
 */
int
bgetc(bp)
BFILE	*bp;
{
    int		n;

    if (bp->p == NULL)
	return EOF;
    if (bp->p < bp->ep)
	return (int)*(bp->p++);
    n = read(bp->fd, bp->buf, BBUFSIZ);
    if (n <= 0) {
	bp->pos = 0L;
	bp->p = bp->ep = NULL;
	return EOF;
    }
    bp->pos += bp->ep - bp->buf;
    bp->p = bp->buf;
    bp->ep = bp->buf + n;
    return (int)*(bp->p++);
}

/*
 * bgetcbw - ߤΰ֤եƬbgetc()
 */
int
bgetcbw(bp)
BFILE	*bp;
{
    int		n;
    long	npos;

    if (bp->p == NULL)
	return EOF;
    if (bp->p > bp->buf)
	return (int)*(--bp->p);
    n = BBUFSIZ;
    npos = bp->pos - n;
    if (bp->pos < 0L) {
	npos = 0L;
	n = bp->pos - npos;
	if (n == 0)
	    return EOF;
    }
    if (lseek(bp->fd, npos, SEEK_SET) < 0
	|| read(bp->fd, bp->buf, n) < n) {
	bp->pos = 0L;
	bp->p = bp->ep = NULL;
	return EOF;
    }
    bp->pos = npos;
    bp->ep = bp->buf + n;
    bp->p = bp->ep;
    return (int)*(--bp->p);
}

/*
 * bclose - ХåեϤclose()ɤ
 */
int
bclose(bp)
BFILE	*bp;
{
    int		fd;

    fd = bp->fd;
    free((char *)bp);
    return close(fd);
}

/* -------------------- ܸ -------------------- */

#define	KC_JIS		0
#define	KC_EUC		1
#define	KC_SJIS		2

#ifdef UNIX
#define	KC_DEF		KC_EUC
#endif
#ifdef MSDOS
#define	KC_DEF		KC_SJIS
#endif

/*
 * ɽ
 */
uchr	*gaijitbl[8][256] = {
    { /* G0 */
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"/",
	0,0,0,0,0,0,0,0,0,0,":",0,0,"=",0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,"...",0,0,0,0,0,0,0,0,0,0,
	0,0,0,"\"","\"",0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,"(C)",0,0,0,0,"(R)",0,
	0,0,0,0,0,0,0,"/",0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    }, { /* G1 */
    	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,"(֡)",0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    }, { /* G2 */
    	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,"",0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    }, { /* G3 */
    	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,"(P)",0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,"",0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    }, { /* G4 */
    	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,"",0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"",
	"","","",0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    }, { /* G5 */
    	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    }, { /* G6 */
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    }, { /* G99 */
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,"#",0,0,0,0,0,0,0,0,0,0,0,"/",
	0,0,0,0,0,0,0,0,0,0,0,0,"<",0,">",0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,"...",0,0,0,0,0,0,0,0,0,0,
	0,0,0,"\"","\"",0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	"A","A",0,0,0,0,0,0,"E","E",0,0,"I","I",0,0,
	0,0,"O","O",0,0,0,0,0,"U","U",0,0,0,0,0,
	"a","a",0,0,0,0,0,0,"e","e",0,0,"i","i",0,0,
	0,0,"o","o",0,0,0,0,0,"u","u",0,0,"y",0,0
    }
};

/*
 * ǥեȳ
 */
uchr	*gdeftbl[8] = { 0, 0, 0, 0, 0, 0 ,"", 0 };

typedef	struct _alttbl_t {
    uchr	org[4];			/* ɽ			*/
    uchr	*alt;			/* ɽ			*/
} ALTTBL;

#define	ATBLINC		10		/* ɽɽʬ		*/

uchr	have_alt[256];			/* ʸɽĤ?	*/
ALTTBL	*alttbl = NULL;			/* ɽɽ			*/
int	altnum = 0;			/* ɽɽǿ		*/
int	in_alt = FALSE;			/* ɽ֤?		*/

int	curpos = 0;			/* ߤɽ		*/
int	kcode = KC_DEF;			/* ϴ		*/
int	jiskanji = 'B';			/* JISɤδ	*/
int	jisalpha = 'B';			/* JISɤαѻ	*/
int	width = 0;			/* Ϲ			*/
int	indent = 0;			/* ǥ			*/
int	kmode = FALSE;			/* üJISؼ֤?	*/
int	rawmode = FALSE;		/* ̵ù⡼		*/
int	gfont = -1;			/* եֹ		*/
int	hlink = FALSE;			/* ϥѡ󥯻		*/

int	add_alt();
int	init_alt();
uchr	*get_gaiji();
int	load_gaiji();
uchr	*tosjis();
void	outchar();
void	outstr();
void	set_indent();
void	newline();

/*
 * add_alt - ɽɽɽɲä
 */
int
add_alt(org, alt)
uchr	*org, *alt;
{
    int		i;
    uchr	*p;
    static int	atblsiz = 0;

    for (i = 0; i < altnum; i++) {
	if (!strcmp(alttbl[i].org, org)) {
	    p = strpool(alt);
	    if (p == NULL)
		return ERR;
	    alttbl[i].alt = p;
	    return OK;
	}
    }
    if (alttbl == NULL) {
	atblsiz = ATBLINC;
	alttbl = (ALTTBL *)malloc(sizeof(ALTTBL) * atblsiz);
	altnum = 0;
    } else if (altnum >= atblsiz) {
	atblsiz += ATBLINC;
	alttbl = (ALTTBL *)realloc(alttbl, sizeof(ALTTBL) * atblsiz);
    }
    if (alttbl == NULL)
	return ERR;
    p = strpool(alt);
    if (p == NULL)
	return ERR;
    strcpy(alttbl[altnum].org, org);
    alttbl[altnum].alt = p;
    have_alt[*org] = TRUE;
    altnum++;
    return OK;
}

/*
 * init_alt - ɽɽ˥ǥեɽϿ
 */
int
init_alt()
{
    int		err;

    err = 0;
    if (add_alt("\xa5", "/") == ERR) /* 1Хȥʤ */
	err++;
    return err;
}

/*
 * get_gaiji - եֹȥɤ鳰ʸ֤
 */
uchr *
get_gaiji(g, ch)
int	g, ch;
{
    uchr	*p;

    if (g == 9)
	g = 7;
    p = gaijitbl[g][ch];
    if (p == NULL)
	p = gdeftbl[g];
    return p;
}

/*
 * load_gaiji - ɽեɤǳϿ
 */
int
load_gaiji(file)
uchr	*file;
{
    int		c, ch, g, isalt;
    int		line, err;
    uchr	*p, *q;
    FILE	*fp;
    uchr	org[4], buf[256], tmp[256];

    if ((fp = fopen(file, "r")) == NULL) {
	outstr("ERR: ɽե뤬ץǤޤ\n");
	return ERR;
    }
    line = 0;
    err = 0;
    while (fgets(buf, 256, fp) != NULL) {
	line++;
	buf[strlen(buf) - 1] = '\0';
	p = skipsp(buf);
	if (*p == '\0' || *p == ';')
	    continue;
	if (*p == '"') {	/* ɽ */
	    p++;
	    if (*p == '\\') {
		p = escchar(p, &c);
		org[0] = c;
		org[1] = '\0';
	    } else if (SJIS1(*p)) {
		org[0] = *p++;
		org[1] = *p++;
		org[2] = '\0';
	    } else {
		org[0] = *p++;
		org[1] = '\0';
	    }
	    if (*p != '"') {
		sprintf(tmp,
		    "ERR: line %d: ظʸޤ\n", line);
		outstr(tmp);
		err++;
		continue;
	    }
	    p++;
	    isalt = TRUE;
	} else {	/*  */
	    if (*p != 'G' || !strchr("01234569", p[1]) || p[2] != '-' ||
		!(isxdigit(p[3]) && isxdigit(p[4]) || p[3] == '*')) {
		sprintf(tmp,
		    "ERR: line %d: ֹ椬ޤ\n", line);
		outstr(tmp);
		err++;
		continue;
	    }
	    g = p[1] - '0';
	    if (g == 9)
		g = 7;
	    if (p[3] == '*') {
		ch = -1;
		p += 4;
	    } else {
		ch = hexval(p + 3);
		p += 5;
	    }
	    isalt = FALSE;
	}
	p = skipsp(p);
	if (*p == '=')
	    p++;
	p = skipsp(p);
	if (*p != '"') {
	    sprintf(tmp,
		"ERR: line %d: ɽʸޤ\n", line);
	    outstr(tmp);
	    err++;
	    continue;
	}
	p++;
	q = tmp;
	while (*p && *p != '"') {
	    if (*p == '\\') {
		p = escchar(p, &c);
		if (c == '\\' || c == '<' || c == '>')
		    *q++ = '\\';
		*q++ = c;
		continue;
	    }
	    if (SJIS1(*p)) {
		*q++ = *p++;
		*q++ = *p++;
		continue;
	    }
	    if (*p == '<' || *p == '>' || *p == '#')
		*q++ = '\\';
	    *q++ = *p++;
	}
	if (*p != '"') {
	    sprintf(tmp,
		"ERR: line %d: ɽʸޤ\n", line);
	    outstr(tmp);
	    err++;
	    continue;
	}
	*q = '\0';
	if (isalt) {
	    if (add_alt(org, tmp) == ERR) {
		outstr("ERR: ꡼­ޤ\n");
		err++;
	    }
	    continue;
	}
	if ((q = strpool(tmp)) == NULL) {
	    outstr("ERR: ꡼­ޤ\n");
	    err++;
	    continue;
	}
	if (ch >= 0)
	    gaijitbl[g][ch] = q;
	else
	    gdeftbl[g] = q;
    }
    fclose(fp);
    if (err)
	return ERR;
    return OK;
}

#ifdef MSDOS
uchr *
tosjis(str)
uchr	*str;
{
    return str;
}

void
outchar(c)
int	c;
{
    if (c == 0)
	return;
    putchar(c);
}
#endif

#ifdef UNIX
/*
 * tosjis - kcodeɽ줿ʸ򥷥եJISѴ
 *	    (ޥɹ԰Ѵ˻Ȥ)
 */
uchr *
tosjis(str)
uchr	*str;
{
    int		c, c1;
    int		c2, km;
    uchr	*p;
    static uchr	buf[128];

    if (kcode == KC_SJIS) {
	strcpy((char *)buf, str);
	return buf;
    }
    km = FALSE;
    p = buf;
    c1 = 0;
    while ((c = *str++) != '\0') {
	if (c1 != 0) {
	    c1 &= 0x7f;
	    c &= 0x7f;
	    if ((c1 & 0x01) == 0) {
		c += 0x7e;
	    } else {
		c += 0x1f;
		if (c > 0x7e)
		    c++;
	    }
	    c1 = (c1 + 0xe1) >> 1;
	    if (c1 > 0x9f)
		c1 += 0x40;
	    *p++ = c1;
	    *p++ = c;
	    c1 = 0;
	    continue;
	}
	if (c == '\033') {
	    c1 = *str++;
	    c2 = *str++;
	    if (c1 == '$' && (c2 == '@' || c2 == 'B'))
		km = TRUE;
	    else if (c1 == '(' && (c2 == 'J' || c2 == 'B'))
		km = FALSE;
	    continue;
	}
	if ((c & 0x80) || km == 1) {
	    c1 = c;
	    continue;
	}
	*p++ = c;
    }
    *p = '\0';
    return buf;
}

/*
 * outchar - եJISʸܤʤ
 *	     kcodeѴƽϤ
 *	     0ʤ¦ξ֤ѻ᤹(JISΤȤɬ)
 */
void
outchar(c)
int	c;
{
    static int	knj1 = 0;

    if (c == '\0') {
	if (kmode) {
	    printf("\033(%c", jisalpha);
	    kmode = FALSE;
	}
	return;
    }
    if (knj1 != 0) {
	if (kcode == KC_JIS && !kmode) {
	    printf("\033$%c", jiskanji);
	    kmode = TRUE;
	}
	if (kcode == KC_JIS || kcode == KC_EUC) {
	    if (knj1 > 0x9f)
		knj1 -= 0x40;
	    knj1 += knj1;
	    if (c <= 0x9e) {
		knj1 -= 0xe1;
		if (c >= 0x80)
		    c -= 1;
		c -= 0x1f;
	    } else {
		knj1 -= 0xe0;
		c -= 0x7e;
	    }
	    if (kcode == KC_EUC) {
		knj1 += 0x80;
		c += 0x80;
	    }
	}
	putchar(knj1);
	putchar(c);
	knj1 = 0;
	return;
    }
    if (c >= 0x81) {
	knj1 = c;
	return;
    }
    if (kmode) {
	printf("\033(%c", jisalpha);
	kmode = FALSE;
    }
    putchar(c);
}
#endif

/*
 * outstr - ѴʤoutcharͳʸϤ
 */
void
outstr(p)
uchr	*p;
{
    int		i, g;
    uchr	*gstr;
    uchr	tmp[16];

    while (*p) {
	if (rawmode) {
	    outchar(*p++);
	    continue;
	}
	if (*p == '<') {
	    if (p[1] == '/') {
		if (p[2] == 'G' && isdigit(p[3]))
		    gfont = -1;
		else if (!strncmp(p+2, "RUBY>", 5))
		    outstr(")");
		else if (!strncmp(p+2, "HL>", 3))
		    hlink = FALSE;
	    } else {
		if (p[1] == 'G')
		    gfont = p[2] - '0';
		else if (!strncmp(p+1, "RUBY>", 5))
		    outstr("(");
		else if (!strncmp(p+1, "HL>", 3))
		    hlink = TRUE;
	    }
	    while (*p != '>')
		p++;
	    p++;
	    continue;
	}
	if (*p == ':' && hlink) {
	    /*
	     * ϥѡ󥯻Ρ:װʹߤϤ٤̵
	     */
	    p++;
	    while (*p && (*p != '<' || strncmp(p, "</HL>", 5))) {
		if (SJIS1(*p))
		    p++;
		p++;
	    }
	    p += 5;
	    hlink = FALSE;
	    continue;
	}
	if (*p == '#' && p[3] == '#') {
	    g = (gfont == -1)? 0: gfont;
	    gstr = get_gaiji(g, hexval(p+1));
	    if (gstr) {
		outstr(gstr);
	    } else {
		sprintf(tmp, "\\<G%d-%c%c\\>", g, p[1], p[2]);
		outstr(tmp);
	    }
	    p += 4;
	    continue;
	}
	if (!in_alt && have_alt[*p]) {
	    for (i = 0; i < altnum; i++) {
		if (*p == alttbl[i].org[0] &&
		    (!SJIS1(*p) || p[1] == alttbl[i].org[1]))
		    break;
	    }
	    if (i < altnum) {
		in_alt = TRUE;
		outstr(alttbl[i].alt);
		in_alt = FALSE;
		if (SJIS1(*p))
		    p++;
		p++;
		continue;
	    }
	}
	if (*p == '\\')
	    p++;
	if (SJIS1(*p)) {
	    if (width > 0 && curpos >= width - 1)
		newline();
	    outchar(*p++);
	    outchar(*p++);
	    curpos += 2;
	    continue;
	}
	if (*p < ' ' || *p == 0x7f) {
	    switch (*p) {
	    case '\n':
		newline();
		p++;
		break;
	    case '\t':
		if (width > 0 && ((curpos | 0x07) + 1) > width)
		    newline();
		outchar(*p++);
		curpos = (curpos | 0x07) + 1;
		break;
	    default:
		outchar(*p++);
		break;
	    }
	    continue;
	}
	if (width > 0 && curpos >= width && !strchr("!),.:;?]}", *p))
	    newline();
	outchar(*p++);
	curpos++;
    }
    outchar(0);
}

/*
 * set_indent - ǥ̤ꤹ
 */
void
set_indent(n)
int	n;
{
    indent = n;
}

/*
 * newline - Ԥ̤ǥȤ
 */
void
newline()
{
    outchar('\n');
    for (curpos = 0; curpos < indent; curpos++)
	outchar(' ');
}

/* -------------------- ɽ񼰽 -------------------- */

/*
 * ʸǡƬΥ٥
 */
#define	LBL_ERROR	(-1)
#define	LBL_CMT		 0		/* (ɽ)			*/
#define	LBL_DR		 1		/* 			*/
#define	LBL_EN		 2		/* Ф			*/
#define	LBL_ENN		 3		/* Ѱɽ???(ɽ)	*/
#define	LBL_ENV		 4		/* ɽ			*/
#define	LBL_ENVN	 5		/* ֤ɽ???		*/
#define	LBL_ET		 6		/* ???			*/
#define	LBL_EV		 7		/* Ʊ			*/
#define	LBL_EX		 8		/* 				*/
#define	LBL_EXKEY	 9		/* 㸡			*/
#define	LBL_EXSUB	10		/* 㥵ֹ			*/
#define	LBL_F		11		/* IFθ???(tallith)		*/
#define	LBL_ID		12		/* 				*/
#define	LBL_IDSUB	13		/* 祵ֹ			*/
#define	LBL_IF		14		/* Ե§			*/
#define	LBL_IMG		15		/* ǥǡ(ɽ)		*/
#define	LBL_J2E		16		/* ܸ줫(adsuki bean)	*/
#define	LBL_KEY		17		/* (ɽ)		*/
#define	LBL_KEYEX	18		/* 㸡(ɽ)		*/
#define	LBL_KEYID	19		/* 縡(ɽ)		*/
#define	LBL_LOC		20		/* ʸǼ(ɽ)		*/
#define	LBL_MEN		21		/* MNθ???			*/
#define	LBL_MN		22		/* ̣				*/
#define	LBL_MNSUB	23		/* ֹ̣			*/
#define	LBL_NB		24		/* 				*/
#define	LBL_NBP		25		/* ɽ			*/
#define	LBL_NBPSUB	26		/* ɽ𥵥ֹ		*/
#define	LBL_NBSUB	27		/* 𥵥ֹ			*/
#define	LBL_NSBUS	28		/* NBSUBθ???(and)		*/
#define	LBL_OT		29		/* 졢ȯ...		*/
#define	LBL_OTSUB	30		/* 쥵ֹ			*/
#define	LBL_PR		31		/* ȯ				*/
#define	LBL_PS		32		/* ʻ				*/
#define	LBL_RA		33		/* ???(ɽ)			*/
#define	LBL_RES		34		/* ???(ɽ)			*/
#define	LBL_RN		35		/* ???(ɽ)			*/
#define	LBL_SM		36		/* ???(ɽ)			*/
#define	LBL_SND		37		/* ǡ(ɽ)		*/
#define	LBL_SRC		38		/* 츻				*/
#define	LBL_SRCSUB	39		/* 츻ֹ			*/
#define	LBL_TL		40		/* ʸȥ			*/
#define	LBL_TLSUB	41		/* ʸȥ륵ֹ		*/
#define	LBL_TQ		42		/* ̣ʬ(getΡI ͭ)*/
#define	LBL_TR		43		/* 				*/
#define	LBL_TRSUB	44		/* եֹ			*/
/*
 * ʲcsrd
 */
#define	LBL_ZEX		45		/* 硦㸡̤	*/
#define	LBL_ZID		46		/* 硦㸡̤	*/

typedef	struct _lbltbl_t {
    int		id;			/* ٥뼱ID			*/
    int		disp;			/* Ϥ뤫?			*/
    uchr	*label;			/* ٥ʸ			*/
    uchr	*leader;		/* Ƭ˽Ϥʸ		*/
} LBLTBL;

/*
 * ٥ɽ
 */
LBLTBL	labeltbl[] = {
    { LBL_CMT,		FALSE,	"CMT",		""	},
    { LBL_DR,		TRUE,	"DR",		""	},
    { LBL_EN,		TRUE,	"EN",		" "	},
    { LBL_ENN,		FALSE,	"ENN",		""	},
    { LBL_ENV,		TRUE,	"ENV",		""	},
    { LBL_ENVN,		TRUE,	"ENVN",		""	},
    { LBL_ET,		TRUE,	"ET",		""	},
    { LBL_EV,		TRUE,	"EV",		""	},
    { LBL_EX,		TRUE,	"EX",		"  "	},
    { LBL_EXKEY,	FALSE,	"EXKEY",	""	},
    { LBL_EXSUB,	TRUE,	"EXSUB",	""	},
    { LBL_F,		TRUE,	"F",		""	},
    { LBL_ID,		TRUE,	"ID",		""	},
    { LBL_IDSUB,	TRUE,	"IDSUB",	""	},
    { LBL_IF,		TRUE,	"IF",		""	},
    { LBL_IMG,		FALSE,	"IMG",		""	},
    { LBL_J2E,		TRUE,	"J2E",		""	},
    { LBL_KEY,		FALSE,	"KEY",		""	},
    { LBL_KEYEX,	FALSE,	"KEYEX",	""	},
    { LBL_KEYID,	FALSE,	"KEYID",	""	},
    { LBL_LOC,		FALSE,	"LOC",		""	},
    { LBL_MEN,		TRUE,	"MEN",		""	},
    { LBL_MN,		TRUE,	"MN",		""	},
    { LBL_MNSUB,	TRUE,	"MNSUB",	""	},
    { LBL_NB,		TRUE,	"NB",		""	},
    { LBL_NBP,		TRUE,	"NBP",		"  "	},
    { LBL_NBPSUB,	TRUE,	"NBPSUB",	""	},
    { LBL_NBSUB,	TRUE,	"NBSUB",	""	},
    { LBL_NSBUS,	TRUE,	"NSBUS",	""	},
    { LBL_OT,		TRUE,	"OT",		""	},
    { LBL_OTSUB,	TRUE,	"OTSUB",	""	},
    { LBL_PR,		TRUE,	"PR",		" "	},
    { LBL_PS,		TRUE,	"PS",		"\n"	},
    { LBL_RA,		FALSE,	"RA",		""	},
    { LBL_RES,		FALSE,	"RES",		""	},
    { LBL_RN,		FALSE,	"RN",		""	},
    { LBL_SM,		TRUE,	"SM",		""	},
    { LBL_SND,		FALSE,	"SND",		""	},
    { LBL_SRC,		TRUE,	"SRC",		""	},
    { LBL_SRCSUB,	TRUE,	"SRCSUB",	""	},
    { LBL_TL,		TRUE,	"TL",		""	},
    { LBL_TLSUB,	TRUE,	"TLSUB",	""	},
    { LBL_TQ,		TRUE,	"TQ",		"\n"	},
    { LBL_TR,		TRUE,	"TR",		""	},
    { LBL_TRSUB,	TRUE,	"TRSUB",	""	},
    { LBL_ZEX,		TRUE,	"ZEX",		""	},
    { LBL_ZID,		TRUE,	"ZID",		""	},
    { LBL_ERROR,	FALSE,	NULL,		NULL	}
};

LBLTBL	*get_label();
int	load_format();
int	suppress();

/*
 * get_label - ƬΥ٥̤
 */
LBLTBL *
get_label(str)
uchr	*str;
{
    uchr	*p, *q;
    LBLTBL	*lp;
    uchr	tmp[128];

    p = str;
    q = tmp;
    while (*p && isalpha(*p) && isupper(*p))
	*q++ = *p++;
    *q = '\0';
    if (!strncmp(str, "J2E", 3))
	strcpy(tmp, "J2E");
    lp = labeltbl;
    while (lp->label != NULL) {
	if (!strncmp(tmp, lp->label, strlen(tmp)))
	    break;
	lp++;
    }
    if (lp->id == LBL_OT) {
	if (isdigit(str[2]) && str[3] == 'S')
	    lp++;	/* OTOTSUBؤ褦ˤ */
    }
    return lp;
}

/*
 * load_format - 񼰥եɤǥ٥ɽ򹹿
 */
int
load_format(file)
uchr	*file;
{
    int		c, line, err, disp;
    uchr	*p, *q;
    FILE	*fp;
    LBLTBL	*lp;
    uchr	buf[256], tmp[256];

    if ((fp = fopen(file, "r")) == NULL) {
	outstr("ERR: ɽ񼰥ե뤬ץǤޤ\n");
	return ERR;
    }
    line = 0;
    err = 0;
    while (fgets(buf, 256, fp) != NULL) {
	line++;
	buf[strlen(buf) - 1] = '\0';
	disp = TRUE;
	p = skipsp(buf);
	if (*p == '\0' || *p == ';')
	    continue;
	if (*p == '!') {
	    disp = FALSE;
	    p++;
	}
	p = skipsp(p);
	lp = get_label(p);
	if (lp->id == LBL_ERROR) {
	    sprintf(tmp,
		"ERR: line %d: 񼰹̾ޤ\n", line);
	    outstr(tmp);
	    err++;
	    continue;
	}
	while (*p && (isupper(*p) || isdigit(*p)))
	    p++;
	p = skipsp(p);
	if (*p == '=')
	    p++;
	p = skipsp(p);
	if (*p != '"') {
	    sprintf(tmp,
		"ERR: line %d: ʸޤ\n", line);
	    outstr(tmp);
	    err++;
	    continue;
	}
	p++;
	q = tmp;
	while (*p && *p != '"') {
	    if (*p == '\\') {
		p = escchar(p, &c);
		if (c == '\\' || c == '<' || c == '>')
		    *q++ = '\\';
		*q++ = c;
		continue;
	    }
	    if (SJIS1(*p)) {
		*q++ = *p++;
		*q++ = *p++;
		continue;
	    }
	    if (*p == '<' || *p == '>' || *p == '#')
		*q++ = '\\';
	    *q++ = *p++;
	}
	if (*p != '"') {
	    sprintf(tmp,
		"ERR: line %d: ʸޤ\n", line);
	    outstr(tmp);
	    err++;
	    continue;
	}
	*q = '\0';
	if ((q = strpool(tmp)) == NULL) {
	    outstr("ERR: ꡼­ޤ\n");
	    err++;
	    continue;
	}
	lp->leader = q;
	lp->disp = disp;
    }
    fclose(fp);
    if (err)
	return ERR;
    return OK;
}

/*
 * suppress - ʸǻꤵ줿ܤɽ
 */
int
suppress(str)
uchr	*str;
{
    if (str == NULL)
	return OK;
    if (!strcmp(str, "a"))
	str = "teio";
    while (*str) {
	switch (*str) {
	case 't':
	    get_label("TR")->disp = FALSE;
	    get_label("TRSUB")->disp = FALSE;
	    break;
	case 'e':
	    get_label("EX")->disp = FALSE;
	    get_label("EXSUB")->disp = FALSE;
	    get_label("ZEX")->disp = FALSE;
	    break;
	case 'i':
	    get_label("ID")->disp = FALSE;
	    get_label("IDSUB")->disp = FALSE;
	    get_label("ZID")->disp = FALSE;
	    break;
	case 'o':
	    get_label("OT")->disp = FALSE;
	    get_label("OTSUB")->disp = FALSE;
	    break;
	default:
	    return ERR;
	}
	str++;
    }
    return OK;
}

/* -------------------- ʸɽ -------------------- */

#define	MAIN_DAT	"main.txt"	/* ʸ				*/

#define	REV_LF		0xf5		/* 0x0a(LF)Υӥåȿž		*/

#define	LBUFSIZ		4096		/* ԥХåեΥ		*/
					/* Сmain.datκ	*/
					/* Ĺ2389;͵ߤƤ	*/

/*
 * ȯϡ{;פȡ2}פǰϤޤ(VEGAб)
 */
#define	BP_LEADER	'{'		/* csrd¦ȯ󳫻	*/
#define	BP_START	';'		/* ȯ󳫻		*/
#define	BP_END		'2'		/* ȯλ		*/
#define	BP_TRAILER	'}'		/* csrd¦ȯλ	*/

/*
 * BPTBL.gcΥޥ
 */
#define	CHMASK		0x00ff		/* ʸ			*/
#define	GRMASK		0x1f00		/* եȥ롼		*/
#define	ITMASK		0x8000		/* å			*/

#define	GRNMASK		0x0f00		/* եȥ롼ֹ		*/
#define	GRUNDEF		0x1000		/* եȥ롼̤	*/

#define	GNUM(g)		(((g) == 0x0900)? 99: ((g) >> 8))

typedef	struct _bptbl_t {
    unt		gc;			/* եȥ롼+ʸ	*/
    uchr	bps[4];			/* ȯ		*/
} BPTBL;

/*
 * ȯɽ
 */
BPTBL bptbl[] = {
    { 'a',	"A"	},		/* a				*/
    { 'b',	"B"	},		/* b				*/
    { 'd',	"D"	},		/* d				*/
    { 'e',	"E"	},		/* e				*/
    { 'f',	"F"	},		/* f				*/
    { 'g',	"G"	},		/* g				*/
    { 'h',	"H"	},		/* h				*/
    { 'i',	"I"	},		/* i				*/
    { 'j',	"J"	},		/* j				*/
    { 'k',	"K"	},		/* k				*/
    { 'l',	"L"	},		/* l				*/
    { 'm',	"M"	},		/* m				*/
    { 'n',	"N"	},		/* n				*/
    { 'o',	"O"	},		/* o				*/
    { 'p',	"P"	},		/* p				*/
    { 'r',	"R"	},		/* r				*/
    { 's',	"S"	},		/* s				*/
    { 't',	"T"	},		/* t				*/
    { 'u',	"U"	},		/* u				*/
    { 'v',	"V"	},		/* v				*/
    { 'w',	"W"	},		/* w				*/
    { 'z',	"Z"	},		/* z				*/
    { 0x00e0,	"^A"	},		/* a				*/
    { 0x00e1,	"_A"	},		/* a				*/
    { 0x00e6,	"%"	},		/* aeι			*/
    { 0x00e8,	"^E"	},		/* e				*/
    { 0x00e9,	"_E"	},		/* e				*/
    { 0x00ec,	"^I"	},		/* i				*/
    { 0x00ed,	"_I"	},		/* i				*/
    { 0x00f0,	"\\]"	},		/* theth			*/
    { 0x00f2,	"^O"	},		/* o				*/
    { 0x00f3,	"_O"	},		/* o				*/
    { 0x00f9,	"^U"	},		/* u				*/
    { 0x00fa,	"_U"	},		/* u				*/
    { 0x0141,	"*"	},		/* ȤΤʤa		*/
    { 0x0142,	"\\<"	},		/* γo			*/
    { 0x0143,	"_+"	},		/* ΤʤAˡ		*/
    { 0x014a,	"_%"	},		/* aeιˡ			*/
    { 0x014b,	"^%"	},		/* aeιˡ			*/
    { 0x014c,	"_5"	},		/* ޤ첻ˡ		*/
    { 0x014d,	"^5"	},		/* ޤ첻ˡ		*/
    { 0x014e,	"_*"	},		/* ȤΤʤaˡ		*/
    { 0x014f,	"^*"	},		/* ȤΤʤaˡ		*/
    { 0x0150,	":"	},		/* shesh			*/
    { 0x0151,	"_\\<"	},		/* γoˡ		*/
    { 0x0152,	"^\\<"	},		/* γoˡ		*/
    { 0x0153,	"_\\>"	},		/* ݤEˡ			*/
    { 0x0154,	"^\\>"	},		/* ݤEˡ			*/
    { 0x016a,	"?"	},		/* throughth			*/
    { 0x0173,	"!"	},		/* 餫g			*/
    { 0x0176,	"$"	},		/* singng			*/
    { 0x02e1,	"^+"	},		/* ΤʤAˡ		*/
    { 0x03b9,	"5"	},		/* ޤ첻			*/
    { 0x0477,	"3"	}		/* Ф			*/
};

#define	NBPS	(sizeof(bptbl) 	/ sizeof(bptbl[0]))

int	do_braille = FALSE;		/* ȯѴԤ?	*/
int	nobracket = FALSE;		/* ȯϤ[]뤫?	*/
int	firstidiom;			/* ʻκǽ		*/
int	have_en;			/* Фñɽľ(̵Ի)	*/
uchr	line[LBUFSIZ];			/* 1ԥǡɽѺΰ	*/

uchr	*bpstr();
uchr	*bp_transfer();
BFILE	*dic_open();
int	dgetline();
int	showline();
int	show_data();
int	show_idiom();
int	show_header();
int	show_version();

/*
 * bpstr - ʸбȯ֤
 */
uchr *
bpstr(gc)
unt	gc;
{
    int		i;

    gc &= (GRNMASK|CHMASK);	/* GRUNDEF<G0>Ʊ */
    for (i = 0; i < NBPS; i++) {
	if (gc == bptbl[i].gc)
	    return bptbl[i].bps;
    }
    return NULL;
}

/*
 * bp_transfer - ȯߤ
 *		 ̤Ϥ줿Хåե񤭤ǽ񤭹
 *		 ѴʸǤϥγĤäƤǽ
 */
uchr *
bp_transfer(line)
uchr	*line;
{
    int		level;
    unt		c, it, nit, g, ng;
    uchr	*p, *q;
    unt		*u, *uu, *upto;
    static unt	tmp[1024];	/* ѴǡϺ776Х	*/

#ifdef DEBUG
    if (debug)
	printf("line in= \"%s\"\n", line);
#endif
    /*
     * tmp˥ե/åդʸȤΩƤ
     */
    g = GRUNDEF;
    it = 0;
    p = line;
    u = tmp;
    while (*p) {
	if (*p == '<') {
	    if (p[1] == 'G')
		g = (p[2] - '0') << 8;
	    else if (p[1] == '/' && p[2] == 'G')
		g = GRUNDEF;
	    else if (p[1] == 'I' && p[2] == '>')
		it = ITMASK;
	    else if (p[1] == '/' && p[2] == 'I' && p[3] == '>')
		it = 0;
	    else {
		while (*p != '>')
		    *u++ = it | g | *p++;
		*u++ = it | g | *p++;
		continue;
	    }
	    while (*p++ != '>')
		;
	    continue;
	}
	if (SJIS1(*p)) {
	    *u++ = it | g | *p++;
	    *u++ = it | g | *p++;
	    continue;
	}
	if (*p == '#' && p[3] == '#') {
	    *u++ = it | g | hexval(p + 1);
	    p += 4;
	    continue;
	}
	*u++ = it | g | *p++;
    }
    *u = '\0';
    /*
     * ȯᤷʤlineľ
     */
    g = GRUNDEF;
    it = 0;
    level = 0;
    p = line;
    u = tmp;
    upto = NULL;
    while (*u) {
	nit = *u & ITMASK;
	if (nit != it) {
	    strcpy(p, nit? "<I>": "</I>");
	    while (*p++ != '>')
		;
	    it = nit;
	}
	ng = *u & GRMASK;
	if (ng != g) {
	    if (g != GRUNDEF) {
		sprintf(p, "</G%d>", GNUM(g));
		while (*p++ != '>')
		    ;
	    }
	    if (ng != GRUNDEF) {
		sprintf(p, "<G%d>", GNUM(ng));
		while (*p++ != '>')
		    ;
	    }
	    g = ng;
	}
	if ((*u & GRUNDEF) != 0 && SJIS1(*u & CHMASK)) {
	    *p++ = (*u++ & CHMASK);
	    *p++ = (*u++ & CHMASK);
	    continue;
	}
	if (upto && u < upto)
	    goto notrans;
	switch (*u & (GRNMASK|CHMASK)) {
	case '[':
	    if (!nobracket)
		*p++ = *u & CHMASK;
	    level++;
	    break;
	case ']':
	    if (!nobracket)
		*p++ = *u & CHMASK;
	    if (level > 0)
		level--;
	    break;
	default:
	    if (level > 0 && bpstr(*u) != NULL) {
		uu = u;
		while (*uu && bpstr(*uu)) {
		    uu++;
		}
		c = *uu & (GRMASK|CHMASK);
		if (c == ' ' || c == ';' || c == ',' ||
		    c == '-' || c == ']' || c == '|') {
		    if (g != GRUNDEF) {
			sprintf(p, "</G%d>", GNUM(g));
			while (*p++ != '>')
			    ;
			g = GRUNDEF;
		    }
		    *p++ = BP_LEADER;
		    *p++ = BP_START;
		    while (u < uu) {
			q = bpstr(*u++);
			while (*q)
			    *p++ = *q++;
		    }
		    *p++ = BP_END;
		    *p++ = BP_TRAILER;
		    u = uu;
		    continue;
		}
		upto = uu;
	    }
	notrans:
	    ng = *u & GRMASK;
	    c = *u & CHMASK;
	    if (ng == GRUNDEF) {
		*p++ = c;
	    } else if (ng != 0 ||
		c >= 0x80 || c == '/' || c == ':' || c == '=') {
		sprintf(p, "#%02x#", c);
		p += 4;
	    } else {
		*p++ = c;
	    }
	}
	u++;
    }
    *p = '\0';
    if (it) {
	strcpy(p, "</I>");
	p += 4;
    }
    if (g != GRUNDEF)
	sprintf(p, "</G%d>", GNUM(g));
#ifdef DEBUG
    if (debug)
	printf("line out=\"%s\"\n", line);
#endif
    return line;
}

/*
 * dic_open - ǡեbopen()
 */
BFILE *
dic_open(dicdir, dicfile)
uchr	*dicdir, *dicfile;
{
    BFILE	*bfp;
    uchr	buf[256];

    sprintf(buf, "%s/%s", dicdir, dicfile);
    if ((bfp = bopen(buf)) == NULL) {
	outstr("ERR: ե뤬ץǤޤ(");
	outstr(buf);
	outstr(")\n");
	return NULL;
    }
    return bfp;
}

/*
 * dgetline - ʸǡ1ɤ߹ߡԤĹ֤
 */
int
dgetline(bfp, buf)
BFILE	*bfp;
uchr	*buf;
{
    int		c;
    uchr	*p;

    p = buf;
    while ((c = bgetc(bfp)) != REV_LF)
	*p++ = ~c;
    *p = '\0';
    return p - buf;
}

/*
 * showline - 1Ԥʸǡɽ
 */
int
showline(line)
uchr	*line;
{
    uchr	*p, *q;
    LBLTBL	*lp;

    if (rawmode) {
	outstr(line);
	outstr("\n");
	return OK;
    }
    lp = get_label(line);
    if (lp->id == LBL_ERROR) {
#ifdef DEBUG
	if (debug) {
	    outstr("ERR> ");
	    outstr(line);
	    outstr("\n");
	}
#endif
	return ERR;
    }
    if (!lp->disp) {
#ifdef DEBUG
	if (debug) {
	    outstr("[");
	    outstr(lp->label);
	    outstr("*]\n");
	}
#endif
	return OK;
    }
    if (have_en && lp->id != LBL_PR) {
	set_indent(0);
	outstr("\n");
    }
    have_en = FALSE;
#ifdef DEBUG
    if (debug) {
	outstr("[");
	outstr(lp->label);
	outstr("] ");
    }
#endif
    p = skipeq(line);
    if (*p == '\0')
	return OK;
    set_indent(nspaces(lp->leader));
    outstr(lp->leader);
    switch (lp->id) {
    case LBL_DR:
	q = p;
	while (*q && *q != '|')
	    q++;
	*q = 0;
	outstr(p);
	set_indent(0);
	outstr("\n");
	break;
    case LBL_EN:
	q = p;
	while (*q && *q != '|')
	    q++;
	*q = 0;
	outstr(p);
	have_en = TRUE;
	break;
    case LBL_ID:
	if (firstidiom) {
	    outstr("\n\n");
	    firstidiom = FALSE;
	}
	goto normal;
    case LBL_PS:
	firstidiom = TRUE;
	goto normal;
    case LBL_TRSUB:
	if (!strncmp(p, "", 2)) {
	    p += 2;
	    while (*p && strncmp(p, "", 2)) {
		if (SJIS1(*p))
		    p++;
		p++;
	    }
	    if (*p)
		p += 2;
	}
	goto normal;
    case LBL_PR:
    case LBL_IF:
	if (do_braille)
	    p = bp_transfer(p);
	goto normal;
    default:
    normal:
	outstr(p);
	set_indent(0);
	outstr("\n");
	break;
    }
    return OK;
}

/*
 * show_data - ʸǡɽ
 */
int
show_data(bfp, dpos, dlen)
BFILE	*bfp;
long	dpos, dlen;
{
    int		len;

    if (bseek(bfp, dpos) == ERR)
	return ERR;
    firstidiom = TRUE;
    while (dlen > 0L) {
	len = dgetline(bfp, line);
	showline(line);
	dlen -= (long)(len + 1);
    }
    return OK;
}

/*
 * show_idiom - 硦θ̤ɽ
 */
int
show_idiom(bfp, dpos)
BFILE	*bfp;
long	dpos;
{
    int		idiom;
    long	npos;
    uchr	*p, *q;
    LBLTBL	*lp;
    uchr	ps[128], tr[32];

    /*
     * ȤǹƬޤ̤ɬפΤ
     * 硦ɤ߽Ф;͵Ĥ
     * եƬˤäbseek()
     * 줫ΰ֤bseek()
     * 뤳Ȥread()β餻Ϥ
     */
    npos = dpos - (BBUFSIZ - 512);
    if (npos < 0L)
	npos = 0;
    if (bseek(bfp, npos) == ERR)
	return ERR;
    if (bseek(bfp, dpos) == ERR)
	return ERR;
    dgetline(bfp, line);
    if (rawmode) {
	outstr(line);
	outstr("\n");
	return OK;
    }
    if (*line == 'I' || *line == 'D') {
	lp = get_label("ZID");
	idiom = TRUE;
    } else {
	lp = get_label("ZEX");
	idiom = FALSE;
    }
    if (!lp->disp)
	return OK;
    set_indent(nspaces(lp->leader));
    outstr(lp->leader);
    outstr(skipeq(line));
    /*
     * եƬ̤äEN=õ
     * 鸽֤߰ޤɬפʾɤɽ
     */
    if (bseek(bfp, dpos) == ERR)
	return ERR;
    for (;;) {
	if ((bgetcbw(bfp) ^ 0xff) == '=' &&
	    (bgetcbw(bfp) ^ 0xff) == 'N' &&
	    (bgetcbw(bfp) ^ 0xff) == 'E' &&
	    (bgetcbw(bfp) ^ 0xff) == '\n')
	    break;
    }
    bgetc(bfp);
    outstr(" (");
    dgetline(bfp, line);
    p = q = skipeq(line);
    while (*q && *q != '|')
	q++;
    *q = '\0';
    outstr(p);
    *ps = *tr = '\0';
    while (btell(bfp) < dpos) {
	dgetline(bfp, line);
	if (!strncmp(line, "PS=", 3)) {
	    strcpy(ps, line + 3);
	    *tr = '\0';
	    continue;
	}
	if (!idiom && !strncmp(line, "TR", 2)) {
	    p = line + 2;
	    if (*p == 'S') /* TRSUB */
		p += 3;
	    q = tr;
	    while (*p && *p != '=')
		*q++ = *p++;
	    *q = '\0';
	}
    }
    if (*ps) {
	outstr(", ");
	outstr(ps);
	if (*tr)
	    outstr(tr);
	if (idiom)
	    outstr(" ");
    }
    outstr(")");
    set_indent(0);
    outstr("\n");
    return OK;
}

/*
 * show_header - ENˤ븫Фǡɽ
 */
int
show_header(bfp, dpos)
BFILE	*bfp;
long	dpos;
{
    uchr	*p, *q;

    if (bseek(bfp, dpos) == ERR)
	return ERR;
    for (;;) {
	if (dgetline(bfp, line) <= 0)
	    return ERR;
	if (get_label(line)->id != LBL_EN)
	    continue;
	p = skipeq(line);
	q = p;
	while (*q && *q != '|')
	    q++;
	*q = 0;
	outstr(p);
	break;
    }
    return OK;
}

/*
 * show_version - ʸǡΥСɽ
 */
int
show_version(dicdir)
uchr	*dicdir;
{
    uchr	*p;
    BFILE	*bfp;

    if ((bfp = dic_open(dicdir, MAIN_DAT)) == NULL)
	return ERR;
    bseek(bfp, 0L);
    while (dgetline(bfp, line) > 0 && !strncmp(line, "CMT=", 4)) {
	if (rawmode) {
	    outstr(line);
	    outstr("\n");
	    continue;
	}
	p = line + 4;
	if (!strncmp(p, "***", 3) ||
	    !strncmp(p, "TITLE:", 6) ||
	    !strncmp(p, "Based", 5) ||
	    !strncmp(p, "DATE:", 5)) {
	    outstr(p);
	    outstr("\n");
	}
    }
    bclose(bfp);
    return OK;
}

/* --------------- 硦㸡ȥե --------------- */

#define	TT0SIZ		1000		/* ̳Ǽǿ	*/

/*
 * ǡǼ
 */
#define	TF_USE0		0		/* 0Ȥ		*/
#define	TF_USE01	1		/* 0ȥե1Ȥ	*/
#define	TF_USE1		2		/* ե1Ȥ		*/
#define	TF_USE12	3		/* ե1ȥե2Ȥ	*/

typedef	struct _tftbl {
    long	val;			/* ǡ			*/
    long	num;			/* ǡ			*/
    int		n0;			/* tt0Υǡ		*/
    int		n0x;			/* tt0㳫ϰ/߰	*/
    long	n1;			/* tf1Υǡ		*/
    long	n1x;			/* tf1θ߰		*/
    long	n2;			/* tf2Υǡ		*/
    long	n2x;			/* tf2θ߰		*/
    long	*tt0;			/* 0			*/
    uchr	*tf1;			/* ȥե1		*/
    uchr	*tf2;			/* ȥե2		*/
    FILE	*fp1;			/* ȥե1 FP		*/
    FILE	*fp2;			/* ȥե2 FP		*/
    long	v1;			/* tf1ɤߥǡ		*/
    long	v2;			/* tf2ɤߥǡ		*/
    int		use;			/* ǡǼ			*/
    int		open;			/* ץ󤵤Ƥ뤫?	*/
} TFTBL;

TFTBL	*tftbl;				/* ȥեɽ		*/

int	setuptmp();
void	cleantmp();
int	twopen();
int	twrite();
int	twclose();
int	tropen();
long	tread();
int	trclose();
int	tisopen();
void	tswap();
void	tfree();
int	lcmp();
long	getlval();

/*
 * setuptmp - ȥեɽ
 */
int
setuptmp()
{
    int		n, len;
    uchr	*tmpdir;
    TFTBL	*tp;
    uchr	tmp[128];

    tftbl = (TFTBL *)malloc(sizeof(TFTBL) * 3);
    if (tftbl == NULL)
	return ERR;
    len = 0;
    if ((tmpdir = getenv("TMP")) != NULL ||
	(tmpdir = getenv("TEMP")) != NULL) {
	strcpy(tmp, tmpdir);
	bsltosl(tmp);
	len = strlen(tmp);
	if (tmp[len-1] != '/')
	    tmp[len++] = '/';
    }
    tp = tftbl;
    for (n = 0; n < 3; n++) {
	sprintf(tmp+len, "cs%d1XXXXXX", n);
	tp->tf1 = strpool(tmp);
	sprintf(tmp+len, "cs%d2XXXXXX", n);
	tp->tf2 = strpool(tmp);
	if (tp->tf1 == NULL || tp->tf2 == NULL)
	    return ERR;
	mktemp(tp->tf1);
	mktemp(tp->tf2);
	tp->fp1 = NULL;
	tp->fp2 = NULL;
	tp->open = FALSE;
	tp++;
    }
    tp = tftbl;
    for (n = 0; n < 3; n++) {
	tp->tt0 = (long *)malloc(TT0SIZ * sizeof(long));
	/*
	 * ꡼­ʤtt0ϻȤʤƤ褤
	 * 顼ˤϤʤ
	 */
	tp++;
    }
#ifdef DEBUG
    if (debug2) {
	tp = tftbl;
	for (n = 0; n < 3; n++) {
	    printf("tftbl[%d]:\n", n);
	    printf(" tt0=%s\n", tp->tt0? "(in use)": "(not in use)");
	    printf(" tf1=%s\n", tp->tf1);
	    printf(" tf2=%s\n", tp->tf2);
	    tp++;
	}
    }
#endif
    return OK;
}

/*
 * cleantmp - ĤäƤ뤫⤷ʤȥե
 */
void
cleantmp()
{
    int		n;
    TFTBL	*tp;

    if (tftbl == NULL)
	return;
    tp = tftbl;
    for (n = 0; n < 3; n++) {
	if (tp->fp1 != NULL) {
	    fclose(tp->fp1);
	    tp->fp1 = NULL;
	}
	if (tp->fp2 != NULL) {
	    fclose(tp->fp2);
	    tp->fp2 = NULL;
	}
	unlink(tp->tf1);
	unlink(tp->tf2);
	tp->open = FALSE;
	tp++;
    }
}

/*
 * twopen - ȥե륻åȤ񤭽Фץ󤹤
 */
int
twopen(tn)
int	tn;
{
    TFTBL	*tp;

    tp = &tftbl[tn];
    tp->val = 0L;
    tp->num = 0L;
    tp->n0 = tp->n0x = 0;
    tp->n1 = tp->n1x = 0L;
    tp->n2 = tp->n2x = 0L;
    tp->fp1 = tp->fp2 = NULL;
    tp->use = (tp->tt0 != NULL)? TF_USE0: TF_USE1;
    tp->open = TRUE;
    return OK;
}

/*
 * twrite - ȥե륻åȤ˽񤭽Ф
 */
int
twrite(tn, val)
int	tn;
long	val;
{
    int		n;
    TFTBL	*tp;

    tp = &tftbl[tn];
    switch (tp->use) {
    case TF_USE0:
	if (tp->n0 >= TT0SIZ) {
	    /*
	     * ˼ޤʤäΤtf1Ȥ
	     */
	    if ((tp->fp1 = fopen(tp->tf1, "w")) == NULL)
		goto openerr;
#ifdef DEBUG
	    if (debug2) {
		printf("twrite(%d): open tf1(%s), num=%ld, val=%07lx\n",
		    tn, tp->tf1, tp->num, val);
	    }
#endif
	    for (n = tp->n0x; n < TT0SIZ; n++) {
		if (fprintf(tp->fp1, "%07lx\n", tp->tt0[n]) == EOF)
		    goto writeerr;
	    }
	    tp->n0 = tp->n0x;
	    tp->n1 = (long)(TT0SIZ - tp->n0x);
	    if (tp->n0x > 0) {
		/*
		 * ζä
		 * ϻĤtf1˰ư줿
		 * Ȥtt0򥽡ȤɬפϤʤ(n0x=0)
		 */
		tp->n0x = 0;
		tp->use = TF_USE01;
		goto use01;
	    }
	    /*
	     * Τtf1˰ư줿
	     */
	    tp->use = TF_USE1;
	    goto use1;
	}
	if (val < tp->val) {
	    /*
	     * ζ褿
	     */
	    tp->n0x = tp->n0;
	}
	tp->tt0[tp->n0++] = val;
	break;
    case TF_USE01:
    use01:
	if (val < tp->val)
	    goto fmterr;
	goto use1write;
    case TF_USE1:
    use1:
	if (val < tp->val) {
	    /*
	     * ζ褿
	     * ʸtf2Ȥ
	     */
	    if ((tp->fp2 = fopen(tp->tf2, "w")) == NULL)
		goto openerr;
#ifdef DEBUG
	    if (debug2) {
		printf("twrite(%d): open tf2(%s), num=%ld, val=%07lx\n",
		    tn, tp->tf1, tp->num, val);
	    }
#endif
	    tp->use = TF_USE12;
	    goto use12;
	}
    use1write:
	if (fprintf(tp->fp1, "%07lx\n", val) == EOF)
	    goto writeerr;
	tp->n1++;
	break;
    case TF_USE12:
	if (val < tp->val)
	    goto fmterr;
    use12:
	if (fprintf(tp->fp2, "%07lx\n", val) == EOF)
	    return ERR;
	tp->n2++;
	break;
    }
    tp->val = val;
    tp->num++;
    return OK;
openerr:
    outstr("ERR: ѥե뤬Ǥޤ\n");
    return ERR;
writeerr:
    outstr("ERR: ǥäѤǤ\n");
    return ERR;
fmterr:
    outstr("PANIC: 硦㥤ǥåͽʤ¤Ǥ\n");
#ifdef DEBUG
    if (debug2) {
	printf("num=%ld, cur=%lx, prev=%lx\n", tp->num, val, tp->val);
    }
#endif
    return ERR;
}

/*
 * twclose - ȥե륻åȤ򥯥
 */
int
twclose(tn)
int	tn;
{
    TFTBL	*tp;

    tp = &tftbl[tn];
#ifdef DEBUG
    if (debug2) {
	printf("twclose(%d): n0=%d, n1=%ld, n2=%ld\n",
	    tn, tp->n0, tp->n1, tp->n2);
    }
#endif
    switch (tp->use) {
    case TF_USE0:
	if (tp->n0x > 0) {
	    /*
	     * tt0硦ζ
	     * tt0򥽡Ȥɬפ
	     */
	    qsort((uchr *)tp->tt0, (size_t)tp->n0, sizeof(long), lcmp);
	}
	break;
    case TF_USE12:
	/*
	 * tf1硢tf2㤬
	 */
	if (fclose(tp->fp2) == EOF)
	    goto closeerr;
	tp->fp2 = NULL;
	/* fall thru ... */
    case TF_USE01:
	/*
	 * tt0硢tf1㤬
	 */
	/* fall thru ... */
    case TF_USE1:
	/*
	 * tf1Τ줫ޤϤξ
	 * ͤñĴäƤ
	 */
	if (fclose(tp->fp1) == EOF)
	    goto closeerr;
	tp->fp1 = NULL;
	break;
    }
    tp->open = FALSE;
    return OK;
closeerr:
    outstr("ERR: ǥäѤǤ\n");
    return ERR;
}

/*
 * tropen - ȥե륻åȤɤ߹ߥץ󤹤
 */
int
tropen(tn)
int	tn;
{
    TFTBL	*tp;

    tp = &tftbl[tn];
    switch (tp->use) {
    case TF_USE0:
	tp->n0x = 0;
	break;
    case TF_USE01:
	tp->n0x = 0;
	goto open1;
    case TF_USE12:
	if ((tp->fp2 = fopen(tp->tf2, "r")) == NULL)
	    goto openerr;
	tp->v2 = getlval(tp->fp2);
	tp->n2x = 0L;
	/* fall thru ... */
    case TF_USE1:
    open1:
	if ((tp->fp1 = fopen(tp->tf1, "r")) == NULL)
	    goto openerr;
	tp->v1 = getlval(tp->fp1);
	tp->n1x = 0L;
	break;
    }
    tp->open = TRUE;
    return OK;
openerr:
    outstr("ERR: ѥե뤬ץǤޤ\n");
    return ERR;
}

/*
 * tread - ȥե륻åȤɤ߹
 */
long
tread(tn)
int	tn;
{
    long	v;
    TFTBL	*tp;

    tp = &tftbl[tn];
    switch (tp->use) {
    case TF_USE0:
	if (tp->n0x >= tp->n0)
	    return EOF;
	v = tp->tt0[tp->n0x++];
	break;
    case TF_USE01:
	if (tp->n0x >= tp->n0) {
	    if (tp->n1x >= tp->n1) {
		return EOF;
	    } else {
		v = tp->v1;
		tp->v1 = getlval(tp->fp1);
		tp->n1x++;
	    }
	} else {
	    if (tp->n1x >= tp->n1) {
		v = tp->tt0[tp->n0x++];
	    } else {
		if (tp->tt0[tp->n0x] < tp->v1) {
		    v = tp->tt0[tp->n0x++];
		} else {
		    v = tp->v1;
		    tp->v1 = getlval(tp->fp1);
		    tp->n1x++;
		}
	    }
	}
	break;
    case TF_USE1:
	if (tp->n1x >= tp->n1)
	    return EOF;
	v = tp->v1;
	tp->v1 = getlval(tp->fp1);
	tp->n1x++;
	break;
    case TF_USE12:
	if (tp->n1x >= tp->n1) {
	    if (tp->n2x >= tp->n2) {
		return EOF;
	    } else {
		v = tp->v2;
		tp->v2 = getlval(tp->fp2);
		tp->n2x++;
	    }
	} else {
	    if (tp->n2x >= tp->n2) {
		v = tp->v1;
		tp->v1 = getlval(tp->fp1);
		tp->n1x++;
	    } else {
		if (tp->v1 < tp->v2) {
		    v = tp->v1;
		    tp->v1 = getlval(tp->fp1);
		    tp->n1x++;
		} else {
		    v = tp->v2;
		    tp->v2 = getlval(tp->fp2);
		    tp->n2x++;
		}
	    }
	}
	break;
    }
    return v;
}

/*
 * trclose - ȥե륻åȤ򥯥
 */
int
trclose(tn)
int	tn;
{
    TFTBL	*tp;

    tp = &tftbl[tn];
    switch (tp->use) {
    case TF_USE0:
	break;
    case TF_USE12:
	fclose(tp->fp2);
	tp->fp2 = NULL;
	/* fall thru ... */
    case TF_USE01:
    case TF_USE1:
	fclose(tp->fp1);
	tp->fp1 = NULL;
	break;
    }
    tp->open = FALSE;
    return OK;
}

/*
 * tisopen - ȥե륻åȤϥץ󤵤Ƥ뤫?
 */
int
tisopen(tn)
int	tn;
{
    return tftbl[tn].open;
}

/*
 * tswap - TFTBL򴹤
 */
void
tswap(tn0, tn1)
int	tn0, tn1;
{
    TFTBL	tftmp;

    tftmp = tftbl[tn0];
    tftbl[tn0] = tftbl[tn1];
    tftbl[tn1] = tftmp;
}

/*
 * tfree - tt0
 */
void
tfree(tn)
int	tn;
{
    TFTBL	*tp;

    if (tftbl == NULL)
	return;
    tp = &tftbl[tn];
    if (tp->tt0) {
	free((char *)tp->tt0);
	tp->tt0 = NULL;
    }
}

/*
 * lcmp - longͤɤ(qsort)
 */
int
lcmp(p1, p2)
long	*p1, *p2;
{
    if (*p1 < *p2)
	    return -1;
    if (*p1 > *p2)
	    return 1;
    return 0;
}

/*
 * getlval - ե뤫1Ԥ16ʸɤlongȤ֤
 */
long
getlval(fp)
FILE	*fp;
{
    uchr	tmp[16];
    long	l;

    if (fgets(tmp, 16, fp) == NULL)
	return (long)EOF;
    sscanf(tmp, "%lx", &l);
    return l;
}

/* --------------------  -------------------- */

#define	EN_SRCH		0		/* ñ측			*/
#define	TR_SRCH		1		/* 측			*/
#define	ID_SRCH		2		/* 硦㸡		*/

#define	X_MATCH		0		/* ׸			*/
#define	F_MATCH		1		/* ׸			*/
#define	R_MATCH		2		/* ׸			*/
#define	W_MATCH		3		/* 磻ɥɸ		*/

#define	EN_F_IDX	"enf.idx"	/* ñץǥå	*/
#define	EN_R_IDX	"enr.idx"	/* ñץǥå	*/
#define	TR_F_IDX	"trf.idx"	/* ץǥå	*/
#define	TR_R_IDX	"trr.idx"	/* ץǥå	*/
#define	EN_LIST		"en.dat"	/* ñꥹ			*/
#define	TR_LIST		"tr.dat"	/* ꥹ			*/
#define	ID_IDX		"id.idx"	/* 硦㥤ǥå	*/
#define	ID_LIST		"id.dat"	/* 硦ꥹ		*/
#define	EN_M_LIST	"miden.txt"	/* ñְץꥹ		*/
#define	TR_M_LIST	"midtr.txt"	/* ְץꥹ		*/

#define	INODETOP	0x00000100L	/* ǥåƬΡɰ	*/
#define	LENTTOP		0x00000100L	/* ꥹȥȥ꡼Ƭ	*/

/*
 * ǥåȥ꡼
 */
typedef	struct _ient {
    uchr	lstpos[4];		/* ꥹȥեΰ	*/
    uchr	next[4];		/* ̥ΡɤΥΡֹ	*/
} IENT;

/*
 * ǥåΡ
 */
typedef	struct _inode {
    uchr	pageno[4];		/* 				*/
    uchr	last[4];		/* Ρκǽȥ꡼ֹ	*/
    IENT	ent[7];			/* ΡΥȥ꡼		*/
} INODE;

/*
 * ꥹȥȥ꡼
 */
typedef	struct _lent {
    long	dpos;			/* ʸǡ		*/
    long	dlen;			/* ʸǡ		*/
    uchr	fkey[128];		/* ץ			*/
    uchr	rkey[128];		/* ץ			*/
    uchr	kstr[256];		/* Фʸ			*/
} LENT;

/*
 * 硦ꥹȥȥ꡼
 */
typedef	struct _ilent {
    unt		entid;			/* ֹ			*/
    unt		nent;			/* ƱñĿ???		*/
    long	dpos;			/* ʸǡ		*/
    uchr	idkey[24];		/* ñʸ(17ʸ)	*/
} ILENT;

int	stype = EN_SRCH;		/* (ñ//)	*/
int	mtype = X_MATCH;		/* ޥå(///)	*/
uchr	*idxfile = NULL;		/* ѥǥåե	*/
uchr	*lstfile = NULL;		/* ѥꥹȥե		*/

INODE	inode;				/* 			*/
LENT	lent;				/* 			*/
ILENT	ilent;				/* 			*/

long	val();
uchr	*fmtkstr();
void	getlistkey();
int	getfirstent();
void	getlistent();
int	index_search();
void	getilistent();
int	idiom_search();
uchr	*mgetent();
int	match();
int	wild_search();
uchr	*getword();
int	search();

/*
 * val - ʸ4ХͤlongѴ
 */
long
val(str)
register uchr	*str;
{
    return ((long)str[3] << 24) +
	   ((long)str[2] << 16) +
	   ((long)str[1] << 8) +
	   (long)str[0];
}

/*
 * fmtkstr - ФʸΡ@פԤѴ
 */
uchr *
fmtkstr(kstr)
uchr	*kstr;
{
    int		in;
    uchr	*p, *q;
    static uchr	knew[256];

    in = FALSE;
    p = kstr;
    q = knew;
    while (*p) {
	if (*p == '<') {
	    if (!strncmp(p, "<G99>", 5))
		in = TRUE;
	    else if (!strncmp(p, "</G99>", 6))
		in = FALSE;
	    while (*p != '>')
		*q++ = *p++;
	    *q++ = *p++;
	    continue;
	}
	if (!in && *p == '@') {
	    while (*p == '@')
		p++;
	    *q++ = '\n';
	    continue;
	}
	*q++ = *p++;
    }
    if (q > knew && q[-1] == '\n')
	q--;
    *q = '\0';
    return knew;
}

/*
 * getlistkey - ꥹȥե뤫鸫ФʸФ
 */
void
getlistkey(lfp, buf, mtype)
BFILE	*lfp;
uchr	*buf;
int	mtype;
{
    int		len;
    uchr	*p;

    bgetc(lfp);
    bgetc(lfp);
    if (mtype == R_MATCH) {
	len = bgetc(lfp);
	while (len-- > 0)
	    bgetc(lfp);
	bgetc(lfp);
	bgetc(lfp);
    }
    len = bgetc(lfp);
    p = buf;
    while (len-- > 0)
	*p++ = bgetc(lfp);
    *p = '\0';
}

/*
 * getfirstent - ˥ޥåǽΥȥ꡼õ
 */
int
getfirstent(ifp, lfp, word, ip, np)
BFILE	*ifp, *lfp;
uchr	*word;
INODE	*ip;
int	*np;
{
    int		i, n, last, len, cmp;
    long	ipos, lpos, nodeno;
    uchr	key[128];
#ifdef DEBUG
    int		first, level;
#endif

    ipos = INODETOP;
#ifdef DEBUG
    level = 0;
#endif
    /*
     * ȥåסʤν
     */
    for (;;) {
	if (bseek(ifp, ipos) == ERR ||
	    bread(ifp, (uchr *)ip, sizeof(INODE)) < sizeof(INODE)) {
	    outstr("PANIC: ǥåե礬ޤ\n");
	    return ERR;
	}
	if (val(ip->ent[0].next) == 0L) {
	    /*
	     * ǽʢ̤ˡǽ
	     */
	    break;
	}
#ifdef DEBUG
	if (debug) {
	    printf("<level %d>\n", ++level);
	    printf("pageno=%08lx, last=%08lx\n",
		val(ip->pageno), val(ip->last));
	    for (i = 0; i <= (int)val(ip->last); i++) {
		lpos = val(ip->ent[i].lstpos);
		printf("e[%d].lstpos=%08lx, e[%d].next=%08lx",
		    i, lpos, i, val(ip->ent[i].next));
		if (lpos > 0L) {
		    bseek(lfp, lpos);
		    getlistkey(lfp, key, mtype);
		    printf(", key=[%s]", key);
		}
		printf("\n");
	    }
	}
#endif
	last = (int)val(ip->last);
	for (i = 0; i < last; i++) {
	    lpos = val(ip->ent[i+1].lstpos);
	    if (bseek(lfp, lpos) == ERR) {
		outstr("PANIC: ꥹȥե礬ޤ\n");
		return ERR;
	    }
	    getlistkey(lfp, key, mtype);
#ifdef DEBUG
	    if (debug)
		printf("i=%d, word=[%s], key=[%s]\n", i, word, key);
#endif
	    if (strcmp(word, key) <= 0)
		break;
	}
	nodeno = val(ip->ent[i].next);
	ipos = (nodeno - 1L) * sizeof(INODE) + INODETOP;
#ifdef DEBUG
	if (debug)
	    printf("nodeno=%08lx, ipos=%08lx\n", nodeno, ipos);
#endif
    }
    /*
     * ǽʤν
     */
    len = strlen(word);
    last = (int)val(ip->last);
    n = 0;
#ifdef DEBUG
    first = TRUE;
#endif
    for (;;) {
	if (n > last) {
	    if (bread(ifp, (uchr *)ip, sizeof(INODE)) < sizeof(INODE) ||
		val(ip->pageno) == 0L) {
		/*
		 * ǥåνüã
		 */
		return ERR;
	    }
	    last = (int)val(ip->last);
	    n = 0;
	}
#ifdef DEBUG
	if (debug && n == 0) {
	    if (first) {
		printf("<last level>\n");
		first = FALSE;
	    } else {
		printf("<next node>\n");
	    }
	    printf("pageno=%08lx, last=%08lx\n",
		val(ip->pageno), val(ip->last));
	    for (i = 0; i <= (int)val(ip->last); i++) {
		lpos = val(ip->ent[i].lstpos);
		bseek(lfp, lpos);
		getlistkey(lfp, key, mtype);
		printf("e[%d].lstpos=%08lx, key=[%s]\n", i, lpos, key);
	    }
	}
#endif
	lpos = val(ip->ent[n].lstpos);
	if (bseek(lfp, lpos) == ERR) {
	    outstr("PANIC: ꥹȥե礬ޤ\n");
	    return ERR;
	}
	getlistkey(lfp, key, mtype);
	cmp = strncmp(word, key, len);
	if (cmp < 0)
	    return ERR;
	if (cmp == 0) {
	    if (mtype == X_MATCH && strcmp(word, key) != 0)
		return ERR;
	    *np = n;
	    return OK;
	}
	n++;
    }
    /* NOTREACHED */
}

/*
 * getlistent - ꥹȥե뤫鸫ФǡФ
 */
void
getlistent(lfp, lp)
BFILE	*lfp;
LENT	*lp;
{
    int		i, len;
    uchr	*p;

    bgetc(lfp);
    bgetc(lfp);
    len = bgetc(lfp);
    p = lp->fkey;
    while (len-- > 0)
	*p++ = bgetc(lfp);
    *p = '\0';
    bgetc(lfp);
    bgetc(lfp);
    len = bgetc(lfp);
    p = lp->rkey;
    while (len-- > 0)
	*p++ = bgetc(lfp);
    *p = '\0';
    bgetc(lfp);
    bgetc(lfp);
    lp->dpos = 0L;
    for (i = 0; i < 32; i += 8)
	lp->dpos |= ((long)bgetc(lfp) << i);
    bgetc(lfp);
    bgetc(lfp);
    lp->dlen = 0L;
    for (i = 0; i < 32; i += 8)
	lp->dlen |= ((long)bgetc(lfp) << i);
    for (i = 0; i < 8; i++)
	bgetc(lfp);
    len = bgetc(lfp);
    p = lp->kstr;
    while (len-- > 0)
	*p++ = bgetc(lfp);
    *p = '\0';
}

/*
 * index_search - //פǥǥåԤ
 */
int
index_search(dicdir, showall, word)
uchr	*dicdir, *word;
int	showall;
{
    int		n, last, len, cmp, ret;
    long	lpos;
    uchr	*keyp;
    BFILE	*ifp, *lfp, *bfp;
#ifdef DEBUG
    int		i;
    uchr	key[128];
#endif

    ret = OK;
    ifp = lfp = bfp = NULL;
    if ((ifp = dic_open(dicdir, idxfile)) == NULL ||
	(lfp = dic_open(dicdir, lstfile)) == NULL)
	goto err;
    if (getfirstent(ifp, lfp, word, &inode, &n) == ERR)
	goto err;
    keyp = (mtype == R_MATCH)? lent.rkey: lent.fkey;
    len = strlen(word);
    last = (int)val(inode.last);
    for (;;) {
	if (n > last) {
	    if (bread(ifp, (uchr *)&inode, sizeof(INODE)) < sizeof(INODE) ||
		val(inode.pageno) == 0L) {
		/*
		 * ǥåνüã
		 */
		break;
	    }
	    last = (int)val(inode.last);
	    n = 0;
	}
#ifdef DEBUG
	if (debug && n == 0) {
	    printf("<next node>\n");
	    printf("pageno=%08lx, last=%08lx\n",
		val(inode.pageno), val(inode.last));
	    for (i = 0; i <= (int)val(inode.last); i++) {
		lpos = val(inode.ent[i].lstpos);
		bseek(lfp, lpos);
		getlistkey(lfp, key, mtype);
		printf("e[%d].lstpos=%08lx, key=[%s]\n", i, lpos, key);
	    }
	}
#endif
	lpos = val(inode.ent[n].lstpos);
	if (bseek(lfp, lpos) == ERR) {
	    outstr("PANIC: ꥹȥե礬ޤ\n");
	    goto err;
	}
	getlistent(lfp, &lent);
	cmp = strncmp(word, keyp, len);
	if (cmp < 0)
	    break;
	if (cmp > 0) {
	    n++;
	    continue;
	}
	if (showall || mtype == X_MATCH) {
	    if (mtype == X_MATCH && strcmp(word, keyp) != 0)
		break;
	    if (bfp == NULL) {
		if ((bfp = dic_open(dicdir, MAIN_DAT)) == NULL)
		    goto err;
	    } else {
		outstr("\n");
	    }
#ifdef DEBUG
	    if (debug)
		printf("show_dat: key=[%s], dpos=%lx, dlen=%lx\n",
		    lent.fkey, lent.dpos, lent.dlen);
#endif
	    if (show_data(bfp, lent.dpos, lent.dlen) == ERR)
		goto err;
	} else {
	    outstr(fmtkstr(lent.kstr));
	    if (stype == TR_SRCH) {
		outstr(" [");
		outstr(lent.fkey);
		outstr("]");
	    }
	    outstr("\n");
	}
	n++;
    }
    goto done;
err:
    ret = ERR;
done:
    if (ifp != NULL)
	bclose(ifp);
    if (lfp != NULL)
	bclose(lfp);
    if (bfp != NULL)
	bclose(bfp);
    return ret;
}

/*
 * getilistent - 硦ꥹȥե뤫鹽ñǡФ
 */
void
getilistent(lfp, ip)
BFILE	*lfp;
ILENT	*ip;
{
    int		i, len;
    uchr	*p;

    ip->entid = bgetc(lfp);
    ip->entid += (bgetc(lfp) << 8);
    len = bgetc(lfp);
    p = ip->idkey;
    while (len-- > 0)
	*p++ = bgetc(lfp);
    *p = '\0';
    bgetc(lfp);
    bgetc(lfp);
    ip->dpos = 0L;
    for (i = 0; i < 32; i += 8)
	ip->dpos |= ((long)bgetc(lfp) << i);
    bgetc(lfp);
    bgetc(lfp);
    ip->nent = bgetc(lfp);
    ip->nent += (bgetc(lfp) << 8);
    for (i = 0; i < 4; i++)
	bgetc(lfp);
}

/*
 * idiom_search - 硦㸡Ԥ
 */
int
idiom_search(dicdir, ac, av)
uchr	*dicdir;
int	ac;
uchr	**av;
{
    int		i, n, last, cmp, ret, nomore;
    long	lpos, odpos;
    long	l0, l1, num0, num1, num2, n0, n1;
    uchr	*word;
    BFILE	*ifp, *lfp, *bfp;
#ifdef DEBUG
    uchr	key[128];
#endif

    /*
     * 
     */
    for (i = 0; i < ac; i++) {
	/*
	 * ʸ狼ɤ
	 * ˥åƤ
	 */
	if (getword(tosjis(av[i])) == NULL)
	    return ERR;
    }
    ret = OK;
    ifp = lfp = bfp = NULL;
    if ((ifp = dic_open(dicdir, idxfile)) == NULL ||
	(lfp = dic_open(dicdir, lstfile)) == NULL ||
	(bfp = dic_open(dicdir, MAIN_DAT)) == NULL)
	goto err;
    if (setuptmp() == ERR) {
	outstr("ERR: ꡼­ޤ\n");
	goto err;
    }
    /*
     * ǽñ򸡺
     * ̤Ϻȥå0˽񤭽Ф
     * Ǹñʤ餽Τޤɽƽ
     */
    word = getword(tosjis(*av));
    if (getfirstent(ifp, lfp, word, &inode, &n) == ERR)
	goto err;
#ifdef DEBUG
    if (debug2)
	printf("search1 start: word=%s\n", word);
#endif
    nomore = (ac == 1);
    num0 = 0L;
    odpos = 0L;
    last = (int)val(inode.last);
    for (;;) {
	if (n > last) {
	    if (bread(ifp, (uchr *)&inode, sizeof(INODE)) < sizeof(INODE) ||
		val(inode.pageno) == 0L)
		break;
	    last = (int)val(inode.last);
	    n = 0;
	}
#ifdef DEBUG
	if (debug && n == 0) {
	    printf("<next node>\n");
	    printf("pageno=%08lx, last=%08lx\n",
		val(inode.pageno), val(inode.last));
	    for (i = 0; i <= (int)val(inode.last); i++) {
		lpos = val(inode.ent[i].lstpos);
		bseek(lfp, lpos);
		getlistkey(lfp, key, X_MATCH);
		printf("e[%d].lstpos=%08lx, key=[%s]\n", i, lpos, key);
	    }
	}
#endif
	lpos = val(inode.ent[n].lstpos);
	if (bseek(lfp, lpos) == ERR) {
	    outstr("PANIC: ꥹȥե礬ޤ\n");
	    goto err;
	}
	getilistent(lfp, &ilent);
	cmp = strcmp(word, ilent.idkey);
	if (cmp < 0)
	    break;
	if (cmp > 0) {
	    n++;
	    continue;
	}
#ifdef DEBUG
	if (debug)
	    printf("idkey=[%s], entid=%04x, nent=%04x, dpos=%08lx\n",
		ilent.idkey, ilent.entid, ilent.nent, ilent.dpos);
#endif
	if (ilent.dpos == odpos) {
	    n++;
	    continue;
	}
	odpos = ilent.dpos;
	if (nomore) {
	    /*
	     * ʸ1Ĥä
	     */
#ifdef DEBUG
	    if (debug2) {
		printf("dpos=%08lx\n", ilent.dpos);
		num0++;
		n++;
		continue;
	    }
#endif
	    if (show_idiom(bfp, ilent.dpos) == ERR)
		goto err;
	    num0++;
	    n++;
	    continue;
	}
	/*
	 * ̤Ͽ
	 */
	if (!tisopen(0) && twopen(0) == ERR ||
	    twrite(0, ilent.dpos) == ERR)
	    goto err;
	num0++;
	n++;
    }
#ifdef DEBUG
    if (debug2)
	printf("num0=%ld\n", num0);
#endif
    if (tisopen(0) && twclose(0) == ERR)
	goto err;
    if (nomore || num0 == 0L) {
	/*
	 * Ǹñ줫̤0ä
	 */
	goto done;
    }
    ac--, av++;
    /*
     * Ĥñ򸡺
     * ̤Ϻȥå1˽񤭽Ф
     * ȥå0Ⱥȥå1ͤ碌
     * ξ¸ߤΤȥå2˽񤭽Ф
     * 뤤ϺǸñʤ̤ɽ
     */
    while (ac > 0) {
	word = getword(tosjis(*av));
	if (getfirstent(ifp, lfp, word, &inode, &n) == ERR)
	    goto err;
#ifdef DEBUG
	if (debug2)
	    printf("search2 start: word=%s\n", word);
#endif
	nomore = (ac == 1);
	num1 = 0L;
	odpos = 0L;
	last = (int)val(inode.last);
	for (;;) {
	    if (n > last) {
		if (bread(ifp, (uchr *)&inode, sizeof(INODE)) < sizeof(INODE) ||
		    val(inode.pageno) == 0L)
		    break;
		last = (int)val(inode.last);
		n = 0;
	    }
#ifdef DEBUG
	    if (debug && n == 0) {
		printf("<next node>\n");
		printf("pageno=%08lx, last=%08lx\n",
		    val(inode.pageno), val(inode.last));
		for (i = 0; i <= (int)val(inode.last); i++) {
		    lpos = val(inode.ent[i].lstpos);
		    bseek(lfp, lpos);
		    getlistkey(lfp, key, X_MATCH);
		    printf("e[%d].lstpos=%08lx, key=[%s]\n", i, lpos, key);
		}
	    }
#endif
	    lpos = val(inode.ent[n].lstpos);
	    if (bseek(lfp, lpos) == ERR) {
		outstr("PANIC: ꥹȥե礬ޤ\n");
		goto err;
	    }
	    getilistent(lfp, &ilent);
	    cmp = strcmp(word, ilent.idkey);
	    if (cmp < 0)
		break;
	    if (cmp > 0) {
		n++;
		continue;
	    }
#ifdef DEBUG
	    if (debug)
		printf("idkey=[%s], entid=%04x, nent=%04x, dpos=%08lx\n",
		    ilent.idkey, ilent.entid, ilent.nent, ilent.dpos);
#endif
	    if (ilent.dpos == odpos) {
		n++;
		continue;
	    }
	    odpos = ilent.dpos;
	    /*
	     * ̤Ͽ
	     */
	    if (!tisopen(1) && twopen(1) == ERR ||
	        twrite(1, ilent.dpos) == ERR)
		goto err;
	    num1++;
	    n++;
	}
#ifdef DEBUG
	if (debug2)
	    printf("num1=%ld\n", num1);
#endif
	if (tisopen(1) && twclose(1) == ERR)
	    goto err;
	if (num1 == 0L) {
	    /*
	     * ̤0ä
	     */
	    goto done;
	}
	/*
	 * ȥå0Ⱥȥå1ͤ碌
	 * ξ¸ߤΤȥå2˽񤭽Ф
	 * η̤򿷤ʺȥå0Ȥ
	 */
	if (tropen(0) == ERR || tropen(1) == ERR)
	    goto err;
#ifdef DEBUG
	if (debug2) {
	    printf("compare start\n");
	}
#endif
	n0 = n1 = num2 = 0L;
	l0 = tread(0);
	l1 = tread(1);
	for (;;) {
	    if (l0 < l1) {
		if (++n0 >= num0)
		    break;
		l0 = tread(0);
		continue;
	    }
	    if (l1 < l0) {
		if (++n1 >= num1)
		    break;
		l1 = tread(1);
		continue;
	    }
	    if (nomore) {
#ifdef DEBUG
		if (debug2) {
		    printf("dpos=%08lx\n", l0);
		    goto next;
		}
#endif
		if (show_idiom(bfp, l0) == ERR)
		    goto err;
		goto next;
	    }
	    /*
	     * ̤Ͽ
	     */
	    if (!tisopen(2) && twopen(2) == ERR ||
		twrite(2, l0) == ERR)
		goto err;
	next:
	    if (++n0 >= num0)
		break;
	    l0 = tread(0);
	    if (++n1 >= num1)
		break;
	    l1 = tread(1);
	    num2++;
	}
#ifdef DEBUG
	if (debug2)
	    printf("num2=%ld\n", num2);
#endif
	trclose(0);
	trclose(1);
	if (tisopen(2) && twclose(2) == ERR)
	    goto err;
	if (num2 == 0L) {
	    /*
	     * ̤0ä
	     */
	    goto done;
	}
	tswap(0, 2);
	ac--, av++;
    }
    goto done;
err:
    ret = ERR;
done:
    tfree(0);
    tfree(1);
    tfree(2);
    if (ifp != NULL)
	bclose(ifp);
    if (lfp != NULL)
	bclose(lfp);
    if (bfp != NULL)
	bclose(bfp);
#ifdef DEBUG
    if (debug2)
	return ret;
#endif
    cleantmp();
    return ret;
}

/*
 * mgetent - ְץꥹȤ1ɤ߹
 */
uchr *
mgetent(bfp, buf)
BFILE	*bfp;
uchr	*buf;
{
    int		c;
    uchr	*p;

    if ((c = bgetc(bfp)) == EOF)
	return NULL;
    p = buf;
    do {
	*p++ = c;
    } while ((c = bgetc(bfp)) != '\r');
    *p = '\0';
    return buf;
}

/*
 * match - ʸȥѥξȹԤ
 */
int
match(str, pat)
uchr	*str, *pat;
{
    unt		c;
    uchr	*s, *p;

#ifdef DEBUG
    if (debug2) {
	printf("str=\"%s\", pat=\"%s\"\n", str, pat);
    }
#endif
    if (stype == EN_SRCH) {
	/*
	 * 1Хʸξȹ
	 */
	while (*str) {
	    switch (*pat) {
	    case '?':
		/* 
		 * Ǥդʸȥޥå
		 */
		break;
	    case '*':
		/*
		 * strλĤ1ʸĸ餷ʤ
		 * patλĤȥޥå뤫ɤĴ٤
		 */
		s = str;
		do {
		    if (match(s, pat + 1))
			return TRUE;
		} while (*s++);
		break;
	    case '[':
		for (p = pat + 1; *p != ']'; p++) {
		    if (*str == *p)
			break;
		    if (p[1] == '-') {
			if (*str >= *p && *str <= p[2])
			    break;
			p += 2;
		    }
		}
		if (*p == ']') {
		    /*
		     * ޥåʤä
		     */
		    return FALSE;
		}
		while (*p != ']')
		    p++;
		pat = p;
		break;
	    case '\0':
		/* 
		 * ѥ˿Ԥ
		 */
		return FALSE;
	    default:
		if (*str != *pat) {
		    /*
		     * ޥåʤä
		     */
		    return FALSE;
		}
		break;
	    }
	    str++;
	    pat++;
	}
	if (*pat == '\0') {
	    /*
	     * ե̾ȥѥƱ˿Ԥ
	     */
	    return TRUE;
	}
	return FALSE;
    }
    /*
     * 2Хʸξȹ
     */
    while (*str) {
	switch (*pat) {
	case '?':
	    /* 
	     * Ǥդʸȥޥå
	     */
	    str += 2;
	    pat++;
	    break;
	case '*':
	    /*
	     * strλĤ1ʸĸ餷ʤ
	     * patλĤȥޥå뤫ɤĴ٤
	     */
	    s = str;
	    for (;;) {
		if (match(s, pat + 1))
		    return TRUE;
		if (*s == '\0')
		    break;
		s += 2;
	    }
	    str += 2;
	    pat++;
	    break;
	case '[':
	    p = pat + 1;
	    while (*p != ']') {
		if (*str == *p && str[1] == p[1])
		    break;
		if (p[2] == '-') {
		    c = (*str << 8 | str[1]);
		    if (c >= (p[0] << 8 | p[1]) &&
			c <= (p[3] << 8 | p[4]))
			break;
		    p += 3;
		}
		p += 2;
	    }
	    if (*p == ']') {
		/*
		 * ޥåʤä
		 */
		return FALSE;
	    }
	    while (*p != ']') {
		if (*p == '-') {
		    p++;
		    continue;
		}
		p += 2;
	    }
	    str += 2;
	    pat = p + 1;
	    break;
	case '\0':
	    /* 
	     * ѥ˿Ԥ
	     */
	    return FALSE;
	default:
	    if (*str != *pat || str[1] != pat[1]) {
		/*
		 * ޥåʤä
		 */
		return FALSE;
	    }
	    str += 2;
	    pat += 2;
	    break;
	}
    }
    if (*pat == '\0') {
	/*
	 * ե̾ȥѥƱ˿Ԥ
	 */
	return TRUE;
    }
    return FALSE;
}

/*
 * wild_search - 磻ɥɸԤ
 */
int
wild_search(dicdir, showall, pat)
uchr	*dicdir, *pat;
int	showall;
{
    int		ret, first;
    long	dpos, dlen, odpos;
    uchr	*p;
    BFILE	*lfp, *bfp;
    uchr	buf[256];

    ret = OK;
    lfp = bfp = NULL;
    if ((lfp = dic_open(dicdir, lstfile)) == NULL ||
	(bfp = dic_open(dicdir, MAIN_DAT)) == NULL)
	goto err;
    bseek(lfp, 0L);
    first = TRUE;
    odpos = 0L;
    while (mgetent(lfp, buf) != NULL) {
	p = buf;
	while (*p && *p != '0')
	    p++;
	*p = '\0';
	if (!match(buf, pat))
	    continue;
	sscanf(p+1, "%7lx%lx", &dpos, &dlen);
#ifdef DEBUG
	if (debug)
	    printf("show_dat: key=[%s], dpos=%lx, dlen=%lx\n",
		buf, dpos, dlen);
#endif
	if (showall) {
	    if (first)
		first = FALSE;
	    else
		outstr("\n");
	    if (dpos == odpos)
		continue;
	    if (show_data(bfp, dpos, dlen) == ERR)
		goto err;
	} else {
	    if (show_header(bfp, dpos) == ERR)
		goto err;
	    if (stype == EN_SRCH)
		lower(buf);
	    outstr(" [");
	    outstr(buf);
	    outstr("]\n");
	}
    }
    goto done;
err:
    ret = ERR;
done:
    if (lfp != NULL)
	bclose(lfp);
    if (bfp != NULL)
	bclose(bfp);
    return ret;
}

/*
 * getword - ʸäƸñ줽¾Ԥ
 */
uchr *
getword(str)
uchr	*str;
{
    int		n, len, err;
    int		eng, knj, any, meta, bra;
    uchr	*s, *p, *q, ch;
    static uchr	buf[128];

    len = strlen(str);
    eng = knj = any = meta = 0;
    err = 0;
    bra = FALSE;
    s = str;
    while (*s) {
	if (strchr("*?[]-", *s)) {
	    if (*s == '*' && (bra || s[1] == '*') ||
		*s == '?' && bra ||
		*s == '[' && (bra || s[1] == '-' || s[1] == ']') ||
		*s == '-' && (!bra || s[1] == ']') ||
		*s == ']' && !bra) {
		err++;
		break;
	    }
	    if (*s == '[')
		bra = TRUE;
	    else if (*s == ']')
		bra = FALSE;
	    else if (*s == '?')
		any++;
	    s++;
	    meta++;
	    continue;
	}
	if (SJIS1(*s)) {
	    s += 2;
	    knj++;
	    continue;
	}
	s++;
	eng++;
    }
    if (err || bra) {
	outstr("ERR: 磻ɥɸ˸꤬ޤ\n");
	return NULL;
    }
    if (knj > 0 && eng > 0) {
	outstr("ERR: ñ˱Ѹܸ줬ߤƤޤ\n");
	return NULL;
    }
    if (knj == 0 && eng == 0 && any == 0) {
	outstr("ERR: ñ줬Ǥ\n");
	return NULL;
    }
    if (stype == ID_SRCH) {
	if (knj) {
	    outstr("ERR: 硦㸡ܸ줬ꤵƤޤ\n");
	    return NULL;
	}
	if (mtype != X_MATCH) {
	    outstr("ERR: 硦㸡Դ׸ꤵƤޤ\n");
	    return NULL;
	}
    }
    if (meta == 0)
	mtype = X_MATCH;
    else if (meta == 1 && str[len-1] == '*')
	mtype = F_MATCH;
    else if (meta == 1 && *str == '*')
	mtype = R_MATCH;
    else
	mtype = W_MATCH;
    if (knj)
	stype = TR_SRCH;
    s = str;
    p = buf;
    if (mtype == F_MATCH || mtype == R_MATCH) {
	len--;
	if (mtype == R_MATCH)
	    s++;
    }
    n = len;
    while (n > 0) {
	if (SJIS1(*s)) {
	    *p++ = *s++;
	    *p++ = *s++;
	    n -= 2;
	    continue;
	}
	if (islower(*s)) {
	    *p++ = toupper(*s);
	    s++;
	} else {
	    *p++ = *s++;
	}
	n--;
    }
    *p = '\0';
    if (mtype == R_MATCH) {
	/*
	 * ʸսˤ
	 */
	p = buf;
	while (*p) {
	    if (SJIS1(*p)) {
		ch = *p;
		*p = p[1];
		p[1] = ch;
		p++;
	    }
	    p++;
	}
	p = buf;
	q = buf + len - 1;
	while (p < q) {
	    ch = *p;
	    *p++ = *q;
	    *q-- = ch;
	}
    }
    return buf;
}

/*
 * search - Υᥤ롼
 */
int
search(dicdir, showall, ac, av)
uchr	*dicdir;
int	showall;
int	ac;
uchr	**av;
{
    int		ret;
    uchr	*word;

    if ((word = getword(tosjis(*av))) == NULL)
	return ERR;
    switch (stype) {
    case EN_SRCH:
	switch (mtype) {
	case X_MATCH:
	case F_MATCH:
	    idxfile = EN_F_IDX;
	    lstfile = EN_LIST;
	    ret = index_search(dicdir, showall, word);
	    break;
	case R_MATCH:
	    idxfile = EN_R_IDX;
	    lstfile = EN_LIST;
	    ret = index_search(dicdir, showall, word);
	    break;
	case W_MATCH:
	    lstfile = EN_M_LIST;
	    ret = wild_search(dicdir, showall, word);
	    break;
	}
	break;
    case TR_SRCH:
	switch (mtype) {
	case X_MATCH:
	case F_MATCH:
	    idxfile = TR_F_IDX;
	    lstfile = TR_LIST;
	    ret = index_search(dicdir, showall, word);
	    break;
	case R_MATCH:
	    idxfile = TR_R_IDX;
	    lstfile = TR_LIST;
	    ret = index_search(dicdir, showall, word);
	    break;
	case W_MATCH:
	    lstfile = TR_M_LIST;
	    ret = wild_search(dicdir, showall, word);
	    break;
	}
	break;
    case ID_SRCH:
	idxfile = ID_IDX;
	lstfile = ID_LIST;
	ret = idiom_search(dicdir, ac, av);
	break;
    }
    return ret;
}

/* -------------------- ᥤ -------------------- */

#define	CSRD_ENV	"CSRD"		/* ץꤹĶѿ	*/

#define	MINWIDTH	20		/* Ϲβ		*/

int	showall = FALSE;		/* ԴפǤɽ뤫?*/
int	showver = FALSE;		/* ǡСɽ	*/
uchr	*dicdir = NULL;			/* ǥ쥯ȥ꡼		*/
uchr	*fmtfile = NULL;		/* ɽ񼰥ե		*/
uchr	*gaifile = NULL;		/* ɽե		*/
uchr	*supstr = NULL;			/* ɽ			*/

void	usage();
int	parse_opt();
#if defined(UNIX) && defined(RC_PATH)
int	init_rcfile();
#endif
int	init_env();
void	onintr();
int	main();

/*
 * usage - ˡɽƽλ
 */
void
usage()
{
    outstr("شۥϥѸ켭ŵ桼ƥƥ Ver.");
    outstr(version);
    outstr(" (");
    outstr(date);
    outstr(")\n    Written by Junn Ohta (ohta@src.ricoh.co.jp),");
    outstr(" Public Domain.\n\nˡ: ");
    outstr(progname);
    outstr(" [-d\\<DIR\\>] [-f\\<񼰥ե\\>] [-g\\<ե\\>]\n");
    outstr("             [-w\\<\\>] [-s\\<ɽ\\>] [-b[x]] [-a] [-v]");
#ifdef UNIX
    outstr("\n             [-c\\<\\>]");
#endif
    outstr(" \\<\\>\n\n");
    outstr("ץ: (Ķѿ");
    outstr(CSRD_ENV);
    outstr("ǻꤹ뤳ȤǤޤ)\n");
    outstr("    -d: ǥ쥯ȥ꡼\n");
    outstr("    -f: ɽ񼰥ե\n");
    outstr("    -g: ɽե\n");
    outstr("    -w: Ϲ (-w0:Ԥʤ(ɸ))\n");
    outstr("    -s: ܤɽˤ\n");
    outstr("        (-st:̣, -se:, -si:, -so:, -sa:٤)\n");
    outstr("    -b: ȯ (-bx:[])\n");
    outstr("    -a: ԴפǤƤɽ\n");
    outstr("    -v: ǡΥСɽ\n");
#ifdef UNIX
    outstr("    -c: ܸ쥳 (-cj:JIS, -ce:EUC(ɸ), -cs:եJIS)\n");
#endif
    outstr("\n: (硦㸡ʳǤ줫⸡Ǥޤ)\n");
    outstr("    ׸: \\<ʸ\\>     磻ɥɸ: *?[]-ޤʸ\n");
    outstr("    ׸: \\<ʸ\\>*    硦㸡: -i \\<ʸ\\> ...\n");
    outstr("    ׸: *\\<ʸ\\>\n");
    exit(1);
}

/*
 * parse_opt - Ķѿޤϥޥɹ԰ǻꤵ줿ץ
 *	       ϤɬפԤ
 */
int
parse_opt(acp, avp)
int	*acp;
uchr	***avp;
{
    int		n, ac;
    uchr	*s, **av;

    ac = *acp;
    av = *avp;
    while (ac > 0 && **av == '-') {
	s = *av + 1;
	switch (*s++) {
	case 'D':
	case 'd':
	    if (!*s) {
		ac--, av++;
		if (ac == 0 || **av == '-')
		    return ERR;
		s = *av;
	    }
	    dicdir = strpool(s);
	    bsltosl(dicdir);
	    n = strlen(dicdir);
	    if (dicdir[n-1] == '/')
		dicdir[n-1] = '\0';
	    break;
	case 'F':
	case 'f':
	    if (!*s) {
		ac--, av++;
		if (ac == 0 || **av == '-')
		    return ERR;
		s = *av;
	    }
	    fmtfile = strpool(s);
	    bsltosl(fmtfile);
	    break;
	case 'G':
	case 'g':
	    if (!*s) {
		ac--, av++;
		if (ac == 0 || **av == '-')
		    return ERR;
		s = *av;
	    }
	    gaifile = strpool(s);
	    bsltosl(gaifile);
	    break;
	case 'A':
	case 'a':
	    showall = TRUE;
	    break;
	case 'W':
	case 'w':
	    if (!*s) {
		ac--, av++;
		if (ac == 0 || **av == '-')
		    return ERR;
		s = *av;
	    }
	    if (!isdigit(*s))
		return ERR;
	    width = atoi(s);
	    if (width != 0 && width < MINWIDTH)
		width = MINWIDTH;
	    break;
	case 'B':
	case 'b':
	    do_braille = TRUE;
	    if (*s == 'x' || *s == 'X')
		nobracket = TRUE;
	    else
		nobracket = FALSE;
	    break;
#ifdef UNIX
	case 'C':
	case 'c':
	    if (!*s) {
		ac--, av++;
		if (ac == 0 || **av == '-')
		    return ERR;
		s = *av;
	    }
	    switch (*s) {
	    case 'J':
	    case 'j':
		kcode = KC_JIS;
		if (s[1] && s[2]) {
		    jiskanji = s[1];
		    jisalpha = s[2];
		}
		break;
	    case 'E':
	    case 'e':
		kcode = KC_EUC;
		break;
	    case 'S':
	    case 's':
		kcode = KC_SJIS;
		break;
	    default:
		return ERR;
	    }
	    break;
#endif
	case 'S':
	case 's':
	    if (!*s) {
		ac--, av++;
		if (ac == 0 || **av == '-')
		    return ERR;
		s = *av;
	    }
	    supstr = strpool(s);
	    break;
	case 'I':
	case 'i':
	    stype = ID_SRCH;
	    break;
	case 'V':
	case 'v':
	    showver = TRUE;
	    break;
	case 'R':
	case 'r':
	    rawmode = TRUE;
	    break;
#ifdef DEBUG
	case 'Z':
	case 'z':
	    if (*s == 'z' || *s == 'Z')
		debug2 = TRUE;
	    else
		debug = TRUE;
	    break;
#endif
	default:
	    return ERR;
	}
	ac--, av++;
    }
    *acp = ac;
    *avp = av;
    return OK;
}

#if defined(UNIX) && defined(RC_PATH)
/*
 * init_rcfile - եǻꤵ줿ץ᤹
 *		 Contributed by   (Nokubi Takatsugu)
 */
int
init_rcfile()
{
    int		ec;
    uchr	*env, *s, **ev, **pp;
    FILE	*fp;
    struct stat	st;

    if (stat(RC_PATH, &st) < 0)
	return OK;
    if ((fp = fopen(RC_PATH, "r")) == NULL)
	return ERR;
    env = (uchr *)malloc(st.st_size + 1);
    if (env == NULL)
	return ERR;
    if (fread(env, st.st_size, 1, fp) < 1)
	return ERR;
    *(env + st.st_size - 1) = '\0';
    fclose(fp);
    ec = 1;
    for (s = env; *s; s++) {
	if (*s == ' ' || *s == '\t')
	    ec++;
    }
    ev = (uchr **)malloc(sizeof(uchr *) * (ec + 1));
    pp = ev;
    while ((s = strtok(env, " \t")) != NULL) {
	*pp++ = s;
	env = NULL;
    }
    *pp = NULL;
    pp = ev;
    if (parse_opt(&ec, &ev) != OK) {
	outstr("ERR: ե ");
	outstr(RC_PATH);
	outstr(" ˸꤬ޤ\n");
	return ERR;
    }
    free((char *)pp);
    free((char *)env);
    return OK;
}
#endif

/*
 * init_env - ĶѿCSRDǻꤵ줿ץ᤹
 */
int
init_env()
{
    int		ec;
    uchr	*env, *s, **ev, **pp;

    if ((env = getenv(CSRD_ENV)) == NULL)
	return OK;
    ec = 1;
    for (s = env; *s; s++) {
	if (*s == ' ' || *s == '\t')
	    ec++;
    }
    ev = (uchr **)malloc(sizeof(uchr *) * (ec + 1));
    pp = ev;
    while ((s = strtok(env, " \t")) != NULL) {
	*pp++ = s;
	env = NULL;
    }
    *pp = NULL;
    pp = ev;
    if (parse_opt(&ec, &ev) != OK) {
	outstr("ERR: Ķѿ ");
	outstr(CSRD_ENV);
	outstr(" ˸꤬ޤ\n");
	return ERR;
    }
    free((char *)pp);
    return OK;
}

/*
 * onintr - ߻νλ
 */
void
onintr()
{
    outchar(0);	/* JIS⡼ɤʤASCII᤹(UNIX) */
    cleantmp();	/* 硦㸡Ѥΰե */
    exit(0);
}

/*
 * main - ᥤ롼
 */
int
main(ac, av)
int	ac;
uchr	**av;
{
    signal(SIGINT, onintr);
#if defined(UNIX) && defined(RC_PATH)
    if (init_rcfile() != OK)
	exit(1);
#endif
    if (init_env() != OK)
	exit(1);
    ac--, av++;
    if (parse_opt(&ac, &av) != OK)
	usage();
    if (!showver && (ac == 0 || stype != ID_SRCH && ac > 1))
	usage();
    if (dicdir == NULL) {
	outstr("ERR: ǥ쥯ȥ꡼ꤵƤޤ\n");
	exit(1);
    }
    if (showver) {
	show_version(dicdir);
	exit(0);
    }
    if (init_alt() == ERR)
	exit(1);
    if (gaifile != NULL) {
	if (load_gaiji(gaifile) == ERR)
	    exit(1);
    }
    if (fmtfile != NULL) {
	if (load_format(fmtfile) == ERR)
	    exit(1);
    }
    if (suppress(supstr) == ERR) {
	outstr("ERR: ɽ(-sץ)˸꤬ޤ\n");
	exit(1);
    }
    if (search(dicdir, showall, ac, av) == ERR)
	exit(1);
    exit(0);
}
