#!/bin/sh
#
# $Id: patchin.sh,v 1.1.1.6 2003/09/30 11:25:51 ducrot Exp $
#

if [ "$1" = "" ]; then
  echo "Syntax: $0 KERNELDIR"
  exit 1
fi
cpufreq=$PWD

if [ ! -f $cpufreq/patchin.sh ]; then
  echo "Please run me in the cpufreq directory"
  exit 1
fi

ln -sf $cpufreq/linux/Documentation/cpufreq $1/Documentation/cpu-freq
ln -sf $cpufreq/linux/Documentation/cpufreq-old $1/Documentation/cpufreq-old
ln -sf $cpufreq/linux/include/linux/cpufreq.h $1/include/linux/
ln -sf $cpufreq/linux/drivers/cpufreq $1/drivers/cpufreq

ln -sf $cpufreq/linux/arch/i386/kernel/cpufreq/elanfreq.c $1/arch/i386/kernel
ln -sf $cpufreq/linux/arch/i386/kernel/cpufreq/gx-suspmod.c $1/arch/i386/kernel
ln -sf $cpufreq/linux/arch/i386/kernel/cpufreq/longhaul.c $1/arch/i386/kernel
ln -sf $cpufreq/linux/arch/i386/kernel/cpufreq/longhaul.h $1/arch/i386/kernel
ln -sf $cpufreq/linux/arch/i386/kernel/cpufreq/longrun.c $1/arch/i386/kernel
ln -sf $cpufreq/linux/arch/i386/kernel/cpufreq/p4-clockmod.c $1/arch/i386/kernel
ln -sf $cpufreq/linux/arch/i386/kernel/cpufreq/powernow-k6.c $1/arch/i386/kernel
ln -sf $cpufreq/linux/arch/i386/kernel/cpufreq/powernow-k7.c $1/arch/i386/kernel
ln -sf $cpufreq/linux/arch/i386/kernel/cpufreq/powernow-k7.h $1/arch/i386/kernel
ln -sf $cpufreq/linux/arch/i386/kernel/cpufreq/powernow-k8.c $1/arch/i386/kernel
ln -sf $cpufreq/linux/arch/i386/kernel/cpufreq/powernow-k8.h $1/arch/i386/kernel
ln -sf $cpufreq/linux/arch/i386/kernel/cpufreq/speedstep-centrino.c $1/arch/i386/kernel
ln -sf $cpufreq/linux/arch/i386/kernel/cpufreq/speedstep-smi.c $1/arch/i386/kernel
ln -sf $cpufreq/linux/arch/i386/kernel/cpufreq/speedstep-ich.c $1/arch/i386/kernel
ln -sf $cpufreq/linux/arch/i386/kernel/cpufreq/speedstep-lib.c $1/arch/i386/kernel
ln -sf $cpufreq/linux/arch/i386/kernel/cpufreq/speedstep-lib.h $1/arch/i386/kernel
ln -sf $cpufreq/linux/arch/i386/kernel/cpufreq/speedstep-piix4.c $1/arch/i386/kernel

cd $1
patch -p1 -i $cpufreq/patch
