

#include "boost/multi_array.hpp"

#define BOOST_INCLUDE_MAIN
#include "boost/test/test_tools.hpp"

#include <algorithm>
#include <list>


int
test_main(int, char*[])
{
  typedef boost::multi_array<double, 3> array;
  typedef array::size_type size_type;
  boost::array<size_type,3> sizes = { { 3, 3, 3 } };
  const size_type num_elements = 27;

  // Copy Constructor
  {
    array A(sizes);
    std::vector<double> vals(num_elements, 4.5);
    A.assign(vals.begin(),vals.end());
    array B(A);
    BOOST_TEST(A == B);
    BOOST_TEST(B == A);
    BOOST_TEST(A[0] == B[0]);
  }
  // Assignment Operator
  {
    array A(sizes), B(sizes);
    std::vector<double> vals(num_elements, 4.5);
    A.assign(vals.begin(),vals.end());
    B = A;
    BOOST_TEST(A == B);
    BOOST_TEST(B == A);
    BOOST_TEST(B[0] == A[0]);

    typedef array::index_range range;
    array::index_gen indices;
    array::array_view<2>::type C = A[indices[2][range()][range()]];
    array::array_view<2>::type D = B[indices[2][range()][range()]];
    BOOST_TEST(C == D);
  }
  // Different Arrays
  {
    array A(sizes), B(sizes);
    std::vector<double> valsA(num_elements, 4.5);
    std::vector<double> valsB(num_elements, 2.5);
    A.assign(valsA.begin(),valsA.end());
    B.assign(valsB.begin(),valsB.end());

    BOOST_TEST(A != B);
    BOOST_TEST(B != A);
    BOOST_TEST(A[0] != B[0]);

    typedef array::index_range range;
    array::index_gen indices;
    array::array_view<2>::type C = A[indices[2][range()][range()]];
    array::array_view<2>::type D = B[indices[2][range()][range()]];
    BOOST_TEST(C != D);
  }

  // Comparisons galore!
  {
    array A(sizes), B(sizes);

    double valsA[] = {
        0, 0, 0,
        0, 0, 0,
        0, 0, 0,

        1, 1, 1,
        1, 1, 1,
        1, 1, 1,

        2, 2, 2,
        2, 2, 2,
        2, 2, 2
    };

    double valsB[] = {
        0, 0, 0,
        0, 0, 0,
        0, 0, 0,

        1, 1, 1,
        1, 1, 1,
        1, 1, 1,

        2, 2, 2,
        2, 2, 2,
        2, 2, 1
    };

    A.assign(valsA,valsA+num_elements);
    B.assign(valsB,valsB+num_elements);

    BOOST_TEST(B < A);
    BOOST_TEST(A > B);

    BOOST_TEST(B <= A);
    BOOST_TEST(A >= B);

    BOOST_TEST(B[0] == A[0]);
    BOOST_TEST(B[2] < A[2]);

    array C = A;
    
    BOOST_TEST(C <= A);
    BOOST_TEST(C >= A);

    BOOST_TEST(!(C < A));
    BOOST_TEST(!(C > A));

    typedef array::index_range range;
    array::index_gen indices;
    array::array_view<2>::type D = A[indices[2][range()][range()]];
    array::array_view<2>::type E = B[indices[2][range()][range()]];

    BOOST_TEST(E < D);
    BOOST_TEST(E <= D);
  }



  return boost::exit_success;
}


