#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "globals.h"
#include "functions.h"

int parse_body(int iflag)
{
char token[TOKENSIZE];
char tmptoken[TOKENSIZE];
char newtoken[LINELENGTH];
int tokentype,c,ch;

  in_body++;

  while((tokentype=gettoken(token))!=0)
  {

#ifdef DEBUG
printf("%s\n",token);
#endif

    if (tokentype==5)
    { 
      if (iflag==1)
      { break; }

      putc('\n',out); 
    }
      else
    if (tokentype==6)
    {
      if (iflag==1)
      {
	tokentypepush=tokentype;
	strcpy(tokenpush,token);
	putc('\n',out);
        if (in_body==1)
	{ in_body--; return 0; }
          else
        { copyhtml(); }
      }
        else
      {
        fprintf(out,"?>");

        if (in_body==1)
	{ in_body--; return 0; }
          else
        { copyhtml(); }
      }
    }
      else
    if (strcasecmp(token,"case")==0)
    { strcpy(tokenpush,token); tokentypepush=tokentype; break; }
      else
    if ((strcasecmp(token,"loop")==0 || strcasecmp(token,"wend")==0) ||
        (strcasecmp(token,"next")==0))
    { break; }
      else
    if (strcasecmp(token,"end")==0)
    {
      c=gettoken(tmptoken);
      if (c!=5)
      {
        push(tmptoken,c);
        break;
      }

      autoindent();
      fprintf(out,"exit();\n");
    }
      else
    if (strcasecmp(token,"elseif")==0)
    { 
      indent--;
      autoindent();
      fprintf(out,"}\n");
      autoindent();
      fprintf(out,"  else\n");
      autoindent();
      fprintf(out,"if ");

      parse_condition();
      tokentype=gettoken(token);

      fprintf(out,"\n");
      autoindent();
      fprintf(out,"{\n");
      indent++;
    }
      else
    if (strcasecmp(token,"session")==0)
    { parse_session(); }
      else
    if (strcasecmp(token,"else")==0)
    { 
      indent--;
      autoindent();
      fprintf(out,"}\n");
      autoindent();
      fprintf(out,"  else\n");
      autoindent();
      fprintf(out,"{\n");
      indent++;
    }
      else
    if (tokentype==15)
    { fprintf(out,"%s",token); }
      else
    if (tokentype==0)
    { return 0; }
      else
    if (isfunction(token)==1)
    {
      strcpy(tmptoken,token);
      c=gettoken(token);
      if (strcmp(token,"=")==0)
      {
        autoindent();
	fprintf(out,"$function_ret=");
	eval_expression(" ");
      }
        else
      {
        autoindent();
	fprintf(out,"%s",tmptoken);
        push(token,c);
	convert_funct(newtoken,"1,2,3,4,5,6,7,8,9,10,11,12,13,14,15",4);
	fprintf(out,"%s;",newtoken);
      }
    }
      else
    if (tokentype==2 || strcmp("=",token)==0) 
    { 
      eval_token(tokentype,token); 
    }
      else
    if (tokentype==11)
    {
      /* This kinda sucks but.. if token is 11 at the beginning of the line
      lets assume that it's a comment line.. this might cause problems..
      if you have problems, comment this crap out */
      fprintf(out,"//%s",&token[1]);
      ch=0;
      while (ch!='\r' && ch!='\n')
      {
        if (pushback!=-1)
        { ch=pushback; pushback=-1; }
          else
        { ch=getc(in); }
        if (ch==EOF) break;

        if (ch=='%')
        {
          ch=getc(in);
          if (ch=='>')
          {
            putc('?',out);
            putc('>',out);
            /* copyhtml(); */
            return 0;
          }
            else
          { putc('%',out);}
        }

        putc(ch,out);
      }
      line++;
      pushback=getc(in);
      if (pushback=='\n' || pushback=='\r')
      { if (ch!=pushback) pushback=-1; }
    }
      else
    if (strcmp(token,"<")==0)
    {
      if (is_endscript()==1)
      {
        if (in_body==1)
        {
          in_body--;
          fprintf(out,"?>\n");
          return 0;
        }
          else
        { copyhtml(); }
      }
    }
   
    if (iflag==1) break;
  }

  in_body--;
 
  if (tokentype==5) { putc('\n',out); }
  if (strcasecmp(token,"end")==0) return 1;

  return 0;
}

int parse_command_set(char *newtoken,char *variable)
{
int tokentype;
char token[TOKENSIZE];

  tokentype=gettoken(token);
  strcpy(newtoken,"");

  if (tokentype==2)
  {
    autoindent();
    fprintf(out,"$%s_%s=",variable,token);

    tokentype=gettoken(token);

    if (strcmp(token,"=")!=0)
    { error(token,"=","Command Object"); }
    eval_expression(" ");
  }

  return 0;
}

int parse_command(char *newtoken,char *variable)
{
int tokentype;
char token[TOKENSIZE];
char temp[1024];

  sprintf(newtoken,"%s",variable);

  while(1)
  {
    tokentype=gettoken(token);

    if (tokentype!=2)
    { push(token,tokentype); break; }

    sprintf(temp,"_%s",token);

    tokentype=gettoken(token);

    if (strcmp(token,".")!=0)
    { push(token,tokentype); break; }
  }

  return 0;
}


int parse_set(char *newtoken)
{
int tokentype;
char token[TOKENSIZE];
char temptoken[TOKENSIZE];
char temp_spaces[100];
char molecule1[LINELENGTH];
int t;

  temp_spaces[0]=0;
  molecule1[0]=0;
  tokentype=gettoken(token);
  strcpy(temptoken,token);

  for (t=0; t<objectsptr; t++)
  { if (strcasecmp(token,objects[t])==0) break; }

  /* if (t<objectsptr && getobject(token)==3) */
  if (getobject(token)==3)
  {
    strcpy(temptoken,token);

    tokentype=gettoken(token);
    if (strcmp(token,".")==0)
    {
      tokentype=gettoken(token);
      sprintf(newtoken,"$%s_%s=",temptoken,token);

      tokentype=gettoken(token);
      if (strcmp(token,"=")!=0)
      { error(token,"=","Set"); }

      tokentype=gettoken(token);
      if (getobject(token)==1)
      {
        strcat(newtoken,"$");
        strcat(newtoken,token);
      }

      while(tokentype!=5)
      { tokentype=gettoken(token); }

      strcat(newtoken,";");
      strcat(newtoken,"\n");

      return 0;
    }
      else
    { push(token,tokentype); }
  }

  strcpy(objects[t],token);
  strcpy(objectstype[t],"unkown");
  if (t==objectsptr) objectsptr++;

  tokentype=gettoken(token);
  if (strcmp(token,"=")!=0)
  { error(token,"=","Set"); }

  tokentype=gettoken(token);
  if (strcasecmp(token,"nothing")==0)
  { 
    add_indent(temp_spaces);
    sprintf(newtoken,"%s$%s=null;\n",temp_spaces,temptoken); 
  }
    else
  if (strcasecmp(token,"server")==0)
  {
    tokentype=gettoken(token);
    if (strcmp(token,".")!=0)
    { error(token,".","Server"); }

    tokentype=gettoken(token);
    if (strcasecmp(token,"createobject")==0)
    {
      tokentype=gettoken(token);
      if (strcmp(token,"(")!=0)
      { error(token,"(","CreateObject"); }

      tokentype=gettoken(token);
      if (tokentype!=10 && tokentype!=11)
      { error(token,"String Literal","CreateObject"); }

      strcpy(objectstype[t],token);
      if (t==objectsptr) objectsptr++;

      tokentype=gettoken(token);
      if (strcmp(token,")")!=0)
      { error(token,")","CreateObject"); }
      sprintf(newtoken,"// $%s is of type %s\n",objects[t],objectstype[t]);
    }
      else
    {
      setvar=t;
      eval_element(newtoken,tokentype,token);
      setvar=0;
      sprintf(newtoken,"// $%s is of type %s\n",objects[t],objectstype[t]);
    } 
  }
    else
  if (getobject(token)==5)
  {
    strcpy(objectstype[t],"Scripting.FileSystemObject");
    eval_element(molecule1,tokentype,token);
    strcat(newtoken,"$");
    strcat(newtoken,temptoken);
    strcat(newtoken,"=");
    strcat(newtoken,molecule1);
  }
    else
  {
/* printf("Set NOT SERVER (eval_element): %s\n",token); */
 
    setvar=t;
    eval_element(newtoken,tokentype,token);
/* printf("came back: %s\n",newtoken); */
    setvar=0;
  }

  return 0;
}

int parse_rem()
{
int ch;

  fprintf(out,"// ");

  while((ch=getc(in)))
  {
    if (ch=='\r') ch='\n';
    putc(ch,out);
    if (ch=='\n' || ch==EOF) return 0;
  }

  return 0;
}

int parse_dim()
{
char token[TOKENSIZE];
int tokentype;

  if (inclass==0)
  {
    while((tokentype=gettoken(token))!=0)
    {
      if (tokentype==5 || tokentype==13) break;
    }
  }
    else
  {
    autoindent();
    fprintf(out,"var ");

    while((tokentype=gettoken(token))!=0)
    {
      if (tokentype==6)
      {
        strcpy(tokenpush,token);
        tokentypepush=tokentype;
        fprintf(out,"; ");
        break;
      }
        else
      if (tokentype==5 || tokentype==13)
      { fprintf(out,";\n"); break; }
        else
      if (tokentype!=2 && tokentype!=16)
      { error(token,", or variable","Dim"); }
        else
      if (tokentype==2)
      { fprintf(out,"$%s",token); }
        else
      if (tokentype==16)
      { fprintf(out,","); }
    } 
  }

  return 0;
}

int parse_at_language()
{
int tokentype;
char token[TOKENSIZE];

  tokentype=gettoken(token);
  if (strcmp(token,"=")!=0)
  {
    error(token,"=","LANGUAGE");
  }

  tokentype=gettoken(token);
  remove_quotes(token);

#ifdef DEBUG
printf("%s\n",token);
#endif

  if (strcasecmp(token,"vbscript")==0)
  {
    language=0;
    fprintf(out,"// asp2php (vbscript) converted\n");
  }
    else
  if (strcasecmp(token,"jscript")==0 || strcasecmp(token,"javascript")==0)
  {
    language=1;
    fprintf(out,"// asp2php (jscript) converted\n");
    printf("Warning: JScript has very little support right now.\n");
  }
    else
  {
    language=0;
    fprintf(out,"// asp2php (unknown) converted\n");
    printf("Warning: Unknown language specified.\n");
  }


  return 0;
}

/*
int parse_at()
{
int tokentype;
char token[TOKENSIZE];

  while((tokentype=gettoken(token))!=0)
  {
    if (tokentype==6)
    {
      strcpy(tokenpush,token);
      tokentypepush=tokentype;
      return 0; 
    }
      else
    if (tokentype==5 || tokentype==13)
    { break; }
      else
    if (strcasecmp(token,"language")==0)
    { fprintf(out,"// LANGUAGE = asp2php converted\n"); }
  }

  return 0;
}
*/

int parse_randomize()
{
int tokentype;
char token[TOKENSIZE];

  while(tokentype!=5)
  {
    tokentype=gettoken(token);
  }

  autoindent();
  fprintf(out,"mt_srand((double)microtime()*1000000);\n");

  return 0;
}

