#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "globals.h"
#include "functions.h"


/* checks to see if the current token is a known
   defined function */

int isfunction(char *token)
{
int t=0;

  for (t=0; t<functptr; t++)
  { if (strcasecmp(funct[t],token)==0) return 1; }

  return 0;
}

int parse_funct(int isfunct)
{
char token[TOKENSIZE];
char newtoken[LINELENGTH];
int tokentype,c;

  infunct=isfunct; 

  tokentype=gettoken(token);
  autoindent();
  fprintf(out,"function %s",token);

  tokentype=gettoken(token);
  push(token,tokentype);

  newtoken[0]=0;

  if (strcmp(token,"(")==0)
  { eval_funct(newtoken); fprintf(out,"(%s)",newtoken); }
    else
  { fprintf(out,"()"); }

  fprintf(out,"\n");
  autoindent();

  fprintf(out,"{\n");
  autoindent();
  fprintf(out,"  global extract($GLOBALS);\n\n");

  indent++;
  c=parse_body(0);

  autoindent();
  fprintf(out,"return $function_ret;\n");
  indent--;
  autoindent();
  fprintf(out,"} ");

  tokentype=gettoken(token);

  if (isfunct==1)
  {
    if (strcasecmp(token,"function")!=0 && strcasecmp(token,"property")!=0)
    { error(token,"function","parse_funct"); }
  }
    else
  if (isfunct==2)
  {
    if (strcasecmp(token,"sub")!=0 && strcasecmp(token,"property")!=0)
    { error(token,"sub","parse_funct"); }
  }
  infunct=0;

  return 0;
}

int eval_funct(char *newtoken)
{
int tokentype;
char token[TOKENSIZE];
int parencount=1;
char molecule[LINELENGTH];

  tokentype=gettoken(token);
  if (strcmp("(",token)!=0)
  { 
    push(token,tokentype);
    strcat(newtoken,"()");
    /* error(token,"(","eval_funct"); */
    return 0; 
  }

  while((tokentype=gettoken(token))!=0)
  {
    if (strcmp("(",token)==0)
    { parencount++; strcat(newtoken,"("); }
      else
    if (strcmp(")",token)==0)
    {
      parencount--;
      if (parencount!=0)
      { strcat(newtoken,")"); }
        else
      { break; }
    }
      else
    if (strcmp(",",token)==0)
    { strcat(newtoken,","); }
      else
    {
      eval_element(molecule,tokentype,token);
      strcat(newtoken,molecule);
    }
  }

  return 0;
}

int find_null(char *s, int l)
{
  while(s[l]!=0)
  {
    l++;
    if (l>LINELENGTH) return 0;
  }

  return l;
}

/*

supress flags:

bit 0: supress parenthesis
bit 1: supress , between params. use . instead
bit 2: don't put more PHP params than there are asp params
bit 3: Fix windows paths in strings 
bit 4: This is an array, not a function

*/

void convert_funct(char *newtoken, char *params1, int suppress)
{
char params[256];
char molecule[LINELENGTH];
char temp[LINELENGTH];
int paramptr[50];
int param_count;
int parens,pflag,tokentype,isstring,t,m,l,k,n;
char token[TOKENSIZE];
char s[10];
char extra[256];

#ifdef DEBUG
printf("\nENTERING convert_funct()\n");
#endif

  strcpy(params,params1);
  parens=0;
  molecule[0]=0;
  pflag=0;
  isstring=0;

  param_count=0;
  paramptr[0]=0;

  tokentype=gettoken(token);

  if (strcmp(token,"(")==0)
  {
    parens++;
    pflag=1;
  }
    else
  { push(token,tokentype); }

  while(1)
  {
#ifdef DEBUG
printf("token: %s (%d)\n",token,tokentype);
#endif
    tokentype=gettoken(token);
    /* if (tokentype==5) break; */
    if (tokentype==0) return;
    if (tokentype==10 || tokentype==11) isstring=1;
    if (tokentype==15 || tokentype==5 || tokentype==6)
    {
      push(token,tokentype);
      break;
    }

    if (spacer==1) strcat(&molecule[paramptr[param_count]]," ");

    if (strcmp(token,"(")==0)
    {
      parens++;
      strcat(&molecule[paramptr[param_count]],"(");
    }
      else
    if (strcmp(token,")")==0)
    {
      parens--;
      if (parens==0 && pflag==1) break;
      if (parens<0)
      {
        push(token,tokentype);
        break;
      }
      strcat(&molecule[paramptr[param_count]],")");
    }
      else
    if (strcasecmp(token,"else")==0)
    {
      push(token,tokentype);
      break;
    }
      else
    if (strcasecmp(token,"mod")==0)
    { strcat(&molecule[paramptr[param_count]],"%"); }
      else
    if (tokentype==7 || tokentype==1)
    { 
      strcat(&molecule[paramptr[param_count]],token);
#ifdef DEBUG
printf("molecule: %s token: %s\n",&molecule[paramptr[param_count]],token);
#endif
    }
      else
    if (tokentype==3)
    {
      strcat(&molecule[paramptr[param_count]],"\n");
      autoindent_string(&molecule[paramptr[param_count]]);
    }
      else
    if (tokentype==9)
    { strcat(&molecule[paramptr[param_count]],"."); }
      else
    if (tokentype==16)
    {
      t=find_null(molecule,paramptr[param_count]);
#ifdef DEBUG
printf("Found null: %d\n",t);
#endif
      param_count++;
      paramptr[param_count]=t+1;
      molecule[t+1]=0;
    }
      else
    if (tokentype==10 || tokentype==11)
    {
      if ((suppress&8)!=0)
      { if (fixwin95paths==1) fixwinpath(token); }
      strcat(&molecule[paramptr[param_count]],token);
    }
      else
    {
      eval_element(temp,tokentype,token);
      strcat(&molecule[paramptr[param_count]],temp);
    }
  }

  if (parens!=0)
  { printf("Warning: Unbalanced parenthesis on line %d\n",line); } 

#ifdef DEBUG
  for (l=0; l<=param_count; l++)
  {
    printf(">> %d: (%d),%s\n",l,paramptr[l],&molecule[paramptr[l]]);
  }
#endif

  strcat(params,"\n");
  t=strlen(params);
  s[0]=0;
  pflag=0;
  m=0;

  if ((suppress&16)==16)
  { strcat(newtoken,"["); }
    else
  if ((suppress&1)==0)
  { strcat(newtoken,"("); }

  extra[0]=0;

  for(l=0; l<t; l++)
  {
    if ((suppress&4)!=0 && pflag>param_count)
    { break; }

    if (params[l]=='-' || params[l]=='+' || params[l]=='@')
    {
      k=0;
      while(params[l]!=',' && params[l]!='\n')
      { extra[k++]=params[l++]; }

      extra[k]=0;
#ifdef DEBUG
printf("atoi extra=%d\n",atoi(extra));
#endif

      if (extra[0]=='@')
      {
        if (pflag!=0)
        {
          if ((suppress&2)==0)
          { strcat(newtoken,","); }
            else
          { strcat(newtoken,"."); }
        }
        strcat(newtoken,&extra[1]);

        s[0]=0;
        extra[0]=0;
        pflag++;
        m=0;

        if (params[l]=='\n') break;
        continue;
      }
    }

    if (params[l]==',' || params[l]=='\n')
    {
      s[m]=0;
      m=atoi(s);
      if (m!=0)
      {
        if (pflag!=0)
        {
          if ((suppress&16)==16)
          { strcat(newtoken,"]["); }
            else
          if ((suppress&2)==0)
          { strcat(newtoken,","); }
            else
          { strcat(newtoken,"."); }
        }

        m--;
        if (m<=param_count)
        {
          if (isnum(&molecule[paramptr[m]])==1 && atoi(extra)!=0)
          {
            n=atoi(&molecule[paramptr[m]])+atoi(extra);
            sprintf(extra,"%d",n);
#ifdef DEBUG
printf("extra to append: %s\n",extra);
#endif
            strcat(newtoken,extra);
          }
            else
          {
            strcat(newtoken,&molecule[paramptr[m]]);
            strcat(newtoken,extra);
          }
        }

        s[0]=0;
        extra[0]=0;
        pflag++;
        m=0;
      }
      if (params[l]=='\n') break;
    }
      else
    { s[m++]=params[l]; }
  }

  if ((suppress&16)==16)
  { strcat(newtoken,"]"); }
    else
  if ((suppress&1)==0)
  { strcat(newtoken,")"); }
}


