/* this file is a part of Ami software, (C) Hwang chi-deok 1999 */

#include "config.h"

#include "amitype.h"
#include "ami.h"
#include <gdk/gdkx.h>


static GHashTable *font_table = NULL;
static Window find_top_window (Window win);

GdkFont *
util_fontset_load(char *name)
{
    char **font_names;
    XFontStruct **font_structs;
    int num_fonts = 0;
    GdkFont *font, *f;
    GString *s;
    int i;

    if (!font_table) {
	font_table = g_hash_table_new(g_str_hash, g_str_equal);
    }
    font = g_hash_table_lookup(font_table, name);
    if (font) {
	gdk_font_ref(font);
	return font;
    }
    font = gdk_fontset_load(name);
    if (font)
       num_fonts = XFontsOfFontSet(
	    GDK_FONT_XFONT(font), &font_structs, &font_names);
    if (num_fonts != 2) {
	g_warning("fontset(%s) loading failed", name);
	if (default_xim_font) gdk_font_ref(default_xim_font);
	return default_xim_font;
    }
    s = g_string_new(NULL);
    for (i=0;i<num_fonts;i++) {
	s = g_string_append(s, font_names[i]);
	if (i != num_fonts - 1) g_string_append_c(s, ',');
    }
    if (strcmp(name, s->str) == 0) {
	g_hash_table_insert(font_table, g_strdup(name), font);
	g_string_free(s, TRUE);
	return font;
    }
    f = g_hash_table_lookup(font_table, s->str);
    if (f) {
	gdk_font_unref(font);
	gdk_font_ref(f);
	g_hash_table_insert(font_table, g_strdup(name), f);
	g_string_free(s, FALSE);
	return f;
    }
    g_hash_table_insert(font_table, g_strdup(name), font);
    g_hash_table_insert(font_table, s->str, font);
    g_string_free(s, FALSE);
    return font;
}

static gboolean
remove_font(gpointer key, gpointer value, gpointer user_data)
{
    if (value == user_data) {
	g_free(key);
	return TRUE;
    } else 
        return FALSE;
}

int
util_font_real_unref(GdkFont *font)
{
    GdkFontPrivate *private = (GdkFontPrivate *)font;
    if (private->ref_count == 1) {
	g_hash_table_foreach_remove(font_table, remove_font, font);
    }
    gdk_font_unref(font);
    return FALSE;
}

void
util_font_unref(GdkFont *font)
{
    GdkFontPrivate *private = (GdkFontPrivate *)font;
    if (private->ref_count == 1) {
	gtk_timeout_add(1000*60*2, (GtkFunction)util_font_real_unref, font);
    } else {
	gdk_font_unref(font);
    }
}

GdkWindow *
util_get_top_window (GdkWindow *win)
{
    Window xwin;
    GdkWindow *top;
    g_return_val_if_fail (win != NULL, NULL);
    xwin = find_top_window(GDK_WINDOW_XWINDOW(win));
    top = gdk_window_lookup(xwin);
    if (!top) top = gdk_window_foreign_new(xwin);
    else gdk_window_ref(top);
    return top;
}


static Window try_parent (Window win, Atom WM_STATE);

static Window 
find_top_window (Window win)
{
    Atom WM_STATE;
    Atom type = None;
    int format;
    unsigned long nitems, after;
    unsigned char *data;
    Window inf;

    WM_STATE = gdk_atom_intern("WM_STATE", TRUE);
    if (!WM_STATE)
	return win;
    XGetWindowProperty(GDK_DISPLAY(), win, WM_STATE, 0, 0, False, AnyPropertyType,
		       &type, &format, &nitems, &after, &data);
    if (type)
	return win;
    inf = try_parent(win, WM_STATE);
    if (!inf)
	inf = win;
    return inf;
}

static Window 
try_parent (Window win, Atom WM_STATE)
{
    Window root, parent;
    Window *children = NULL;
    unsigned int nchildren;
    unsigned int i;
    Atom type = None;
    int format;
    unsigned long nitems, after;
    unsigned char *data;
    Window inf = 0;

    if (!XQueryTree(GDK_DISPLAY(), win, &root, &parent, &children, &nchildren))
	return 0;
    if (children) XFree((char *)children);

    if (root == parent) return win;
    XGetWindowProperty(GDK_DISPLAY(), parent, WM_STATE, 0, 0, False,
		       AnyPropertyType, &type, &format, &nitems,
		       &after, &data);
    if (type) return parent;
    return try_parent(parent, WM_STATE);
}

static GSList *gc_list = NULL;
static int 
do_real_gc(void)
{
    GSList *list = gc_list;
    while(list) {
	free(list->data);
	list = list->next;
    }
    g_slist_free(gc_list);
    gc_list = NULL;
    return FALSE;
}

void 
do_gc(char *buf)
{
    return;
    if (!gc_list) {
	gtk_timeout_add(1000, (GtkFunction)do_real_gc, NULL);
    }
    gc_list = g_slist_prepend(gc_list, buf);
}

int
util_get_mb_strlen(const char *s, int len)
{
    int i, mblen = 0;
    if (len < 0) len = strlen(s);
    for (i=0;i<len;i++) {
	if (s[i] & 0x80) i++;
	mblen++;
    }
    return mblen;
}
