/*
 * VFenc.h
 *
 *  Programmmed by Werner Lemberg
 *  E-Mail:  a7621gac@awiuni11.bitnet
 *
 *  Edition History
 *  19 Feb 1996  First version.
 *
 */

/* This file is part of VFlib
 *
 * Copyright (C) 1995-1998 Hirotsugu KAKUGAWA.   All rights reserved.
 *
 * This file is part of the VFlib Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __VFLIB_VFENC_H__

#define __VFLIB_VFENC_H__

int     VFE_SearchEncoding();
int     VFE_SearchCharSet();
int     VFE_GetEncoding();
int     VFE_GetCharSet();

int     VFE_Init();
int     VFE_Deinit();
int     VFE_OpenFont();
int     VFE_CloseFont();
int     VFE_CloseAllFonts();
int     VFE_GetBitmap();
long*   VFE_GetOutline();
long*   VFE_GetOutline2();
int     VFE_DrawOutline();
int     VFE_FreeOutline();


/* font encodings */

#define ENC_EUC      1   /* JIS, KS, GB etc. */
#define ENC_SJIS     2   /* SJIS */
#define ENC_BIG5     3   /* Big 5 */
#define ENC_UNIC     4   /* Unicode */

/* font character sets */

#define CS_BIG5_HKU         0x401
#define CS_BIG5_ETEN        0x402
#define CS_CNS11643_1992    0x300
#define CS_CNS11643_1992_1  0x301
#define CS_CNS11643_1992_2  0x302
#define CS_CNS11643_1992_3  0x303
#define CS_CNS11643_1992_4  0x304
#define CS_CNS11643_1992_5  0x305
#define CS_CNS11643_1992_6  0x306
#define CS_CNS11643_1992_7  0x307
#define CS_GB2312_1980      0x101
#define CS_GB12345_1990     0x102
#define CS_JISX0208_1983    0x001
#define CS_JISX0212_1990    0x002
#define CS_KSC5601_1987     0x201


/* encoding string to encoding value mapping table */

struct s_encoding_table {
  char *EncString;
  int  EncValue;
};
typedef struct s_encoding_table  EncodingTable;

extern EncodingTable  EncTable[];  /* in VFEtable.c */

/* charset string to charset value mapping table */

struct s_charset_table {
  char *CharSetString;
  int  CharSetValue;
  int  DefEncValue;  /* default encoding value */
};
typedef struct s_charset_table CharSetTable;

extern CharSetTable  ChSetTable[];  /* in VFEtable.c */


/* common conversion routines for EUC fonts */

#define KUTEN_TO_GL(CJKcode)  ((CJKcode) + 0x2020)
#define KUTEN_TO_GR(CJKcode)  ((CJKcode) + 0xA0A0)
#define GL_TO_KUTEN(CJKcode)  ((CJKcode) - 0x2020)
#define GL_TO_GR(CJKcode)     ((CJKcode) + 0x8080)
#define GR_TO_KUTEN(CJKcode)  ((CJKcode) - 0xA0A0)
#define GR_TO_GL(CJKcode)     ((CJKcode) - 0x8080)


#endif  /*__VFLIB_VFENC_H__*/
