/*************************************************************************
 *
 *  $RCSfile: macclip.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdlib.h>
#include <stdio.h>

#include <mac_start.h>
#include <Types.h>
#include <Memory.h>
#include <Scrap.h>
#include <Events.h>
#include <mac_end.h>

#include <tools/stream.hxx>

#include <macexchg.hxx>

#ifndef _NEW_HXX
#include <tools/new.hxx>
#endif

#include <salinst.hxx>
#include <salctype.hxx>
#include <saldata.hxx>
#include <getsys.hxx>

ResType FormatResType(UINT32 n)
{
	char	szResName[5];
	sprintf(szResName, "sF%02x", n);
	return *(ResType *)szResName;			
}

ResType DataResType(UINT32 n)
{
	char	szResName[5];
	sprintf(szResName, "sD%02x", n);
	return *(ResType *)szResName;			
}

//==================================================================================================
// XDTransMacClip
//==================================================================================================

class XDTransMacClip : public XDTrans
{
public:
	XDTransMacClip() : mnRefCount(1) {}

	virtual void aquire();
	virtual void release();
	
	virtual UINT32	*getTypeList(UINT32 &rSize) const;
	virtual BYTE	*getData(UINT32 nFormat, UINT32 &rSize);

protected:
	virtual ~XDTransMacClip() {}
	
	ULONG	mnRefCount;
};


//**************************************************************************************************
//    XDTransMacClip::aquire
//**************************************************************************************************

void XDTransMacClip::aquire()
{
	mnRefCount++;
}


//**************************************************************************************************
//    XDTransMacClip::release
//**************************************************************************************************

void XDTransMacClip::release()
{
	if (--mnRefCount <= 0)
		delete this;
}


//**************************************************************************************************
//    XDTransMacClip::getTypeList
//**************************************************************************************************

UINT32	*__getTypeList(UINT32 &rSize)
{
	long offset, result;
	UINT32	uTypeList[100];			// temporre Liste fr die maximal 100 Typen
	UINT32	*pTypeList = NULL;
	
	rSize = 0;

	// Zuerst die Native-Typen ermitteln

/*
	for (int n = 0; n < 100; n++)
	{
		Handle hData = NewHandle(0);
		
		result = GetScrap(hData, FormatResType(n), &offset);
		if (result > 0)
		{
			HLock(hData);
			String	aStr((const char *)*hData);
			HUnlock(hData);
			
			const FormatItem	*pItem = XMacExchange::theExchange.findItem(aStr);
			
			if (pItem)
				uTypeList[rSize++] = pItem->mnFormatID;
		}
		else
			break;
		
		DisposeHandle(hData);
	}
*/

	// Wie wre es mit HTML

	if (GetScrap(nil, MAC_FORMAT_HTML, &offset) >= 0)
		uTypeList[rSize++] = FORMAT_HTML;
	
	// Haben wir vielleicht auch RTF ?
	
	if (GetScrap(nil, MAC_FORMAT_RTF, &offset) >= 0)
		uTypeList[rSize++] = FORMAT_RTF;
	
	// Liegt reiner Text im Clipboard ?
	
	if (GetScrap(nil, MAC_FORMAT_TEXT, &offset) >= 0)
		uTypeList[rSize++] = FORMAT_STRING;
	
	// Wenn PICT im Clipboard liegt, bieten wird Bitmap und GDIMetafile an
	
	if (GetScrap(nil, MAC_FORMAT_PICT, &offset) >= 0)
	{
		uTypeList[rSize++] = FORMAT_GDIMETAFILE;
		uTypeList[rSize++] = FORMAT_BITMAP;
	}

	// Jetzt eine Typeliste allokieren und die temporren Daten kopieren
	
	if (rSize > 0)
	{
		pTypeList = new UINT32[rSize];
		if (pTypeList)
			memcpy(pTypeList, uTypeList, rSize * sizeof(UINT32));
		else
			rSize = 0;
	}
	
	return pTypeList;
}

UINT32	*XDTransMacClip::getTypeList(UINT32 &rSize) const
{
	return ::__getTypeList(rSize);
}



//**************************************************************************************************
//    XDTransMacClip::getData
//**************************************************************************************************

BYTE *XDTransMacClip::getData(UINT32 nFormat, UINT32 &rSize)
{
	ResType	theResType;
	BYTE	*pData = NULL;
	
	rSize = 0;

	// Welcher Typ wird gewnscht ?
	
	switch (nFormat)
	{
		case FORMAT_STRING:
			theResType = MAC_FORMAT_TEXT;
			break;
		case FORMAT_GDIMETAFILE:
		case FORMAT_BITMAP:
			theResType = MAC_FORMAT_PICT;
			break;
		case FORMAT_RTF:
+			theResType = MAC_FORMAT_RTF;
			break;
		default:
			if (nFormat == FORMAT_HTML)
				theResType = MAC_FORMAT_HTML;
			else
				theResType = MAC_FORMAT_NONE;
			break;
	}
	
	// Wenn es einen korrespondirenden Typ gibt, dann holen wird die Daten aus dem
	// System clipboard und konvertieren sie.
	
	if (theResType != MAC_FORMAT_NONE)
	{
		Handle hData = NewHandle(0);
		long offset, result = GetScrap(hData, theResType, &offset);
		
		if (result > 0)
		{
			HLock(hData);
			pData = ConvertResType2Format(theResType, nFormat, (const BYTE *)*hData, result, rSize);
			HUnlock(hData);
		}
		
		DisposeHandle(hData);
	}
	
	// Andernfalls handelt es sich um ein Native-format des Office
	
	else
	{

		for (int n = 0; n < 100 && !pData; n++)
		{
			Handle hNameData = NewHandle(0);
			
			long offset, result = GetScrap(hNameData, FormatResType(n), &offset);
			if (result > 0)
			{
				HLock(hNameData);
				String	aStr((const char *)*hNameData);
				HUnlock(hNameData);
				
				const FormatItem	*pItem = XMacExchange::theExchange.findItem("", nFormat);
				
				if (pItem && pItem->maFormatName == aStr)
				{
					Handle	hData = NewHandle(0);
					result = GetScrap(hData, DataResType(n), &offset);
					if (result > 0)
					{
						pData = new BYTE[result];
						if (pData)
						{
							memcpy(pData, *hData, result);
							rSize = result;
						}
					}
					DisposeHandle(hData);
				}
			}
			
			DisposeHandle(hNameData);
		}
		
	}


	return pData;
}

//==================================================================================================
// MacSystemClipboard
//==================================================================================================

class XMacClipboard : public XSystemClipboard
{
public:
	XMacClipboard();
	virtual ~XMacClipboard();
	
	virtual void copy(XDTrans* pData) ;
	virtual XDTrans* paste();
	virtual void clear();

	virtual void registerListener( XClipboardListener& xListener );


protected:
	XClipboardListener	*mpListener;
	XDTrans				*mpLastXDTrans;

	virtual void writeBack(BOOL bAllFormats);
	virtual void writeFormat(UINT32 nFormat, ResType theResType);
	virtual void cleared();
	virtual void changed();

	static XMacClipboard theClipboard;

	friend void UpdateMacClipboard(BOOL);
	friend void MacClipboardHasChanged();
	
	friend XSystemClipboard* GetSystemClipboard();
};


//**************************************************************************************************
//    XMacClipboard::theClipboard
//**************************************************************************************************

XMacClipboard XMacClipboard::theClipboard; // Die Instanz des Systemclipboard-Interfaces

//**************************************************************************************************
//    XMacClipboard::CTOR
//**************************************************************************************************

XMacClipboard::XMacClipboard() :
	mpListener(NULL),
	mpLastXDTrans(NULL)
{
}

//**************************************************************************************************
//    XMacClipboard::DTOR
//**************************************************************************************************

XMacClipboard::~XMacClipboard()
{
	// Wenn wir noch ein Interface haben, sollten wir das jezt freigeben

	if (mpLastXDTrans)
	{
		mpLastXDTrans->release;
		mpLastXDTrans = NULL;
	}
}

//**************************************************************************************************
//    XMacClipboard::changed
//**************************************************************************************************

void XMacClipboard::registerListener(XClipboardListener &xListener)
{
	mpListener = &xListener;
	changed();	// Sicherheitshalber benachrichtigen wir ihn gleich
}



//**************************************************************************************************
//    XMacClipboard::changed
//**************************************************************************************************

void XMacClipboard::changed()
{
	// Der Inhalt des Systemclipboarda hat sich gendert, also ist des zuletzt uebergebene Interface
	// hinfaellig und wir koenne es freigeben.
	
	if (mpLastXDTrans)
	{
		mpLastXDTrans->release();
		mpLastXDTrans = NULL;
	}
		
	// Jetzt noch den Listener benachrichtigen, da sich der Inhalt geaendert hat.

	if (mpListener)
		mpListener->changed();
}


//**************************************************************************************************
//    XMacClipboard::cleared
//**************************************************************************************************

void XMacClipboard::cleared()
{
	// Das Systemclipboard wurde gelscht, also mu das interne Clipboard auch gelscht werden,
	// um keine Inkonsistenzen zu haben. Das zuletzt bergebene Interface knnen wir daher
	// freigeben.
	
	if (mpLastXDTrans)
	{
		mpLastXDTrans->release();
		mpLastXDTrans = NULL;
	}
	
	// Jetzt noch den Listener benachrichtigen, da das clipboard gelscht wurde
	
	if (mpListener)
		mpListener->cleared();
}

//**************************************************************************************************
//    XMacClipboard::copy
//**************************************************************************************************

void XMacClipboard::copy(XDTrans *pDataTrans)
{
	// Die Methode Copy schreibt die Daten noch nicht ins Systemclipboard, sondern mekrt sich
	// nur das zuletzt bergebene Interface.
	
	// Da der Writer das Lschen des internen Clipboards beim Runterfahren des Office dadurch
	// realisiert, da er ein leeres Objekt kopiert, mssen wir diesen Fall abfangen und vorher
	// die zuletzt kopierten Daten ins System-Clipboard schreiben.
	
	
	// NULL-Pointer als leeres Interface: Daten wegschreiben und ignorieren
	
	if (pDataTrans == NULL)
	{
		writeBack(TRUE);
		return;
	}


	// Wenn die Gre der Typeliste 0 ist, handelt es sich auch um ein leeres Objekt, aber
	// der Zeiger auf die Typeliste sollte evtl. freigegebn werden und das Interface losgelassen
	// werden (release).
	
	UINT32	nTypeList, *pTypeList = pDataTrans->getTypeList(nTypeList);	
	
	if (pTypeList == NULL)
		nTypeList = 0;
	else
		delete pTypeList;
		
	if (nTypeList == 0)
	{
		writeBack(TRUE);
		pDataTrans->release();
		return;	
	}
	
	// Hier beginnt der eigentliche Code
	
	// Falls schon ein Interface bergeben wurde, vergessen wird das jetzt
	if (mpLastXDTrans)
	{
		mpLastXDTrans->release();
		mpLastXDTrans = NULL;
	}
		
	// Neues Interface merken
	
	mpLastXDTrans = pDataTrans;
	mpLastXDTrans->aquire();
}

//**************************************************************************************************
//    XMacClipboard::writeFormat
//**************************************************************************************************

void XMacClipboard::writeFormat(UINT32 nFormatID, ResType theResType)
{
	UINT32	nSize;
	BYTE *pData = mpLastXDTrans->getData(nFormatID, nSize);
	
	if (pData)
	{
		BYTE *pConvData = ConvertFormat2ResType(nFormatID, theResType, pData, nSize, nSize);
		delete pData;
		if (pConvData)
		{
			PutScrap(nSize, theResType, pConvData);
			delete pConvData;
		}
	}
}

//**************************************************************************************************
//    XMacClipboard::writeBack
//**************************************************************************************************

void XMacClipboard::writeBack(BOOL bWriteNative)
{
	if (mpLastXDTrans)
	{
		// Zuerst einmal lschen wir das MAC-System-Clipboard
		ZeroScrap();
		
		// Jetzt alle Standard-Typen des Interfaces sichern

		if (HasFormat(mpLastXDTrans, FORMAT_HTML))
			writeFormat(FORMAT_HTML, MAC_FORMAT_HTML);

		if (HasFormat(mpLastXDTrans, FORMAT_STRING))
			writeFormat(FORMAT_STRING, MAC_FORMAT_TEXT);
		
		if (HasFormat(mpLastXDTrans, FORMAT_RTF))
			writeFormat(FORMAT_RTF, MAC_FORMAT_RTF);

		// Wenn Bitmap oder GDIMetafile vorliegt, duerfen wir nur ein Format schreiben
		
		if (HasFormat(mpLastXDTrans, FORMAT_GDIMETAFILE))
			writeFormat(FORMAT_GDIMETAFILE, MAC_FORMAT_PICT);
		else if (HasFormat(mpLastXDTrans, FORMAT_BITMAP))
			writeFormat(FORMAT_BITMAP, MAC_FORMAT_PICT);
		
		// Auch die Office-Formate wegschreiben
		
		if (bWriteNative)
		{
			UINT32 nTypeList;
			UINT32 *pTypeList = mpLastXDTrans->getTypeList(nTypeList);
			
			for (UINT32 n = 0; n < nTypeList && pTypeList; n++)
			{
				UINT32	nFormatID = pTypeList[n];
				
				const FormatItem *pItem = XMacExchange::theExchange.findItem("", nFormatID);
				
				if (pItem)
				{
					PutScrap(pItem->maFormatName.Len() + 1, FormatResType(n), (BYTE *)(const char *)(pItem->maFormatName));
					
					UINT32	nDataSize;
					BYTE 	*pDataBuf = mpLastXDTrans->getData(nFormatID, nDataSize);
					
					if (pDataBuf)
					{
						PutScrap(nDataSize, DataResType(n), pDataBuf);
						delete pDataBuf;
					}
				}

			}
			
			if (pTypeList)
				delete pTypeList;
		}
		
	}

	if (mpLastXDTrans)
	{
		mpLastXDTrans->release();
		mpLastXDTrans = NULL;
	}
}

//**************************************************************************************************
//    XMacClipboard::paste
//**************************************************************************************************

XDTrans *XMacClipboard::paste()
{
	// Paste liefert nur ein Interface, also erzeugen wir jetzt eines, es werden aber noch 
	// keine Daten kopiert.

	return new XDTransMacClip;
}


//**************************************************************************************************
//    XMacClipboard::clear
//**************************************************************************************************

void XMacClipboard::clear()
{
	// Clear wird im Augenblick flschlicherweise beim Runterfahren des Office aufgerufen.
	// Entgegen der Semantik wird daher nicht das Systemclipboard gelscht, sondern. Der Inhalt
	// des internen Clipboards ins Systemclipboard geschrieben.
	
	// ZeroScrap();
	// cleared();

	writeBack(TRUE);
}


//**************************************************************************************************
//    UpdateSystemClipboard
//**************************************************************************************************

// Wie UpdateMacClipboard aber wird nach VCL exportiert

void UpdateSystemClipboard()
{
	UpdateMacClipboard(TRUE);
}

//**************************************************************************************************
//    UpdateMacClipboard
//**************************************************************************************************

// Wrapper der das Clipboard dazu bringt alle oder nur die Standardformate wegzuschreiben.

void UpdateMacClipboard(BOOL bAllFormats)
{
	XMacClipboard::theClipboard.writeBack(bAllFormats);
}

//**************************************************************************************************
//    MacClipboardHasChanged
//**************************************************************************************************

// Benachrichtigt das Systemclipboard-Interface, dass sich das Clipboard geaendert hat

void MacClipboardHasChanged()
{
	XMacClipboard::theClipboard.changed();
}

//**************************************************************************************************
//    XMacClipboard::clear
//**************************************************************************************************

// Liefert die Instanz des Clipboard-Interfaces

XSystemClipboard* GetSystemClipboard()
{
	return &XMacClipboard::theClipboard;
}

