/*************************************************************************
 *
 *  $RCSfile: macmain2.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#if __profile__

#include "mac_start.h"

#include <profiler.h>

#include "mac_end.h"

#endif



#include <svmac.h>



#include <mac_start.h>

#include <graphics routines.h>

#include <Threads.h>

#include <mac_end.h>



#include <stdlib.h>



# define protected public // alles erlaubt !!!!

# define private public // alles erlaubt !!!!



#include "solar.h"

#include <tools/time.hxx>

#include <tools/debug.hxx>

// #include "tools.hxx"



#ifndef _SV_SALDATA_HXX

#include <saldata.hxx>

#endif



#include "SVApp.hxx"



#ifndef _SV_SALFRAME_HXX

#include <salframe.hxx>

#endif

#ifndef _MACWIN_HXX

#include <macwin.hxx>

#endif



#include "main.h"



// =======================================================================



#define	kSuspendResumeMessage	1		/* high byte of suspend/resume event message */

#define	kResumeMask				1		/* bit of message field for resume vs. suspend */



// =======================================================================



void DoEvent( EventRecord *pEvent );



void DoFocusCheck( void );

void DoMouseMove( EventRecord *pEvent );

void DoMouseUp( EventRecord *pEvent );

void DoMouseDown( EventRecord *pEvent );

void DoKey( EventRecord *pEvent );

void DoUpdate( EventRecord *pEvent );

void DoActivate( EventRecord *pEvent );

void DoHighLevelEvent( EventRecord *pEvent );



// =======================================================================



static BOOL IsDAWindow( WindowPtr pWindow );

static void DoSuspendResume( EventRecord *pEvent, BOOL becomingActive );

static void DoCloseWindow( WindowPtr pWindow );



// =======================================================================



void SV_EventLoop()

{

	static int			timerbraus=0;

	static int			saferbraus=0;

	static short		nTimerCount = 0;

	SalData*			pSalData = GetSalData();

	SVLOOPPROCDATA*		pLoopProcs = pSalData->mpLoopProcData;

	EventRecord			event;

	short				nEventMask = everyEvent;

	Boolean				gotEvent;



	// Wenn eine LoopProc gesetzt ist, dann wird sie auch jedes mal gerufen

	saferbraus++;

	if ( pLoopProcs && (timerbraus <= 1) )

	{

		while ( pLoopProcs )

		{

			(*( pLoopProcs->mpLoopProc ))();

			pLoopProcs = pLoopProcs->mpNext;

		}

	}

	saferbraus--;



	gotEvent = WaitNextEvent( nEventMask, &event, 2L, nil );

	// Save ClipRgn

	RgnHandle oldClip = NewRgn();

	GetClip(oldClip);



	// Pruefen, ob Hook gesetzt ist und ggfs. Hook aufrufen

	// True als Return Wert bedeutet, das SV das Event NICHT bearbeiten

	// soll !!!

	if ( pSalData->mpSVHook )

		gotEvent = (! ((*( pSalData->mpSVHook ))( &event ))) && gotEvent;



	// Event soll verarbeitet werden? --> dann mal los.

	if ( gotEvent )

		DoEvent(&event);



	// Es kommen zu wenig MMove Events! Deshalb hier noch ein paar

	// mehr erzeugen! Aber nur, wenn kein HighLevel Event, da bei

	// denen das where Feld fuer was anderes benutzt wird

	if ( event.what != kHighLevelEvent )

		DoMouseMove(&event);



	if ( pSalData->mpUserEvent )

	{	

		GrafPtr savePortUE;GetPort(&savePortUE);// test test 

		pSalData->ImplDispatchUserEvents( Time::GetSystemTicks() );

		SetPort(savePortUE);// test test 

	}

	if ( pSalData->mbInForeground && pSalData->mpFocusWin != FrontWindow() )

	{	DoFocusCheck();

	}



//	DoIdle();



	// ggfs. die Cursor blinken lassen, zuerst nach Textedits suchen und

	// anschliessend den StarView Cursor blinken lassen.



	// Eventuell aufgetretene Timeouts behandeln

	if ( saferbraus <= 1)

	if ( pSalData->mnTimerId )

	{	

		if ( (event.what == nullEvent) || (nTimerCount++ == 4) )

		{

			nTimerCount = 0;

			// Notify the time Manager that a timeout has occured

			if ( pSalData->mnTimerId < Time::GetSystemTicks() )

			{	timerbraus++;

				SalTimerProc();

				timerbraus--;

			}

		}

	}

	// Eventuelle SoundNotify abarbeiten

//	if (ImpSound::MustNotify())

//		ImpSound::DoNotify();



	YieldToAnyThread();



	if ( pSalData->mbEnde )

	{	ImplHandleShutDownMsg();

	}

	pSalData->maLastEventRec = event;

	//Restore ClipRgn

	SetClip(oldClip);

	DisposeRgn(oldClip);



}



// -----------------------------------------------------------------------



void DoEvent( EventRecord *pEvent )

{

	GetSalData()->mpMacEvent = pEvent;



	switch (pEvent->what) {

		case nullEvent :

			DoMouseMove( pEvent );

			break;

		case mouseUp :

			DoMouseUp( pEvent );

			break;

		case mouseDown :

			DoMouseDown( pEvent );

			break;

		case keyDown :

			DoKey(pEvent);

			break;

		case keyUp :

			DoKey(pEvent);

			break;

		case autoKey :

			DoKey(pEvent);

			break;

		case updateEvt :

			DoUpdate(pEvent);

			break;

		case activateEvt :

			DoActivate(pEvent);

			break;

			

		case diskEvt:

			break;



		case osEvt:

			switch ((pEvent->message >> 24) & 0x0FF)

			{

				case kSuspendResumeMessage:

					DoSuspendResume(pEvent,(pEvent->message & kResumeMask) == 1);

				break;

			}

			break;

		case kHighLevelEvent:

			DoHighLevelEvent( pEvent );

			break;

		default :

			break;

	} // end switch (pEvent->what)

}



// -----------------------------------------------------------------------



void DoSuspendResume( EventRecord *pEvent, BOOL becomingActive )

{

	SalData*	pSalData = GetSalData();



	DBG_ASSERT(!pSalData->ImplIsInSuspendResume(), "Nested Suspend/Resume handling ?");



	MAC_SetCursor( &(qd.arrow) );



	pSalData->ImplSetInSuspendResume(TRUE);

	pSalData->mbInForeground = becomingActive;

	if ( becomingActive )

	{

		;

	}

	else

	{

		WindowPtr	pFocusWin = pSalData->mpFocusWin;

		if ( pFocusWin )

		{	ImplHandleFocusMsg( (SalFrame *)GetWRefCon( pFocusWin ), FALSE );

		}

		pSalData->mpFocusWin = 0L;

		// Mouse leave message

        if ( pSalData->mpWantLeaveMsg )

        {    pSalData->ImplSendMessage( pSalData->mpWantLeaveMsg, (void*)0L, SAL_MSG_MOUSELEAVE );

		}



	}

	pSalData->ImplSetInSuspendResume(FALSE);

}



// -----------------------------------------------------------------------



void DoHighLevelEvent( EventRecord *pEvent )

{

	OSErr aErr;



	aErr = AEProcessAppleEvent( pEvent );

}



// -----------------------------------------------------------------------



void DoFocusCheck()

{	

	SalData*	pSalData = GetSalData();

	WindowPtr	pFrontWin = FrontWindow();

	WindowPtr	pFocusWin = pSalData->mpFocusWin;



	if ( pFocusWin != pFrontWin )

	{	

		if ( pFocusWin )

		{	ImplHandleFocusMsg( (SalFrame *)GetWRefCon( pFocusWin ), FALSE );

		}

		if ( pFrontWin )

		{	ImplHandleFocusMsg( (SalFrame *)GetWRefCon( pFrontWin ), TRUE );

		}

		pSalData->mpFocusWin = pFrontWin;

	}

}



// -----------------------------------------------------------------------



void DoMouseMove( EventRecord *pEvent )

{	

	// null event only

    SalData* pSalData = GetSalData();

	MacPoint	aPoint( pEvent->where );

	MacPoint	aLastPoint( pSalData->maLastEventRec.where );

	SalFrame*	pCaptureFrame = pSalData->mpCaptureFrame;

	WindowPtr	pMacWin=0L;



	INT16 partCode = FindWindow( aPoint, &pMacWin );

	if ( pCaptureFrame )

	{	

		if ( pSalData->mbInForeground && pEvent->what == nullEvent && aPoint != aLastPoint )

		{	// egal wo

			ImplHandleMouseMsg( pEvent, pCaptureFrame );

		}

		if ( pSalData->mbMouseButtonDown && StillDown())

		{

			MAC_Point	aNextPoint;

			while ( StillDown() )//testetetetetetetete

			{

				GetMouse( &aNextPoint );LocalToGlobal( &aNextPoint );

				if ( aPoint != aNextPoint)

				{	

					pEvent->where = aNextPoint;

					ImplHandleMouseMsg( pEvent, pCaptureFrame );

	if ( pSalData->mpUserEvent )

	{	

		GrafPtr savePortUE;GetPort(&savePortUE);// test test 

		pSalData->ImplDispatchUserEvents( Time::GetSystemTicks() );

		SetPort(savePortUE);// test test 

	}



					aPoint = aNextPoint;

				}

			}

		}

	}

	else

	{

		if ( pSalData->mpWantLeaveMsg )

		{

			// Mouse leave message

			if ( pMacWin && pSalData->mpWantLeaveMsg != (SalFrame *)GetWRefCon( pMacWin ) )

			{    pSalData->ImplSendMessage( pSalData->mpWantLeaveMsg, (void*)0L, SAL_MSG_MOUSELEAVE );

			}

			else

			// Mouse leave message

			if ( partCode != inContent )

			{    //

				pSalData->ImplSendMessage( pSalData->mpWantLeaveMsg, (void*)0L, SAL_MSG_MOUSELEAVE );

			}

		}

		// only foreground mouse move events 

		if ( pSalData->mbInForeground && pEvent->what == nullEvent && aPoint != aLastPoint )

		{	if ( partCode == inContent )

			{

				ImplHandleMouseMsg( pEvent, pMacWin );

			}

		}

	}

}



// -----------------------------------------------------------------------



void DoMouseUp( EventRecord *pEvent )

{

	SalData* 		pSalData = GetSalData();

	WindowPtr		pMacWin=0L;

	SalFrame*		pCaptureFrame = pSalData->mpCaptureFrame;



	pSalData->mbMouseButtonDown = FALSE;

	INT16 partCode = FindWindow( pEvent->where, &pMacWin );

	// 

	if ( pMacWin && partCode == inContent )

	{

		ImplHandleMouseMsg( pEvent, pMacWin );

	}

	else

	if ( pCaptureFrame )

	{	

		ImplHandleMouseMsg( pEvent, pCaptureFrame );

	}

	else

	{	MAC_SetCursor( &(qd.arrow) );

	}

}



// -----------------------------------------------------------------------

// Check to see if a window belongs to a desk accessory.



BOOL IsDAWindow( WindowPtr pWindow )

{

	if ( pWindow == nil )

		return FALSE;

	else	/* DA windows have negative windowKinds */

		return ((WindowPeek) pWindow)->windowKind < 0;

} /*IsDAWindow*/



void DoCloseWindow( WindowPtr pMacWin )

{

	if ( IsDAWindow( pMacWin ) )

		CloseDeskAcc( ((WindowPeek) pMacWin)->windowKind );

	else 

	{	

		ImplHandleCloseMsg( (SalFrame *)GetWRefCon( pMacWin ) );

	}

}



// -----------------------------------------------------------------------



void DoInDrag(EventRecord *pEvent, WindowPtr pMacWin)

{

	Rect aRect = ( **GetGrayRgn() ).rgnBBox;

	if ( ! ( pEvent->modifiers & cmdKey ) )

	{

		SelectWindow( pMacWin );

	}

	DragWindow( pMacWin, pEvent->where, &aRect );

}



// -----------------------------------------------------------------------



void DoGrowWindow(EventRecord *pEvent, WindowPtr pMacWin)

{

	INT32	newSize;

	INT16	newHeight,newWidth;

	Rect	growLimitSizes;

	

	SetPort(pMacWin);

	InvalRect(&pMacWin->portRect);

	

	growLimitSizes.top = 80;			/* min height */

	growLimitSizes.bottom = 32767;		/* max height */

	growLimitSizes.left = 120; 			/* min width */

	growLimitSizes.right = 32767;		/* max width */

	

	newSize = GrowWindow(pMacWin,pEvent->where,&growLimitSizes);

	newHeight = HiWord(newSize);

	newWidth = LoWord(newSize);

	SizeWindow(pMacWin,newWidth,newHeight,TRUE);

	ImplHandleSizeMsg(pMacWin);

}



// -----------------------------------------------------------------------





void DoZoom(EventRecord *pEvent, WindowPtr pMacWin, int part)

{

	GrafPtr savePort;

	

	GetPort(&savePort);

	SetPort(pMacWin);

	

	if(TrackBox(pMacWin,pEvent->where,part))

	{

		ZoomWindow(pMacWin,part,true);

		ImplHandleSizeMsg(pMacWin);

	}

	

	SetPort(savePort);

}



// -----------------------------------------------------------------------



void DoMenu( long msel )

{

	if ( GetSalData()->mbHasDummyMenu )

	{

		int item = LoWord(msel);

		int menu = HiWord(msel);

		int nQuitMenuPressed = MenuDispatch( menu, item );

		if ( nQuitMenuPressed )

			GetSalData()->mbEnde = TRUE;

	}

}



// -----------------------------------------------------------------------



void DoKey( EventRecord *pEvent )

{

	static Boolean	KeyPressed = false;	// true most recent event is a keyDown event 

	static char		KeyValue = 0;		// the ascii code of the most recent key down

	

	char c = (char)pEvent->message & charCodeMask;

	

	SalData*	pSalData = GetSalData();



	if ( !pSalData->mbInForeground )

	{	pSalData->mbInForeground = TRUE;

		DoFocusCheck();

	}

	KeyPressed = true;

	KeyValue = c;

	WindowPtr	pFocusWin = pSalData->mpFocusWin;



	if ( pFocusWin )

	{	ImplHandleKeyMsg( pEvent, (SalFrame *)GetWRefCon( pFocusWin ));

	}



	// hier wird ggfs. die Applikation beendet, wenn CMD-Q gedrueckt wurde

	if ( pEvent->modifiers & cmdKey )	// quit menu

	{

		DoMenu(MenuKey(pEvent->message & charCodeMask));	

	}

}



// -----------------------------------------------------------------------



void DoMouseDown( EventRecord *pEvent )

{

	WindowPtr pMacWin=0L;



	INT16 partCode = FindWindow( pEvent->where, &pMacWin );



	if ( pMacWin )

	{	

		SalData*	pSalData = GetSalData();

		pSalData->mbInForeground = TRUE;



		if ( partCode != inContent )

			MAC_SetCursor( &(qd.arrow) );



		switch (partCode)

		{	

			case inDesk :

			break;

			case inSysWindow: // DA: let the system handle the mouseDown

				SystemClick( pEvent, pMacWin );

			break;

			case inGoAway :

				if ( TrackGoAway( pMacWin, pEvent->where ) )

				{	DoCloseWindow( pMacWin );

				}

			break;

			case inDrag :

				DoInDrag( pEvent, pMacWin );

			break;

			case inContent :

				pSalData->mbMouseButtonDown = TRUE;

				ImplHandleMouseMsg( pEvent, pMacWin );

			break;

			case inGrow :

				DoGrowWindow(pEvent,pMacWin);

			break;

			case inZoomIn :

			case inZoomOut :

				DoZoom(pEvent,pMacWin,inZoomIn);

			break;

			default:

			break;

		}

	}

	else

	{	MAC_SetCursor( &(qd.arrow) );

		switch (partCode)

		{	

			case inMenuBar :

				DoMenu(MenuSelect(pEvent->where));

			break;

		}

	}

}



// -----------------------------------------------------------------------



void DrawClippedGrowIcon(WindowPtr pMacWin)

{

	Rect		clip;

	RgnHandle	oldClip;

	

	oldClip = NewRgn();

	GetClip(oldClip);

	clip = pMacWin->portRect;

	clip.left = clip.right - 15;

	clip.top = clip.bottom - 15;



	ClipRect(&clip);

	DrawGrowIcon( pMacWin );

	SetClip(oldClip);

	DisposeRgn(oldClip);

}



// -----------------------------------------------------------------------



void DrawImage(GrafPtr graf) // test test

{

	PicHandle	pict;

	

	pict = GetPicture(128);

	DrawPicture(pict,&graf->portRect);	

}



// -----------------------------------------------------------------------



void DoCheckColorDept( EventRecord *pEvent )

{

	static short nLastPixelSize = 0;

	// Hat sich die Farbaufloesung geaendert?

	GDHandle hMainDev = GetMainDevice();

	short nActPixelSize = (*(*hMainDev)->gdPMap)->pixelSize;

	if ( nActPixelSize != nLastPixelSize )

	{	if ( nLastPixelSize )

		{

			ImplHandleSettingsChangeMsg( SALEVENT_DISPLAYCHANGED );

		}

	}

}



// -----------------------------------------------------------------------



void DoUpdate2( EventRecord *pEvent, WindowPtr updateWindow )

{

#ifdef DBG_UTIL

	static short upTest=0;

	if ( upTest )

	{

		EraseRect(&updateWindow->portRect);	// test test

		DrawImage(updateWindow);			// test test

	}

#endif

	

	ImplHandlePaintMsg( updateWindow );

	

	SalData* pSalData = GetSalData();

	if ( pSalData->mpUserEvent )

	{	pSalData->ImplDispatchUserEvents( Time::GetSystemTicks() );

	}

	

	DrawClippedGrowIcon(updateWindow);

}



// -----------------------------------------------------------------------





void DoUpdate1(EventRecord *pEvent)

{

	GrafPtr		savePort;

	WindowPtr	updateWindow = (WindowPtr)pEvent->message;

	

	GetPort(&savePort);

	SetPort(updateWindow);

	if ( ! EmptyRgn( ((WindowPeek)updateWindow)->updateRgn ) )

	{	BeginUpdate(updateWindow);

		DoUpdate2( pEvent, updateWindow );

		EndUpdate(updateWindow);

	}

#ifdef DBG_UTIL

	else

	{

		DBG_ERROR( "DoUpdate1 EmptyRgn ");

	}

#endif

	SetPort(savePort);

}



// -----------------------------------------------------------------------





void DoUpdate(EventRecord *pEvent)

{

	static BOOL		bInUpdate = FALSE;



	if ( bInUpdate )

		return;



	bInUpdate = TRUE;

	DoCheckColorDept( pEvent );

	DoUpdate1( pEvent );

	bInUpdate = FALSE;

}



// -----------------------------------------------------------------------



void DoActivate(EventRecord *pEvent) // dummy erstmal

{

}






