/*************************************************************************
 *
 *  $RCSfile: stdstr.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/05/14 08:29:36 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <precomp.h>
#include <udm/stdstr.hxx>


// NOT FULLY DEFINED SERVICES
// #include "std_conv.hxx"               



namespace udm
{

Data::accessor_type
Stdstr::inq_Type() const
{
 	return t_String;
}

Data::description
Stdstr::inq_TypeDescription() const
{
 	return Data::description("s");
}

Stdstr &
Stdstr::access_Str()
{
 	return *this;
}


//*********************       Stdstr_Null      *******************//

class Stdstr_Null : public Stdstr
{
  public:
    virtual             ~Stdstr_Null();
  private:
    // Interface Data
    virtual void        do_Dispose();
    virtual void        do_BinWrite(
                            csv::bostream &     o_out ) const;
    // Interface Stdstr:
    virtual value_type  inq_Value() const;
};

Stdstr_Null::~Stdstr_Null()
{
}

void                Stdstr_Null::do_Dispose() { }
void                Stdstr_Null::do_BinWrite( csv::bostream & ) const    {}


Stdstr::value_type
Stdstr_Null::inq_Value() const
{
 	return String::Null_();
}


template <>
Stdstr &
get_null<Stdstr>( csv::Type2Type<Stdstr> )
{
    static Stdstr * pNull_ = new Stdstr_Null;
    return *pNull_;
}



}   // namespace udm


