/*************************************************************************
 *
 *  $RCSfile: rmtpacc.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/07 12:27:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _UCPRMT_RMTPACC_HXX_
#define _UCPRMT_RMTPACC_HXX_

#include <list>
#include <map>
#include <vector>

#ifndef _COM_SUN_STAR_LANG_DISPOSEDEXCEPTION_HPP_
#include <com/sun/star/lang/DisposedException.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XUNOTUNNEL_HPP_
#include <com/sun/star/lang/XUnoTunnel.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_REMOTECONTENTPROVIDERCHANGEACTION_HPP_
#include <com/sun/star/ucb/RemoteContentProviderChangeAction.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XREMOTECONTENTPROVIDERACCEPTOR_HPP_
#include <com/sun/star/ucb/XRemoteContentProviderAcceptor.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XREMOTECONTENTPROVIDERACTIVATOR_HPP_
#include <com/sun/star/ucb/XRemoteContentProviderActivator.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XREMOTECONTENTPROVIDERCHANGENOTIFIER_HPP_
#include <com/sun/star/ucb/XRemoteContentProviderChangeNotifier.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XREMOTECONTENTPROVIDERDONELISTENER_HPP_
#include <com/sun/star/ucb/XRemoteContentProviderDoneListener.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XREMOTECONTENTPROVIDERSUPPLIER_HPP_
#include <com/sun/star/ucb/XRemoteContentProviderSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_ 
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_H_ 
#include <com/sun/star/uno/Sequence.h>
#endif
#ifndef _CPPUHELPER_INTERFACECONTAINER_HXX_
#include <cppuhelper/interfacecontainer.hxx>
#endif
#ifndef _CPPUHELPER_WEAK_HXX_ 
#include <cppuhelper/weak.hxx>
#endif
#ifndef _OSL_MUTEX_HXX_ 
#include <osl/mutex.hxx>
#endif
#ifndef _RTL_USTRING_HXX_ 
#include <rtl/ustring.hxx>
#endif
#ifndef _SAL_TYPES_H_ 
#include <sal/types.h>
#endif

namespace com { namespace sun { namespace star {
	namespace lang { class XMultiServiceFactory; }
	namespace ucb { class XContentProviderManager; }
	namespace uno { class XInterface; }
} } }
namespace ucb { struct ContentProviderRegistrationInfo; }

//============================================================================
namespace ucprmt {

class ProviderAcceptor:
		public cppu::OWeakObject,
		public com::sun::star::lang::XServiceInfo,
		public com::sun::star::lang::XTypeProvider,
        public com::sun::star::lang::XComponent,
		public com::sun::star::ucb::XRemoteContentProviderAcceptor,
		public com::sun::star::ucb::XRemoteContentProviderActivator,
		public com::sun::star::ucb::XRemoteContentProviderSupplier,
		public com::sun::star::ucb::XRemoteContentProviderChangeNotifier,
		public com::sun::star::ucb::XRemoteContentProviderDoneListener,
		public com::sun::star::lang::XUnoTunnel
{
public:
	virtual ~ProviderAcceptor() throw ();

	//========================================================================
	// com::sun::star::uno::XInterface:

	virtual com::sun::star::uno::Any SAL_CALL
	queryInterface(com::sun::star::uno::Type const & rType)
		throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL acquire() throw ();

    virtual void SAL_CALL release() throw ();

	//========================================================================
	// com::sun::star::lang::XServiceInfo:

    virtual rtl::OUString SAL_CALL getImplementationName()
		throw (com::sun::star::uno::RuntimeException);

    virtual sal_Bool SAL_CALL supportsService(rtl::OUString const &
											      rServiceName)
		throw (com::sun::star::uno::RuntimeException);

    virtual com::sun::star::uno::Sequence< rtl::OUString > SAL_CALL
	getSupportedServiceNames() throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::lang::XTypeProvider:

    virtual
	com::sun::star::uno::Sequence< com::sun::star::uno::Type > SAL_CALL
	getTypes() throw (com::sun::star::uno::RuntimeException);

    virtual com::sun::star::uno::Sequence< sal_Int8 > SAL_CALL
	getImplementationId() throw (com::sun::star::uno::RuntimeException);

    //========================================================================
    // com::sun::star::lang::XComponent:

    virtual void SAL_CALL dispose()
        throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL
    addEventListener(
        com::sun::star::uno::Reference<
                com::sun::star::lang::XEventListener > const &
            rListener)
        throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL
    removeEventListener(
        com::sun::star::uno::Reference<
                com::sun::star::lang::XEventListener > const &
            rListener)
        throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::ucb::XRemoteContentProviderAcceptor:

	virtual sal_Bool SAL_CALL
	addRemoteContentProvider(
		rtl::OUString const & rIdentifier,
		com::sun::star::uno::Reference<
		        com::sun::star::lang::XMultiServiceFactory > const &
		    rFactory,
		com::sun::star::uno::Sequence< rtl::OUString > const & rTemplates,
		com::sun::star::uno::Reference<
		     com::sun::star::ucb::XRemoteContentProviderDoneListener > const &
		    rDoneListener)
		throw (com::sun::star::uno::RuntimeException);

	virtual sal_Bool SAL_CALL
	removeRemoteContentProvider(
		rtl::OUString const & rIdentifier)
		throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::ucb::XRemoteContentProviderActivator:

	virtual
	com::sun::star::uno::Reference<
		com::sun::star::ucb::XContentProviderManager >
	SAL_CALL
	activateRemoteContentProviders()
		throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::ucb::XRemoteContentProviderSupplier:

	virtual
	com::sun::star::uno::Reference<
		com::sun::star::lang::XMultiServiceFactory >
	SAL_CALL
	queryRemoteContentProvider(
		rtl::OUString const & rIdentifier)
		throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::ucb::XRemoteContentProviderChangeNotifier:

    virtual void SAL_CALL
    addRemoteContentProviderChangeListener(
        com::sun::star::uno::Reference<
           com::sun::star::ucb::XRemoteContentProviderChangeListener > const &
            rListener)
        throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL
    removeRemoteContentProviderChangeListener(
        com::sun::star::uno::Reference<
           com::sun::star::ucb::XRemoteContentProviderChangeListener > const &
            rListener)
        throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::ucb::XRemoteContentProviderDoneListener:

	virtual void SAL_CALL
	doneWithRemoteContentProviders(
		com::sun::star::uno::Reference<
		        com::sun::star::ucb::XRemoteContentProviderAcceptor > const &
		    rAcceptor)
		throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::lang::XUnoTunnel:

	virtual sal_Int64 SAL_CALL
	getSomething(
		com::sun::star::uno::Sequence< sal_Int8 > const & rIdentifier)
		throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// Service Implementation:

	static sal_Char const * getImplementationName_static();

	static com::sun::star::uno::Sequence< rtl::OUString >
	getSupportedServiceNames_static();

	static
	com::sun::star::uno::Reference< com::sun::star::uno::XInterface > SAL_CALL
	createInstance(
		com::sun::star::uno::Reference<
		        com::sun::star::lang::XMultiServiceFactory > const &
		    rTheFactory);

private:
	struct Data
	{
		com::sun::star::uno::Reference<
				com::sun::star::lang::XMultiServiceFactory >
			m_xFactory;
		com::sun::star::uno::Reference<
		        com::sun::star::ucb::XRemoteContentProviderDoneListener >
		    m_xDoneListener;
		std::vector< ucb::ContentProviderRegistrationInfo > m_aProviders;

		inline
		Data(com::sun::star::uno::Reference<
			         com::sun::star::lang::XMultiServiceFactory > const &
			     rTheFactory,
			 com::sun::star::uno::Reference<
			 com::sun::star::ucb::XRemoteContentProviderDoneListener > const &
			     rTheDoneListener);
	};

	typedef std::map< rtl::OUString, Data > Map;
        //TODO! A STLport hash_map might be more efficient, but it does not
        // seem to guarantee the required property that iterators into the map
        // stay valid accross insertions and deletions.

    typedef std::list< Map::iterator > List;

	Map m_aMap;
    List m_aActivations;
	osl::Mutex m_aMutex;
    cppu::OInterfaceContainerHelper m_aEventListeners;
    cppu::OInterfaceContainerHelper m_aChangeListeners;
	com::sun::star::uno::Reference<
	        com::sun::star::lang::XMultiServiceFactory >
	    m_xFactory;
	com::sun::star::uno::Reference<
	        com::sun::star::ucb::XContentProviderManager >
	    m_xUcb;
	rtl::OUString m_aUcbServiceSpecifier;
    bool m_bDisposed;
	bool m_bActivated;
        // order of members is important

    inline void checkDisposed()
        throw (com::sun::star::lang::DisposedException);

	ProviderAcceptor(
		com::sun::star::uno::Reference<
		        com::sun::star::lang::XMultiServiceFactory > const &
		    rTheFactory);

	static void
	setExternalUcb(
		com::sun::star::uno::Reference<
	            com::sun::star::ucb::XRemoteContentProviderAcceptor > const &
		    rAcceptor,
		rtl::OUString const & rServiceSpecifier);

	bool activate(Map::iterator const & rIt)
		throw (com::sun::star::uno::RuntimeException);

    void
    notifyChangeListeners(
        rtl::OUString const & rIdentifier,
        com::sun::star::ucb::RemoteContentProviderChangeAction eAction);
};

}

#endif // _UCPRMT_RMTPACC_HXX_
