/*************************************************************************
 *
 *  $RCSfile: rapofflinecommandmap.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/07 12:58:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_RAPOFFLINECOMMANDMAP_HXX
#define INCLUDED_UCB_RAPOFFLINECOMMANDMAP_HXX

#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_TYPE_HXX_
#include <com/sun/star/uno/Type.hxx>
#endif
#ifndef _RTL_REF_HXX_
#include "rtl/ref.hxx"
#endif
#ifndef _SAL_TYPES_H_
#include "sal/types.h"
#endif
#ifndef _SALHELPER_SIMPLEREFERENCEOBJECT_HXX_
#include "salhelper/simplereferenceobject.hxx"
#endif

#include <hash_map>

namespace com { namespace sun { namespace star {
    namespace uno { class Any; }
    namespace ucb { class XCommandEnvironment; }
} } }
namespace rtl {
    class OUString;
    struct OUStringHash;
}

namespace ucprmt { namespace offline {

typedef com::sun::star::uno::Any
            (* CommandFunction)(
                void * pContent,
                com::sun::star::uno::Any const & rArgument,
                com::sun::star::uno::Reference<
                        com::sun::star::ucb::XCommandEnvironment > const &
                    rEnvironment);
    //TODO! (1) It would be nice to replace 'void * pContent' with something
    // better.  (2) It would be nice to add a 'throw
    // (com::sun::star::uno::Exception)' specification.

struct CommandDescription
{
    com::sun::star::uno::Type m_aArgType;
    CommandFunction m_pFunction;

    inline CommandDescription() {}

    inline CommandDescription(com::sun::star::uno::Type const & rArgType,
                              CommandFunction pFunction):
        m_aArgType(rArgType), m_pFunction(pFunction) {}
};

class CommandMap: public salhelper::SimpleReferenceObject,
                  public std::hash_map< rtl::OUString,
                                        CommandDescription,
                                        rtl::OUStringHash >
{
public:
    CommandMap();

private:
    virtual ~CommandMap() SAL_THROW(());
};

class CommandMapSupplier
{
public:
    virtual rtl::Reference< CommandMap > getCommandMap() = 0;
};

} }

#endif // INCLUDED_UCB_RAPOFFLINECOMMANDMAP_HXX
