/*************************************************************************
 *
 *  $RCSfile: shellprp.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: nf $ $Date: 2001/04/23 13:59:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <string.hxx>
#include <shellprp.hxx>

const char *szDirSeparator[] =
{
	"/",
	"/",
	"\\",
	":",
	NULL
};

const char *szQuote[] =
{
	"\"",
	"\"",
	"`",
	"`",
	NULL
};

const char *szCommandSeparator[] =
{
	"; ",
	"; ",
	"\n",
	"\n",
	NULL
};


ShellProperties::ShellProperties()
{
	char *szUseShell = getenv("USESHELL");

	if ( szUseShell ) {
		ByteString sShell(szUseShell);
		sShell.ToLowerAscii();
		if ( (sShell == "csh" || sShell == "tcsh") )
			m_eShell = CSH;
		else if ( sShell == "sh" || sShell == "bash" )
			m_eShell = SH;
		else if ( sShell == "mpw" )
			m_eShell = MPW;
		else if ( sShell == "4nt" || sShell == "JP4NT" )
			m_eShell = JP4NT;
		else
			m_eShell = UNSET;
	}

	if ( !szUseShell || m_eShell == UNSET ) {
#if defined (UNX)
		m_eShell = CSH;
#elif defined(MAC)
		m_eShell = MPW;
#else
		m_eShell = JP4NT;
#endif
	}
}

ShellProperties::~ShellProperties()
{
}

ByteString
ShellProperties::getDirSeparator()
{
	return ByteString(szDirSeparator[m_eShell]);
}

ByteString
ShellProperties::getCommandSeparator()
{
	return ByteString(szCommandSeparator[m_eShell]);
}

ByteString
ShellProperties::getQuote()
{
	return ByteString(szQuote[m_eShell]);
}

ByteString
ShellProperties::getEnvSetter(const ByteString& sVariable, const ByteString& sValue)
{
	ByteString sStr;

	switch ( m_eShell ) {
		case CSH:
			sStr = 	"setenv ";
			sStr += sVariable;
			sStr += " ";
			sStr += sValue;
			break;
		case SH:
			sStr = 	sVariable;
			sStr +=	"=";
			sStr += sValue;
			sStr +=	"; export ";
			sStr += sVariable;
			break;
		case JP4NT:
		case MPW:		// FIXME: fix for mpw Shell
			sStr = 	"set ";
			sStr +=	sVariable;
			sStr += "=";
			sStr += sValue;
			break;
		default:
			sStr = "";
	}
	return sStr;
}

ByteString
ShellProperties::getEnvUnsetter(const ByteString& sVariable)
{
	ByteString sStr;

	switch ( m_eShell ) {
		case CSH:
			sStr = 	"unsetenv ";
			sStr += sVariable;
			sStr += " >& /dev/null";
			break;
		case SH:
			sStr = 	"unset ";
			sStr +=	sVariable;
			sStr += " > /dev/null 2>&1";
			break;
		case JP4NT:
		case MPW:		// FIXME: fix for mpw Shell
			sStr = 	"unset ";
			sStr +=	sVariable;
			sStr += " >& NUL";
			break;
		default:
			sStr = "";
	}
	return sStr;
}

ByteString
ShellProperties::getAliasSetter(const ByteString& sCommand, const ByteString& sAction)
{
	ByteString sStr;

	switch ( m_eShell ) {
		case CSH:
			sStr = 	"alias ";
			sStr += sCommand;
			sStr += " ";
			sStr += sAction;
			break;
		case SH:
			sStr = 	"alias ";
			sStr += sCommand;
			sStr += "=";
			sStr += sAction;
			break;
		case JP4NT:
		case MPW:		// FIXME: fix for mpw Shell
			sStr = 	"alias ";
			sStr +=	sCommand;
			sStr += "=";
			sStr += sAction;
			break;
		default:
			sStr = "";
	}
	return sStr;
}

ByteString
ShellProperties::getAliasUnsetter(const ByteString& sCommand)
{
	ByteString sStr;

	switch ( m_eShell ) {
		case CSH:
			sStr = 	"unalias ";
			sStr += sCommand;
			sStr += " >& /dev/null";
			break;
		case SH:
			sStr = 	"unalias ";
			sStr += sCommand;
			sStr += " > /dev/null 2>&1";
			break;
		case JP4NT:
		case MPW:		// FIXME: fix for mpw Shell
			sStr = 	"unalias ";
			sStr += sCommand;
			sStr += " >& NUL";
			break;
		default:
			sStr = "";
	}
	return sStr;
}

ByteString
ShellProperties::getErrorMessageOrExit(const ByteString& sMessage)
{
	// just use shell exit command if sMessage is empty
	ByteString sStr;
	ByteString sMesg;

	if ( sMessage == "" ) {
		switch ( m_eShell ) {
			case CSH:
			case SH:
				sMesg = "exit";
				break;
			case JP4NT:
				sMesg = "quit";
				break;
			default:
				sMesg = "";
		}
	}
	else {
		sMesg = "echo ";
		sMesg += sMessage;
	}


	switch ( m_eShell ) {
		case CSH:
			sStr = 	"if ( $status != 0 ) ";
			sStr += sMesg;
			break;
		case SH:
			sStr = "if [ $? -ne 0 ]\nthen ";
			sStr += sMesg;
			sStr += "\nfi";
			break;
		case JP4NT:
			sStr = "if \"%?\" != \"0\" ";
			sStr += sMesg;
			break;
		case MPW:
			sStr = " ";
			break;
	default:
		sStr = "";
	}

	return sStr;
}


ShellProperties&
ShellProperties::getShellProperties()
{
	static ShellProperties theShellProperties;

	return theShellProperties;
}

