/*************************************************************************
 *
 *  $RCSfile: include.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/15 17:55:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// cl /AH /F 8000 include.cxx

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../getopt.h"

#include <stdlib.h>

// Miscellaneous constants
#ifdef MAX_PATH
#undef MAX_PATH
#endif // MAX_PATH
#define MAX_PATH 255

#ifdef MAX_LINE
#undef MAX_LINE
#endif // MAX_LINE
#define MAX_LINE 16384

#ifdef BUFFER_SIZE
#undef BUFFER_SIZE
#endif // BUFFER_SIZE
#define BUFFER_SIZE 512

#define TRUE 1
#define FALSE 0

char pIncludeFile[MAX_PATH];
char pDefString[MAX_PATH];
char pNameClass[MAX_PATH];
int bIncludeState = 0;

int bFindDefs = FALSE;
int bDefine = FALSE;
int bInc = FALSE;

int SearchClass ( char* pClass, FILE* pFp );

int PrintInclude()
{
	if ( strcmp ( "", pIncludeFile ))
	{
		fprintf ( stdout, "#ifndef %s \n", pDefString, pNameClass );
		if (bFindDefs) {
			fprintf ( stdout, "#define %s\n", pDefString );
		};
		if ( bIncludeState )
			fprintf ( stdout, "#include \"%s\"\n", pIncludeFile );
		else
			fprintf ( stdout, "#include <%s>\n", pIncludeFile );
		fprintf ( stdout, "#endif\n\n");
	}

	return 0;
}

int PrintDefine(FILE* pFp)
{
	char aLineBuffer[BUFFER_SIZE];
	char aBuffer[BUFFER_SIZE];
	char *pSearchClassName;
	char* pChar;
	char pOldStr[MAX_PATH];
	char pSecStr[MAX_PATH];
	char pAlreadyStr[MAX_PATH] ="";

	// das gesamte File nochmal einlesen,
	// die Zeilen, die das gesuchte HeaderFile beinhalten
	// genauer angucken, und das Letzte Define rausschreiben

	while ( fgets ( aLineBuffer, MAX_LINE, pFp ) != NULL )
	{
		(void) strcpy ( aBuffer, aLineBuffer );
		(void) strtok ( aBuffer, " \t" ); // HeaderName
		pSearchClassName = strtok ( NULL, " \t" );	 // Typ
		pSearchClassName = strtok ( NULL, " \t" );	 // Klasse

		if ( !strcmp ( pSearchClassName, pNameClass ) )
		{
			// das letzte Define suchen !
			pChar = strtok ( NULL, "\t" ); // Type
			do
			{
				strcpy (pSecStr, pOldStr );
				strcpy (pOldStr, pChar );
				pChar = strtok ( NULL, "\t" );
			}
			while ( pChar != NULL );
			fprintf ( stdout, "// found #define %s\n", pSecStr );
		}

	}
	return 0;
}

int SearchDefines ( FILE *pFp )
{
	char aLineBuffer[BUFFER_SIZE];
	char aBuffer[BUFFER_SIZE];
	char *pHeaderFileName;
	char* pChar;
	char pOldStr[MAX_PATH];
	char pSecStr[MAX_PATH];
	char pAlreadyStr[MAX_PATH] ="";

	// das gesamte File nochmal einlesen,
	// die Zeilen, die das gesuchte HeaderFile beinhalten
	// genauer angucken, und das Letzte Define rausschreiben

	//(void) strcpy ( pChar, "NULL");
	while ( fgets ( aLineBuffer, MAX_LINE, pFp ) != NULL )
	{
		(void) strcpy ( aBuffer, aLineBuffer );
		pHeaderFileName = strtok ( aBuffer, " \t" );

		if ( !strcmp ( pHeaderFileName, pIncludeFile ) )
		{
			// das letzte Define suchen !
			pChar = strtok ( NULL, "\t" ); // class
			pChar = strtok ( NULL, "\t" );
			if ( strcmp ( pChar, pNameClass ))
			{
				do
				{
					strcpy (pSecStr, pOldStr );
					strcpy (pOldStr, pChar );
					pChar = strtok ( NULL, "\t" );
				}
				while ( pChar != NULL );
				//fprintf ( stderr, "Debug: #define %s\n", pOldStr );
				if ( strcmp ( pAlreadyStr, pSecStr ))
						fprintf ( stdout, "#define %s\n", pSecStr );
				strcpy ( pAlreadyStr, pSecStr );
			}
		}

	}
	PrintInclude();
	return 1;
}

int usage()
{
	//fprintf (stderr,"include [-sw|-sc|-sd|-sm|-sim|-sch|-my|-l] Klassenname \n" );
	fprintf (stderr,"include [-p{sw|sc|sd|sm|sim|sch|my|l}] [-c <class.lst>] [-x] [-d] Klassenname \n" );
	exit (0);
	return 0;
}

int
#ifdef WNT
__cdecl
#endif
main ( int argc, char** argv )
{
	char* pChar, *pToken;
	char pSearchfile[MAX_PATH];
	char *pClassName;
	FILE* pFp;
	int c;
	int disgit_optind = 0;
	char pFileName[MAX_PATH];
	int bUseOwnFile = 0;

#ifdef UNX
	strcpy( pSearchfile,  "/class.lst" );
#else
	strcpy( pSearchfile,  "\\class.lst" );
#endif
	strcpy( pFileName, "" );
	while (1)
	{
		int this_option_optind = optind ? optind :1;
		int option_index = 0;
		static struct option long_options[] =
		{
			{"prj",1,0,0 },
			{"file",1,0,0},
			{0,0,0,0 }
		};
		c = getopt_long ( argc, argv, "?hp:c:s:f:xd",
				long_options, &option_index );
		if ( c == EOF)
			break;

		switch (c)
		{
			case 'h' :
				usage();
				break;
			case '?' :
				usage();
				break;
			case 'c' :
				strcpy( pSearchfile, optarg );
				bUseOwnFile = 1;
				bIncludeState = 1;
				break;
			case 'd' :
				bDefine = TRUE;
				break;
			case 'f' :
					(void) strcpy ( pIncludeFile, optarg );
#if OSL_DEBUG_LEVEL > 1
					fprintf( stderr, "Include File %s\n", pIncludeFile );
#endif
					bInc = TRUE;
				break;
			case 'p' :
				if ( !strcmp ( "sw", optarg ))
				{
					strcpy ( pSearchfile, "\\sw.lst" );
					//fprintf ( stderr, "Writer !\n");
				} else
				if ( !strcmp ( "sc", optarg ))
				{
					strcpy ( pSearchfile, "\\sc.lst" );
				} else
				if ( !strcmp ( "sd", optarg ))
				{
				} else
				if ( !strcmp ( "sm", optarg ))
				{
					strcpy ( pSearchfile, "\\sm.lst" );
				} else
				if ( !strcmp ( "sim", optarg ))
				{
					strcpy ( pSearchfile, "\\sim.lst" );
				} else
				if ( !strcmp ( "sch", optarg ))
				{
					strcpy ( pSearchfile, "\\sch.lst" );
				} else
				if ( !strcmp ( "my", optarg ))
				{
					strcpy ( pSearchfile, "\\my.lst" );
				} else
				if ( !strcmp ( "l", optarg ))
				{
					strcpy ( pSearchfile, "\\l.lst" );
				}
				break;
			case 's' :
				if ( !strcmp ( "w", optarg ))
				{
					strcpy ( pSearchfile, "\\sw.lst" );
					//fprintf ( stderr, "Writer !\n");
				} else
				if ( !strcmp ( "c", optarg ))
				{
					strcpy ( pSearchfile, "\\sc.lst" );
				} else
				if ( !strcmp ( "d", optarg ))
				{
					strcpy ( pSearchfile, "\\sd.lst" );
				} else
				if ( !strcmp ( "m", optarg ))
				{
					strcpy ( pSearchfile, "\\sm.lst" );
				} else
				if ( !strcmp ( "im", optarg ))
				{
					strcpy ( pSearchfile, "\\sim.lst" );
				} else
				if ( !strcmp ( "ch", optarg ))
				{
					strcpy ( pSearchfile, "\\sch.lst" );
				}
				break;
			case 'x' :
				bFindDefs = TRUE;
				//fprintf ( stderr, "Extra Defines \n" );
				break;
			default :
				fprintf ( stderr, "???????????\n" );
		}
	}
	if ( optind < argc )
	{
		while (optind < argc)
		{
#			ifdef DEBUG_VERBOSE
			printf ("%s ", argv[optind]);
#			endif
			int nLength = strlen( argv[optind] ) +1;
			pClassName = (char *)malloc ( nLength );
			(void) strcpy ( pClassName, argv[optind] );
			optind++;
		}
		printf ("\n");
	}
	else
	{
		if (!bInc)
		{
			usage();
			//fprintf ( stderr, "fehlendes Argument !\n" );
			exit(0);
		}
		else
		{
			pClassName = (char *)malloc ( 7 );
			strcpy( pClassName,"Dummy");
		}
	}

	pChar = getenv ( "SOLARINC" );
	if ( !pChar  )
	{
			fprintf( stderr, "no Environment set !\n" );
			exit( 0 );
	}
	pToken = strtok ( pChar, " " );
	do
	{
		pToken +=2;
		//fprintf( stderr, "token : %s \n", pToken );
		if ( pToken && !bUseOwnFile )
			(void) strcpy ( pFileName, pToken );
		(void) strcat ( pFileName, pSearchfile );
		//fprintf( stderr, "Searching : %s \n", pSearchfile );

		if (( pFp = fopen ( pFileName, "r" )) == NULL )
		{
			pToken = strtok ( NULL, " " );
		}
		else
		{
			pToken = NULL;
				SearchClass( pClassName, pFp );

			/*if ( bFindDefs )
			{
				fseek( pFp, 0L, SEEK_SET);
				SearchDefines(pFp);
			}
			else if ( bDefine )
			{
				fseek( pFp, 0L, SEEK_SET);
				PrintDefine(pFp);
			}
			else if ( bInc )
			{
				fseek( pFp, 0L, SEEK_SET);
				SearchDefines(pFp);
			}
			else
				PrintInclude();*/
		}
	}
	while ( pToken );
	return 0;
}

int SearchClass ( char* pClass, FILE* pFp )
{
	char aLineBuffer[BUFFER_SIZE], aBuffer[BUFFER_SIZE];
	//char aBuffer[BUFFER_SIZE];
	char *pHeaderFileName;
	char *pDefine;
	char *pClassName;
	char *pResult;
	while ( fgets ( aLineBuffer, MAX_LINE, pFp ) != NULL )
	{
		(void) strcpy ( aBuffer, aLineBuffer );
		pHeaderFileName = strtok ( aBuffer, " \t" );

		//pClassName = strtok ( NULL, " \t" );  // Den Type ueberlesen
		strtok ( NULL, " \t" );  // Den Type ueberlesen
		pClassName = strtok ( NULL, " \t" );
		pDefine = strtok ( NULL, " \t" );

		if ( !strcmp ( pClassName, pClass ))
		{
			(void) strcpy ( pDefString, pDefine );
			if (bDefine) {
				fprintf ( stdout, "// found #define %s\n\n", pDefString);
				continue;
			};
			(void) strcpy ( pIncludeFile, pHeaderFileName );
			(void) strcpy ( pNameClass, pClassName );
			//if (bFindDefs || bInc) {
			if (bFindDefs) {
				PrintDefine(pFp);
				continue;
			};
			/*fprintf ( stdout, "#ifndef %s\n", pDefine );

			char aBuf[MAX_PATH];

			//fprintf ( stderr, "#include <%s>\n", pHeaderFileName );
			(void) strcpy ( aBuf, pHeaderFileName );
			pResult = strtok ( aBuf, "\\" );

			do {
				if (pResult) strcpy (pttt, pResult);
			}
			while ( (pResult = strtok ( NULL, "\\" )) != NULL );
			for ( i=0; i<strlen(pttt); i++)
				pttt[i] = tolower(pttt[i]);
			fprintf ( stdout, "#include <%s>\n", pttt );
			fprintf ( stdout, "#endif\n" );*/
			PrintInclude();
			//return TRUE;
		}
	}
	return FALSE;
}

