/*************************************************************************
 *
 *  $RCSfile: dirsync.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 17:03:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdio.h>

#include <string.hxx>
#include <list.hxx>

#include <../fattr.hxx>


static ByteString aAccessDelimiter( DirEntry::GetAccessDelimiter(), gsl_getSystemTextEncoding());

DECLARE_LIST( DirFileList, FileAttribute * );
DECLARE_LIST( DirectoryList, ByteString * );

class DirSync
{
	DirEntry	aSourceDir;
	DirEntry	aDestDir;
	DirFileList *pList;
	DirectoryList *pDirList;
	ULONG		nLen;
	BOOL		bSub;
	BOOL		bForce;

	BOOL		bError;

	void		Impl_Init();
	void		RemoveFiles( Dir &rSrcDir, Dir &rDestDir );
	void		ScanDir( DirEntry &rDir );

protected:
	virtual void Print( ByteString& );
	virtual void Print( const char* );
public:
				DirSync( ByteString &rSourcePath, ByteString &rDestPath );

	BOOL		Execute();
	void		SetForceMode( BOOL bFlag ){ bForce = bFlag;}
	void		SetSubDirMode( BOOL bFlag ){ bSub = bFlag;}
};

DirSync::DirSync( ByteString &rSrc, ByteString &rDest ) :
	bSub( FALSE ), bForce( FALSE ),
	bError( FALSE )

{
	aSourceDir = DirEntry( String( rSrc, gsl_getSystemTextEncoding()));
	aDestDir = DirEntry( String( rDest, gsl_getSystemTextEncoding()) );
	nLen = ByteString( aSourceDir.GetFull(), gsl_getSystemTextEncoding()).Len();
	Impl_Init();
}

void DirSync::Impl_Init()
{
	pDirList = new DirectoryList;
	pList = new DirFileList;

}

void DirSync::Print( ByteString& rStr )
{
	fprintf( stderr, "%s", rStr.GetBuffer());
}

void DirSync::Print( const char* pStr )
{
	fprintf( stderr, "%s", pStr);
}
/*
 * Den Verzeichnisbaum einmal komplett reinlutschen
 *
 */

void DirSync::ScanDir( DirEntry &rDir )
{
	Dir aDir( rDir );
	ULONG nCount = aDir.Count();

	Print(".");
	for ( USHORT i=0; i<nCount; i++ )
	{
		DirEntry aDirEntry = aDir[i];
		FileAttribute *pFile = new FileAttribute( aDirEntry );
		if ( pFile->GetKind() == FSYS_KIND_FILE )
		{
			pList->Insert( pFile, LIST_APPEND );
		}
		else if ( bSub && (pFile->GetKind() == FSYS_KIND_DIR ))
		{
			if ( ByteString( pFile->GetDirEntry().GetName(), gsl_getSystemTextEncoding()) != ".." &&
					ByteString( pFile->GetDirEntry().GetName(), gsl_getSystemTextEncoding()) != "." )
			{
				pList->Insert( pFile, LIST_APPEND );
				ByteString *pName = new ByteString( pFile->GetDirEntry().GetFull(), gsl_getSystemTextEncoding());
				pName->Erase(0, (USHORT)nLen+1 );
				pDirList->Insert( pName, LIST_APPEND );
				DirEntry aTmpEntry(pFile->GetDirEntry());
				ScanDir( aTmpEntry );
			}
		}
	}
}

/*
 * Einmal das Kopieren lostreten
 *
 */

BOOL DirSync::Execute()
{
	BOOL bCopy = FALSE;
	BOOL bDir = FALSE;

	if ( !aSourceDir.Exists() )
	{
		bError = TRUE; return FALSE;
	}
	else
	{
		if ( FileStat(aSourceDir).GetKind() == FSYS_KIND_DIR )
		{
			Print( "Scanning Directories:");
			ScanDir( aSourceDir );
			Print( "\n");
		}
		else
		{
			bError = TRUE;
			return FALSE;
		}

	}

	if ( bError )
		return FALSE;

	ByteString aDestPath( aDestDir.GetFull(), gsl_getSystemTextEncoding());
	if ( !aDestDir.Exists() )
		aDestDir.MakeDir();
	ULONG nCount = pList->Count();

	FileAttribute *pFile = pList->GetObject(0);

 	for ( ULONG i=0; i<nCount; i++ )
	{
		pFile = pList->GetObject(i);
		if ( pFile->GetKind() == FSYS_KIND_DIR )
			bDir = TRUE;
		ByteString aName( pFile->GetDirEntry().GetFull(), gsl_getSystemTextEncoding());
#ifndef UNX
		if ( aName.GetChar( 1 ) == ':' )
		{
			USHORT nLen = ByteString( aSourceDir.GetFull(), gsl_getSystemTextEncoding()).Len();
			aName.Erase(0, nLen); // c:\SourceDir abschneiden
		}
#else
		USHORT nLen = ByteString( aSourceDir.GetFull(), gsl_getSystemTextEncoding()).Len();
		aName.Erase(0, nLen); // /develop/update/dev abschneiden

#endif
		ByteString sTmpDest( aDestPath );
		sTmpDest += aAccessDelimiter;
		sTmpDest += aName;
		DirEntry aDestination( String( sTmpDest, gsl_getSystemTextEncoding()));
		if ( !aDestination.Exists() )
		{
			bCopy = TRUE; bDir = FALSE;
		}

		if ( bDir )
		{
			if ( !aDestination.Exists() )
			{
				fprintf( stderr, "Md: %s", ByteString( aDestination.GetFull(), gsl_getSystemTextEncoding()).GetBuffer());
				aDestination.MakeDir();
			}
			bDir = FALSE;
		}

		if ( bCopy )
		{
			FileCloner aCloner( pFile->GetDirEntry(), aDestination );
			if ( !bForce )
			{
				aCloner.SetUpdateCopy();
				aCloner.SetDiffCopy();
			}
			aCloner.Execute();
			if ( aCloner.Copied() )
			{
				fprintf( stderr, "Copy: %s\n", ByteString( aCloner.GetTarget().GetFull(), gsl_getSystemTextEncoding()).GetBuffer());
			}
            else
            {
                fprintf( stderr,"Error while copying %s\n", ByteString( aCloner.GetTarget().GetFull(), gsl_getSystemTextEncoding()).GetBuffer());
                exit(1);
            }
			bCopy = FALSE;
		}
	}
	// hier muesste wohl der Directory Abgleich passieren
	// ueber beide Directries muss iteriert werden und im
	// Zielverzeichnis weggeschmissen werden
	// also bei jeder Datei im Zielverzeichnis wird geguckt
	// ob diese im Sourceverzeichnis existiert, wenn nicht dann
	// loeschen.

	Dir a1Dir( aSourceDir );
	Dir a2Dir( aDestDir );
	RemoveFiles( a1Dir, a2Dir );

	for ( ULONG k=0; k<pDirList->Count(); k++ )
	{
		DirEntry aSrc = aSourceDir + DirEntry( *pDirList->GetObject(k));
		DirEntry aDes = aDestDir + DirEntry( *pDirList->GetObject(k));
		//fprintf( stderr, "Dir : %s\n", pDirList->GetObject(k)->GetStr());
		Dir a1Dir( aSourceDir );
		Dir a2Dir( aDestDir );
		RemoveFiles( a1Dir, a2Dir );
	}

	return TRUE;
}

/*
 * in dieser Funktion werden die ueberfluessigen Dateien im Zielverzeichnis
 * geloescht
 *
 */

void DirSync::RemoveFiles( Dir &rSrcDir, Dir &rDestDir )
{
	BOOL bFound;
	ULONG nCount = rDestDir.Count();

	//fprintf(stderr, "RemoveFiles : %s %s \n", rSrcDir.GetFull().GetStr(),
			//rDestDir.GetFull().GetStr());
	for ( USHORT i=0; i<nCount; i++ )
	{
		bFound = FALSE;
		DirEntry aEntry = rDestDir[i];

		if ( FileStat( aEntry ).GetKind() != FSYS_KIND_DIR )
		{
			ByteString aFileName( aEntry.GetName(), gsl_getSystemTextEncoding());

			USHORT nSrcCount = rSrcDir.Count();
			for ( USHORT j=0; j<nSrcCount; j++)
			{
				DirEntry aSrcEntry = rSrcDir[j];
				ByteString aSrcFileName( aSrcEntry.GetName(), gsl_getSystemTextEncoding());
				//fprintf( stderr, "Compare: %s %s\n", aFileName.GetStr(),
				//		aSrcFileName.GetStr());
				if ( aFileName == aSrcFileName )
				{
					bFound = TRUE;
					break;
				}
			}
			// wenn im Source nicht gefunden, dann loeschen !!!
			if ( !bFound )
			{
				fprintf( stderr, "Erase: %s\n", ByteString( aEntry.GetFull(), gsl_getSystemTextEncoding()).GetBuffer());
				aEntry.Kill();
			}
		}
	}
}

/*
 * Driver fuer DirSync
 * -------------------------------------------------------
 *
 */

int usage( char** ppArgs )
{
	fprintf( stderr, "%s (MH)  -- Usage : \n", ppArgs[0] );
	fprintf( stderr, "%s [-s|a|f|n] SourceDirectory TargetDirectory\n",
																ppArgs[0] );
	fprintf( stderr, "\t-a: Adjust Time to 2 Seconds \n" );
	fprintf( stderr, "\t-s: Copy SubDirectories \n" );
	fprintf( stderr, "\t-f: Copy everything \n" );
	fprintf( stderr, "\t-n: Don't delete obsolete files on Target Directory\n" );

	return 0;
}
int
#ifdef WNT
__cdecl
#endif
main( int argc, char **argv )
{
	BOOL bSubDirs = FALSE;
	BOOL bAdjust = FALSE;
	BOOL bForce = FALSE;
	BOOL bNonExists = FALSE;
	ByteString aSourcePath, aDestPath, aPath;

	if ( argc > 1 )
	{
		ByteString aOption;
		for ( USHORT i=1; i< argc; i++ )
		{
			aOption = argv[i];
			if ( aOption == "-s" )
				bSubDirs = TRUE;
			else
			if ( aOption == "-a" )
				bAdjust = TRUE;
			else
			if ( aOption == "-f" )
				bForce = TRUE;
			else
			if ( aOption == "-n" )
				bNonExists = TRUE;
			else
				aPath = aOption;

			if ( aSourcePath == "" )
				aSourcePath = aPath;
			else
				aDestPath = aPath;
		}
	}
	else
		return usage( argv );

	DirSync *pDSync = new DirSync( aSourcePath, aDestPath );
	// alle Header aus $PRJ\inc delivern !!
	//pDeliv->SetAll( TRUE );
	pDSync->SetForceMode( bForce );
	pDSync->SetSubDirMode( bSubDirs );
	if (!pDSync->Execute())
	{
		fprintf( stderr, "Fehler aufgetreten !\n");
		return 1;
	}
	delete pDSync;
	return 0;
}
