/*************************************************************************
 *
 *  $RCSfile: StreamObserver.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:54:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package stardiv.controller;

import java.util.Observer;
import java.util.Observable;
import java.net.URL;
import java.net.MalformedURLException;
import sun.net.ProgressData;
import sun.net.ProgressEntry;


/** 
 *
 * @version    $Version: 1.0 $
 * @author     Markus Meyer
 *
 */
public class StreamObserver implements Observer
{
	public StreamObserver()
	{
		ProgressData.pdata.addObserver( this );
	}

	public void dispose()
	{
		ProgressData.pdata.deleteObserver( this );
	}

	static long nLastTime;
	public void update( Observable aObj, Object aArg )
	{
		try
		{
			nLastTime = System.currentTimeMillis();
			
			String aStatus = null;
			ProgressEntry pEntry = (ProgressEntry)aArg;
			switch( pEntry.what )
			{
				case ProgressData.CONNECTED:
					{
						try
						{
							URL aURL = new URL( pEntry.label );
							aStatus = "Connect: Host " + aURL.getHost() + " contacted. Waiting for reply...";
						}
						catch( MalformedURLException e )
						{
							aStatus = "Connect: " + pEntry.label;
						}
					}
				break;

				case ProgressData.UPDATE:
					if( System.currentTimeMillis() - nLastTime > 3000 )
						// Only 1 update / 3s
						return;
					if( pEntry.need != 0 )
					{
						// Java kommt mit dem letzten Byte nicht r"uber
						aStatus = "Transfered: " + pEntry.label + " - ";
						int nPercent = (int)(((long)pEntry.read * 100) / pEntry.need);
						aStatus += String.valueOf( nPercent ) + "% of ";
						if( pEntry.need >= 1000 )
							aStatus += String.valueOf( pEntry.need / 1000 ) + "K ";
						else
							aStatus += String.valueOf( pEntry.need );
						aStatus += "bytes.";
					}
					else
						aStatus = "Transfered: " + pEntry.label;
				break;

				case ProgressData.NEW:
					aStatus = "Try: " + pEntry.label;
				break;
				case ProgressData.DELETE:
					aStatus = "Done: " + pEntry.label;
				break;
			}
			if( aStatus != null )
			{
				/*
				switch( pEntry.type )
				{
					case ProgressEntry.HTML:
						aStatus += " (Html)";
					break;
					case ProgressEntry.IMAGE:
						aStatus += " (Image)";
					break;
					case ProgressEntry.CLASS:
						aStatus += " (Class)";
					break;
					case ProgressEntry.AUDIO:
						aStatus += " (Audio)";
					break;
				}
				*/

				nLastTime = System.currentTimeMillis();
				
				
				//showStatus( aStatus ); 	//fuehrt zum Deadlock unter Solaris Sparc
											// sync. Aufruf native->java->native
			}

		}
		catch( Throwable e )
		{
		}
	}

	public void showStatus( String pStatus )
	{
		if( pStatus != null )
		{
			System.out.println( pStatus );
		}
	}
}



