/*************************************************************************
 *
 *  $RCSfile: delcfg.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ok $ $Date: 2000/11/10 12:35:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _DELCFG_HXX
#define _DELCFG_HXX

#ifndef _SV_CONFIG_HXX //autogen
#include <tools/config.hxx>
#endif

enum DeliverState	{ NOT_AVAILABLE = 0, AVAILABLE = 1, PREPARE = 2 };

class DeliverConfig
{
		ByteString 			m_aFileName;

		ByteString			m_aBuild;
		DeliverState		m_eNormalState;
		ByteString			m_aNormalDate;
		DeliverState		m_eBigFileState;
		ByteString			m_aBigFileDate;
		DeliverState		m_eChannelState;
		ByteString			m_aChannelDate;

		ByteString			m_aFiles;
		ByteString			m_aDefaultSize;
		ByteString			m_aDefaultTempSize;
		ByteString			m_aMinimalSize;
		ByteString			m_aMinimalTempSize;
		ByteString			m_aWorkstationSize;

		ByteString			m_aComment;
		BOOL				m_bAgent;

		BOOL 				m_bExists;

public:
			DeliverConfig( const ByteString& rFileName );

		BOOL 			Exists() const 							{ return m_bExists; }
		const ByteString&	GetIniName() const						{ return m_aFileName; }

		void 			Read();
		void 			Write();

		void			SetBuild(const ByteString& rNew)			{ m_aBuild = rNew; }
		const ByteString&	GetBuild() const						{ return m_aBuild; }

		void			SetNormalState(DeliverState eNew) 		{ m_eNormalState = eNew; }
		DeliverState	GetNormalState() const			 		{ return m_eNormalState; }
		void			SetBigFileState(DeliverState eNew) 		{ m_eBigFileState = eNew; }
		DeliverState	GetBigFileState() const			 		{ return m_eBigFileState; }
		void			SetChannelState(DeliverState eNew) 		{ m_eChannelState = eNew; }
		DeliverState	GetChannelState() const			 		{ return m_eChannelState; }

		void			SetNormalDate(const ByteString& rNew) 	{ m_aNormalDate = rNew; }
		const ByteString&	GetNormalDate() const			 		{ return m_aNormalDate; }
		void			SetBigFileDate(const ByteString& rNew) 	{ m_aBigFileDate = rNew; }
		const ByteString&	GetBigFileDate() const			 		{ return m_aBigFileDate; }
		void			SetChannelDate(const ByteString& rNew) 	{ m_aChannelDate = rNew; }
		const ByteString&	GetChannelDate() const			 		{ return m_aChannelDate; }

		void			SetFiles(const ByteString& rNew) 			{ m_aFiles = rNew; }
		void			SetDefaultSize(const ByteString& rNew) 	{ m_aDefaultSize = rNew; }
		void			SetDefaultTempSize(const ByteString& rNew){ m_aDefaultTempSize = rNew; }
		void			SetMinimalSize(const ByteString& rNew) 	{ m_aMinimalSize = rNew; }
		void			SetMinimalTempSize(const ByteString& rNew){ m_aMinimalTempSize = rNew; }
		void			SetWorkstationSize(const ByteString& rNew){ m_aWorkstationSize = rNew; }

		void			SetComment(const ByteString& rNew) 		{ m_aComment = rNew; }
		const ByteString&	GetComment() const			 			{ return m_aComment; }

		void			SetAgent(BOOL bNew)   					{ m_bAgent = bNew; }
		BOOL			IsAgent() const				 			{ return m_bAgent; }
};

#endif // _DELCFG_HXX

