/*************************************************************************
 *
 *  $RCSfile: slchghdl.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: ka $ $Date: 2001/10/23 11:54:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#include <svtools/filedlg.hxx>
#ifndef _SV_GROUP_HXX //autogen
#include <vcl/group.hxx>
#endif
#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif

#include "slidechg.hxx"
#include "slidechg.hrc"
#include "app.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"
#include "sdattr.hxx"
#include "sdresid.hxx"
#include "sdview.hxx"
#include "drawdoc.hxx"

using namespace ::com::sun::star;

// -----------------------------------------------------------------------

IMPL_LINK( SdSlideChangeWin, ClickPreviewHdl, void *, EMPTYARG )
{
	BOOL bCheck = !aBtnPreview.IsChecked();
	aBtnPreview.Check( bCheck );

	SfxBoolItem aItem( SID_PREVIEW_WIN, bCheck );
	GetBindings().GetDispatcher()->Execute( 
		SID_PREVIEW_WIN, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );

	return( 0L );
}

// -----------------------------------------------------------------------

IMPL_LINK( SdSlideChangeWin, ClickUpdateHdl, void *, EMPTYARG )
{
	bUpdate = !aBtnUpdate.IsChecked();
	aBtnUpdate.Check( bUpdate );

	if( bUpdate )
	{
		SfxBoolItem aItem( SID_SLIDE_CHANGE_STATE, TRUE );
		GetBindings().GetDispatcher()->Execute( 
			SID_SLIDE_CHANGE_STATE, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );
	}

	return( 0L );
}

// -----------------------------------------------------------------------

IMPL_LINK( SdSlideChangeWin, ClickAssignHdl, void *, EMPTYARG )
{
	SfxBoolItem aItem( SID_SLIDE_CHANGE_ASSIGN, TRUE );
	GetBindings().GetDispatcher()->Execute( 
		SID_SLIDE_CHANGE_ASSIGN, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );

	return( 0L );
}

// -----------------------------------------------------------------------

IMPL_LINK( SdSlideChangeWin, SelectEffectHdl, void *, p )
{
	if( p != &aCtlEffect )
		FillValueSet();

	if( aLbSpeed.GetSelectEntryPos() == LISTBOX_ENTRY_NOTFOUND )
		aLbSpeed.SelectEntryPos( 1 );

	// Favorit ?
	USHORT nPos = aLbEffect.GetSelectEntryPos();
	if( nPos == 0 )
	{
		USHORT nId  = aCtlEffect.GetSelectItemId();
		if( nId != 1 )
			aLbSound.SelectEntry( GetSoundById( nId ) );
		aBtnSound.SetState( nId == 1 ? STATE_NOCHECK : STATE_CHECK );
		ClickSoundHdl( NULL );
	}
	return( 0L );
}

// -----------------------------------------------------------------------
//	In Abhaengigkeit vom Sound werden Favoriten gesetzt oder entfernt
// -----------------------------------------------------------------------

IMPL_LINK( SdSlideChangeWin, SelectSoundHdl, void *, p )
{
	presentation::FadeEffect eFE = GetFadeEffect();

	if( p )
	{
		USHORT nPos = aLbEffect.GetSelectEntryPos();
		SetFadeEffect( eFE );
	}
	else
	{
		if( eFE != presentation::FadeEffect_NONE )
			SetFadeEffect( eFE );
	}
	return( 0L );
}

// -----------------------------------------------------------------------

IMPL_LINK( SdSlideChangeWin, ClickAutoHdl, ImageButton *, pBtn )
{
	if( pBtn )
		pBtn->Check( !pBtn->IsChecked() );

	BOOL bCheck = aBtnAuto.IsChecked();

	if( bCheck )
	{
		aBtnManual.Check( FALSE );
		aBtnSemi.Check( FALSE );
		aFldTime.Enable();
		if( pBtn )
			aFldTime.Reformat();
	}
	else
	{
		aFldTime.Enable( FALSE );
		aFldTime.SetEmptyTime();
	}

	return( 0L );
}

// -----------------------------------------------------------------------

IMPL_LINK( SdSlideChangeWin, ClickSemiHdl, ImageButton *, pBtn )
{
	if( pBtn )
		pBtn->Check( !pBtn->IsChecked() );

	BOOL bCheck = aBtnSemi.IsChecked();

	if( bCheck )
	{
		aBtnManual.Check( FALSE );
		aBtnAuto.Check( FALSE );
		aFldTime.Enable( FALSE );
		aFldTime.SetEmptyTime();
	}

	return( 0L );
}

// -----------------------------------------------------------------------

IMPL_LINK( SdSlideChangeWin, ClickManualHdl, ImageButton *, pBtn )
{
	if( pBtn )
		pBtn->Check( !pBtn->IsChecked() );

	BOOL bCheck = aBtnManual.IsChecked();

	if( bCheck )
	{
		aBtnAuto.Check( FALSE );
		aBtnSemi.Check( FALSE );
		aFldTime.Enable( FALSE );
		aFldTime.SetEmptyTime();
	}

	return( 0L );
}

// -----------------------------------------------------------------------

IMPL_LINK( SdSlideChangeWin, ClickSoundHdl, ImageButton *, pBtn )
{
	if( pBtn )
		pBtn->Check( !pBtn->IsChecked() );

	BOOL bCheck = aBtnSound.IsChecked();

	aBtnSearch.Enable( bCheck );
	aLbSound.Enable( bCheck );

	return( 0L );
}

// -----------------------------------------------------------------------

IMPL_LINK( SdSlideChangeWin, ClickSearchHdl, ImageButton *, pBtn )
{
	OpenFileDialog();

	return( 0L );
}

// -----------------------------------------------------------------------

IMPL_LINK( SdSlideChangeWin, ClickViewTypeHdl, ImageButton *, pBtn )
{
	// Der folgende Code ist bestimmt fuer 2 Sichten (und 2 Buttons)
	if( pBtn )
	{
		aBtnVTEffect.Check( &aBtnVTEffect == pBtn );
		aBtnVTExtras.Check( &aBtnVTExtras == pBtn || bBreakEven );

		if( aBtnVTEffect.IsChecked() )
			eViewType = VIEWTYPE_SC_EFFECT;
		else if( aBtnVTExtras.IsChecked() )
			eViewType = VIEWTYPE_SC_EXTRAS;

		if( eViewType == VIEWTYPE_SC_EFFECT )
		{
			aLbEffect.Show();
			aCtlEffect.Show();
			aLbSpeed.Show();
		}
		else if( eViewType == VIEWTYPE_SC_EXTRAS )
		{
			aLbEffect.Hide();
			aCtlEffect.Hide();
			aLbSpeed.Hide();
		}
		if( eViewType == VIEWTYPE_SC_EXTRAS || bBreakEven )
		{
			aBtnAuto.Show();
			aBtnSemi.Show();
			aBtnManual.Show();
			aFldTime.Show();
			aBtnSound.Show();
			aBtnSearch.Show();
			aLbSound.Show();
		}
		else
		{
			aBtnAuto.Hide();
			aBtnSemi.Hide();
			aBtnManual.Hide();
			aFldTime.Hide();
			aBtnSound.Hide();
			aBtnSearch.Hide();
			aLbSound.Hide();
		}

		aGrpEffect.SetText( String( SdResId( GetViewTypeResId( eViewType ) ) ) );
	}
	else
	{
		aBtnVTEffect.Check( eViewType == VIEWTYPE_SC_EFFECT );
		aBtnVTExtras.Check( eViewType == VIEWTYPE_SC_EXTRAS || bBreakEven );
	}

	return( 0L );
}

